/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.tools;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcodec.common.IntArrayList;
import org.jcodec.common.NIOUtils;

public class ToJSON {
    static Set<Class> primitive = new HashSet<Class>();
    static Set<String> omitMethods = new HashSet<String>();

    public static List<String> allFields(Class claz) {
        return ToJSON.allFieldsExcept(claz, new String[0]);
    }

    public static List<String> allFieldsExcept(Class claz, String ... except) {
        ArrayList<String> result = new ArrayList<String>();
        for (Method method : claz.getDeclaredMethods()) {
            if (!ToJSON.isGetter(method)) continue;
            try {
                String name = ToJSON.toName(method);
                result.add(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toJSON(Object obj) {
        StringBuilder builder = new StringBuilder();
        IntArrayList stack = new IntArrayList();
        ToJSON.toJSONSub(obj, stack, builder);
        return builder.toString();
    }

    public static void fieldsToJSON(Object obj, StringBuilder builder, String ... fields) {
        Method[] methods = obj.getClass().getMethods();
        for (String field : fields) {
            Method m = ToJSON.findGetter(methods, field);
            if (m == null) continue;
            ToJSON.invoke(obj, new IntArrayList(), builder, m, field);
        }
    }

    private static Method findGetter(Method[] methods, String field) {
        String isGetter = ToJSON.getterName("is", field);
        String getGetter = ToJSON.getterName("get", field);
        for (Method method : methods) {
            if (!isGetter.equals(method.getName()) && !getGetter.equals(method.getName()) || !ToJSON.isGetter(method)) continue;
            return method;
        }
        return null;
    }

    private static String getterName(String pref, String field) {
        if (field == null) {
            throw new IllegalArgumentException("Passed null string as field name");
        }
        char[] ch = field.toCharArray();
        if (ch.length == 0) {
            return pref;
        }
        ch[0] = ch.length > 1 && Character.isUpperCase(ch[1]) ? Character.toLowerCase(ch[0]) : Character.toUpperCase(ch[0]);
        return pref + new String(ch);
    }

    private static void toJSONSub(Object obj, IntArrayList stack, StringBuilder builder) {
        int id = System.identityHashCode(obj);
        if (stack.contains(id)) {
            builder.append("\"!-!-!-!-LOOP-!-!-!-!\"");
            return;
        }
        stack.push(id);
        if (obj instanceof ByteBuffer) {
            obj = NIOUtils.toArray((ByteBuffer)obj);
        }
        if (obj == null) {
            builder.append("null");
        } else if (obj instanceof String) {
            builder.append("\"");
            ToJSON.escape((String)obj, builder);
            builder.append("\"");
        } else if (obj instanceof Map) {
            Iterator it = ((Map)obj).entrySet().iterator();
            builder.append("{");
            while (it.hasNext()) {
                Map.Entry e = it.next();
                builder.append("\"");
                builder.append(e.getKey());
                builder.append("\":");
                ToJSON.toJSONSub(e.getValue(), stack, builder);
                if (!it.hasNext()) continue;
                builder.append(",");
            }
            builder.append("}");
        } else if (obj instanceof Iterable) {
            Iterator it = ((Iterable)obj).iterator();
            builder.append("[");
            while (it.hasNext()) {
                ToJSON.toJSONSub(it.next(), stack, builder);
                if (!it.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
        } else if (obj instanceof Object[]) {
            builder.append("[");
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                ToJSON.toJSONSub(Array.get(obj, i), stack, builder);
                if (i >= len - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else if (obj instanceof long[]) {
            long[] a = (long[])obj;
            builder.append("[");
            for (int i = 0; i < a.length; ++i) {
                builder.append(String.format("0x%016x", a[i]));
                if (i >= a.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else if (obj instanceof int[]) {
            int[] a = (int[])obj;
            builder.append("[");
            for (int i = 0; i < a.length; ++i) {
                builder.append(String.format("0x%08x", a[i]));
                if (i >= a.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else if (obj instanceof float[]) {
            float[] a = (float[])obj;
            builder.append("[");
            for (int i = 0; i < a.length; ++i) {
                builder.append(String.format(".3f", Float.valueOf(a[i])));
                if (i >= a.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else if (obj instanceof double[]) {
            double[] a = (double[])obj;
            builder.append("[");
            for (int i = 0; i < a.length; ++i) {
                builder.append(String.format(".6f", a[i]));
                if (i >= a.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else if (obj instanceof short[]) {
            short[] a = (short[])obj;
            builder.append("[");
            for (int i = 0; i < a.length; ++i) {
                builder.append(String.format("0x%04x", a[i]));
                if (i >= a.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else if (obj instanceof byte[]) {
            byte[] a = (byte[])obj;
            builder.append("[");
            for (int i = 0; i < a.length; ++i) {
                builder.append(String.format("0x%02x", a[i]));
                if (i >= a.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else if (obj instanceof boolean[]) {
            boolean[] a = (boolean[])obj;
            builder.append("[");
            for (int i = 0; i < a.length; ++i) {
                builder.append(a[i]);
                if (i >= a.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else {
            builder.append("{");
            for (Method method : obj.getClass().getMethods()) {
                if (omitMethods.contains(method.getName()) || !ToJSON.isGetter(method)) continue;
                String name = ToJSON.toName(method);
                ToJSON.invoke(obj, stack, builder, method, name);
            }
            builder.append("}");
        }
        stack.pop();
    }

    private static void invoke(Object obj, IntArrayList stack, StringBuilder builder, Method method, String name) {
        try {
            Object invoke = method.invoke(obj, new Object[0]);
            builder.append('\"');
            builder.append(name);
            builder.append("\":");
            if (invoke != null && primitive.contains(invoke.getClass())) {
                builder.append(invoke);
            } else {
                ToJSON.toJSONSub(invoke, stack, builder);
            }
            builder.append(",");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void escape(String invoke, StringBuilder sb) {
        char[] ch;
        for (char c : ch = invoke.toCharArray()) {
            if (c < ' ') {
                sb.append(String.format("\\%02x", c));
                continue;
            }
            sb.append(c);
        }
    }

    private static String toName(Method method) {
        if (!ToJSON.isGetter(method)) {
            throw new IllegalArgumentException("Not a getter");
        }
        char[] name = method.getName().toCharArray();
        int ind = name[0] == 'g' ? 3 : 2;
        name[ind] = Character.toLowerCase(name[ind]);
        return new String(name, ind, name.length - ind);
    }

    public static boolean isGetter(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (!(method.getName().startsWith("get") || method.getName().startsWith("is") && method.getReturnType() == Boolean.TYPE)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    static {
        primitive.add(Boolean.class);
        primitive.add(Byte.class);
        primitive.add(Short.class);
        primitive.add(Integer.class);
        primitive.add(Long.class);
        primitive.add(Float.class);
        primitive.add(Double.class);
        primitive.add(Character.class);
        omitMethods.add("getClass");
        omitMethods.add("get");
    }
}

