/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.common.tools.MathUtil;

public class Intra16x16PredictionBuilder {
    public static void predictWithMode(int predMode, int[] residual, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine, int[] topLeft, int x) {
        switch (predMode) {
            case 0: {
                Intra16x16PredictionBuilder.predictVertical(residual, topAvailable, topLine, x);
                break;
            }
            case 1: {
                Intra16x16PredictionBuilder.predictHorizontal(residual, leftAvailable, leftRow, x);
                break;
            }
            case 2: {
                Intra16x16PredictionBuilder.predictDC(residual, leftAvailable, topAvailable, leftRow, topLine, x);
                break;
            }
            case 3: {
                Intra16x16PredictionBuilder.predictPlane(residual, leftAvailable, topAvailable, leftRow, topLine, topLeft, x);
            }
        }
    }

    public static void predictVertical(int[] residual, boolean topAvailable, int[] topLine, int x) {
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                residual[off] = MathUtil.clip(residual[off] + topLine[x + i], 0, 255);
                ++i;
                ++off;
            }
        }
    }

    public static void predictHorizontal(int[] residual, boolean leftAvailable, int[] leftRow, int x) {
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                residual[off] = MathUtil.clip(residual[off] + leftRow[j], 0, 255);
                ++i;
                ++off;
            }
        }
    }

    public static void predictDC(int[] residual, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine, int x) {
        int i;
        int s0;
        if (leftAvailable && topAvailable) {
            s0 = 0;
            for (i = 0; i < 16; ++i) {
                s0 += leftRow[i];
            }
            for (i = 0; i < 16; ++i) {
                s0 += topLine[x + i];
            }
            s0 = s0 + 16 >> 5;
        } else if (leftAvailable) {
            s0 = 0;
            for (i = 0; i < 16; ++i) {
                s0 += leftRow[i];
            }
            s0 = s0 + 8 >> 4;
        } else if (topAvailable) {
            s0 = 0;
            for (i = 0; i < 16; ++i) {
                s0 += topLine[x + i];
            }
            s0 = s0 + 8 >> 4;
        } else {
            s0 = 128;
        }
        for (i = 0; i < 256; ++i) {
            residual[i] = MathUtil.clip(residual[i] + s0, 0, 255);
        }
    }

    public static void predictPlane(int[] residual, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine, int[] topLeft, int x) {
        int H = 0;
        for (int i = 0; i < 7; ++i) {
            H += (i + 1) * (topLine[x + 8 + i] - topLine[x + 6 - i]);
        }
        H += 8 * (topLine[x + 15] - topLeft[0]);
        int V = 0;
        for (int j = 0; j < 7; ++j) {
            V += (j + 1) * (leftRow[8 + j] - leftRow[6 - j]);
        }
        int c = 5 * (V += 8 * (leftRow[15] - topLeft[0])) + 32 >> 6;
        int b = 5 * H + 32 >> 6;
        int a = 16 * (leftRow[15] + topLine[x + 15]);
        int off = 0;
        for (int j = 0; j < 16; ++j) {
            int i = 0;
            while (i < 16) {
                int val = MathUtil.clip(a + b * (i - 7) + c * (j - 7) + 16 >> 5, 0, 255);
                residual[off] = MathUtil.clip(residual[off] + val, 0, 255);
                ++i;
                ++off;
            }
        }
    }
}

