/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class GridGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String CORNER_VERTEX = "Corner Vertex";
    private int rows;
    private int cols;

    public GridGraphGenerator(int n, int n2) {
        if (n < 2) {
            throw new IllegalArgumentException("illegal number of rows (" + n + "). there must be at least two.");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("illegal number of columns (" + n2 + "). there must be at least two.");
        }
        this.rows = n;
        this.cols = n2;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        TreeMap<Integer, V> treeMap = new TreeMap<Integer, V>();
        int n = 0;
        for (int i = 0; i < this.rows * this.cols; ++i) {
            boolean bl;
            V v = vertexFactory.createVertex();
            graph.addVertex(v);
            treeMap.put(i + 1, v);
            boolean bl2 = bl = i == 0 || i == this.cols - 1 || i == this.cols * (this.rows - 1) || i == this.rows * this.cols - 1;
            if (!bl || map == null) continue;
            map.put("Corner Vertex " + ++n, v);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            Iterator iterator2 = treeMap.keySet().iterator();
            while (iterator2.hasNext()) {
                int n3 = (Integer)iterator2.next();
                if ((n2 % this.cols <= 0 || n2 + 1 != Integer.valueOf(n3)) && n2 + this.cols != n3) continue;
                graph.addEdge(treeMap.get(n2), treeMap.get(n3));
                graph.addEdge(treeMap.get(n3), treeMap.get(n2));
            }
        }
    }
}

