/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.dense;

import org.la4j.factory.Factory;
import org.la4j.matrix.AbstractMatrix;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.dense.DenseMatrix;
import org.la4j.matrix.dense.DenseSafeMatrix;

public abstract class AbstractBasicMatrix
extends AbstractMatrix
implements DenseMatrix {
    private static final int BLOCKSIZE = 64;

    public AbstractBasicMatrix(Factory factory) {
        super(factory);
    }

    public AbstractBasicMatrix(Factory factory, int rows, int columns) {
        super(factory, rows, columns);
    }

    @Override
    public Matrix multiply(Matrix matrix, Factory factory) {
        if (matrix instanceof DenseMatrix && this.rows % 64 == 0 && this.columns % 64 == 0 && matrix.columns() % 64 == 0) {
            return this.multiplyBlockedWith64(matrix, factory);
        }
        return super.multiply(matrix, factory);
    }

    private Matrix multiplyBlockedWith64(Matrix matrix, Factory factory) {
        Matrix result = factory.createMatrix(this.rows, matrix.columns());
        for (int i = 0; i < this.rows; i += 64) {
            for (int k = 0; k < this.columns; k += 64) {
                for (int j = 0; j < matrix.columns(); j += 64) {
                    for (int u = 0; u < 64; ++u) {
                        for (int w = 0; w < 64; ++w) {
                            for (int v = 0; v < 64; ++v) {
                                result.set(i + u, j + v, result.get(i + u, j + v) + this.get(i + u, k + w) * matrix.get(k + w, j + v));
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Matrix safe() {
        return new DenseSafeMatrix(this);
    }
}

