/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.unit;

import java.util.Map;
import org.ngs.ngunits.UnconvertibleException;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.converter.AddConverter;
import org.ngs.ngunits.converter.MultiplyConverter;
import org.ngs.ngunits.converter.RationalConverter;
import org.ngs.ngunits.unit.UnitDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnit
implements Unit {
    public final UnitDelegate delegate;

    protected AbstractUnit(UnitDelegate unitDelegate) {
        this.delegate = unitDelegate;
    }

    @Override
    public String getSymbol() {
        return null;
    }

    @Override
    public Map<Unit, Integer> getProductUnits() {
        return null;
    }

    @Override
    public boolean isCompatible(Unit unit) {
        return this.delegate.compatible(this, unit);
    }

    public Unit asType(Class clazz) {
        return this;
    }

    @Override
    public UnitConverter getConverterTo(Unit unit) throws UnconvertibleException {
        return this.getConverterToAny(unit);
    }

    public UnitConverter getConverterToAny(Unit unit) throws UnconvertibleException {
        return this.delegate.getConverter(this, unit);
    }

    public Unit alternate(String string) {
        return this.delegate.alternate(this, string);
    }

    public Unit annotate(String string) {
        return this.delegate.annotate(this, string);
    }

    public Unit transform(UnitConverter unitConverter) {
        return this.delegate.transform(this, unitConverter);
    }

    public Unit add(double d) {
        return this.transform(new AddConverter(d));
    }

    public Unit multiply(double d) {
        if (d == 1.0) {
            return this;
        }
        if (StrictMath.floor(d) == d && Math.abs(d) < 2.147483647E9) {
            return this.transform(new RationalConverter((long)d, 1L));
        }
        return this.transform(new MultiplyConverter(d));
    }

    public Unit multiply(Unit unit) {
        return this.delegate.multiply(this, unit);
    }

    public Unit inverse() {
        return this.delegate.divide(this.delegate.one(), this);
    }

    public Unit divide(double d) {
        if (d == 1.0) {
            return this;
        }
        if (StrictMath.floor(d) == d && Math.abs(d) < 2.147483647E9) {
            return this.transform(new RationalConverter(1L, (long)d));
        }
        return this.transform(new MultiplyConverter(1.0 / d));
    }

    public Unit divide(Unit unit) {
        return this.delegate.divide(this, unit);
    }

    @Override
    public Unit<?> root(int n) {
        if (n > 0) {
            return this.delegate.root(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return this.delegate.one().divide(this.root(-n));
    }

    @Override
    public Unit<?> pow(int n) {
        if (n > 0) {
            return this.multiply((Unit)this.pow(n - 1));
        }
        if (n == 0) {
            return this.delegate.one();
        }
        return this.delegate.one().divide(this.pow(-n));
    }
}

