/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits;

import java.util.HashSet;
import org.ngs.ngunits.NonSI;
import org.ngs.ngunits.Prefix;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.SystemOfUnits;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Acceleration;
import org.ngs.ngunits.quantity.Action;
import org.ngs.ngunits.quantity.AmountOfSubstance;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Area;
import org.ngs.ngunits.quantity.Dimensionless;
import org.ngs.ngunits.quantity.DynamicViscosity;
import org.ngs.ngunits.quantity.ElectricCapacitance;
import org.ngs.ngunits.quantity.ElectricCharge;
import org.ngs.ngunits.quantity.ElectricConductance;
import org.ngs.ngunits.quantity.ElectricCurrent;
import org.ngs.ngunits.quantity.ElectricInductance;
import org.ngs.ngunits.quantity.ElectricPermittivity;
import org.ngs.ngunits.quantity.ElectricPotential;
import org.ngs.ngunits.quantity.ElectricResistance;
import org.ngs.ngunits.quantity.Energy;
import org.ngs.ngunits.quantity.Force;
import org.ngs.ngunits.quantity.Frequency;
import org.ngs.ngunits.quantity.Illuminance;
import org.ngs.ngunits.quantity.Information;
import org.ngs.ngunits.quantity.InformationRate;
import org.ngs.ngunits.quantity.IonDose;
import org.ngs.ngunits.quantity.KinematicViscosity;
import org.ngs.ngunits.quantity.Length;
import org.ngs.ngunits.quantity.LineicNumber;
import org.ngs.ngunits.quantity.LuminousFlux;
import org.ngs.ngunits.quantity.LuminousIntensity;
import org.ngs.ngunits.quantity.LuminousIntensityDensity;
import org.ngs.ngunits.quantity.MagneticFlux;
import org.ngs.ngunits.quantity.MagneticFluxDensity;
import org.ngs.ngunits.quantity.MagneticFluxIntensity;
import org.ngs.ngunits.quantity.MagneticPermittivity;
import org.ngs.ngunits.quantity.MagneticTension;
import org.ngs.ngunits.quantity.Mass;
import org.ngs.ngunits.quantity.Power;
import org.ngs.ngunits.quantity.Pressure;
import org.ngs.ngunits.quantity.RadiationDoseAbsorbed;
import org.ngs.ngunits.quantity.RadiationDoseEffective;
import org.ngs.ngunits.quantity.RadioactiveActivity;
import org.ngs.ngunits.quantity.SolidAngle;
import org.ngs.ngunits.quantity.Temperature;
import org.ngs.ngunits.quantity.Time;
import org.ngs.ngunits.quantity.Velocity;
import org.ngs.ngunits.quantity.Volume;

public final class UCUM
extends SystemOfUnits {
    protected static HashSet<Unit<?>> METRIC_UNITS = new HashSet();
    public static final UCUM INSTANCE = new UCUM();
    public static final Unit<Length> METER = UCUM.ucum(SI.METRE, true);
    public static final Unit<Time> SECOND = UCUM.ucum(SI.SECOND, true);
    public static final Unit<Mass> GRAM = UCUM.ucum(SI.GRAM, true);
    public static final Unit<Mass> KILOGRAM = SI.KILOGRAM;
    public static final Unit<Angle> RADIAN = UCUM.ucum(SI.RADIAN, true);
    public static final Unit<Temperature> KELVIN = UCUM.ucum(SI.KELVIN, true);
    public static final Unit<ElectricCharge> COULOMB = UCUM.ucum(SI.COULOMB, true);
    public static final Unit<LuminousIntensity> CANDELA = UCUM.ucum(SI.CANDELA, true);
    public static final Unit<Dimensionless> TRIILLIONS = UCUM.ucum(DELEGATE.one().multiply(1.0E12), false);
    public static final Unit<Dimensionless> BILLIONS = UCUM.ucum(DELEGATE.one().multiply(1.0E9), false);
    public static final Unit<Dimensionless> MILLIONS = UCUM.ucum(DELEGATE.one().multiply(1000000.0), false);
    public static final Unit<Dimensionless> THOUSANDS = UCUM.ucum(DELEGATE.one().multiply(1000.0), false);
    public static final Unit<Dimensionless> HUNDREDS = UCUM.ucum(DELEGATE.one().multiply(100.0), false);
    public static final Unit<Dimensionless> PI = UCUM.ucum(DELEGATE.one().multiply(Math.PI), false);
    public static final Unit<Dimensionless> PERCENT = UCUM.ucum(DELEGATE.one().divide(100.0), false);
    public static final Unit<Dimensionless> PER_THOUSAND = UCUM.ucum(DELEGATE.one().divide(1000.0), false);
    public static final Unit<Dimensionless> PER_MILLION = UCUM.ucum(DELEGATE.one().divide(1000000.0), false);
    public static final Unit<Dimensionless> PER_BILLION = UCUM.ucum(DELEGATE.one().divide(1.0E9), false);
    public static final Unit<Dimensionless> PER_TRILLION = UCUM.ucum(DELEGATE.one().divide(1.0E12), false);
    public static final Unit<AmountOfSubstance> MOLE = UCUM.ucum(SI.MOLE, true);
    public static final Unit<SolidAngle> STERADIAN = UCUM.ucum(SI.STERADIAN, true);
    public static final Unit<Frequency> HERTZ = UCUM.ucum(DELEGATE.one().divide(SECOND), true);
    public static final Unit<Force> NEWTON = UCUM.ucum(SI.NEWTON, true);
    public static final Unit<Pressure> PASCAL = UCUM.ucum(SI.PASCAL, true);
    public static final Unit<Energy> JOULE = UCUM.ucum(SI.JOULE, true);
    public static final Unit<Power> WATT = UCUM.ucum(SI.WATT, true);
    public static final Unit<ElectricCurrent> AMPERE = UCUM.ucum(SI.AMPERE, true);
    public static final Unit<ElectricPotential> VOLT = UCUM.ucum(SI.VOLT, true);
    public static final Unit<ElectricCapacitance> FARAD = UCUM.ucum(SI.FARAD, true);
    public static final Unit<ElectricResistance> OHM = UCUM.ucum(SI.OHM, true);
    public static final Unit<ElectricConductance> SIEMENS = UCUM.ucum(SI.SIEMENS, true);
    public static final Unit<MagneticFlux> WEBER = UCUM.ucum(SI.WEBER, true);
    public static final Unit<Temperature> CELSIUS = UCUM.ucum(SI.CELSIUS, true);
    public static final Unit<MagneticFluxDensity> TESLA = UCUM.ucum(SI.TESLA, true);
    public static final Unit<ElectricInductance> HENRY = UCUM.ucum(SI.HENRY, true);
    public static final Unit<LuminousFlux> LUMEN = UCUM.ucum(SI.LUMEN, true);
    public static final Unit<LuminousIntensity> LUX = UCUM.ucum(SI.LUX, true);
    public static final Unit<RadioactiveActivity> BECQUEREL = UCUM.ucum(SI.BECQUEREL, true);
    public static final Unit<RadiationDoseAbsorbed> GRAY = UCUM.ucum(SI.GRAY, true);
    public static final Unit<RadiationDoseEffective> SIEVERT = UCUM.ucum(SI.SIEVERT, true);
    public static final Unit<Angle> DEGREE = UCUM.ucum(NonSI.DEGREE_ANGLE, false);
    public static final Unit<Angle> GRADE = UCUM.ucum(NonSI.GRADE, false);
    public static final Unit<Angle> GON = GRADE;
    public static final Unit<Angle> MINUTE_ANGLE = UCUM.ucum(NonSI.MINUTE_ANGLE, false);
    public static final Unit<Angle> SECOND_ANGLE = UCUM.ucum(NonSI.SECOND_ANGLE, false);
    public static final Unit<Volume> LITER = UCUM.ucum(NonSI.LITRE, true);
    public static final Unit<Area> ARE = UCUM.ucum(NonSI.ARE, true);
    public static final Unit<Time> MINUTE = UCUM.ucum(NonSI.MINUTE, false);
    public static final Unit<Time> HOUR = UCUM.ucum(NonSI.HOUR, false);
    public static final Unit<Time> DAY = UCUM.ucum(NonSI.DAY, false);
    public static final Unit<Time> YEAR_TROPICAL = UCUM.ucum(DAY.multiply(365.24219), false);
    public static final Unit<Time> YEAR_JULIAN = UCUM.ucum(DAY.multiply(365.25), false);
    public static final Unit<Time> YEAR_GREGORIAN = UCUM.ucum(DAY.multiply(365.2425), false);
    public static final Unit<Time> YEAR = UCUM.ucum(DAY.multiply(365.25), false);
    public static final Unit<Time> WEEK = UCUM.ucum(NonSI.WEEK, false);
    public static final Unit<Time> MONTH_SYNODAL = UCUM.ucum(DAY.multiply(29.53059), false);
    public static final Unit<Time> MONTH_JULIAN = UCUM.ucum(YEAR_JULIAN.divide(12.0), false);
    public static final Unit<Time> MONTH_GREGORIAN = UCUM.ucum(YEAR_GREGORIAN.divide(12.0), false);
    public static final Unit<Time> MONTH = UCUM.ucum(YEAR_JULIAN.divide(12.0), false);
    public static final Unit<Mass> TONNE = UCUM.ucum(NonSI.METRIC_TON, true);
    public static final Unit<Pressure> BAR = UCUM.ucum(NonSI.BAR, true);
    public static final Unit<Mass> ATOMIC_MASS_UNIT = UCUM.ucum(NonSI.ATOMIC_MASS, true);
    public static final Unit<Energy> ELECTRON_VOLT = UCUM.ucum(NonSI.ELECTRON_VOLT, true);
    public static final Unit<Length> ASTRONOMIC_UNIT = UCUM.ucum(NonSI.ASTRONOMICAL_UNIT, false);
    public static final Unit<Length> PARSEC = UCUM.ucum(NonSI.PARSEC, true);
    public static final Unit<Velocity> C = UCUM.ucum(NonSI.C, true);
    public static final Unit<Action> PLANCK = UCUM.ucum(JOULE.multiply(SECOND).multiply(6.6260755E-24), true);
    public static final Unit<Dimensionless> BOLTZMAN = UCUM.ucum(JOULE.divide(KELVIN).multiply(1.380658E-23), true);
    public static final Unit<ElectricPermittivity> PERMITTIVITY_OF_VACUUM = UCUM.ucum(FARAD.divide(METER).multiply(8.854187817E-12), true);
    public static final Unit<MagneticPermittivity> PERMEABILITY_OF_VACUUM = UCUM.ucum(NEWTON.multiply(1.2566370614359173E-6).divide(AMPERE.pow(2)), true);
    public static final Unit<ElectricCharge> ELEMENTARY_CHARGE = UCUM.ucum(NonSI.E, true);
    public static final Unit<Mass> ELECTRON_MASS = UCUM.ucum(NonSI.ELECTRON_MASS, true);
    public static final Unit<Mass> PROTON_MASS = UCUM.ucum(GRAM.multiply(1.6726231E-24), true);
    public static final Unit<Acceleration> NEWTON_CONSTANT_OF_GRAVITY = UCUM.ucum(METER.pow(3).multiply(KILOGRAM.pow(-1)).multiply(SECOND.pow(-2)).multiply(6.67259E-11), true);
    public static final Unit<Acceleration> ACCELLERATION_OF_FREEFALL = UCUM.ucum(NonSI.G, true);
    public static final Unit<Pressure> ATMOSPHERE = UCUM.ucum(NonSI.ATMOSPHERE, false);
    public static final Unit<Length> LIGHT_YEAR = UCUM.ucum(NonSI.LIGHT_YEAR, true);
    public static final Unit<Force> GRAM_FORCE = UCUM.ucum(GRAM.multiply(ACCELLERATION_OF_FREEFALL), true);
    public static final Unit<LineicNumber> KAYSER = UCUM.ucum(DELEGATE.one().divide(Prefix.CENTI.transform(METER)), true);
    public static final Unit<Acceleration> GAL = UCUM.ucum(Prefix.CENTI.transform(METER).divide(SECOND.pow(2)), true);
    public static final Unit<Force> DYNE = UCUM.ucum(NonSI.DYNE, true);
    public static final Unit<Energy> ERG = UCUM.ucum(NonSI.ERG, true);
    public static final Unit<DynamicViscosity> POISE = UCUM.ucum(NonSI.POISE, true);
    public static final Unit<ElectricCurrent> BIOT = UCUM.ucum(AMPERE.multiply(10.0), true);
    public static final Unit<KinematicViscosity> STOKES = UCUM.ucum(NonSI.STOKE, true);
    public static final Unit<MagneticFlux> MAXWELL = UCUM.ucum(NonSI.MAXWELL, true);
    public static final Unit<MagneticFluxDensity> GAUSS = UCUM.ucum(NonSI.GAUSS, true);
    public static final Unit<MagneticFluxIntensity> OERSTED = UCUM.ucum(DELEGATE.one().divide(PI).multiply(AMPERE).divide(METER).multiply(250.0), true);
    public static final Unit<MagneticTension> GILBERT = UCUM.ucum(OERSTED.multiply(Prefix.CENTI.transform(METER)), true);
    public static final Unit<LuminousIntensityDensity> STILB = UCUM.ucum(CANDELA.divide(Prefix.CENTI.transform(METER).pow(2)), true);
    public static final Unit<Illuminance> LAMBERT = UCUM.ucum(NonSI.LAMBERT, true);
    public static final Unit<Illuminance> PHOT = UCUM.ucum(LUX.divide(10000.0), true);
    public static final Unit<RadioactiveActivity> CURIE = UCUM.ucum(NonSI.CURIE, true);
    public static final Unit<IonDose> ROENTGEN = UCUM.ucum(NonSI.ROENTGEN, true);
    public static final Unit<RadiationDoseAbsorbed> RAD = UCUM.ucum(NonSI.RAD, true);
    public static final Unit<RadiationDoseEffective> REM = UCUM.ucum(NonSI.REM, true);
    public static final Unit<Length> INCH_INTERNATIONAL = UCUM.ucum(Prefix.CENTI.transform(METER).multiply(254.0).divide(100.0), false);
    public static final Unit<Length> FOOT_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.multiply(12.0), false);
    public static final Unit<Length> YARD_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.multiply(3.0), false);
    public static final Unit<Length> MILE_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.multiply(5280.0), false);
    public static final Unit<Length> FATHOM_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.multiply(6.0), false);
    public static final Unit<Length> NAUTICAL_MILE_INTERNATIONAL = UCUM.ucum(METER.multiply(1852.0), false);
    public static final Unit<Length> KNOT_INTERNATIONAL = UCUM.ucum(NAUTICAL_MILE_INTERNATIONAL.divide(HOUR), false);
    public static final Unit<Area> SQUARE_INCH_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.pow(2), false);
    public static final Unit<Area> SQUARE_FOOT_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.pow(2), false);
    public static final Unit<Area> SQUARE_YARD_INTERNATIONAL = UCUM.ucum(YARD_INTERNATIONAL.pow(2), false);
    public static final Unit<Volume> CUBIC_INCH_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.pow(3), false);
    public static final Unit<Volume> CUBIC_FOOT_INTERNATIONAL = UCUM.ucum(FOOT_INTERNATIONAL.pow(3), false);
    public static final Unit<Volume> CUBIC_YARD_INTERNATIONAL = UCUM.ucum(YARD_INTERNATIONAL.pow(3), false);
    public static final Unit<Volume> BOARD_FOOT_INTERNATIONAL = UCUM.ucum(CUBIC_INCH_INTERNATIONAL.multiply(144.0), false);
    public static final Unit<Volume> CORD_INTERNATIONAL = UCUM.ucum(CUBIC_FOOT_INTERNATIONAL.multiply(128.0), false);
    public static final Unit<Length> MIL_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.divide(1000.0), false);
    public static final Unit<Area> CIRCULAR_MIL_INTERNATIONAL = UCUM.ucum(MIL_INTERNATIONAL.multiply(PI).divide(4.0), false);
    public static final Unit<Length> HAND_INTERNATIONAL = UCUM.ucum(INCH_INTERNATIONAL.multiply(4.0), false);
    public static final Unit<Length> FOOT_US_SURVEY = UCUM.ucum(METER.multiply(1200.0).divide(3937.0), false);
    public static final Unit<Length> YARD_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.multiply(3.0), false);
    public static final Unit<Length> INCH_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.divide(12.0), false);
    public static final Unit<Length> ROD_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.multiply(33.0).divide(2.0), false);
    public static final Unit<Length> CHAIN_US_SURVEY = UCUM.ucum(ROD_US_SURVEY.multiply(4.0), false);
    public static final Unit<Length> LINK_US_SURVEY = UCUM.ucum(CHAIN_US_SURVEY.divide(100.0), false);
    public static final Unit<Length> RAMDEN_CHAIN_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.multiply(100.0), false);
    public static final Unit<Length> RAMDEN_LINK_US_SURVEY = UCUM.ucum(CHAIN_US_SURVEY.divide(100.0), false);
    public static final Unit<Length> FATHOM_US_SURVEY = UCUM.ucum(FOOT_US_SURVEY.multiply(6.0), false);
    public static final Unit<Length> FURLONG_US_SURVEY = UCUM.ucum(ROD_US_SURVEY.multiply(40.0), false);
    public static final Unit<Length> MILE_US_SURVEY = UCUM.ucum(FURLONG_US_SURVEY.multiply(8.0), false);
    public static final Unit<Area> ACRE_US_SURVEY = UCUM.ucum(ROD_US_SURVEY.pow(2).multiply(160.0), false);
    public static final Unit<Area> SQUARE_ROD_US_SURVEY = UCUM.ucum(ROD_US_SURVEY.pow(2), false);
    public static final Unit<Area> SQUARE_MILE_US_SURVEY = UCUM.ucum(MILE_US_SURVEY.pow(2), false);
    public static final Unit<Area> SECTION_US_SURVEY = UCUM.ucum(MILE_US_SURVEY.pow(2), false);
    public static final Unit<Area> TOWNSHP_US_SURVEY = UCUM.ucum(SECTION_US_SURVEY.multiply(36.0), false);
    public static final Unit<Length> MIL_US_SURVEY = UCUM.ucum(INCH_US_SURVEY.divide(1000.0), false);
    public static final Unit<Length> INCH_BRITISH = UCUM.ucum(Prefix.CENTI.transform(METER).multiply(2539998.0).divide(1000000.0), false);
    public static final Unit<Length> FOOT_BRITISH = UCUM.ucum(INCH_BRITISH.multiply(12.0), false);
    public static final Unit<Length> ROD_BRITISH = UCUM.ucum(FOOT_BRITISH.multiply(33.0).divide(2.0), false);
    public static final Unit<Length> CHAIN_BRITISH = UCUM.ucum(ROD_BRITISH.multiply(4.0), false);
    public static final Unit<Length> LINK_BRITISH = UCUM.ucum(CHAIN_BRITISH.divide(100.0), false);
    public static final Unit<Length> FATHOM_BRITISH = UCUM.ucum(FOOT_BRITISH.multiply(6.0), false);
    public static final Unit<Length> PACE_BRITISH = UCUM.ucum(FOOT_BRITISH.multiply(5.0).divide(20.0), false);
    public static final Unit<Length> YARD_BRITISH = UCUM.ucum(FOOT_BRITISH.multiply(3.0), false);
    public static final Unit<Length> MILE_BRITISH = UCUM.ucum(FOOT_BRITISH.multiply(5280.0), false);
    public static final Unit<Length> NAUTICAL_MILE_BRITISH = UCUM.ucum(FOOT_BRITISH.multiply(6080.0), false);
    public static final Unit<Length> KNOT_BRITISH = UCUM.ucum(NAUTICAL_MILE_BRITISH.divide(HOUR), false);
    public static final Unit<Area> ACRE_BRITISH = UCUM.ucum(YARD_BRITISH.pow(2).multiply(4840.0), false);
    public static final Unit<Volume> GALLON_US = UCUM.ucum(CUBIC_INCH_INTERNATIONAL.multiply(231.0), false);
    public static final Unit<Volume> BARREL_US = UCUM.ucum(GALLON_US.multiply(42.0), false);
    public static final Unit<Volume> QUART_US = UCUM.ucum(GALLON_US.divide(4.0), false);
    public static final Unit<Volume> PINT_US = UCUM.ucum(QUART_US.divide(2.0), false);
    public static final Unit<Volume> GILL_US = UCUM.ucum(PINT_US.divide(4.0), false);
    public static final Unit<Volume> FLUID_OUNCE_US = UCUM.ucum(GILL_US.divide(4.0), false);
    public static final Unit<Volume> FLUID_DRAM_US = UCUM.ucum(FLUID_OUNCE_US.divide(8.0), false);
    public static final Unit<Volume> MINIM_US = UCUM.ucum(FLUID_DRAM_US.divide(60.0), false);
    public static final Unit<Volume> CORD_US = UCUM.ucum(CUBIC_FOOT_INTERNATIONAL.multiply(128.0), false);
    public static final Unit<Volume> BUSHEL_US = UCUM.ucum(CUBIC_INCH_INTERNATIONAL.multiply(215042.0).divide(100.0), false);
    public static final Unit<Volume> GALLON_WINCHESTER = UCUM.ucum(BUSHEL_US.divide(8.0), false);
    public static final Unit<Volume> PECK_US = UCUM.ucum(BUSHEL_US.divide(4.0), false);
    public static final Unit<Volume> DRY_QUART_US = UCUM.ucum(PECK_US.divide(8.0), false);
    public static final Unit<Volume> DRY_PINT_US = UCUM.ucum(DRY_QUART_US.divide(2.0), false);
    public static final Unit<Volume> TABLESPOON_US = UCUM.ucum(FLUID_OUNCE_US.divide(2.0), false);
    public static final Unit<Volume> TEASPOON_US = UCUM.ucum(TABLESPOON_US.divide(3.0), false);
    public static final Unit<Volume> CUP_US = UCUM.ucum(TABLESPOON_US.multiply(16.0), false);
    public static final Unit<Volume> GALLON_BRITISH = UCUM.ucum(LITER.multiply(454609.0).divide(100000.0), false);
    public static final Unit<Volume> PECK_BRITISH = UCUM.ucum(GALLON_BRITISH.multiply(2.0), false);
    public static final Unit<Volume> BUSHEL_BRITISH = UCUM.ucum(PECK_BRITISH.multiply(4.0), false);
    public static final Unit<Volume> QUART_BRITISH = UCUM.ucum(GALLON_BRITISH.divide(4.0), false);
    public static final Unit<Volume> PINT_BRITISH = UCUM.ucum(QUART_BRITISH.divide(2.0), false);
    public static final Unit<Volume> GILL_BRITISH = UCUM.ucum(PINT_BRITISH.divide(4.0), false);
    public static final Unit<Volume> FLUID_OUNCE_BRITISH = UCUM.ucum(GILL_BRITISH.divide(5.0), false);
    public static final Unit<Volume> FLUID_DRAM_BRITISH = UCUM.ucum(FLUID_OUNCE_BRITISH.divide(8.0), false);
    public static final Unit<Volume> MINIM_BRITISH = UCUM.ucum(FLUID_DRAM_BRITISH.divide(60.0), false);
    public static final Unit<Mass> GRAIN = UCUM.ucum(Prefix.MILLI.transform(GRAM).multiply(6479891.0).divide(100000.0), false);
    public static final Unit<Mass> POUND = UCUM.ucum(GRAM.multiply(7000.0), false);
    public static final Unit<Mass> OUNCE = UCUM.ucum(POUND.divide(16.0), false);
    public static final Unit<Mass> DRAM = UCUM.ucum(OUNCE.divide(16.0), false);
    public static final Unit<Mass> SHORT_HUNDREDWEIGHT = UCUM.ucum(POUND.multiply(100.0), false);
    public static final Unit<Mass> LONG_HUNDREDWEIGHT = UCUM.ucum(POUND.multiply(112.0), false);
    public static final Unit<Mass> SHORT_TON = UCUM.ucum(SHORT_HUNDREDWEIGHT.multiply(20.0), false);
    public static final Unit<Mass> LONG_TON = UCUM.ucum(LONG_HUNDREDWEIGHT.multiply(20.0), false);
    public static final Unit<Mass> STONE = UCUM.ucum(POUND.multiply(14.0), false);
    public static final Unit<Force> POUND_FORCE = UCUM.ucum(POUND.multiply(ACCELLERATION_OF_FREEFALL), false);
    public static final Unit<Mass> PENNYWEIGHT_TROY = UCUM.ucum(GRAIN.multiply(24.0), false);
    public static final Unit<Mass> OUNCE_TROY = UCUM.ucum(PENNYWEIGHT_TROY.multiply(24.0), false);
    public static final Unit<Mass> POUND_TROY = UCUM.ucum(OUNCE_TROY.multiply(12.0), false);
    public static final Unit<Mass> SCRUPLE_APOTHECARY = UCUM.ucum(GRAIN.multiply(20.0), false);
    public static final Unit<Mass> DRAM_APOTHECARY = UCUM.ucum(SCRUPLE_APOTHECARY.multiply(3.0), false);
    public static final Unit<Mass> OUNCE_APOTHECARY = UCUM.ucum(DRAM_APOTHECARY.multiply(8.0), false);
    public static final Unit<Mass> POUND_APOTHECARY = UCUM.ucum(OUNCE_APOTHECARY.multiply(12.0), false);
    public static final Unit<Length> LINE = UCUM.ucum(INCH_INTERNATIONAL.divide(12.0), false);
    public static final Unit<Length> POINT = UCUM.ucum(LINE.divide(6.0), false);
    public static final Unit<Length> PICA = UCUM.ucum(POINT.multiply(12.0), false);
    public static final Unit<Length> POINT_PRINTER = UCUM.ucum(INCH_INTERNATIONAL.multiply(13837.0).divide(1000000.0), false);
    public static final Unit<Length> PICA_PRINTER = UCUM.ucum(POINT_PRINTER.multiply(12.0), false);
    public static final Unit<Length> PIED = UCUM.ucum(Prefix.CENTI.transform(METER).multiply(3248.0).divide(100.0), false);
    public static final Unit<Length> POUCE = UCUM.ucum(PIED.divide(12.0), false);
    public static final Unit<Length> LINGE = UCUM.ucum(POUCE.divide(12.0), false);
    public static final Unit<Length> DIDOT = UCUM.ucum(LINGE.divide(6.0), false);
    public static final Unit<Length> CICERO = UCUM.ucum(DIDOT.multiply(12.0), false);
    public static final Unit<Temperature> FAHRENHEIT = UCUM.ucum(KELVIN.multiply(5.0).divide(9.0).add(459.67), false);
    public static final Unit<Energy> CALORIE_AT_15C = UCUM.ucum(JOULE.multiply(41858.0).divide(10000.0), true);
    public static final Unit<Energy> CALORIE_AT_20C = UCUM.ucum(JOULE.multiply(41819.0).divide(10000.0), true);
    public static final Unit<Energy> CALORIE_MEAN = UCUM.ucum(JOULE.multiply(419002.0).divide(100000.0), true);
    public static final Unit<Energy> CALORIE_INTERNATIONAL_TABLE = UCUM.ucum(JOULE.multiply(41868.0).divide(10000.0), true);
    public static final Unit<Energy> CALORIE_THERMOCHEMICAL = UCUM.ucum(JOULE.multiply(4184.0).divide(1000.0), true);
    public static final Unit<Energy> CALORIE = UCUM.ucum(CALORIE_THERMOCHEMICAL, true);
    public static final Unit<Energy> CALORIE_FOOD = UCUM.ucum(Prefix.KILO.transform(CALORIE_THERMOCHEMICAL), false);
    public static final Unit<Energy> BTU_AT_39F = UCUM.ucum(Prefix.KILO.transform(JOULE).multiply(105967.0).divide(100000.0), false);
    public static final Unit<Energy> BTU_AT_59F = UCUM.ucum(Prefix.KILO.transform(JOULE).multiply(105480.0).divide(100000.0), false);
    public static final Unit<Energy> BTU_AT_60F = UCUM.ucum(Prefix.KILO.transform(JOULE).multiply(105468.0).divide(100000.0), false);
    public static final Unit<Energy> BTU_MEAN = UCUM.ucum(Prefix.KILO.transform(JOULE).multiply(105587.0).divide(100000.0), false);
    public static final Unit<Energy> BTU_INTERNATIONAL_TABLE = UCUM.ucum(Prefix.KILO.transform(JOULE).multiply(1.05505585262E11).divide(1.0E11), false);
    public static final Unit<Energy> BTU_THERMOCHEMICAL = UCUM.ucum(Prefix.KILO.transform(JOULE).multiply(105735.0).divide(100000.0), false);
    public static final Unit<Energy> BTU = UCUM.ucum(BTU_THERMOCHEMICAL, false);
    public static final Unit<Power> HORSEPOWER = UCUM.ucum(FOOT_INTERNATIONAL.multiply(POUND_FORCE).divide(SECOND), false);
    public static final Unit<Volume> STERE = UCUM.ucum(METER.pow(3), true);
    public static final Unit<Length> ANGSTROM = UCUM.ucum(Prefix.NANO.transform(METER).divide(10.0), false);
    public static final Unit<Area> BARN = UCUM.ucum(Prefix.FEMTO.transform(METER).pow(2).multiply(100.0), false);
    public static final Unit<Pressure> ATMOSPHERE_TECHNICAL = UCUM.ucum(Prefix.KILO.transform(GRAM_FORCE).divide(Prefix.CENTI.transform(METER).pow(2)), false);
    public static final Unit<ElectricConductance> MHO = UCUM.ucum(SIEMENS.alternate("mho"), true);
    public static final Unit<Pressure> POUND_PER_SQUARE_INCH = UCUM.ucum(POUND_FORCE.divide(INCH_INTERNATIONAL.pow(2)), false);
    public static final Unit<Pressure> CIRCLE = UCUM.ucum(PI.multiply(RADIAN).multiply(2.0), false);
    public static final Unit<Pressure> SPHERE = UCUM.ucum(PI.multiply(STERADIAN).multiply(4.0), false);
    public static final Unit<Mass> CARAT_METRIC = UCUM.ucum(GRAM.divide(5.0), false);
    public static final Unit<Dimensionless> CARAT_GOLD = UCUM.ucum(DELEGATE.one().divide(24.0), false);
    public static final Unit<Information> BIT = UCUM.ucum(SI.BIT, true);
    public static final Unit<Information> BYTE = UCUM.ucum(NonSI.BYTE, true);
    public static final Unit<InformationRate> BAUD = UCUM.ucum(DELEGATE.one().divide(SECOND), true);

    protected static Unit ucum(Unit unit, boolean bl) {
        if (bl) {
            METRIC_UNITS.add(unit);
        }
        return UCUM.u(unit);
    }

    private UCUM() {
    }
}

