/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits;

import org.ngs.ngunits.SystemOfUnits;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Acceleration;
import org.ngs.ngunits.quantity.AmountOfSubstance;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Area;
import org.ngs.ngunits.quantity.CatalyticActivity;
import org.ngs.ngunits.quantity.ElectricCapacitance;
import org.ngs.ngunits.quantity.ElectricCharge;
import org.ngs.ngunits.quantity.ElectricConductance;
import org.ngs.ngunits.quantity.ElectricCurrent;
import org.ngs.ngunits.quantity.ElectricInductance;
import org.ngs.ngunits.quantity.ElectricPotential;
import org.ngs.ngunits.quantity.ElectricResistance;
import org.ngs.ngunits.quantity.Energy;
import org.ngs.ngunits.quantity.Force;
import org.ngs.ngunits.quantity.Frequency;
import org.ngs.ngunits.quantity.Illuminance;
import org.ngs.ngunits.quantity.Information;
import org.ngs.ngunits.quantity.Length;
import org.ngs.ngunits.quantity.LuminousFlux;
import org.ngs.ngunits.quantity.LuminousIntensity;
import org.ngs.ngunits.quantity.MagneticFlux;
import org.ngs.ngunits.quantity.MagneticFluxDensity;
import org.ngs.ngunits.quantity.Mass;
import org.ngs.ngunits.quantity.Power;
import org.ngs.ngunits.quantity.Pressure;
import org.ngs.ngunits.quantity.RadiationDoseAbsorbed;
import org.ngs.ngunits.quantity.RadiationDoseEffective;
import org.ngs.ngunits.quantity.RadioactiveActivity;
import org.ngs.ngunits.quantity.SolidAngle;
import org.ngs.ngunits.quantity.Temperature;
import org.ngs.ngunits.quantity.Time;
import org.ngs.ngunits.quantity.Velocity;
import org.ngs.ngunits.quantity.Volume;
import org.ngs.ngunits.unit.BaseUnit;

public final class SI
extends SystemOfUnits {
    public static final SI INSTANCE = new SI();
    public static final Unit<ElectricCurrent> AMPERE = SI.u(new BaseUnit(DELEGATE, "A"));
    public static final Unit<LuminousIntensity> CANDELA = SI.u(new BaseUnit(DELEGATE, "cd"));
    public static final Unit<Temperature> KELVIN = SI.u(new BaseUnit(DELEGATE, "K"));
    public static final Unit<Mass> KILOGRAM = SI.u(new BaseUnit(DELEGATE, "kg"));
    public static final Unit<Length> METRE = SI.u(new BaseUnit(DELEGATE, "m"));
    public static final Unit<Length> METER = METRE;
    public static final Unit<AmountOfSubstance> MOLE = SI.u(new BaseUnit(DELEGATE, "mol"));
    public static final Unit<Time> SECOND = SI.u(new BaseUnit(DELEGATE, "s"));
    public static final Unit<Mass> GRAM = KILOGRAM.divide(1000.0);
    public static final Unit<Angle> RADIAN = SI.u(DELEGATE.one().alternate("rad"));
    public static final Unit<SolidAngle> STERADIAN = SI.u(DELEGATE.one().alternate("sr"));
    public static final Unit<Information> BIT = SI.u(DELEGATE.one().alternate("bit"));
    public static final Unit<Frequency> HERTZ = SI.u(DELEGATE.one().divide(SECOND).alternate("Hz"));
    public static final Unit<Force> NEWTON = SI.u(METRE.multiply(KILOGRAM).divide(SECOND.pow(2)).alternate("N"));
    public static final Unit<Pressure> PASCAL = SI.u(NEWTON.divide(METRE.pow(2)).alternate("Pa"));
    public static final Unit<Energy> JOULE = SI.u(NEWTON.multiply(METRE).alternate("J"));
    public static final Unit<Power> WATT = SI.u(JOULE.divide(SECOND).alternate("W"));
    public static final Unit<ElectricCharge> COULOMB = SI.u(SECOND.multiply(AMPERE).alternate("C"));
    public static final Unit<ElectricPotential> VOLT = SI.u(WATT.divide(AMPERE).alternate("V"));
    public static final Unit<ElectricCapacitance> FARAD = SI.u(COULOMB.divide(VOLT).alternate("F"));
    public static final Unit<ElectricResistance> OHM = SI.u(VOLT.divide(AMPERE).alternate("\u03a9"));
    public static final Unit<ElectricConductance> SIEMENS = SI.u(AMPERE.divide(VOLT).alternate("S"));
    public static final Unit<MagneticFlux> WEBER = SI.u(VOLT.multiply(SECOND).alternate("Wb"));
    public static final Unit<MagneticFluxDensity> TESLA = SI.u(WEBER.divide(METRE.pow(2)).alternate("T"));
    public static final Unit<ElectricInductance> HENRY = SI.u(WEBER.divide(AMPERE).alternate("H"));
    public static final Unit<Temperature> CELSIUS = SI.u(KELVIN.add(273.15));
    public static final Unit<LuminousFlux> LUMEN = SI.u(CANDELA.multiply(STERADIAN).alternate("lm"));
    public static final Unit<Illuminance> LUX = SI.u(LUMEN.divide(METRE.pow(2)).alternate("lx"));
    public static final Unit<RadioactiveActivity> BECQUEREL = SI.u(DELEGATE.one().divide(SECOND).alternate("Bq"));
    public static final Unit<RadiationDoseAbsorbed> GRAY = SI.u(JOULE.divide(KILOGRAM).alternate("Gy"));
    public static final Unit<RadiationDoseEffective> SIEVERT = SI.u(JOULE.divide(KILOGRAM).alternate("Sv"));
    public static final Unit<CatalyticActivity> KATAL = SI.u(MOLE.divide(SECOND).alternate("kat"));
    public static final Unit<Velocity> METRES_PER_SECOND = SI.u(METRE.divide(SECOND));
    public static final Unit<Velocity> METERS_PER_SECOND = METRES_PER_SECOND;
    public static final Unit<Acceleration> METRES_PER_SQUARE_SECOND = SI.u(METRES_PER_SECOND.divide(SECOND));
    public static final Unit<Acceleration> METERS_PER_SQUARE_SECOND = METRES_PER_SQUARE_SECOND;
    public static final Unit<Area> SQUARE_METRE = SI.u(METRE.multiply(METRE));
    public static final Unit<Area> SQUARE_METER = SQUARE_METRE;
    public static final Unit<Volume> CUBIC_METRE = SI.u(SQUARE_METRE.multiply(METRE));
    public static final Unit<Length> KILOMETRE = METER.multiply(1000.0);
    public static final Unit<Length> KILOMETER = KILOMETRE;
    public static final Unit<Length> CENTIMETRE = METRE.divide(100.0);
    public static final Unit<Length> CENTIMETER = CENTIMETRE;
    public static final Unit<Length> MILLIMETRE = METRE.divide(1000.0);
    public static final Unit<Length> MILLIMETER = MILLIMETRE;

    private SI() {
    }
}

