/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.distribution;

import Jama.Matrix;
import java.util.Random;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.math.statistics.distribution.MultivariateGaussian;

public abstract class AbstractMultivariateGaussian
implements MultivariateGaussian {
    public Matrix mean;

    @Override
    public Matrix getMean() {
        return this.mean;
    }

    @Override
    public double[] sample(Random rng) {
        int N = this.mean.getColumnDimension();
        Matrix chol = this.getCovariance().chol().getL();
        Matrix vec = new Matrix(N, 1);
        for (int i = 0; i < N; ++i) {
            vec.set(i, 0, rng.nextGaussian());
        }
        Matrix result = this.mean.plus(chol.times(vec).transpose());
        return result.getArray()[0];
    }

    @Override
    public double[][] sample(int nsamples, Random rng) {
        if (nsamples == 0) {
            return new double[0][0];
        }
        int N = this.mean.getColumnDimension();
        Matrix chol = this.getCovariance().chol().getL();
        Matrix vec = new Matrix(N, nsamples);
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < nsamples; ++j) {
                vec.set(i, j, rng.nextGaussian());
            }
        }
        Matrix result = chol.times(vec).transpose();
        for (int i = 0; i < result.getRowDimension(); ++i) {
            for (int j = 0; j < result.getColumnDimension(); ++j) {
                result.set(i, j, result.get(i, j) + this.mean.get(0, j));
            }
        }
        return result.getArray();
    }

    @Override
    public int numDims() {
        return this.mean.getColumnDimension();
    }

    @Override
    public double estimateProbability(double[] sample) {
        int N = this.mean.getColumnDimension();
        Matrix inv_covar = this.getCovariance().inverse();
        double pdf_const_factor = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, N) * this.getCovariance().det());
        Matrix xm = new Matrix(1, N);
        for (int i = 0; i < N; ++i) {
            xm.set(0, i, sample[i] - this.mean.get(0, i));
        }
        Matrix xmt = xm.transpose();
        double v = xm.times(inv_covar.times(xmt)).get(0, 0);
        return pdf_const_factor * Math.exp(-0.5 * v);
    }

    @Override
    public double estimateLogProbability(double[] sample) {
        int N = this.mean.getColumnDimension();
        Matrix inv_covar = this.getCovariance().inverse();
        double cov_det = this.getCovariance().det();
        double pdf_const_factor = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, N) * cov_det);
        Matrix xm = new Matrix(1, N);
        for (int i = 0; i < N; ++i) {
            xm.set(0, i, sample[i] - this.mean.get(0, i));
        }
        Matrix xmt = xm.transpose();
        double v = xm.times(inv_covar.times(xmt)).get(0, 0);
        return Math.log(pdf_const_factor) + -0.5 * v;
    }

    public String toString() {
        if (this.numDims() < 5) {
            return String.format("MultivariateGaussian[mean=%s,covar=%s]", MatrixUtils.toMatlabString(this.mean).trim(), MatrixUtils.toMatlabString(this.getCovariance()));
        }
        return super.toString();
    }

    @Override
    public double[] estimateLogProbability(double[][] x) {
        double[] lps = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            lps[i] = this.estimateLogProbability(x[i]);
        }
        return lps;
    }
}

