/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.similarity.processor;

import org.openimaj.math.matrix.similarity.SimilarityMatrix;
import org.openimaj.math.matrix.similarity.processor.SimilarityMatrixProcessor;

public class NormaliseData
implements SimilarityMatrixProcessor {
    boolean invert = false;

    public NormaliseData() {
        this(false);
    }

    public NormaliseData(boolean invert) {
        this.invert = invert;
    }

    @Override
    public void process(SimilarityMatrix matrix) {
        int c;
        int r;
        int rows = matrix.getRowDimension();
        int cols = matrix.getColumnDimension();
        double[][] data = matrix.getArray();
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (r = 0; r < rows; ++r) {
            for (c = 0; c < cols; ++c) {
                if (data[r][c] < min) {
                    min = data[r][c];
                }
                if (!(data[r][c] > max)) continue;
                max = data[r][c];
            }
        }
        for (r = 0; r < rows; ++r) {
            for (c = 0; c < cols; ++c) {
                double norm = (data[r][c] - min) / (max - min);
                if (this.invert) {
                    norm = 1.0 - norm;
                }
                data[r][c] = norm;
            }
        }
    }
}

