/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms;

import Jama.Matrix;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Book, author={"Hartley, R.~I.", "Zisserman, A."}, title="Multiple View Geometry in Computer Vision", year="2004", edition="Second", publisher="Cambridge University Press, ISBN: 0521540518")
public enum HomographyRefinement {
    NONE{

        @Override
        protected MultivariateVectorFunction getValueFunction(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return null;
        }

        @Override
        public double computeError(Matrix h, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return 0.0;
        }

        @Override
        protected MultivariateMatrixFunction getJacobianFunction(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return null;
        }

        @Override
        public Matrix refine(Matrix initial, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return initial;
        }
    }
    ,
    SINGLE_IMAGE_TRANSFER{

        @Override
        protected MultivariateVectorFunction getValueFunction(final List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return new MultivariateVectorFunction(){

                public double[] value(double[] h) throws IllegalArgumentException {
                    double[] result = new double[data.size() * 2];
                    for (int i = 0; i < data.size(); ++i) {
                        float X1 = ((Point2d)((IndependentPair)data.get(i)).firstObject()).getX();
                        float Y1 = ((Point2d)((IndependentPair)data.get(i)).firstObject()).getY();
                        double t2 = (double)X1 * h[6];
                        double t3 = (double)Y1 * h[7];
                        double t4 = h[8] + t2 + t3;
                        double t5 = 1.0 / t4;
                        result[i * 2 + 0] = t5 * (h[2] + (double)X1 * h[0] + (double)Y1 * h[1]);
                        result[i * 2 + 1] = t5 * (h[5] + (double)X1 * h[3] + (double)Y1 * h[4]);
                    }
                    return result;
                }
            };
        }

        @Override
        protected MultivariateMatrixFunction getJacobianFunction(final List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return new MultivariateMatrixFunction(){

                public double[][] value(double[] h) {
                    double[][] result = new double[2 * data.size()][9];
                    for (int i = 0; i < data.size(); ++i) {
                        float X1 = ((Point2d)((IndependentPair)data.get(i)).firstObject()).getX();
                        float Y1 = ((Point2d)((IndependentPair)data.get(i)).firstObject()).getY();
                        double t2 = (double)X1 * h[6];
                        double t3 = (double)Y1 * h[7];
                        double t4 = h[8] + t2 + t3;
                        double t5 = 1.0 / t4;
                        double t6 = (double)X1 * h[0];
                        double t7 = (double)Y1 * h[1];
                        double t8 = h[2] + t6 + t7;
                        double t9 = 1.0 / (t4 * t4);
                        double t10 = (double)X1 * t5;
                        double t11 = (double)Y1 * t5;
                        double t12 = (double)X1 * h[3];
                        double t13 = (double)Y1 * h[4];
                        double t14 = h[5] + t12 + t13;
                        result[i * 2 + 0][0] = t10;
                        result[i * 2 + 0][1] = t11;
                        result[i * 2 + 0][2] = t5;
                        result[i * 2 + 0][6] = (double)(-X1) * t8 * t9;
                        result[i * 2 + 0][7] = (double)(-Y1) * t8 * t9;
                        result[i * 2 + 0][8] = -t8 * t9;
                        result[i * 2 + 1][3] = t10;
                        result[i * 2 + 1][4] = t11;
                        result[i * 2 + 1][5] = t5;
                        result[i * 2 + 1][6] = (double)(-X1) * t9 * t14;
                        result[i * 2 + 1][7] = (double)(-Y1) * t9 * t14;
                        result[i * 2 + 1][8] = -t9 * t14;
                    }
                    return result;
                }
            };
        }

        @Override
        public double computeError(Matrix h, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            double error = 0.0;
            for (int i = 0; i < data.size(); ++i) {
                Point2d p1 = ((Point2d)data.get(i).firstObject()).transform(h);
                Point2d p2 = (Point2d)data.get(i).secondObject();
                float dx = p1.getX() - p2.getX();
                float dy = p1.getY() - p2.getY();
                error += (double)(dx * dx + dy * dy);
            }
            return error;
        }

        @Override
        public Matrix refine(Matrix initial, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            LevenbergMarquardtOptimizer lm = new LevenbergMarquardtOptimizer();
            ArrayRealVector start = new ArrayRealVector(initial.getRowPackedCopy());
            RealVector observed = HomographyRefinement.toRealVector(data, false);
            int maxEvaluations = 1000;
            int maxIterations = 1000;
            MultivariateVectorFunction value = this.getValueFunction(data);
            MultivariateMatrixFunction jacobian = this.getJacobianFunction(data);
            MultivariateJacobianFunction model = LeastSquaresFactory.model((MultivariateVectorFunction)value, (MultivariateMatrixFunction)jacobian);
            LeastSquaresOptimizer.Optimum result = lm.optimize(LeastSquaresFactory.create((MultivariateJacobianFunction)model, (RealVector)observed, (RealVector)start, null, (int)1000, (int)1000));
            Matrix improved = MatrixUtils.fromRowPacked(result.getPoint().toArray(), 3);
            MatrixUtils.times(improved, 1.0 / improved.get(2, 2));
            return improved;
        }
    }
    ,
    SINGLE_IMAGE_TRANSFER_INVERSE{

        @Override
        protected MultivariateVectorFunction getValueFunction(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            List dataInv = IndependentPair.swapList(data);
            return SINGLE_IMAGE_TRANSFER.getValueFunction(dataInv);
        }

        @Override
        public double computeError(Matrix h, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            Matrix hInv = h.inverse();
            List dataInv = IndependentPair.swapList(data);
            return SINGLE_IMAGE_TRANSFER.computeError(hInv, dataInv);
        }

        @Override
        protected MultivariateMatrixFunction getJacobianFunction(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            List dataInv = IndependentPair.swapList(data);
            return SINGLE_IMAGE_TRANSFER.getJacobianFunction(dataInv);
        }

        @Override
        public Matrix refine(Matrix initial, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            Matrix hInv = initial.inverse();
            List dataInv = IndependentPair.swapList(data);
            return SINGLE_IMAGE_TRANSFER.refine(hInv, dataInv).inverse();
        }
    }
    ,
    SYMMETRIC_TRANSFER{

        @Override
        protected MultivariateVectorFunction getValueFunction(final List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return new MultivariateVectorFunction(){

                public double[] value(double[] h) throws IllegalArgumentException {
                    double[] result = new double[data.size() * 4];
                    for (int i = 0; i < data.size(); ++i) {
                        float X1 = ((Point2d)((IndependentPair)data.get(i)).firstObject()).getX();
                        float Y1 = ((Point2d)((IndependentPair)data.get(i)).firstObject()).getY();
                        float X2 = ((Point2d)((IndependentPair)data.get(i)).secondObject()).getX();
                        float Y2 = ((Point2d)((IndependentPair)data.get(i)).secondObject()).getY();
                        double t2 = h[0] * h[4] * h[8];
                        double t3 = h[1] * h[5] * h[6];
                        double t4 = h[2] * h[3] * h[7];
                        double t7 = h[0] * h[5] * h[7];
                        double t8 = h[1] * h[3] * h[8];
                        double t9 = h[2] * h[4] * h[6];
                        double t5 = t2 + t3 + t4 - t7 - t8 - t9;
                        double t6 = 1.0 / t5;
                        double t10 = h[0] * h[4];
                        double t11 = t10 - h[1] * h[3];
                        double t12 = t6 * t11;
                        double t13 = h[3] * h[7];
                        double t14 = t13 - h[4] * h[6];
                        double t15 = (double)X2 * t6 * t14;
                        double t16 = h[0] * h[7];
                        double t17 = t16 - h[1] * h[6];
                        double t18 = t12 + t15 - (double)Y2 * t6 * t17;
                        double t19 = 1.0 / t18;
                        double t20 = (double)X1 * h[6];
                        double t21 = (double)Y1 * h[7];
                        double t22 = h[8] + t20 + t21;
                        double t23 = 1.0 / t22;
                        result[4 * i + 0] = t19 * (t6 * (h[1] * h[5] - h[2] * h[4]) + (double)X2 * t6 * (h[4] * h[8] - h[5] * h[7]) - (double)Y2 * t6 * (h[1] * h[8] - h[2] * h[7]));
                        result[4 * i + 1] = -t19 * (t6 * (h[0] * h[5] - h[2] * h[3]) + (double)X2 * t6 * (h[3] * h[8] - h[5] * h[6]) - (double)Y2 * t6 * (h[0] * h[8] - h[2] * h[6]));
                        result[4 * i + 2] = t23 * (h[2] + (double)X1 * h[0] + (double)Y1 * h[1]);
                        result[4 * i + 3] = t23 * (h[5] + (double)X1 * h[3] + (double)Y1 * h[4]);
                    }
                    return result;
                }
            };
        }

        @Override
        public double computeError(Matrix h, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            Matrix hInv = h.inverse();
            double error = 0.0;
            for (int i = 0; i < data.size(); ++i) {
                Point2d p1 = (Point2d)data.get(i).firstObject();
                Point2d p1t = p1.transform(h);
                Point2d p2 = (Point2d)data.get(i).secondObject();
                Point2d p2t = p2.transform(hInv);
                float dx1 = p1t.getX() - p2.getX();
                float dy1 = p1t.getY() - p2.getY();
                float dx2 = p1.getX() - p2t.getX();
                float dy2 = p1.getY() - p2t.getY();
                error += (double)(dx1 * dx1 + dy1 * dy1 + dx2 * dx2 + dy2 * dy2);
            }
            return error;
        }

        @Override
        protected MultivariateMatrixFunction getJacobianFunction(final List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            return new MultivariateMatrixFunction(){

                public double[][] value(double[] h) {
                    double[][] result = new double[4 * data.size()][9];
                    for (int i = 0; i < data.size(); ++i) {
                        float X1 = ((Point2d)((IndependentPair)data.get(i)).firstObject()).getX();
                        float Y1 = ((Point2d)((IndependentPair)data.get(i)).firstObject()).getY();
                        float X2 = ((Point2d)((IndependentPair)data.get(i)).secondObject()).getX();
                        float Y2 = ((Point2d)((IndependentPair)data.get(i)).secondObject()).getY();
                        double t3 = h[4] * h[8];
                        double t4 = h[5] * h[7];
                        double t2 = t3 - t4;
                        double t5 = h[0] * h[4] * h[8];
                        double t6 = h[1] * h[5] * h[6];
                        double t7 = h[2] * h[3] * h[7];
                        double t10 = h[0] * h[5] * h[7];
                        double t11 = h[1] * h[3] * h[8];
                        double t12 = h[2] * h[4] * h[6];
                        double t8 = t5 + t6 + t7 - t10 - t11 - t12;
                        double t9 = 1.0 / (t8 * t8);
                        double t13 = 1.0 / t8;
                        double t14 = h[0] * h[4];
                        double t27 = h[1] * h[3];
                        double t15 = t14 - t27;
                        double t16 = t13 * t15;
                        double t17 = h[3] * h[7];
                        double t28 = h[4] * h[6];
                        double t18 = t17 - t28;
                        double t19 = (double)X2 * t13 * t18;
                        double t20 = h[0] * h[7];
                        double t29 = h[1] * h[6];
                        double t21 = t20 - t29;
                        double t30 = (double)Y2 * t13 * t21;
                        double t22 = t16 + t19 - t30;
                        double t23 = h[1] * h[5];
                        double t32 = h[2] * h[4];
                        double t24 = t23 - t32;
                        double t25 = h[1] * h[8];
                        double t35 = h[2] * h[7];
                        double t26 = t25 - t35;
                        double t31 = 1.0 / t22;
                        double t33 = h[3] * h[8];
                        double t36 = h[5] * h[6];
                        double t34 = t33 - t36;
                        double t37 = 1.0 / (t22 * t22);
                        double t38 = t13 * t24;
                        double t39 = (double)X2 * t2 * t13;
                        double t43 = (double)Y2 * t13 * t26;
                        double t40 = t38 + t39 - t43;
                        double t41 = (double)Y2 * h[7] * t13;
                        double t42 = (double)X2 * t2 * t9 * t18;
                        double t44 = h[0] * h[8];
                        double t46 = h[2] * h[6];
                        double t45 = t44 - t46;
                        double t47 = (double)X2 * h[7] * t13;
                        double t48 = h[0] * h[5];
                        double t50 = h[2] * h[3];
                        double t49 = t48 - t50;
                        double t51 = t9 * t15 * t24;
                        double t52 = (double)X2 * h[4] * t13;
                        double t53 = h[5] * t13;
                        double t54 = (double)X2 * t2 * t9 * t34;
                        double t55 = h[4] * t13;
                        double t56 = t2 * t9 * t15;
                        double t57 = t13 * t49;
                        double t58 = (double)X2 * t13 * t34;
                        double t69 = (double)Y2 * t13 * t45;
                        double t59 = t57 + t58 - t69;
                        double t60 = t9 * t15 * t34;
                        double t61 = (double)Y2 * h[6] * t13;
                        double t62 = (double)X2 * t9 * t18 * t34;
                        double t64 = h[3] * t13;
                        double t63 = t60 + t61 + t62 - t64 - (double)Y2 * t9 * t21 * t34;
                        double t65 = t18 * t18;
                        double t66 = (double)X2 * t9 * t65;
                        double t67 = t9 * t15 * t18;
                        double t68 = t66 + t67 - (double)Y2 * t9 * t18 * t21;
                        double t70 = h[2] * t13;
                        double t71 = h[1] * t13;
                        double t72 = t9 * t15 * t26;
                        double t73 = (double)X2 * t9 * t18 * t26;
                        double t74 = t9 * t15 * t45;
                        double t75 = (double)X2 * h[6] * t13;
                        double t76 = (double)X2 * t9 * t18 * t45;
                        double t78 = h[0] * t13;
                        double t79 = (double)Y2 * t9 * t21 * t45;
                        double t77 = t74 + t75 + t76 - t78 - t79;
                        double t80 = t21 * t21;
                        double t81 = t9 * t15 * t21;
                        double t82 = (double)X2 * t9 * t18 * t21;
                        double t83 = t81 + t82 - (double)Y2 * t9 * t80;
                        double t84 = t9 * t24 * t49;
                        double t85 = (double)Y2 * h[2] * t13;
                        double t86 = (double)Y2 * h[1] * t13;
                        double t87 = (double)X2 * t9 * t18 * t24;
                        double t88 = t9 * t15 * t49;
                        double t89 = (double)X2 * h[3] * t13;
                        double t90 = (double)X2 * t9 * t18 * t49;
                        double t92 = (double)Y2 * h[0] * t13;
                        double t91 = t88 + t89 + t90 - t92 - (double)Y2 * t9 * t21 * t49;
                        double t93 = t15 * t15;
                        double t94 = t9 * t93;
                        double t95 = (double)X2 * t9 * t15 * t18;
                        double t96 = t94 + t95 - (double)Y2 * t9 * t15 * t21;
                        double t97 = (double)X1 * h[6];
                        double t98 = (double)Y1 * h[7];
                        double t99 = h[8] + t97 + t98;
                        double t100 = 1.0 / t99;
                        double t101 = (double)X1 * h[0];
                        double t102 = (double)Y1 * h[1];
                        double t103 = h[2] + t101 + t102;
                        double t104 = 1.0 / (t99 * t99);
                        double t105 = (double)X1 * t100;
                        double t106 = (double)Y1 * t100;
                        double t107 = (double)X1 * h[3];
                        double t108 = (double)Y1 * h[4];
                        double t109 = h[5] + t107 + t108;
                        result[4 * i + 0][0] = -t31 * (t2 * t9 * t24 + (double)X2 * (t2 * t2) * t9 - (double)Y2 * t2 * t9 * t26) + t37 * t40 * (t41 + t42 + t56 - h[4] * t13 - (double)Y2 * t2 * t9 * t21);
                        result[4 * i + 0][1] = t31 * (t53 + t54 - (double)Y2 * h[8] * t13 + t9 * t24 * t34 - (double)Y2 * t9 * t26 * t34) - t37 * t40 * t63;
                        result[4 * i + 0][2] = -t31 * (-t41 + t42 + t55 + t9 * t18 * t24 - (double)Y2 * t9 * t18 * t26) + t37 * t40 * t68;
                        result[4 * i + 0][3] = t31 * (t9 * t24 * t26 - (double)Y2 * t9 * (t26 * t26) + (double)X2 * t2 * t9 * t26) - t37 * t40 * (t47 + t72 + t73 - h[1] * t13 - (double)Y2 * t9 * t21 * t26);
                        result[4 * i + 0][4] = -t31 * (t70 - (double)X2 * h[8] * t13 + t9 * t24 * t45 + (double)X2 * t2 * t9 * t45 - (double)Y2 * t9 * t26 * t45) + t37 * t40 * t77;
                        result[4 * i + 0][5] = t31 * (-t47 + t71 + t9 * t21 * t24 + (double)X2 * t2 * t9 * t21 - (double)Y2 * t9 * t21 * t26) - t37 * t40 * t83;
                        result[4 * i + 0][6] = -t31 * (t9 * (t24 * t24) + (double)X2 * t2 * t9 * t24 - (double)Y2 * t9 * t24 * t26) + t37 * t40 * (t51 + t52 + t87 - (double)Y2 * h[1] * t13 - (double)Y2 * t9 * t21 * t24);
                        result[4 * i + 0][7] = t31 * (t84 + t85 - (double)X2 * h[5] * t13 + (double)X2 * t2 * t9 * t49 - (double)Y2 * t9 * t26 * t49) - t37 * t40 * t91;
                        result[4 * i + 0][8] = -t31 * (t51 - t52 + t86 + (double)X2 * t2 * t9 * t15 - (double)Y2 * t9 * t15 * t26) + t37 * t40 * t96;
                        result[4 * i + 1][0] = t31 * (-t53 + t54 + (double)Y2 * h[8] * t13 + t2 * t9 * t49 - (double)Y2 * t2 * t9 * t45) - t37 * t59 * (t41 + t42 - t55 + t56 - (double)Y2 * t2 * t9 * t21);
                        result[4 * i + 1][1] = -t31 * (t9 * t34 * t49 + (double)X2 * t9 * (t34 * t34) - (double)Y2 * t9 * t34 * t45) + t37 * t59 * t63;
                        result[4 * i + 1][2] = t31 * (-t61 + t62 + t64 + t9 * t18 * t49 - (double)Y2 * t9 * t18 * t45) - t37 * t59 * t68;
                        result[4 * i + 1][3] = -t31 * (-t70 + (double)X2 * h[8] * t13 + t9 * t26 * t49 + (double)X2 * t9 * t26 * t34 - (double)Y2 * t9 * t26 * t45) + t37 * t59 * (t47 - t71 + t72 + t73 - (double)Y2 * t9 * t21 * t26);
                        result[4 * i + 1][4] = t31 * (t9 * t45 * t49 - (double)Y2 * t9 * (t45 * t45) + (double)X2 * t9 * t34 * t45) - t37 * t59 * t77;
                        result[4 * i + 1][5] = -t31 * (-t75 + t78 - t79 + t9 * t21 * t49 + (double)X2 * t9 * t21 * t34) + t37 * t59 * t83;
                        result[4 * i + 1][6] = t31 * (t84 - t85 + (double)X2 * h[5] * t13 + (double)X2 * t9 * t24 * t34 - (double)Y2 * t9 * t24 * t45) - t37 * t59 * (t51 + t52 - t86 + t87 - (double)Y2 * t9 * t21 * t24);
                        result[4 * i + 1][7] = -t31 * (t9 * (t49 * t49) + (double)X2 * t9 * t34 * t49 - (double)Y2 * t9 * t45 * t49) + t37 * t59 * t91;
                        result[4 * i + 1][8] = t31 * (t88 - t89 + t92 + (double)X2 * t9 * t15 * t34 - (double)Y2 * t9 * t15 * t45) - t37 * t59 * t96;
                        result[4 * i + 2][0] = t105;
                        result[4 * i + 2][1] = t106;
                        result[4 * i + 2][2] = t100;
                        result[4 * i + 2][6] = (double)(-X1) * t103 * t104;
                        result[4 * i + 2][7] = (double)(-Y1) * t103 * t104;
                        result[4 * i + 2][8] = -t103 * t104;
                        result[4 * i + 3][3] = t105;
                        result[4 * i + 3][4] = t106;
                        result[4 * i + 3][5] = t100;
                        result[4 * i + 3][6] = (double)(-X1) * t104 * t109;
                        result[4 * i + 3][7] = (double)(-Y1) * t104 * t109;
                        result[4 * i + 3][8] = -t104 * t109;
                    }
                    return result;
                }
            };
        }

        @Override
        public Matrix refine(Matrix initial, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
            LevenbergMarquardtOptimizer lm = new LevenbergMarquardtOptimizer();
            ArrayRealVector start = new ArrayRealVector(initial.getRowPackedCopy());
            RealVector observed = HomographyRefinement.toRealVector(data);
            int maxEvaluations = 1000;
            int maxIterations = 1000;
            MultivariateVectorFunction value = this.getValueFunction(data);
            MultivariateMatrixFunction jacobian = this.getJacobianFunction(data);
            MultivariateJacobianFunction model = LeastSquaresFactory.model((MultivariateVectorFunction)value, (MultivariateMatrixFunction)jacobian);
            LeastSquaresOptimizer.Optimum result = lm.optimize(LeastSquaresFactory.create((MultivariateJacobianFunction)model, (RealVector)observed, (RealVector)start, null, (int)1000, (int)1000));
            Matrix improved = MatrixUtils.fromRowPacked(result.getPoint().toArray(), 3);
            MatrixUtils.times(improved, 1.0 / improved.get(2, 2));
            return improved;
        }
    };


    protected abstract MultivariateVectorFunction getValueFunction(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> var1);

    protected abstract MultivariateMatrixFunction getJacobianFunction(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> var1);

    public abstract double computeError(Matrix var1, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> var2);

    private static RealVector toRealVector(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data, boolean first) {
        double[] vec = new double[data.size() * 2];
        if (first) {
            for (int i = 0; i < data.size(); ++i) {
                vec[i * 2 + 0] = ((Point2d)data.get(i).firstObject()).getX();
                vec[i * 2 + 1] = ((Point2d)data.get(i).firstObject()).getY();
            }
        } else {
            for (int i = 0; i < data.size(); ++i) {
                vec[i * 2 + 0] = ((Point2d)data.get(i).secondObject()).getX();
                vec[i * 2 + 1] = ((Point2d)data.get(i).secondObject()).getY();
            }
        }
        return new ArrayRealVector(vec);
    }

    private static RealVector toRealVector(List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data) {
        double[] vec = new double[data.size() * 4];
        for (int i = 0; i < data.size(); ++i) {
            vec[i * 4 + 0] = ((Point2d)data.get(i).firstObject()).getX();
            vec[i * 4 + 1] = ((Point2d)data.get(i).firstObject()).getY();
            vec[i * 4 + 2] = ((Point2d)data.get(i).secondObject()).getX();
            vec[i * 4 + 3] = ((Point2d)data.get(i).secondObject()).getY();
        }
        return new ArrayRealVector(vec);
    }

    public abstract Matrix refine(Matrix var1, List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> var2);
}

