/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape.util.polygon;

import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.util.polygon.PolygonNode;
import org.openimaj.math.geometry.shape.util.polygon.VertexNode;

public class TopPolygonNode {
    PolygonNode top_node = null;

    public PolygonNode add_local_min(double x, double y) {
        PolygonNode existing_min = this.top_node;
        this.top_node = new PolygonNode(existing_min, x, y);
        return this.top_node;
    }

    public void merge_left(PolygonNode p, PolygonNode q) {
        q.proxy.hole = true;
        if (p.proxy != q.proxy) {
            p.proxy.v[1].next = q.proxy.v[0];
            q.proxy.v[0] = p.proxy.v[0];
            PolygonNode target = p.proxy;
            PolygonNode node = this.top_node;
            while (node != null) {
                if (node.proxy == target) {
                    node.active = 0;
                    node.proxy = q.proxy;
                }
                node = node.next;
            }
        }
    }

    public void merge_right(PolygonNode p, PolygonNode q) {
        q.proxy.hole = false;
        if (p.proxy != q.proxy) {
            q.proxy.v[1].next = p.proxy.v[0];
            q.proxy.v[1] = p.proxy.v[1];
            PolygonNode target = p.proxy;
            PolygonNode node = this.top_node;
            while (node != null) {
                if (node.proxy == target) {
                    node.active = 0;
                    node.proxy = q.proxy;
                }
                node = node.next;
            }
        }
    }

    public int count_contours() {
        int nc = 0;
        PolygonNode polygon = this.top_node;
        while (polygon != null) {
            if (polygon.active != 0) {
                int nv = 0;
                VertexNode v = polygon.proxy.v[0];
                while (v != null) {
                    ++nv;
                    v = v.next;
                }
                if (nv > 2) {
                    polygon.active = nv;
                    ++nc;
                } else {
                    polygon.active = 0;
                }
            }
            polygon = polygon.next;
        }
        return nc;
    }

    public Polygon getResult(Class<Polygon> polyClass) {
        Polygon result = new Polygon();
        int num_contours = this.count_contours();
        if (num_contours > 0) {
            Polygon inner;
            int i;
            PolygonNode npoly_node = null;
            PolygonNode poly_node = this.top_node;
            while (poly_node != null) {
                npoly_node = poly_node.next;
                if (poly_node.active != 0) {
                    Polygon polygon = result;
                    if (num_contours > 1) {
                        polygon = new Polygon();
                    }
                    if (poly_node.proxy.hole) {
                        polygon.setIsHole(poly_node.proxy.hole);
                    }
                    VertexNode vtx = poly_node.proxy.v[0];
                    while (vtx != null) {
                        polygon.addVertex((float)vtx.x, (float)vtx.y);
                        vtx = vtx.next;
                    }
                    if (num_contours > 1) {
                        result.addInnerPolygon(polygon);
                    }
                }
                poly_node = npoly_node;
            }
            Polygon orig = result;
            result = new Polygon();
            for (i = 0; i < orig.getNumInnerPoly(); ++i) {
                inner = orig.getInnerPoly(i);
                if (inner.isHole()) continue;
                result.addInnerPolygon(inner);
            }
            for (i = 0; i < orig.getNumInnerPoly(); ++i) {
                inner = orig.getInnerPoly(i);
                if (!inner.isHole()) continue;
                result.addInnerPolygon(inner);
            }
        }
        return result;
    }

    public void print() {
        System.out.println("---- out_poly ----");
        int c = 0;
        PolygonNode npoly_node = null;
        PolygonNode poly_node = this.top_node;
        while (poly_node != null) {
            System.out.println("contour=" + c + "  active=" + poly_node.active + "  hole=" + poly_node.proxy.hole);
            npoly_node = poly_node.next;
            if (poly_node.active != 0) {
                int v = 0;
                VertexNode vtx = poly_node.proxy.v[0];
                while (vtx != null) {
                    System.out.println("v=" + v + "  vtx.x=" + vtx.x + "  vtx.y=" + vtx.y);
                    vtx = vtx.next;
                }
                ++c;
            }
            poly_node = npoly_node;
        }
    }
}

