/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape.algorithm;

import Jama.Matrix;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.PointList;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class ProcrustesAnalysis {
    protected PointList reference;
    protected Point2d referenceCog;
    protected double scaling;
    protected boolean rotate = true;

    public ProcrustesAnalysis(PointList reference) {
        this(reference, false);
    }

    public ProcrustesAnalysis(PointList reference, boolean normalise) {
        this.reference = reference;
        this.referenceCog = reference.calculateCentroid();
        this.scaling = ProcrustesAnalysis.computeScale(reference, this.referenceCog.getX(), this.referenceCog.getY());
        if (normalise) {
            reference.translate(-this.referenceCog.getX(), -this.referenceCog.getY());
            reference.scale((float)this.scaling);
            this.referenceCog.setX(0.0f);
            this.referenceCog.setY(0.0f);
            this.scaling = 1.0;
        }
    }

    protected static double computeScale(PointList pl, double tx, double ty) {
        double scale = 0.0;
        for (Point2d pt : pl) {
            double x = (double)pt.getX() - tx;
            double y = (double)pt.getY() - ty;
            scale += x * x + y * y;
        }
        scale = Math.sqrt(scale / (double)pl.points.size());
        return 1.0 / scale;
    }

    public Matrix align(PointList toAlign) {
        if (toAlign.points.size() != this.reference.points.size()) {
            throw new IllegalArgumentException("Point lists are different lengths");
        }
        Point2d cog = toAlign.calculateCentroid();
        Matrix trans = TransformUtilities.translateToPointMatrix(cog, this.referenceCog);
        toAlign.translate((float)trans.get(0, 2), (float)trans.get(1, 2));
        double scale = ProcrustesAnalysis.computeScale(toAlign, this.referenceCog.getX(), this.referenceCog.getY());
        float sf = (float)(scale / this.scaling);
        toAlign.scale(this.referenceCog, sf);
        double theta = 0.0;
        if (this.rotate) {
            float num = 0.0f;
            float den = 0.0f;
            int count = this.reference.points.size();
            for (int i = 0; i < count; ++i) {
                Point2d p1 = this.reference.points.get(i);
                Point2d p2 = toAlign.points.get(i);
                float p1x = p1.getX();
                float p1y = p1.getY();
                float p2x = p2.getX();
                float p2y = p2.getY();
                num += p2x * p1y - p2y * p1x;
                den += p2x * p1x + p2y * p1y;
            }
            theta = Math.atan2(num, den);
            toAlign.rotate(this.referenceCog, theta);
        }
        Matrix scaleMat = TransformUtilities.scaleMatrixAboutPoint(sf, sf, this.referenceCog);
        Matrix rotMat = TransformUtilities.rotationMatrixAboutPoint(theta, this.referenceCog.getX(), this.referenceCog.getY());
        return rotMat.times(scaleMat).times(trans);
    }

    public static float computeProcrustesDistance(PointList l1, PointList l2) {
        if (l1.points.size() != l2.points.size()) {
            throw new IllegalArgumentException("Point lists are different lengths");
        }
        int count = l1.points.size();
        float distance = 0.0f;
        for (int i = 0; i < count; ++i) {
            Point2d p1 = l1.points.get(i);
            Point2d p2 = l2.points.get(i);
            float dx = p1.getX() - p2.getX();
            float dy = p1.getY() - p2.getY();
            distance += dx * dx + dy * dy;
        }
        return (float)Math.sqrt(distance);
    }
}

