/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape;

import Jama.Matrix;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.EllipseUtilities;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.RotatedRectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.pair.IndependentPair;

public class Ellipse
implements Shape,
Cloneable {
    private double x;
    private double y;
    private double major;
    private double minor;
    private double rotation;

    public Ellipse(double x, double y, double major, double minor, double rotation) {
        this.x = x;
        this.y = y;
        this.major = major;
        this.minor = minor;
        this.rotation = rotation;
    }

    @Override
    public boolean isInside(Point2d point) {
        double yt;
        double ratioy;
        double rely;
        double cosrot = Math.cos(-this.rotation);
        double sinrot = Math.sin(-this.rotation);
        double relx = (double)point.getX() - this.x;
        double xt = cosrot * relx - sinrot * (rely = (double)point.getY() - this.y);
        double ratiox = xt / this.major;
        return ratiox * ratiox + (ratioy = (yt = sinrot * relx + cosrot * rely) / this.minor) * ratioy <= 1.0;
    }

    @Override
    public Rectangle calculateRegularBoundingBox() {
        double[] minmaxx = new double[2];
        double[] minmaxy = new double[2];
        double tanrot = Math.tan(this.rotation);
        double cosrot = Math.cos(this.rotation);
        double sinrot = Math.sin(this.rotation);
        double tx = Math.atan(-this.minor * tanrot / this.major);
        double ty = Math.atan(this.minor * (1.0 / tanrot) / this.major);
        minmaxx[0] = this.x + (this.major * Math.cos(tx) * cosrot - this.minor * Math.sin(tx) * sinrot);
        minmaxx[1] = this.x + (this.major * Math.cos(tx += Math.PI) * cosrot - this.minor * Math.sin(tx) * sinrot);
        minmaxy[0] = this.y + (this.major * Math.cos(ty) * sinrot + this.minor * Math.sin(ty) * cosrot);
        minmaxy[1] = this.y + (this.major * Math.cos(ty += Math.PI) * sinrot + this.minor * Math.sin(ty) * cosrot);
        double minx = minmaxx[ArrayUtils.minIndex((double[])minmaxx)];
        double miny = minmaxy[ArrayUtils.minIndex((double[])minmaxy)];
        double maxx = minmaxx[ArrayUtils.maxIndex((double[])minmaxx)];
        double maxy = minmaxy[ArrayUtils.maxIndex((double[])minmaxy)];
        return new Rectangle((float)minx, (float)miny, (float)(maxx - minx), (float)(maxy - miny));
    }

    public Polygon calculateOrientedBoundingBox() {
        double minx = -this.major;
        double miny = -this.minor;
        double maxx = this.major;
        double maxy = this.minor;
        Matrix corners = new Matrix((double[][])new double[][]{{minx, miny, 1.0}, {minx, maxy, 1.0}, {maxx, miny, 1.0}, {maxx, maxy, 1.0}});
        corners = corners.transpose();
        Matrix rot = TransformUtilities.rotationMatrix(this.rotation);
        Matrix rotated = rot.times(corners);
        double[][] rotatedData = rotated.getArray();
        double[] rx = ArrayUtils.add((double[])rotatedData[0], (double)this.x);
        double[] ry = ArrayUtils.add((double[])rotatedData[1], (double)this.y);
        Polygon ret = new Polygon();
        ret.points.add(new Point2dImpl((float)rx[0], (float)ry[0]));
        ret.points.add(new Point2dImpl((float)rx[2], (float)ry[2]));
        ret.points.add(new Point2dImpl((float)rx[3], (float)ry[3]));
        ret.points.add(new Point2dImpl((float)rx[1], (float)ry[1]));
        return ret;
    }

    @Override
    public void translate(float x, float y) {
        this.x += (double)x;
        this.y += (double)y;
    }

    @Override
    public void scale(float sc) {
        this.x *= (double)sc;
        this.y *= (double)sc;
        this.major *= (double)sc;
        this.minor *= (double)sc;
    }

    @Override
    public void scale(Point2d centre, float sc) {
        this.translate(-centre.getX(), -centre.getY());
        this.scale(sc);
        this.translate(centre.getX(), centre.getY());
    }

    @Override
    public void scaleCentroid(float sc) {
        this.major *= (double)sc;
        this.minor *= (double)sc;
    }

    @Override
    public Point2d calculateCentroid() {
        return new Point2dImpl((float)this.x, (float)this.y);
    }

    @Override
    public double calculateArea() {
        return Math.PI * this.major * this.minor;
    }

    @Override
    public double minX() {
        return this.calculateRegularBoundingBox().minX();
    }

    @Override
    public double minY() {
        return this.calculateRegularBoundingBox().minY();
    }

    @Override
    public double maxX() {
        return this.calculateRegularBoundingBox().maxX();
    }

    @Override
    public double maxY() {
        return this.calculateRegularBoundingBox().maxY();
    }

    @Override
    public double getWidth() {
        return this.calculateRegularBoundingBox().getWidth();
    }

    @Override
    public double getHeight() {
        return this.calculateRegularBoundingBox().getHeight();
    }

    @Override
    public Shape transform(Matrix transform) {
        return this.asPolygon().transform(transform);
    }

    public Matrix transformAffineCovar(Matrix transform) {
        Matrix affineTransform = TransformUtilities.homographyToAffine(transform, this.x, this.y);
        Matrix affineCovar = EllipseUtilities.ellipseToCovariance(this);
        Matrix newTransform = new Matrix(3, 3);
        newTransform.setMatrix(0, 1, 0, 1, affineCovar);
        newTransform.set(2, 2, 1.0);
        newTransform = affineTransform.times(newTransform).times(affineTransform.transpose());
        return newTransform;
    }

    public Ellipse transformAffine(Matrix transform) {
        Point2d newCOG = this.calculateCentroid().transform(transform);
        return EllipseUtilities.ellipseFromCovariance(newCOG.getX(), newCOG.getY(), this.transformAffineCovar(transform), 1.0f);
    }

    public Matrix normTransformMatrix() {
        double cosrot = Math.cos(this.rotation);
        double sinrot = Math.sin(this.rotation);
        double cosrotsq = cosrot * cosrot;
        double sinrotsq = sinrot * sinrot;
        double scale = Math.sqrt(this.major * this.minor);
        double majorsq = this.major * this.major / (scale * scale);
        double minorsq = this.minor * this.minor / (scale * scale);
        double Cxx = cosrotsq / majorsq + sinrotsq / minorsq;
        double Cyy = sinrotsq / majorsq + cosrotsq / minorsq;
        double Cxy = sinrot * cosrot * (1.0 / majorsq - 1.0 / minorsq);
        double detC = Cxx * Cyy - Cxy * Cxy;
        Matrix cMat = new Matrix((double[][])new double[][]{{Cyy / detC, -Cxy / detC}, {-Cxy / detC, Cxx / detC}});
        cMat = MatrixUtils.sqrt(cMat);
        Matrix retMat = new Matrix((double[][])new double[][]{{cMat.get(0, 0), cMat.get(0, 1), this.x}, {cMat.get(1, 0), cMat.get(1, 1), this.y}, {0.0, 0.0, 1.0}});
        return retMat;
    }

    public Matrix transformMatrix() {
        double cosrot = Math.cos(this.rotation);
        double sinrot = Math.sin(this.rotation);
        double xMajor = cosrot * this.major;
        double yMajor = sinrot * this.major;
        double xMinor = -sinrot * this.minor;
        double yMinor = cosrot * this.minor;
        return new Matrix((double[][])new double[][]{{xMajor, xMinor, this.x}, {yMajor, yMinor, this.y}, {0.0, 0.0, 1.0}});
    }

    @Override
    public Polygon asPolygon() {
        Polygon e = new Polygon();
        Matrix transformMatrix = this.transformMatrix();
        Point2dImpl circlePoint = new Point2dImpl(0.0f, 0.0f);
        for (double t = -Math.PI; t < Math.PI; t += Math.PI / 360) {
            circlePoint.x = (float)Math.cos(t);
            circlePoint.y = (float)Math.sin(t);
            e.points.add(circlePoint.transform(transformMatrix));
        }
        return e;
    }

    @Override
    public double intersectionArea(Shape that) {
        return this.intersectionArea(that, 1);
    }

    @Override
    public double intersectionArea(Shape that, int nStepsPerDimension) {
        if (!this.calculateRegularBoundingBox().isOverlapping(that.calculateRegularBoundingBox())) {
            return 0.0;
        }
        Rectangle union = this.calculateRegularBoundingBox().union(that.calculateRegularBoundingBox());
        float dr = Math.min(union.width, union.height) / (float)nStepsPerDimension;
        int bua = 0;
        int bna = 0;
        int total = 0;
        for (float rx = union.x; rx <= union.x + union.width; rx += dr) {
            for (float ry = union.y; ry <= union.y + union.height; ry += dr) {
                Point2dImpl p = new Point2dImpl(rx, ry);
                boolean inThis = this.isInside(p);
                boolean inThat = that.isInside(p);
                ++total;
                if (inThis && inThat) {
                    ++bna;
                }
                if (!inThis && !inThat) continue;
                ++bua;
            }
        }
        double rectShapeProp = (double)bua / (double)total;
        double intersectProp = (double)bna / (double)bua * rectShapeProp;
        return union.calculateArea() * intersectProp;
    }

    public double getMinor() {
        return this.minor;
    }

    public double getMajor() {
        return this.major;
    }

    public IndependentPair<Matrix, Double> secondMomentsAndScale() {
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Ellipse)) {
            return false;
        }
        Ellipse that = (Ellipse)other;
        return this.major == that.major && this.minor == that.minor && this.x == that.x && this.y == that.y && this.rotation == that.rotation;
    }

    @Override
    public Ellipse clone() {
        Ellipse e;
        try {
            e = (Ellipse)super.clone();
        }
        catch (CloneNotSupportedException e1) {
            return null;
        }
        return e;
    }

    public double getRotation() {
        return this.rotation;
    }

    public String toString() {
        return String.format("Ellipse(x=%4.2f,y=%4.2f,major=%4.2f,minor=%4.2f,rot=%4.2f(%4.2f))", this.x, this.y, this.major, this.minor, this.rotation, this.rotation * 57.29577951308232);
    }

    @Override
    public double calculatePerimeter() {
        double a = this.major;
        double b = this.minor;
        double h = (a - b) * (a - b) / ((a + b) * (a + b));
        return Math.PI * (a + b) * (1.0 + 3.0 * h / (10.0 + Math.sqrt(4.0 - 3.0 * h)));
    }

    @Override
    public RotatedRectangle minimumBoundingRectangle() {
        return new RotatedRectangle(this.x, this.y, 2.0 * this.major, 2.0 * this.minor, this.rotation);
    }

    @Override
    public boolean isConvex() {
        return true;
    }
}

