C
C Max number of nodes and elements
C
      PARAMETER(NMAX=250000)
C
C Max number of nodes per element
C
      PARAMETER(NDSMAX=54)
C
C Max number of subdomains (groups)
C
      PARAMETER(NGMAX=1000)
C
C XYZ(.,I) : 3 coordinates of node I
C           *** 3 values mandatory (even in 2d !)
C
C PR(.,I) : pressures on faces (6 possible) of element I
C           *** need to be filled only if used (i.e. NPR(I) != 0)
C
      REAL*4    XYZ(3,NMAX),PR(6,NMAX)
C
C IBC(.,I) various data (9 possible) attached to node I.
C          *** must be present (can be 9*0)
C
C NODE(0,I) local number (in group) for element I (global numbering)
C
C NODE(1:N,I) list of N nodes of element I 
C            (N=NDS(K) if elment I belongs to group K)
C
C NPR(I) number of faces with pressure in element I (0<=NPR(I)<=6)
C
C NFPR(.,I) list of faces with pressure in element I (NPR(I) members)
C           *** need to be filled only if used (i.e. NPR(I) != 0)
C
C NGROUP(K) subdomain number for group K
C
C NTYP(K) element's type for group K
C         generally NTYP=1. It is used to distinguish between
C         4 nodes quadrangulars in 3d (surface mesh) and 4 nodes
C         tetraedrons:
C         3d quadrangulars: NTYP = 3
C         tetraedrons:      NTYP = 1 (don't ask why:)
C
C NEL(K) number of elements in group K
C
C NDS(K) number of nodes per element in group K
C        Valid values for NDS are:
C         2: segments
C         3: P1 triangles
C         4: Q1 elements in 2d or 3d (surface), or P1 elements in 3d (tetraedrons)
C         6: P2 triangles
C         8: Q1 elements in 3d (hexaedrons)
C         9: Q2 elements in 2d or 3d (surface) (quadrangulars)
C        27: Q2 elements in 3d (hexaedrons)
C
      INTEGER   IBC(9,NMAX),NODE(0:NDSMAX,NMAX),NPR(NMAX),NFPR(6,NMAX)
     &         ,NGROUP(NGMAX),NTYP(NGMAX),NEL(NGMAX),NDS(NGMAX)
C
C HED = title
C
      CHARACTER*80  HED
      CHARACTER*128 FICH
      DATA ITRAD / 0 /
C
      COMMON / AVOIR_NOSTACK / XYZ,PR
     &                        ,IBC,NODE,NPR,NFPR,NF,NGROUP,NTYP,NEL,NDS
