      SUBROUTINE RECONS(NFACE,NF,NF4,NRECONMAX,XMED2,YMED2)
C
      INCLUDE 'com_faces.f'
      INCLUDE 'com_options.f'
C
      IF (NFACE.GT.NFMAX) THEN
        CALL TROPDEPOINTS(NFACE,-1,0)
      ELSE
        NF = NFACE
        IF (ISYM.EQ.4) THEN
          IF (IDEMI.EQ.1.OR.IDEMI.EQ.2) THEN
            NRR = 2
          ELSEIF(IDEMI.EQ.3) THEN
            NRR = 1
          ELSE
            NRR = 4
          ENDIF
        ELSE
          NRR = ISYM
        ENDIF
        NRECONMAX = MIN(NFMAX/NF,NRR)
        IF (NRECONMAX.NE.NRR) THEN
          IF (ILANG.EQ.0) THEN
            PRINT*,
     & '*** Pas assez de mmoire pour toutes les symtries ('
     &           ,NRECONMAX,'/',NRR,')'
          ELSE
            PRINT*,
     & '*** Not enough memory for all the symmetries ('
     &           ,NRECONMAX,'/',NRR,')'
          ENDIF
        ENDIF
        IF (NRECONMAX.GT.1) CALL SYMETR(NF,NRECONMAX,XMED2,YMED2)
        NF4 = NRECONMAX*NF
      ENDIF
      END
C-----------------------------------------------------------------------
      SUBROUTINE SYMETR(NF,NRECONMAX,XMED2,YMED2)
C
      LOGICAL EGAL,BND
      DATA PI / 3.14159265358979 /
      INCLUDE 'com_faces.f'
      INCLUDE 'com_options.f'
C
C symetrie d'ordre 4 dans le plan xy
C
      IF (ISYM.EQ.4) THEN
        IF (ISYMR.EQ.0) THEN
          DO I=1,NF
            I1 = I+NF
            NFAC(1,I1) = NFAC(1,I)
            NFAC(2,I1) = NFAC(NDS,I)
            NFAC(3,I1) = NFAC(NDS-1,I)
            IF (NDS.NE.3) NFAC(4,I1) = NFAC(2,I)
            DO K=1,NDS
              NBOR(K,I1) = NBOR(NDS2-K,I)
            ENDDO
            NNUMFA(I1) = NNUMFA(I)
            NRFAC(I1)  = NRFAC(I)
            ISD2(I1) = ISD2(I)
            IF (IDEMI.EQ.2) THEN
              IF (IFPLAN(I).EQ.3) THEN
                IFPLAN(I) = 4
              ELSEIF(IFPLAN(I).EQ.4) THEN
                IFPLAN(I) = 3
              ENDIF
            ENDIF
            IF (IFPLAN(I).EQ.3) THEN
              IFPLAN(I1) = 1
            ELSE
              IFPLAN(I1) = IFPLAN(I)
            ENDIF
C
            IF (NRECONMAX.GT.2) THEN
              I2 = I1+NF
              NFAC(1,I2) = NFAC(1,I)
              NFAC(2,I2) = NFAC(NDS,I)
              NFAC(3,I2) = NFAC(NDS-1,I)
              IF (NDS.NE.3) NFAC(4,I2) = NFAC(2,I)
              NNUMFA(I2) = NNUMFA(I)
              NRFAC(I2)  = NRFAC(I)
              IF (IFPLAN(I).EQ.3) THEN
                IFPLAN(I2) = 3
              ELSEIF(IFPLAN(I).EQ.4) THEN
                IFPLAN(I2) = 2
              ELSE
                IFPLAN(I2) = IFPLAN(I)
              ENDIF
              DO K=1,NDS
                NBOR(K,I2) = NBOR(NDS2-K,I)
              ENDDO
              ISD2(I2) = ISD2(I)
              IF (NRECONMAX.GT.3) THEN
                I3 = I2+NF
                NFAC(1,I3) = NFAC(1,I)
                NFAC(2,I3) = NFAC(2,I)
                NFAC(3,I3) = NFAC(3,I)
                IF (NDS.NE.3) NFAC(4,I3) = NFAC(4,I)
                NNUMFA(I3) = NNUMFA(I)
                NRFAC(I3)  = NRFAC(I)
                IF (IFPLAN(I).EQ.3) THEN
                  IFPLAN(I3) = 1
                ELSEIF(IFPLAN(I).EQ.4) THEN
                  IFPLAN(I3) = 2
                ELSE
                  IFPLAN(I3) = IFPLAN(I)
                ENDIF
                DO K=1,NDS
                  NBOR(K,I3) = NBOR(K,I)
                ENDDO
                ISD2(I3) = ISD2(I)
              ENDIF
            ENDIF
          ENDDO
C
          DO I=1,NF
            I1 = I+NF
            IF (IDEMI.EQ.2) THEN
              XF(1,I1) = -XF(1,I)-XMED2
              YF(1,I1) =  YF(1,I)
              XF(2,I1) = -XF(NDS,I)-XMED2
              YF(2,I1) =  YF(NDS,I)
              XF(3,I1) = -XF(NDS-1,I)-XMED2
              YF(3,I1) =  YF(NDS-1,I)
              IF (NDS.NE.3) THEN
                XF(4,I1) = -XF(2,I)-XMED2
                YF(4,I1) =  YF(2,I)
              ENDIF
              XF(NDS2,I1) = -XF(NDS2,I)-XMED2
              YF(NDS2,I1) =  YF(NDS2,I)
            ELSE
              XF(1,I1) =  XF(1,I)
              YF(1,I1) = -YF(1,I)-YMED2
              XF(2,I1) =  XF(NDS,I)
              YF(2,I1) = -YF(NDS,I)-YMED2
              XF(3,I1) =  XF(NDS-1,I)
              YF(3,I1) = -YF(NDS-1,I)-YMED2
              IF (NDS.NE.3) THEN
                XF(4,I1) =  XF(2,I)
                YF(4,I1) = -YF(2,I)-YMED2
              ENDIF
              XF(NDS2,I1) =  XF(NDS2,I)
              YF(NDS2,I1) = -YF(NDS2,I)-YMED2
            ENDIF
C
            ZF(1,I1) =  ZF(1,I)
            ZF(2,I1) =  ZF(NDS,I)
            ZF(3,I1) =  ZF(NDS-1,I)
            IF (NDS.NE.3) ZF(4,I1) =  ZF(2,I)
            ZF(NDS2,I1) = ZF(NDS2,I)
C
            IF (NRECONMAX.GT.2) THEN
              I2 = I1+NF
              XF(1,I2) = -XF(1,I)-XMED2
              YF(1,I2) =  YF(1,I)
              ZF(1,I2) =  ZF(1,I)
              XF(2,I2) = -XF(NDS,I)-XMED2
              YF(2,I2) =  YF(NDS,I)
              ZF(2,I2) =  ZF(NDS,I)
              XF(3,I2) = -XF(NDS-1,I)-XMED2
              YF(3,I2) =  YF(NDS-1,I)
              ZF(3,I2) =  ZF(NDS-1,I)
              IF (NDS.NE.3) THEN
                XF(4,I2) = -XF(2,I)-XMED2
                YF(4,I2) =  YF(2,I)
                ZF(4,I2) =  ZF(2,I)
              ENDIF
              XF(NDS2,I2) = -XF(NDS2,I)-XMED2
              YF(NDS2,I2) =  YF(NDS2,I)
              ZF(NDS2,I2) =  ZF(NDS2,I)
              IF (NRECONMAX.GT.3) THEN
                I3 = I2+NF
                XF(1,I3) = -XF(1,I)-XMED2
                YF(1,I3) = -YF(1,I)-YMED2
                ZF(1,I3) =  ZF(1,I)
                XF(2,I3) = -XF(2,I)-XMED2
                YF(2,I3) = -YF(2,I)-YMED2
                ZF(2,I3) =  ZF(2,I)
                XF(3,I3) = -XF(3,I)-XMED2
                YF(3,I3) = -YF(3,I)-YMED2
                ZF(3,I3) =  ZF(3,I)
                IF (NDS.NE.3) THEN
                  XF(4,I3) = -XF(4,I)-XMED2
                  YF(4,I3) = -YF(4,I)-YMED2
                  ZF(4,I3) =  ZF(4,I)
                ENDIF
                XF(NDS2,I3) = -XF(NDS2,I)-XMED2
                YF(NDS2,I3) = -YF(NDS2,I)-YMED2
                ZF(NDS2,I3) =  ZF(NDS2,I)
              ENDIF
            ENDIF
          ENDDO
C symetrie de rotation d'ordre 4 dans le plan xy
        ELSE
          DO I=1,NF
            I1 = I+NF
            DO K=1,NDS
              NFAC(K,I1) = NFAC(K,I)
              NBOR(K,I1) = NBOR(K,I)
            ENDDO
            NNUMFA(I1) = NNUMFA(I)
            NRFAC(I1)  = NRFAC(I)
            ISD2(I1) = ISD2(I)
            IF (IFPLAN(I).EQ.2) THEN
              IFPLAN(I) = 3
              IFPLAN(I1) = 4
            ELSEIF(IFPLAN(I).EQ.3) THEN
              IFPLAN(I) = 4
              IFPLAN(I1) = 1
            ELSE
              IFPLAN(I1) = IFPLAN(I)
            ENDIF
C
            IF (NRECONMAX.GT.2) THEN
              I2 = I1+NF
              DO K=1,NDS
                NFAC(K,I2) = NFAC(K,I)
                NBOR(K,I2) = NBOR(K,I)
              ENDDO
              NNUMFA(I2) = NNUMFA(I)
              NRFAC(I2)  = NRFAC(I)
              IF (IFPLAN(I).EQ.3) THEN
                IFPLAN(I2) = 2
              ELSE
                IFPLAN(I2) = IFPLAN(I)
              ENDIF
              ISD2(I2) = ISD2(I)
              IF (NRECONMAX.GT.3) THEN
                I3 = I2+NF
                DO K=1,NDS
                  NFAC(K,I3) = NFAC(K,I)
                  NBOR(K,I3) = NBOR(K,I)
                ENDDO
                NNUMFA(I3) = NNUMFA(I)
                NRFAC(I3)  = NRFAC(I)
                IFPLAN(I3) = IFPLAN(I)
                ISD2(I3) = ISD2(I)
              ENDIF
            ENDIF
          ENDDO
C
          XPYMED = (XMED2+YMED2)*0.5
          XMYMED = (XMED2-YMED2)*0.5
          DO I=1,NF
            I1 = I+NF
            IF (IDEMI.EQ.2) THEN
              DO K=1,NDS
                XF(K,I1) =  YF(K,I)-XMYMED
                YF(K,I1) = -(XF(K,I)+XPYMED)
                ZF(K,I1) =  ZF(K,I)
              ENDDO
            ELSE
              DO K=1,NDS
                XF(K,I1) = -(YF(K,I)+XPYMED)
                YF(K,I1) =  XF(K,I)+XMYMED
                ZF(K,I1) =  ZF(K,I)
              ENDDO
            ENDIF
            IF (NRECONMAX.GT.2) THEN
              I2 = I1+NF
              DO K=1,NDS
                XF(K,I2) =  YF(K,I)-XMYMED
                YF(K,I2) = -(XF(K,I)+XPYMED)
                ZF(K,I2) =  ZF(K,I)
              ENDDO
              IF (NRECONMAX.GT.3) THEN
                I3 = I2+NF
                DO K=1,NDS
                  XF(K,I3) = -(XF(K,I)+XMED2)
                  YF(K,I3) = -(YF(K,I)+YMED2)
                  ZF(K,I3) =  ZF(K,I)
                ENDDO
              ENDIF
            ENDIF
          ENDDO
        ENDIF
C
C Ordre different de 4
C
      ELSE
        XMED22 = .5*XMED2
        YMED22 = .5*YMED2
        DO N=1,NRECONMAX-1
          NSHIFT = NF*N
          IF (MOD(N,2).EQ.1) THEN
            ANG = REAL(2*(N+1))*PI/REAL(ISYM)
            NNMOD = 0
c            I2 = NDS
c            I3 = NDS-1
c            I4 = 2
          ELSE
            ANG = REAL(2*N+4)*PI/REAL(ISYM)
            NNMOD = NF
c            I2 = 2
c            I3 = 3
c            I4 = 4
          ENDIF
          COCO = COS(ANG)
          SISI = SIN(ANG)
          DO J=1,NF
            II = J+NSHIFT
            I  = J+NNMOD
            NFAC(1,II) = NFAC(1,I)
            NFAC(2,II) = NFAC(NDS,I)
            NFAC(3,II) = NFAC(NDS-1,I)
            IF (NDS.NE.3) NFAC(4,II) = NFAC(2,I)
            DO K=1,NDS
              NBOR(K,II) = NBOR(NDS2-K,I)
            ENDDO
            NNUMFA(II) = NNUMFA(I)
            NRFAC(II)  = NRFAC(I)
            ISD2(II)   = ISD2(I)
C
            XF(1,II) = COCO*(XF(1,I)+XMED22)
     &               + SISI*(YF(1,I)+YMED22) - XMED22
            YF(1,II) = SISI*(XF(1,I)+XMED22)
     &               - COCO*(YF(1,I)+YMED22) - YMED22
            XF(2,II) = COCO*(XF(NDS,I)+XMED22)
     &               + SISI*(YF(NDS,I)+YMED22) - XMED22
            YF(2,II) = SISI*(XF(NDS,I)+XMED22)
     &               - COCO*(YF(NDS,I)+YMED22) - YMED22
            XF(3,II) = COCO*(XF(NDS-1,I)+XMED22)
     &               + SISI*(YF(NDS-1,I)+YMED22) - XMED22
            YF(3,II) = SISI*(XF(NDS-1,I)+XMED22)
     &               - COCO*(YF(NDS-1,I)+YMED22) - YMED22
            IF (NDS.NE.3) THEN
              XF(4,II) = COCO*(XF(2,I)+XMED22)
     &                 + SISI*(YF(2,I)+YMED22) - XMED22
              YF(4,II) = SISI*(XF(2,I)+XMED22)
     &                 - COCO*(YF(2,I)+YMED22) - YMED22
              ZF(4,II) =  ZF(2,I)
            ENDIF
            XF(NDS2,II) = COCO*(XF(NDS2,I)+XMED22)
     &                  + SISI*(YF(NDS2,I)+YMED22) - XMED22
            YF(NDS2,II) = SISI*(XF(NDS2,I)+XMED22)
     &                  - COCO*(YF(NDS2,I)+YMED22) - YMED22
C
            ZF(1,II) = ZF(1,I)
            ZF(2,II) = ZF(NDS,I)
            ZF(3,II) = ZF(NDS-1,I)
            ZF(NDS2,II) = ZF(NDS2,I)
C
            IF (NDS.EQ.3) THEN
              BND = .TRUE.
            ELSE
              BND = EGAL(XF(4,II),XF(2,II-NF))
     &         .AND.EGAL(YF(4,II),YF(2,II-NF))
            ENDIF
            BND = BND.AND.EGAL(XF(1,II),XF(1,II-NF))
     &               .AND.EGAL(YF(1,II),YF(1,II-NF))
     &               .AND.EGAL(XF(2,II),XF(NDS,II-NF))
     &               .AND.EGAL(YF(2,II),YF(NDS,II-NF))
     &               .AND.EGAL(XF(3,II),XF(NDS-1,II-NF))
     &               .AND.EGAL(YF(3,II),YF(NDS-1,II-NF))
            IF (BND) THEN
              IFPLAN(II) = ISYM-N+1
              IFPLAN(II-NF) = ISYM-N+1
            ELSE
              IFPLAN(II) = IFPLAN(I)
            ENDIF
          ENDDO
        ENDDO
      ENDIF
      END
C=======================================================================
      SUBROUTINE MINDIAM(NFACE)
      INCLUDE 'com_faces.f'
      INCLUDE 'com_options.f'
C
      DIAMIN = BIG
      IF (NDS.EQ.2) THEN
        DO I=1,NFACE
          DIAMIN = MIN(DIAMIN,(XF(1,I)-XF(2,I))**2
     &                       +(YF(1,I)-YF(2,I))**2
     &                       +(ZF(1,I)-ZF(2,I))**2)
        ENDDO
      ELSE
        DO I=1,NFACE
          DIAMIN = MIN(DIAMIN
     &                ,MAX((XF(1,I)-XF(3,I))**2
     &                    +(YF(1,I)-YF(3,I))**2
     &                    +(ZF(1,I)-ZF(3,I))**2
     &                    ,(XF(2,I)-XF(NDS,I))**2
     &                    +(YF(2,I)-YF(NDS,I))**2
     &                    +(ZF(2,I)-ZF(NDS,I))**2))
        ENDDO
      ENDIF
      DIAMIN = SQRT(DIAMIN)
      IF (ISTDOUT.EQ.0) THEN
        IF (ILANG.EQ.0) THEN
          PRINT*,'Diamtre minimal d''une face =',DIAMIN
        ELSE
          PRINT*,'Smallest diameter of a facet =',DIAMIN
        ENDIF
      ENDIF
      TOL = DIAMIN*1.E-3
      END
C=======================================================================
      LOGICAL FUNCTION EGAL(X,Y)
      INCLUDE 'com_options.f'
C
      IF (ABS(X-Y).LT.TOL) THEN
        EGAL = .TRUE.
      ELSE
        EGAL = .FALSE.
      ENDIF
      END
