#!/usr/bin/perl
#
# ircmapR-ircnet.pl
#
# Make a pretty image with tree of some IRC network
#
# This one will parse dump of IRC network masks, servers and lists and outputs
# reworked dump, for deity staff of ircnet.com :P.
#
# Basically output is same as input, only there's one universal delimiter ||@||
#
# (c) Petr Baudis <pasky@pasky.ji.cz> 2001, 2002
#
# Other authors: yanek <janek@isse.lipniknb.cz>
#        Thanks: ZZyZZ, jv, pht
#
# No warranty, and so on... distributed under GPL.
# Get it on http://pasky.ji.cz/~pasky/irc
#
# You need to have (as with a lot of my other scripts) IHash.pm
# (case-insensitive hash support) module also now. Please download it at
# http://pasky.ji.cz/~pasky/cp/IHash.pm.
#


###############################################################################
#
# Defaults:
#
## Superverbose?
$v = 1;

$delim = '||@||';

use lib "/home/pasky/ircmap";
	      # replace with the dir where you've IHash.pm (http://pasky.ji.cz/~pasky/cp/IHash.pm)

###############################################################################
#
# If you are not interested in code itself, you should stop here.
#
###############################################################################
#
# Details:
#
$ve="2.0pre4";
$ver="ircmap-$ve";

use IHash;

#
# Read the dump
#

print STDERR "Redumping...\n" if ($v);

while (<>) {
  chomp;

  @input = split(/ /);
  $t = shift(@input);

  if ($t eq 'S') {
    my ($m) = shift(@input);
    my ($s) = shift(@input);
    
    print join($delim, 'S', $m, $s, join(' ', @input)), "\n";
    
  } elsif ($t eq 'M') {
    my ($m) = shift(@input);
    my ($r) = shift(@input);
    my ($n) = shift(@input);

    print join($delim, 'M', $m, $r, $n), "\n";
    
  } elsif ($t eq 'L') {
    my ($s) = shift(@input);
    my ($d) = shift(@input);

    print join($delim, 'L', $s, $d), "\n";

  } elsif ($t eq 'X') {
    my ($k) = shift(@input);

    print join($delim, 'X', $k, join(' ', @input)), "\n";

  } elsif ($t eq 'U') {
    my ($s) = shift(@input);
    my ($u) = shift(@input);

    print join($delim, 'U', $s, $u), "\n";

  } elsif ($t eq 'A') {
    my ($s) = shift(@input);
    my ($a) = join(' ', @input);
    my (@a) = split(/"""/, $a);

    print join($delim, 'A', $s, @a), "\n";
    
  } else {

#    print STDERR "Syntax error: $t ", @input, "\n";
#    exit -1;
  }
}

###############################################################################
#
# No more interesting stuff :-(r)
#
