# How To Use

Nomad uses [`go-changelog`](https://github.com/hashicorp/go-changelog) to generate its changelog on release.

To install, run the following command:

```
go install github.com/hashicorp/go-changelog/cmd/changelog-build@latest
```

## Developer Guide

PRs with code changes should include a `.changelog/<PR Number>.txt` file highlighting the user visible change.

The changelog entry should include the affected component (e.g. `driver/docker`, `api`), and a user-centric summary of the change. If an issue warrants more elaborate description, also update the [Upgrade Guide](../website/content/docs/upgrade/upgrade-specific.mdx).

Use the PR number as the file name. Enterprise private changes should have an entry in the OSS repository referencing a public GitHub issues detailing the change and impact.

The `.txt` files have a markdown-like syntax, with a tag signifying the entry type.

Use the `tools/cl-entry` command to help generate a changelog entry file.

```shell
make cl
```

Below are some examples of how to generate a CHANGELOG entry with your pull request.

### Improvement

~~~
```release-note:improvement
internal/server: Add new option for configs
```
~~~

### Feature

Significant major release features. Typically included in release blog announcement and keynotes.

~~~
```release-note:feature
**Consul namespace support (Enterprise)**: Run Nomad-defined services in their HashiCorp Consul namespaces more easily using Nomad Enterpris
```
~~~

### Improvements

Improvements are incremental and quality of life enhancement that don't rise to the FEATURES level:

```release-note:improvement
cli: Added `-monitor` flag to `deployment status` command and automatically monitor deployments from `job run` command.
```

### Bug

~~~
```release-note:bug
client/fingerprint/java: Fixed a bug where java fingerprinter would not detect some Java distributions
```
~~~

### Multiple Entries

If a PR has multiple entries,

~~~
```release-note:bug
driver/docker: Fix broken code
```
```release-note:bug
client: Fix broken code
```
```release-note:bug
cli: Fix broken code
```
~~~

### Long Description with Markdown

~~~
```release-note:feature
main: Lorem ipsum dolor `sit amet`, _consectetur_ adipiscing elit, **sed** do
eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim
veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo
consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse
cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non
proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
```
~~~


## How to generate CHANGELOG entries for release

Below is an example for running `go-changelog` to generate a collection of
entries. It will generate output that can be inserted into CHANGELOG.md manually.

To generate latest release changelog entry:

```
make changelog
```

You can also call `changelog-build` binary directly. For more information as to what each flag does, make sure to run `changelog-build -help`.

```
cd .changelog
changelog-build -last-release v1.1.2 -this-release HEAD \
                -entries-dir . -changelog-template changelog.tmpl -note-template note.tmpl
```

The command will output the changelog entries to be inserted into CHANGELOG.md with version header (e.g. `## 1.1.3 (August 10, 2022)`). The output is like:

```md
IMPROVEMENTS:

* Added the `bar` interface. [[GH-2032](https://github.com/hashicorp/nomad/issues/2032)]

DEPRECATIONS:

* Deprecated the `foo` interface, please use the `bar` interface instead. [[GH-1001](https://github.com/hashicorp/nomad/issues/1001)]

BUG FIXES:

* csi: fixed a CLI panic when formatting `volume status` with `-verbose` flag [[GH-10818](https://github.com/hashicorp/nomad/issues/10818)]
```

## FAQ

### Can I amend the changelog entry after the PR merged?

Yes. If the release is not out, just update the entry file, or add missed entries. If the original PR is a to-be-backported change, ensure the changelog entry update PR also has the `label:stage/needs-backporting` and appropriate milestone so the backport includes the update too.

When amending entries for an already published release, update the CHANGELOG.md file directly.

### Just modified the entry file, but the `go-changelog` isn't picking it up.

Commit the entry first! `go-changelog` operators on committed files only.


