/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Score.h"
#include "Globals.h"
#include "RTS.h"
#include "PreBattle.h"
#include "Random.h"

namespace Score {

Score_State::Score_State() {
	int x = 50;
	int y = 100;

	for (int i = 0; i != sides.size(); ++i) {
		myWindows.push_back(GenWindow(x, y, RTS_SideStats, i, 0, 0));

		x+= 250;
	}

	JSDL.LoadMusic(globalSettings.bdp + "music/fission.ogg");
	JSDL.PlayMusic();
}

Score_State::~Score_State() {
	if (gsTo == GST_PreBattle)
		RTS::RestartPreBattle();
	else
		PreBattle::Unload();
	KillAllWindows();
}

void Score_State::Main() {
	DrawWorld();
}

void Score_State::MouseD(Uint8 button, Uint16 x, Uint16 y) {
	if (button == SDL_BUTTON_RIGHT)
		myWindows.push_back(GenWindow(x, y, Score_BasePU, 0, 0, 0));
}

void Score_State::Keyboard(SDL_keysym& keysym) {
	if (keysym.sym == SDLK_ESCAPE)
		gsTo = GST_MainMenu;
}

void DrawWorld() {
	JSDL.BltFill(screenRect, 0);

	int winner = -1;	
	int sidesLeft = 0;
	string result;

	for (int i  = 0; i != sides.size(); ++i) {
		int sideTotalCS = sides[i].GetTotalCapShips();

		if (sideTotalCS) {
			++sidesLeft;
			winner = i;
		}
	}

	if (winner == -1)
		result = "The battle must be declared a draw, as against all odds\nthe last remaining capital ships were destroyed at the exact same moment.";
	else if (sidesLeft > 1)
		result = "The battle must be declared a draw, as the maximum frame limit was exceeded.";
	else {
		result = "The battle has ended. ";
		result += sides[winner].name;
		if (sides[winner].name[sides[winner].name.size() - 1] == 's')
			result += " are ";
		else
			result += " is ";
		result += "victorious.";
	}	
	
	bool toFile = false;
	if (globalSettings.batch)
		toFile = true;
		
	WriteText("Battle result:", toFile);
	for (int i = 0; i != sides.size(); ++i) {
		char output[256];
		sprintf(output, "%s: Points: %d Remaining capital ships: %d Remaining non capital ships: %d Total remaining health: %d", sides[i].name.c_str(), sides[i].myPoints, sides[i].GetTotalCapShips(), sides[i].GetTotalUnits() - sides[i].GetTotalCapShips(), sides[i].GetTotalHealth());
		WriteText(output, toFile);
	}
	WriteText(result, toFile);
	char output[100];
	sprintf(output, "Frames elapsed: %d", frameCounter);
	WriteText(output, toFile);
	WriteText("", toFile);

	if (globalSettings.batch)
		gsTo = GST_TheOS;

	boldFonts.BlitString(50, 50, 0, result);

	DrawAllWindows();
}

BasePU::BasePU(int ix, int iy):
PopupMenu(ix, iy, none_constant, 0) {
	MenuItem tempItem;

	tempItem.desc = "Restart battle";
	tempItem.choice = Score_Restart;
	AddItem(tempItem);

	tempItem.desc = "Main menu";
	tempItem.choice = WC_Quit;
	AddItem(tempItem);

	InitRects();
}

bool BasePU::SwitchOnChoice(Uint16 x, Uint16 y) {
	if (currentSelection.choiceType == MCT_LeftCursor) {
		switch (currentSelection.choice) {
		case Score_Restart:
			gsTo = GST_PreBattle;
			break;
		case WC_Quit:
			gsTo = GST_MainMenu;
			closed = true;
			break;
		}
	}

	return false;
}

} //end namespace


