# Distro MXE

MXE is a cross-compilation environment for Linux that creates
Windows executables. It already has a configuration file
to build `sox.exe' from `sox-14.4.2`.

It's just too easy make it build `sox.exe`:
Install the other packages it depends on
(see https://mxe.cc/#requirements) then
```
git clone https://github.com/mxe/mxe.git
cd mxe
make sox
```
and `sox.exe` will appear, after a long pause, as
```
usr/i686-w64-mingw32.static/bin/sox.exe
```

This has been adapted for `sox_ng`. See issue #65

Currently, "make sox" says that it fails but
it does so after making `sox_ng.exe` while trying to
compile a trivial program in `test/`. Reason unknown.

## Things for mxe.cc to do

`src/sox.mk` lists as build dependencies:
```
$(PKG)_DEPS     := cc file flac lame libltdl libmad libpng libsndfile \
                   opencore-amr opus twolame vorbis wavpack
```
but that wants to be `opusfile`, not `opus`.

It also wants `libid3tag` and in the configuration section
```
         --without-id3tag \
```
wants to be
```
         --with-id3tag \
```

For `sox_ng` you also want the build dependencies:
```
                   fftw speexdsp
```
and for sox_ng-14.5 you want to configure
```
         --with-ffmpeg \
```
For 14.6 it is enabled by default.

If `ffmpeg` is not found at run-time, it just can't decode
the four dozen extra file formats and fails cleanly.

Lastly, if you decide to use `sox_ng` as a drop-in replacement for `sox.sf.net`,
configure
```
         --enable-replace \
```
