/*
  File: support.c

  Copyright (C) 2007
  Marcin 'Morgoth' Kurek <morgoth6@box43.pl>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/stat.h>

#include "bootcreator.h"

/*
 * Private
 */

static bool check_for_data(char *buffer);

/*
 * ToUpper
 */

char *to_upper(char *str)
{
	char *x = str;
	char sign;

	if(x)
	{
		while(*x = toupper(*x))
			++x;
	}

	/* End */
	return (str);
}

/*
 * GetLine
 */

int get_line(int fh, int limit, char *buf, int *stat_line, bool pure)
{
	int res = 0;

	if(fh && limit && buf)
	{
		char read_buf;
		int read_res;

		/* Read */
		while((read_res = read(fh, &read_buf, 1)) == 1)
		{
			if(!pure)
			{
				/* Ignore all white chars at begining of the line */
				if(res == 0 && isspace(read_buf))
				{
					if(read_buf == '\n')
						++(*stat_line);

					continue;
				}

				/* New line */
				if(read_buf == '\r')
					continue;	/*  This ugly "thing" should add support for CR/LF new line style
								   inside description file */
			}

			if(read_buf == '\n')
			{
				++(*stat_line);

				break;
			}

			/* Counter */
			++res;

			/* Add to buffer */
			*buf = read_buf;
			++buf;

			/* Sanity */
			if(limit && (res >= limit))
				break;
		}

		/* Insert EOL */
		if(*buf != '\0')
			*buf = '\0';

		/* Sanity */
		if(read_res == -1)
			res = -1;
	}

	/* End */
	return (res);
}

/*
 * load_i
 */

int load_i(const char *buf)
{
	int res = ~0;

	/* Ignore all white chars */
	while(isspace(*buf))
		++buf;

	if(buf && isdigit(*buf))
		res = atoi(buf);

	/* End */
	return (res);
}

/*
 * load_b
 */

int load_b(const char *buf_a)
{
	int res = ~0;
	char buf_b[FILE_BUF_SIZE];
	char *buf = buf_b;

	/* Copy ... */
	strncpy(buf_b, buf_a, FILE_BUF_SIZE);

	/* Ignore all white chars */
	while(isspace(*buf))
		++buf;

	/* Unify */
	to_upper(buf);

	/* And finaly check */
	if((strncmp(buf, "TRUE", strlen("TRUE")) == 0) || (strncmp(buf, "YES", strlen("YES")) == 0) || (strncmp(buf, "1", strlen("1")) == 0))
	{
		res = true;
	}
	else if((strncmp(buf, "FALSE", strlen("FALSE")) == 0) || (strncmp(buf, "NO", strlen("NO")) == 0) || (strncmp(buf, "0", strlen("0")) == 0))
	{
		res = false;
	}

	/* End */
	return (res);
}

/*
 * get_var
 */

bool get_var(char *buf_a, struct bcvar * var)
{
	bool res = false;
	char buf[FILE_BUF_SIZE];

	/* Errase var ! */
	var->var[0] = '\0';
	var->val[0] = '\0';

	/* Parse line */
	if(buf_a && var)
	{
		char *token;

		/* Copy buf to our buffer (strtok() modify it ! */
		strncpy(buf, buf_a, FILE_BUF_SIZE);

		/* Parse ... */
		if(token = strtok(buf, GETVAR_DELIM))
		{
			/* Copy ... */
			strncpy(var->var, token, FILE_BUF_SIZE);

			/* Get the var value */
			if(token = strtok(NULL, GETVAR_DELIM))
			{
				/* Copy ... */
				strncpy(var->val, token, FILE_BUF_SIZE);

				/* Sanity check */
				if((strtok(NULL, GETVAR_DELIM) == NULL) && (var->var[0] != '\0') && (var->val[0] != '\0'))
				{
					/* Check is var && val contain any usefull data */
					if(check_for_data(var->var) && check_for_data(var->val))
						res = true;
				}
			}
		}
	}

	/* End */
	return (res);
}

/*
 * save_line
 */

int save_line(int file, char *buffer, int size)
{
	int written = write(file, buffer, size);

	/* End */
	return (written);
}

int convert_case(int x)
{
	if(x == SECTION_LIMIT)
		return (0);

	/* End */
	return (x);
}

/*
 * Private
 */

static bool check_for_data(char *buffer)
{
	bool res = false;

	if(buffer)
	{
		while(*buffer && !res)
		{
			if(!isspace(*buffer))
				res = true;

			/* Next ... */
			++buffer;
		}
	}

	/* End */
	return (res);
}
