/*
 * types.h --- definition of global values.
 *
 * Copyright (c) 1997, 98, 99, 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2004-07-01 00:38:10 pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef TYPES_H
#define TYPES_H

#include	"dis_type.h"

/*--------------------------------------------------------------------------*/

typedef		unsigned char		UCHAR;

#define		ILLEGAL		(-1)

typedef		unsigned char		bool_t;
#define		TRUE		1
#define		FALSE		0

/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/

/* Liste de tous les types de pieces.
 * Ceci est le code qui sera mis dans l'echiquier.
 */
typedef enum { ROI, PION, DAME, TOUR, FOU, CAVALIER } piece_type_t ;


/*--------------------------------------------------------------------------*/

/* Ordre des octets pour un coup */
#define		PIECE_CAPTUREE		0
#define		CASE_CAPTURE		1
#define		CASE_DEPART		2
#define		CASE_ARRIVEE		3
#define		TYPE_DEPART		4
#define		TYPE_ARRIVEE		5
#define		SIZE_COUP		6

/*--------------------------------------------------------------------------*/

#define		NOMBRE_MAXIMUM_DE_PIECES	0x30

typedef enum
{
    INDEX_CASE_VIDE		= 0x00,

    INDEX_ROI_BLANC		= 0x10,
    INDEX_TOUR_DAME_BLANC	= 0x11,
    INDEX_CAVALIER_DAME_BLANC	= 0x12,
    INDEX_FOU_DAME_BLANC	= 0x13,
    INDEX_DAME_BLANC		= 0x14,
    INDEX_FOU_ROI_BLANC		= 0x15,
    INDEX_CAVALIER_ROI_BLANC	= 0x16,
    INDEX_TOUR_ROI_BLANC	= 0x17,
    INDEX_PION_BLANC_A		= 0x18,
    INDEX_PION_BLANC_B		= 0x19,
    INDEX_PION_BLANC_C		= 0x1a,
    INDEX_PION_BLANC_D		= 0x1b,
    INDEX_PION_BLANC_E		= 0x1c,
    INDEX_PION_BLANC_F		= 0x1d,
    INDEX_PION_BLANC_G		= 0x1e,
    INDEX_PION_BLANC_H		= 0x1f,

    INDEX_ROI_NOIR		= 0x20,
    INDEX_TOUR_DAME_NOIR	= 0x21,
    INDEX_CAVALIER_DAME_NOIR	= 0x22,
    INDEX_FOU_DAME_NOIR		= 0x23,
    INDEX_DAME_NOIR		= 0x24,
    INDEX_FOU_ROI_NOIR		= 0x25,
    INDEX_CAVALIER_ROI_NOIR	= 0x26,
    INDEX_TOUR_ROI_NOIR		= 0x27,
    INDEX_PION_NOIR_A		= 0x28,
    INDEX_PION_NOIR_B		= 0x29,
    INDEX_PION_NOIR_C		= 0x2a,
    INDEX_PION_NOIR_D		= 0x2b,
    INDEX_PION_NOIR_E		= 0x2c,
    INDEX_PION_NOIR_F		= 0x2d,
    INDEX_PION_NOIR_G		= 0x2e,
    INDEX_PION_NOIR_H		= 0x2f,

    PIECE_PAS_CAPTUREE          = 0xFC,
    PIECE_CAPTURANTE_INCONNUE   = 0xFD,
    PAS_DE_CAPTURE              = 0xFE
} piece_index_t ;

#define		COULEUR		0x30	/* Mask to get the piece colour */

typedef enum { BLANC = 0x10, NOIR = 0x20 } colour_t ;

#define		colour(piece)		((colour_t)(piece & COULEUR))
#define		is_white(piece)		(colour(piece) == BLANC)
#define		is_black(piece)		(colour(piece) == NOIR)

/*--------------------------------------------------------------------------*/

typedef enum
{
    a1				= 0x00,
    a2				= 0x10,
    a3				= 0x20,
    a4				= 0x30,
    a5				= 0x40,
    a6				= 0x50,
    a7				= 0x60,
    a8				= 0x70,
    b1				= 0x01,
    b2				= 0x11,
    b3				= 0x21,
    b4				= 0x31,
    b5				= 0x41,
    b6				= 0x51,
    b7				= 0x61,
    b8				= 0x71,
    c1				= 0x02,
    c2				= 0x12,
    c3				= 0x22,
    c4				= 0x32,
    c5				= 0x42,
    c6				= 0x52,
    c7				= 0x62,
    c8				= 0x72,
    d1				= 0x03,
    d2				= 0x13,
    d3				= 0x23,
    d4				= 0x33,
    d5				= 0x43,
    d6				= 0x53,
    d7				= 0x63,
    d8				= 0x73,
    e1				= 0x04,
    e2				= 0x14,
    e3				= 0x24,
    e4				= 0x34,
    e5				= 0x44,
    e6				= 0x54,
    e7				= 0x64,
    e8				= 0x74,
    f1				= 0x05,
    f2				= 0x15,
    f3				= 0x25,
    f4				= 0x35,
    f5				= 0x45,
    f6				= 0x55,
    f7				= 0x65,
    f8				= 0x75,
    g1				= 0x06,
    g2				= 0x16,
    g3				= 0x26,
    g4				= 0x36,
    g5				= 0x46,
    g6				= 0x56,
    g7				= 0x66,
    g8				= 0x76,
    h1				= 0x07,
    h2				= 0x17,
    h3				= 0x27,
    h4				= 0x37,
    h5				= 0x47,
    h6				= 0x57,
    h7				= 0x67,
    h8				= 0x77,

    PIECE_DEJA_TRAITEE		= 0xFB,
    CASE_D_UNE_PIECE_CAPTUREE	= 0xFC,
    CASE_PAS_DE_PROMOTION	= 0xFD,
    CASE_ARRIVEE_QUELCONQUE	= 0xFE

} square_t ;

typedef		square_t		column_t;
typedef		square_t		row_t;
typedef		char			square_delta_t;

#define		column(square)		(square & 0x07)
#define		row(square)		(square & 0x70)

/*--------------------------------------------------------------------------*/

typedef enum { NO_CASTLING, KING_SIDE, QUEEN_SIDE } castling_t ;

/*--------------------------------------------------------------------------*/

typedef enum
{
    /* Immobile : not enough spare moves to make a switchback */
    /* Bloqued like the Bc1 with Pb2 and Pd2 */

    eHas_Moved,			/* Captured or not */
    eCould_Have_Moved,		/* Captured or not */
    eHas_Moved_Once,		/* Not captured    */
    eImmobile_Captured_Castling_Rook,
    eImmobile_Castling_King,
    eImmobile_Captured_Piece,
    eBloqued_Captured_Piece,
    eImmobile_Piece,
    eBloqued_Piece
} moving_piece_t ;

/*--------------------------------------------------------------------------*/

typedef struct
{
    piece_type_t	typePiece;
    colour_t		camp;
    square_t		caseInitiale;
    square_t		caseArrivee;
    piece_index_t	pieceCapturante;
    square_t		casePromotion;
    piece_type_t	typePromotion;
    piece_index_t	index;
    bool_t		has_never_moved;
    moving_piece_t	moving_piece ;
    castling_t		castling;		/* For kings and rooks only */
    unsigned char	nb_captures;		/* For pawns only           */
    UCHAR		nbDestination;
    UCHAR		indDestAct;		/* Pour l'exploration. */
    square_t		destination[16];
    piece_index_t	pieceCapturee[16];	/* Indice des pieces capturees dans l'ordre */
    distance_t		distance[16];		/* Nombre minimum de coup pour cette etape. */


    unsigned char	dummy1;			/* For alignment reasons */
    unsigned char	dummy2;
} piece_t;

#endif /* TYPES_H */
