/*
 * screen.h --- screen package.
 *
 * Copyright (c) 1997-2002 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2002-03-30 17:43:19 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef SCREEN_H
#define	SCREEN_H

#ifdef HAVE_LIBNCURSES

#include	"types.h"

#ifdef __DJGPP__
#include	<pc.h>				/* for kbhit() */
#else
#include	<curses.h>
extern	int	Screen_Key;
#define		kbhit()		((Screen_Key = getch()) != ERR)
#endif /* not __DJGPP__ */

/*--------------------------------------------------------------------------*/
extern	int	ScreenKeyboardCounter ;
#define	keyboardHit()	( ++ScreenKeyboardCounter >= 10000 ?	\
			  ScreenKeyboardCounter = 0 , kbhit() :	\
			  FALSE )
/*--------------------------------------------------------------------------*/

void		screenWriteAssoc( const piece_t* p );
void		screenInit( const square_t*	board,
			    const piece_type_t*	types,
			    unsigned int	number_of_half_moves,
			    const piece_t*	pieces,
			    unsigned int	nb_pieces );
void		screen( const piece_t*	pieces,
			unsigned int	nb_pieces,
			unsigned long	nb_position,
			unsigned int	white_spare_moves,
			unsigned int	black_spare_moves );
void		screenCoup( int i, int nb, const UCHAR* coup );
void		screenPrintListeCoups( unsigned long	nb_solution,
				       unsigned long	see_solution_number,
				       unsigned long	nb_position,
				       const UCHAR*	moves,
				       unsigned int	nb_moves);
void		screenEnd( const char* begin,
			   const char* end,
			   const char* stopped,
			   const char* time );
bool_t		screenKeyboard( bool_t		skipOK,
				const UCHAR*	moves,
				unsigned int	nb_moves,
				unsigned long	nb_positions );

#else /* not HAVE_LIBNCURSES */

#define		keyboardHit()				FALSE

#define	screenWriteAssoc( piece )			/* Do nothing */
#define	screenInit( number_of_half_moves )		/* Do nothing */
#define	screen( pieces, nb_pieces, nb_pos, wsm, bsm )	/* Do nothing */
#define	screenCoup( i, nb, coup )			/* Do nothing */
#define	screenPrintListeCoups( nb_sol, see_sol, nb_pos )/* Do nothing */
#define	screenEnd( begin, end, stopped, time )		/* Do nothing */
#define	screenKeyboard( skipOK, moves, nb_moves, nb_positions )	FALSE

#endif /* not HAVE_LIBNCURSES */

#endif /* SCREEN_H */
