/*
 * explorat.c --- recursive move searching package.
 *
 * Copyright (c) 1997-2002, 2004, 2005 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2005-02-18 14:10:33 pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include	"common.h"

#include	"explorat.h"

#define		EXTERN_EXPLORATION	/* Only defined here !! */
#include	"expltype.h"

#include	"pcpj.h"
#include	"langues.h"
#include	"pcpjcoup.h"
#include	"screen.h"
#include	"pcpjtool.h"
#include	"hash.h"
#include	"distance.h"
#include	"trajet.h"

#include	"test_moves_order.h"

#include	<time.h>		/* For clock()    */
#include	<stdlib.h>		/* For qsort(...) */

/*--------------------------------------------------------------------------*/
/* #define	DEBUG_MOVES */
#define	DEBUG_POS_NUMBER	12
/*--------------------------------------------------------------------------*/

static UCHAR	exploTestOK();
static UCHAR	exploRecursiveHash( colour_t camp );
static void	exploRecursiveMain( colour_t camp );
static void	initialise_datas( unsigned int number_of_moves_limit );
static int	compare_pieces( const void* piece1, const void* piece2 );

/*--------------------------------------------------------------------------*/

unsigned long	NbPosition = 0 ;
static unsigned long	NbSolution = 0 ;
static unsigned long	NbTestOK   = 0 ;

static distance_t*	Current_distance_Table ;

#ifdef	HAVE_LIBNCURSES
#include	<setjmp.h>
static jmp_buf		JumpBuffer ;
#endif /* HAVE_LIBNCURSES */

/*--------------------------------------------------------------------------*/

static exploration_t	explo_datas ;

/*--------------------------------------------------------------------------*/

/* Tous les tests effectues dans cette fonction sont probablement
 * inutiles. En effet, ils sont deja tous fait pendant la generation
 * des coups. Mais comme la fonction est tres rarement appelee, cela
 * ne ralenti par la resolution.
 * En fait, il doit exister un cas ou elle est utile.
 */
static UCHAR
exploTestOK()
{
    piece_index_t	index;

    NbTestOK++;

    if ( explo_datas.white_pieces_to_capture != 0 ||
	 explo_datas.black_pieces_to_capture != 0 )
    {
	return 0 ;
    }

    for (index=INDEX_ROI_BLANC; index<=INDEX_PION_NOIR_H; index++)
    {
	square_t	c    = explo_datas.pieces_squares[ index ];
	piece_type_t	type = explo_datas.pieces_types  [ index ];
	piece_t*	p    = &explo_datas.pieces[ index ];
	piece_type_t	pType ;
	if (c != CASE_D_UNE_PIECE_CAPTUREE)
	{
	    if (c == p->caseArrivee)
	    {
		if (p->casePromotion != CASE_PAS_DE_PROMOTION)
		{
		    pType = p->typePromotion;
		}
		else
		{
		    pType = p->typePiece;
		}
		if ( type != pType )	return 0 ;
	    }
	    else
	    {
		return 0 ;
	    }
	}
    }

    NbSolution++;

    if (!MainVisualFlag || MainFD != stdout)
    {
	fprintf(MainFD, "%s %ld (%s %ld)\n",
		langGetString(eStrSolution), NbSolution,
		langGetString(eStrPosition), NbPosition);
	coupsListePrint();

	if ( MainVerboseFlag && MainFD != stdout )
	{
	    FILE*	temp_fd = MainFD ;
	    printf( "%s %ld (%s %ld)\n",
		    langGetString(eStrSolution), NbSolution ,
		    langGetString(eStrPosition), NbPosition );

	    MainFD = stdout ;
	    coupsListePrint();
	    MainFD = temp_fd ;
	}
    }

#ifdef HAVE_LIBNCURSES
    if (MainVisualFlag)
    {
	screenPrintListeCoups( NbSolution, 0, NbPosition, CoupsListe, CoupsNb );
	if ( keyboardHit()
	     && screenKeyboard( TRUE, CoupsListe, CoupsNb, NbPosition ) )
	{
	    fprintf( MainFD, langGetString( eStrPositionSkipped ), NbPosition );
	    longjmp( JumpBuffer, 1 );
	}
    }
#endif /* HAVE_LIBNCURSES */

    if (MainStopValue == NbSolution)
    {
	mainEnd( eStrStoppedBySolution, NbSolution );
	hashFree();
	exit( EXIT_SUCCESS );
    }

    return NbSolution ;
}

static UCHAR
exploRecursiveHash( colour_t camp )
{
    bool_t		found 		 ;
    unsigned int	numSolution 	 ;
    int			nbCoups		 ; /* Peut valoir ILLEGAL == (-1)     */
    UCHAR		liste[ 1200 ]	 ; /* Soit au max 200 coups jouables  */
    int			nbCoupsRestants	 ;
    colour_t		autreCamp	 ;
    int			nbResteACapturer ;
    square_t		caseDepart	 ;
    unsigned int	solution 	 ;
    int			i		 ;
    UCHAR*		coup		 ;
    piece_t*		p 		 ;
    distance_t		distAvant = -1 	 ;
    unsigned long	hash_value       ;

    if ( explo_datas.white_moves == 0 && explo_datas.black_moves == 0)
    {
	return exploTestOK();
    }

    found = hashTest( &explo_datas, &hash_value, &numSolution );
    if ( found )
    {
	if ( numSolution != 0 )
	{
	    NbSolution++;

	    if (!MainVisualFlag || MainFD != stdout)
	    {
		fprintf(MainFD, "%s %ld (%s %ld)\n",
			langGetString(eStrSolution), NbSolution,
			langGetString(eStrPosition), NbPosition);
		coupsListePrint();
		fprintf(MainFD, "... %s %d.\n", langGetString(eStrSeeSolution),
			numSolution);
	    }

#ifdef HAVE_LIBNCURSES
	    if ( MainVisualFlag )
	    {
		screenPrintListeCoups( NbSolution,
				       0,
				       NbPosition,
				       CoupsListe,
				       CoupsNb );
		if ( keyboardHit()
		     && screenKeyboard( TRUE, CoupsListe, CoupsNb, NbPosition ))
		{
		    fprintf( MainFD,
			     langGetString( eStrPositionSkipped ),
			     NbPosition );
		    longjmp( JumpBuffer, 1 );
		}
	    }
#endif /* HAVE_LIBNCURSES */

	    if (MainStopValue == NbSolution)
	    {
		mainEnd( eStrStoppedBySolution, NbSolution );
		hashFree();
		exit( EXIT_SUCCESS );
	    }

	    return  NbSolution ;
	}
	return 0 ;
    }

    nbCoups = listeCoups( &explo_datas, camp, liste );

#ifdef DEBUG_MOVES
    if ( NbPosition == DEBUG_POS_NUMBER )
    {
	fprintf( MainFD, "Nombre de coups : %d\n", nbCoups );
	for (i = 0, coup = liste; i < nbCoups; i++, coup += SIZE_COUP )
	{
	    printCoup( coup );
	    fprintf( MainFD, "\n" );
	}
    }
#endif /* DEBUG_MOVES */

    if ( nbCoups == ILLEGAL )	return FALSE ;

#ifdef HAVE_LIBNCURSES
    if ( MainVisualFlag
	 && keyboardHit()
	 && screenKeyboard( TRUE, CoupsListe, CoupsNb, NbPosition ) )
    {
	fprintf( MainFD, langGetString( eStrPositionSkipped ), NbPosition );
	longjmp( JumpBuffer, 1 );
    }
#endif /* HAVE_LIBNCURSES */

    if (camp == BLANC)
    {
	nbCoupsRestants = explo_datas.white_moves ;
	explo_datas.white_moves-- ;
	autreCamp = NOIR ;
	nbResteACapturer = explo_datas.black_pieces_to_capture ;
    }
    else
    {
	nbCoupsRestants = explo_datas.black_moves ;
	explo_datas.black_moves-- ;
	autreCamp = BLANC ;
	nbResteACapturer = explo_datas.white_pieces_to_capture ;
    }

    caseDepart = CASE_ARRIVEE_QUELCONQUE ;

    solution = 0;
    p = NULL ;
    for (i=0, coup=liste; i<nbCoups; i++, coup+=SIZE_COUP)
    {
	distance_t	delta	 ;
	bool_t		chgtDest ;
	bool_t		roque	 ;

#ifdef DEBUG_MOVES
	if ( NbPosition == DEBUG_POS_NUMBER )
	{
	    fprintf( MainFD, "J'examine le coup : " );
	    printCoup( coup );
	    fprintf( MainFD, "\n" );
	}
#endif /* DEBUG_MOVES */

	/* Test si le coup doit forcement etre une capture */
	if ( coup[ PIECE_CAPTUREE ] == PAS_DE_CAPTURE
	     && nbResteACapturer == nbCoupsRestants )
	{
	    continue;
	}

	if (caseDepart != coup[CASE_DEPART])
	{
	    caseDepart = coup[CASE_DEPART];
	    p = &explo_datas.pieces[ explo_datas.board[ caseDepart ] ];

	    /* Here there was an optimisation, where the distance in p->distance
	     * is used instead of using the function `distance_table', when the
	     * piece was at it's previous destination.  There is a very subtle
	     * counter example : wPf7xXg8=R and this rook returns to f7 for
	     * tempo, and has its next destination being g8.  This happens in
	     * the SPG by Reto Aschwanden, 1st Prize Champagne Tourney, Portoroz
	     * 2002 : 2B3Rr/p4br1/k2qp1pb/2np4/8/7p/PPP1PP1P/RNBQKBNR, 17.5
	     * moves.
	     *
	     * We now systematically use the function.
	     */
	    if (p->caseArrivee == CASE_ARRIVEE_QUELCONQUE)
	    {
		distAvant = 1;
	    }
	    else
	    {
		distAvant = distance_table( Current_distance_Table,
					    coup[ TYPE_DEPART ],
					    camp,
					    caseDepart,
					    p->caseArrivee );
	    }
	}

	/* Si c'est un roque, distApres vaut 0(zero) ! */
	roque = FALSE;
	if (coup[TYPE_DEPART] == ROI)
	{
	    if (coup[CASE_DEPART] == e1)
	    {
		if (coup[CASE_ARRIVEE] == g1 || coup[CASE_ARRIVEE] == c1)
		{
		    roque = TRUE;
		}
	    }
	    else if (coup[CASE_DEPART] == e8)
	    {
		if (coup[CASE_ARRIVEE] == g8 || coup[CASE_ARRIVEE] == c8)
		{
		    roque = TRUE;
		}
	    }
	}
	if ( roque )
	{
	    delta = 0;
	    chgtDest = FALSE ;

	    if ( p->nbDestination > 1 )
	    {
		p->indDestAct++;
		p->caseArrivee = p->destination[ p->indDestAct ];
		chgtDest = TRUE ;
	    }
	}
	else
	{
	    distance_t	distApres ;

	    chgtDest = FALSE ;

	    if (p->caseArrivee == CASE_ARRIVEE_QUELCONQUE)
	    {
		distApres = 0;
	    }
	    else if ( coup[ PIECE_CAPTUREE ] == PAS_DE_CAPTURE
		      && coup[ CASE_CAPTURE ] != 0 )
	    {
		/* Il s'agit d'une preparation pour une prise en passant. */
		distApres = 0;
	    }
	    else
	    {
		distApres = distance_table( Current_distance_Table,
					    coup[ TYPE_DEPART ],
					    camp,
					    coup[ CASE_ARRIVEE ],
					    p->caseArrivee );
	    }

	    if (distAvant == distApres)
	    {
		if ((camp == BLANC && explo_datas.white_spare_moves < 1) ||
		    (camp == NOIR && explo_datas.black_spare_moves < 1) )
		{
		    continue;
		}
		delta = 1;
	    }
	    else if (distAvant < distApres)
	    {
		/* Il faut rajouter le coup qui est joue */
		delta = distApres - distAvant + 1;
		if ((camp == BLANC && explo_datas.white_spare_moves < delta) ||
		    (camp == NOIR && explo_datas.black_spare_moves < delta) )
		{
		    continue;
		}
	    }
	    else
	    {
		delta = 0;
	    }

	    if (camp == BLANC)	explo_datas.white_spare_moves -= delta;
	    else		explo_datas.black_spare_moves -= delta;

	    if ( p->caseArrivee == CASE_ARRIVEE_QUELCONQUE
		 || ( coup[ CASE_ARRIVEE ] == p->caseArrivee
		      && ( p->pieceCapturee[ p->indDestAct ]
			   == coup[ PIECE_CAPTUREE ] ) ) )
	    {
		if (p->indDestAct != p->nbDestination - 1)
		{
		    p->indDestAct++;
		    p->caseArrivee = p->destination[p->indDestAct];
		    chgtDest = TRUE;
		}
		else if (p->pieceCapturante == PIECE_PAS_CAPTUREE &&
			 ((coup[TYPE_ARRIVEE] == PION) ||
			  (camp == BLANC && explo_datas.white_spare_moves < 2)||
			  (camp == NOIR  && explo_datas.black_spare_moves < 2))
			 && CoupsNb <= MainLimiteTrajet )
		{
		    bool_t	ok = FALSE;
		    int		compteur;
		    for ( compteur = 0;
			  compteur < MainNombreNouvellesCasesInterdites;
			  compteur++ )
		    {
			if ( MainNouvellesCasesInterdites[ compteur ]
			     == p->caseArrivee )
			{
			    ok = TRUE;
			    break;
			}
		    }
		    if ( ok )
		    {
			joueCoup( &explo_datas, coup );
			ok = trajet_traite_nouvelle_case_interdite(
			    &explo_datas,
			    p->destination[ p->indDestAct ] );
			dejoueCoup( &explo_datas, coup );
			if (! ok)
			{
			    if (camp == BLANC)
			    {
				explo_datas.white_spare_moves += delta;
			    }
			    else
			    {
				explo_datas.black_spare_moves += delta;
			    }
			    continue;
			}
		    }
		}
	    }
	}

	joueCoup( &explo_datas, coup );

#ifdef DEBUG_MOVES
	if ( NbPosition == DEBUG_POS_NUMBER )
	{
	    fprintf( MainFD, "Je joue : %d ", CoupsNb );
	    printCoup( coup );
	    fprintf( MainFD, "\n" );
	}
#endif /* DEBUG_MOVES */

	numSolution = exploRecursiveHash( autreCamp );
	if (numSolution && !solution)	solution = numSolution;

	if (chgtDest)
	{
	    p->indDestAct--;
	    p->caseArrivee = p->destination[p->indDestAct];
	}

#ifdef DEBUG_MOVES
	if ( NbPosition == DEBUG_POS_NUMBER )
	{
	    fprintf( MainFD, "Je dejoue : %d ", CoupsNb );
	    printCoup( coup );
	    fprintf( MainFD, "\n" );
	}
#endif /* DEBUG_MOVES */

	dejoueCoup( &explo_datas, coup );

	if (camp == BLANC)	explo_datas.white_spare_moves += delta;
	else			explo_datas.black_spare_moves += delta;
    }

    if ( camp == BLANC )	explo_datas.white_moves++ ;
    else			explo_datas.black_moves++ ;

    hashInsert( &explo_datas, hash_value, solution );
    return solution ;
}

static void
exploRecursiveMain(colour_t camp)
{
    UCHAR		liste[160]; /*(8 pions * 2 + 2 cavaliers * 2)*6 = 120 */
    int			i;
    int			nbCoups; /* Peut valoir ILLEGAL == (-1) */
    colour_t		autreCamp;
    UCHAR*		coup;
    int			nbResteACapturer, nbCoupsRestants;
    square_t		caseDepart;
    clock_t		ticks;
    piece_t*		p;
    distance_t		distAvant;

#ifdef HAVE_LIBNCURSES
    /* Pour SETJMP. "volatile" pour que l'optimisation ne supprime pas
     * l'affectation des variables globales correspondantes. */
    volatile int	nbCoupsBlancs, nbCoupsNoirs;
    volatile int	nbCoupsBlancsRestants, nbCoupsNoirsRestants;
#endif /* HAVE_LIBNCURSES */


    if ( explo_datas.white_moves == 0 && explo_datas.black_moves == 0)
    {
	exploTestOK();
	return;
    }

#ifdef HAVE_LIBNCURSES
    if ( MainVisualFlag )
    {
	if ( setjmp( JumpBuffer ) )
	{
	    /* Remet a jour :
	     *		- Echiquier
	     *		- CoupsNb
	     *		- NbTotalCaptureesBlanches
	     * 		- NbTotalCaptureesNoires
	     *		- les flags pour les roques.
	     */
	    while ( CoupsNb > 0 )
	    {
		dejoueCoup( &explo_datas,
			    &CoupsListe[ ( CoupsNb - 1 ) * 6 ] );
	    }

	    screenCoup(0, 0, 0);

	    explo_datas.white_moves = nbCoupsBlancs;
	    explo_datas.black_moves = nbCoupsNoirs;

	    explo_datas.white_spare_moves = nbCoupsBlancsRestants ;
	    explo_datas.black_spare_moves = nbCoupsNoirsRestants  ;

	    /* Les variables `NbResteACapturerBlanches' et
	     * `NbResteACapturerNoires' ne sont pas modifiees pendant
	     * l'exploration.
	     */

	    for (i=INDEX_ROI_BLANC; i<=INDEX_PION_NOIR_H; i++)
	    {
		explo_datas.pieces[ i ].indDestAct = 0;
	    }

	    return;
	}
	else
	{
	    nbCoupsBlancs = explo_datas.white_moves ;
	    nbCoupsNoirs  = explo_datas.black_moves ;

	    nbCoupsBlancsRestants = explo_datas.white_spare_moves ;
	    nbCoupsNoirsRestants  = explo_datas.black_spare_moves ;
	}
    }
#endif /* HAVE_LIBNCURSES */

    ticks = clock();
    nbCoups = listeCoups( &explo_datas, camp, liste );
    MainTicks1 += clock() - ticks;

    if (nbCoups == ILLEGAL)	return;

    if ( MainVerboseFlag )
    {
	printf( langGetString( eStrNumberOfWhiteMoves ), nbCoups );
    }
    nbCoupsRestants = explo_datas.white_moves ;
    explo_datas.white_moves-- ;
    autreCamp = NOIR ;
    nbResteACapturer = explo_datas.black_pieces_to_capture ;

    caseDepart = CASE_ARRIVEE_QUELCONQUE ;

    i 	      = 0     ;
    p 	      = NULL  ;
    coup      = liste ;
    distAvant = -1    ;
    for (; i<nbCoups; i++, coup+=SIZE_COUP)
    {
	distance_t	delta	  ;
	bool_t		chgtDest  ;
	distance_t	distApres ;

	if ( MainVerboseFlag )
	{
	    FILE*	temp_fd = MainFD ;
	    MainFD = stdout ;
	    printf( langGetString( eStrMove ), i + 1 );
	    printCoup(coup);
	    printf("\n");
	    MainFD = temp_fd ;
	}

#ifdef HAVE_LIBNCURSES
	if ( MainVisualFlag )
	{
	    screenCoup( i + 1, nbCoups, coup );
	    if ( keyboardHit()
		 && screenKeyboard( TRUE, CoupsListe, CoupsNb, NbPosition ) )
	    {
		fprintf( MainFD,
			 langGetString( eStrPositionSkipped ),
			 NbPosition );
		longjmp( JumpBuffer, 1 );
	    }
	}
#endif /* HAVE_LIBNCURSES */

	/* Test si le coup doit forcement etre une capture */
	if ( coup[ PIECE_CAPTUREE ] == PAS_DE_CAPTURE
	     && nbResteACapturer == nbCoupsRestants )
	{
	    continue;
	}
	if (caseDepart != coup[CASE_DEPART])
	{
	    piece_index_t	index ;
	    caseDepart = coup[CASE_DEPART];
	    index = explo_datas.board[ caseDepart ];
	    p = &explo_datas.pieces[ index ];

	    distAvant = p->distance[0]; /* 1er coup de la partie ! */
	}

	if (p->caseArrivee == CASE_ARRIVEE_QUELCONQUE)
	{
	    distApres = 0;
	}
	else
	{
	    distApres = distance_table( Current_distance_Table,
					coup[ TYPE_DEPART ],
					camp,
					coup[ CASE_ARRIVEE ],
					p->caseArrivee );
	}

	if (distAvant == distApres)
	{
	    if ((camp == BLANC && explo_datas.white_spare_moves < 1) ||
		(camp == NOIR  && explo_datas.black_spare_moves < 1) )
	    {
		continue;
	    }
	    delta = 1;
	}
	else if (distAvant < distApres)
	{
	    /* Il faut rajouter le coup qui est joue */
	    delta = distApres - distAvant + 1;
	    if ((camp == BLANC && explo_datas.white_spare_moves < delta) ||
		(camp == NOIR  && explo_datas.black_spare_moves < delta) )
	    {
		continue;
	    }
	}
	else
	{
	    delta = 0;
	}

	if (camp == BLANC)	explo_datas.white_spare_moves -= delta;
	else			explo_datas.black_spare_moves -= delta;

	joueCoup( &explo_datas, coup );

#ifdef DEBUG_MOVES
	if ( NbPosition == DEBUG_POS_NUMBER )
	{
	    fprintf( MainFD, "Je joue : %d ", CoupsNb );
	    printCoup( coup );
	    fprintf( MainFD, "\n" );
	}
#endif /* DEBUG_MOVES */

	chgtDest = FALSE;
	if (p->caseArrivee == CASE_ARRIVEE_QUELCONQUE ||
	    coup[CASE_ARRIVEE] == p->caseArrivee)
	{
	    if (p->indDestAct != p->nbDestination - 1)
	    {
		p->indDestAct++;
		p->caseArrivee = p->destination[p->indDestAct];
		chgtDest = TRUE;
	    }
	    else if (p->pieceCapturante == PIECE_PAS_CAPTUREE &&
		     ((coup[TYPE_ARRIVEE] == PION) ||
		      (camp == BLANC && explo_datas.white_spare_moves < 2) ||
		      (camp == NOIR  && explo_datas.black_spare_moves < 2) ) )
	    {
		bool_t	ok = FALSE ;
		int	compteur ;
		for ( compteur = 0 ;
		      compteur < MainNombreNouvellesCasesInterdites ;
		      compteur++ )
		{
		    if ( MainNouvellesCasesInterdites[ compteur ]
			 == p->caseArrivee )
		    {
			ok = TRUE;
			break;
		    }
		}
		if (CoupsNb <= MainLimiteTrajet && ok)
		{
		    ok = trajet_traite_nouvelle_case_interdite(
			&explo_datas,
			p->destination[ p->indDestAct ] );
		    if (! ok)
		    {
			if ( camp == BLANC )
			{
			    explo_datas.white_spare_moves += delta ;
			}
			else
			{
			    explo_datas.black_spare_moves += delta ;
			}
			dejoueCoup( &explo_datas, coup );
			continue;
		    }
		}
	    }
	}

	exploRecursiveHash(autreCamp);

	if (chgtDest)
	{
	    p->indDestAct--;
	    p->caseArrivee = p->destination[p->indDestAct];
	}

#ifdef DEBUG_MOVES
	if ( NbPosition == DEBUG_POS_NUMBER )
	{
	    fprintf( MainFD, "Je dejoue : %d ", CoupsNb );
	    printCoup( coup );
	    fprintf( MainFD, "\n" );
	}
#endif /* DEBUG_MOVES */

	dejoueCoup( &explo_datas, coup );

	if (camp == BLANC)	explo_datas.white_spare_moves += delta;
	else			explo_datas.black_spare_moves += delta;
    }

#ifdef HAVE_LIBNCURSES
    if ( MainVisualFlag )
    {
	screenCoup( 0, 0, 0 );
    }
#endif /* HAVE_LIBNCURSES */

    if (camp == BLANC)	explo_datas.white_moves++ ;
    else		explo_datas.black_moves++ ;
}

/*--------------------------------------------------------------------------*/

void
explorationCoups( unsigned int number_of_moves_limit )
{
    int		i ;
    piece_t*	p ;
    square_t	arr[ 32 ];

    for (i=0, p=ListeSures; i<NbSures+NbRestantes; i++, p++)
    {
	arr[i]         = p->caseArrivee;
	p->caseArrivee = p->destination[0];
    }

    initialise_datas( number_of_moves_limit );

    if ( test_moves_order( &explo_datas ) )
    {
	/* Castling rooks must now return to there initial squares */
	for ( i = INDEX_ROI_BLANC ; i <= INDEX_PION_NOIR_H ; i++ )
	{
	    square_t	 initial_square = explo_datas.pieces[ i ].caseInitiale ;
	    piece_type_t piece_type     = explo_datas.pieces[ i ].typePiece ;

	    if ( piece_type == TOUR
		 && explo_datas.pieces[ i ].castling != NO_CASTLING )
	    {
		initial_square =
		    ( explo_datas.pieces[ i ].camp == BLANC )
		    ? a1 : a8 ;
		if ( explo_datas.pieces[ i ].castling == KING_SIDE )
		{
		    initial_square += 7 ;
		}
		explo_datas.pieces[ i ].caseInitiale = initial_square ;
	    }
	}

	NbPosition++;

	if ( MainPrintPositionLevel > 0 )
	{
	    fprintf( MainFD,
		     "%s : %ld\n",
		     langGetString( eStrPosition),
		     NbPosition );
	    writeAssociation( "" );
	    fprintf( MainFD, "\n" );
	}

	if ( MainVerboseFlag )
	{
	    if ( ! MainPrintPositionLevel > 0 || MainFD != stdout )
	    {
		FILE*	temp_fd = MainFD ;
		printf( "%s : %ld\n",
			langGetString( eStrPosition ),
			NbPosition );

		MainFD = stdout ;
		writeAssociation( "" );
		printf( "\n" );
		MainFD = temp_fd ;
	    }
	    printf( langGetString( eStrSolutionsFound ), NbSolution );
	}

#ifdef HAVE_LIBNCURSES
	if ( MainVisualFlag )
	{
	    screen( ListeSures,
		    NbSures + NbRestantes,
		    NbPosition,
		    NbCoupsBlancsRestants,
		    NbCoupsNoirsRestants );
	    if ( keyboardHit()
		 && screenKeyboard( TRUE,
				    CoupsListe,
				    CoupsNb,
				    NbPosition ) )
	    {
		for (i=0, p=ListeSures; i<NbSures+NbRestantes; i++, p++)
		{
		    p->caseArrivee = arr[i];
		}
		return ;
	    }
	}
#endif /* HAVE_LIBNCURSES */

	if ( MainExplorationFlag && NbPosition >= MainContinueValue )
	{
	    hashInit( explo_datas.white_moves + explo_datas.black_moves,
		      explo_datas.nb_moving_pieces );
	    exploRecursiveMain( BLANC );
	    hashFree();
	}
    }

    for (i=0, p=ListeSures; i<NbSures+NbRestantes; i++, p++)
    {
	p->caseArrivee = arr[i];
    }
}

/*--------------------------------------------------------------------------*/

static void
initialise_datas( unsigned int number_of_moves_limit )
{
    unsigned int	i ;
    piece_index_t	new_indexes[ INDEX_PION_NOIR_H + 1 ];
    piece_t*		p ;

    explo_datas.white_moves 	  	= NbCoupsBlancs 	   ;
    explo_datas.black_moves 	  	= NbCoupsNoirs  	   ;
    explo_datas.white_spare_moves 	= NbCoupsBlancsRestants    ;
    explo_datas.black_spare_moves 	= NbCoupsNoirsRestants     ;
    explo_datas.white_pieces_to_capture = NbTotalCaptureesBlanches ;
    explo_datas.black_pieces_to_capture = NbTotalCaptureesNoires   ;

    for ( i = INDEX_ROI_BLANC; i <= INDEX_PION_NOIR_H; i++ )
    {
	explo_datas.pieces[ i ] = *( TabIndexPiece[ i ] );

	if ( explo_datas.pieces[ i ].nbDestination > 1 ||
	     explo_datas.pieces[ i ].distance[ 0 ] > 1 )
	{
	    explo_datas.pieces[ i ].moving_piece = eHas_Moved ;
	}
	else if ( explo_datas.pieces[ i ].typePiece == PION )
	{
	    if ( explo_datas.pieces[ i ].distance[ 0 ] == 0 )
	    {
		if ( explo_datas.pieces[ i ].pieceCapturante ==
		     PIECE_PAS_CAPTUREE )
		{
		    explo_datas.pieces[ i ].moving_piece = eBloqued_Piece ;
		}
		else
		{
		    explo_datas.pieces[ i ].moving_piece =
			eBloqued_Captured_Piece ;
		}
	    }
	    else if ( explo_datas.pieces[ i ].distance[ 0 ] == 1 &&
		      ( ( explo_datas.pieces[ i ].pieceCapturee[ 0 ] !=
			  PAS_DE_CAPTURE ) ||
			( abs( explo_datas.pieces[ i ].caseInitiale -
			       explo_datas.pieces[ i ].caseArrivee ) == 16 ) ||
			( ( explo_datas.pieces[ i ].camp == BLANC &&
			    explo_datas.white_spare_moves == 0 ) ||
			  ( explo_datas.pieces[ i ].camp == NOIR &&
			    explo_datas.black_spare_moves == 0 ) ) ) )
	    {
		/* If the pawn made only one move AND
		 *	EITHER he captured
		 *	EITHER he made a single step
		 *	EITHER the are 0 spare moves
		 */
		explo_datas.pieces[ i ].moving_piece = eHas_Moved_Once ;
	    }
	    else
	    {
		explo_datas.pieces[ i ].moving_piece = eHas_Moved ;
	    }
	}
	else if ( explo_datas.pieces[ i ].has_never_moved )
	{
	    if ( explo_datas.pieces[ i ].pieceCapturante == PIECE_PAS_CAPTUREE )
	    {
		explo_datas.pieces[ i ].moving_piece = eBloqued_Piece ;
	    }
	    else
	    {
		explo_datas.pieces[ i ].moving_piece = eBloqued_Captured_Piece ;
	    }
	}
	else if ( ( explo_datas.pieces[ i ].camp == BLANC &&
		    explo_datas.white_spare_moves > 1 ) ||
		  ( explo_datas.pieces[ i ].camp == NOIR &&
		    explo_datas.black_spare_moves > 1 ) )
	{
	    if ( explo_datas.pieces[ i ].distance[ 0 ] == 0 )
	    {
		explo_datas.pieces[ i ].moving_piece = eCould_Have_Moved ;
	    }
	    else
	    {
		explo_datas.pieces[ i ].moving_piece = eHas_Moved ;
	    }
	}
	else
	{
	    /* No spare move allowing a switchback */
	    if ( explo_datas.pieces[ i ].distance[ 0 ] == 0 )
	    {
		if ( explo_datas.pieces[ i ].pieceCapturante ==
		     PIECE_PAS_CAPTUREE )
		{
		    if ( explo_datas.pieces[ i ].typePiece == ROI &&
			 explo_datas.pieces[ i ].castling != NO_CASTLING )
		    {
			explo_datas.pieces[ i ].moving_piece =
			    eImmobile_Castling_King ;
		    }
		    else
		    {
			explo_datas.pieces[ i ].moving_piece = eImmobile_Piece ;
		    }
		}
		else
		{
		    if ( explo_datas.pieces[ i ].castling != NO_CASTLING )
		    {
			explo_datas.pieces[ i ].moving_piece =
			    eImmobile_Captured_Castling_Rook ;
		    }
		    else
		    {
			explo_datas.pieces[ i ].moving_piece =
			    eImmobile_Captured_Piece ;
		    }
		}
	    }
	    else if ( explo_datas.pieces[ i ].pieceCapturante ==
		      PIECE_PAS_CAPTUREE &&
		      ( explo_datas.pieces[ i ].typePiece == CAVALIER ||
			( ( explo_datas.pieces[ i ].camp == BLANC &&
			    explo_datas.white_spare_moves == 0 ) ||
			  ( explo_datas.pieces[ i ].camp == NOIR &&
			    explo_datas.black_spare_moves == 0 ) ) ) )
	    {
		explo_datas.pieces[ i ].moving_piece = eHas_Moved_Once ;
	    }
	    else
	    {
		explo_datas.pieces[ i ].moving_piece = eHas_Moved ;
	    }
	}
    }

/*      square_t	squares[ 4 ]; */
/*      piece_index_t	index  [ 4 ]; */

    explo_datas.current_square_flags = 0 ;
/*      unsigned int	square_flags[ 16 ]; */

    distance_create_table( explo_datas.distances[ 0 ] );
    Current_distance_Table = explo_datas.distances[ 0 ];

    explo_datas.stack_indexes[ 0 ]  = 0 ;
    explo_datas.current_stack_index = 0 ;

    explo_datas.number_of_moves_limit = number_of_moves_limit ;

    qsort( &explo_datas.pieces[ INDEX_ROI_BLANC ],
	   32,
	   sizeof( piece_t ),
	   compare_pieces );

    memset( explo_datas.board, INDEX_CASE_VIDE, sizeof( Echiquier ) );

    explo_datas.nb_moving_pieces = 0 ;
    for ( i = INDEX_ROI_BLANC ; i <= INDEX_PION_NOIR_H ; i++ )
    {
	square_t	initial_square = explo_datas.pieces[ i ].caseInitiale ;
	piece_type_t	piece_type     = explo_datas.pieces[ i ].typePiece ;

	if ( explo_datas.pieces[ i ].castling != NO_CASTLING )
	{
	    if ( piece_type == ROI )
	    {
		initial_square =
		    ( explo_datas.pieces[ i ].camp == BLANC )
		    ? e1 : e8 ;
		explo_datas.pieces[ i ].caseInitiale = initial_square ;
	    }
	    else
	    {
		initial_square =
		    ( explo_datas.pieces[ i ].camp == BLANC )
		    ? a1 : a8 ;
		if ( explo_datas.pieces[ i ].castling == KING_SIDE )
		{
		    initial_square += 7 ;
		}
	    }
/* 	    explo_datas.pieces[ i ].caseInitiale = initial_square ; */
	}
	explo_datas.pieces_squares[ i ] = initial_square ;
	explo_datas.board[ initial_square ] = i ;

	new_indexes[ explo_datas.pieces[ i ].index ] = i ;
	explo_datas.pieces[ i ].index = i ;

	explo_datas.pieces_types[ i ] = piece_type ;
	if ( piece_type == ROI )
	{
	    if ( explo_datas.pieces[ i ].camp == BLANC )
	    {
		White_king = & explo_datas.pieces[ i ];
	    }
	    else
	    {
		Black_king = & explo_datas.pieces[ i ];
	    }
	}

	if ( explo_datas.nb_moving_pieces == 0 &&
	     explo_datas.pieces[ i ].moving_piece >= eImmobile_Piece )
	{
	    explo_datas.nb_moving_pieces = i - INDEX_ROI_BLANC ;
	}
    }

    p = &( explo_datas.pieces[ INDEX_ROI_BLANC ] );
    for ( i = 0 ; i < 32 ; i++,p++ )
    {
	unsigned int	j ;

	if ( p->pieceCapturante != PIECE_PAS_CAPTUREE )
	{
	    p->pieceCapturante = new_indexes[ p->pieceCapturante ];
	}
	for ( j = 0 ; j < p->nbDestination; j++ )
	{
	    if ( p->pieceCapturee[ j ] != PAS_DE_CAPTURE )
	    {
		p->pieceCapturee[ j ] = new_indexes[ p->pieceCapturee[ j ] ];
	    }
	}
    }
}

static int
compare_pieces( const void* piece1, const void* piece2 )
{
    const piece_t*	p1 = (piece_t*) piece1 ;
    const piece_t*	p2 = (piece_t*) piece2 ;

    if ( p1->moving_piece < p2->moving_piece )
    {
	return -1 ;
    }
    else if ( p1->moving_piece > p2->moving_piece )
    {
	return 1 ;
    }
    else
    {
	return 0 ;
    }
}
