/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Aql;

public class FileSpec {
    private Aql aql;
    private String pattern;
    private String target;
    private String props;
    private String recursive;
    private String flat;
    private String regexp;
    private String build;
    private String explode;
    private String[] excludePatterns;
    private String[] sortBy;
    private String sortOrder;
    private String limit;
    private String offset;

    public String getAql() throws IOException {
        if (this.aql != null) {
            return this.aql.getFind();
        }
        return null;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTarget() {
        return this.target;
    }

    public void setAql(Aql aql) {
        this.aql = aql;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
    }

    public String getRecursive() {
        return this.recursive;
    }

    public void setRecursive(String recursive) {
        this.recursive = recursive;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public String getFlat() {
        return this.flat;
    }

    public void setFlat(String flat) {
        this.flat = flat;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public String getExplode() {
        return this.explode;
    }

    public void setExplode(String explode) {
        this.explode = explode;
    }

    public String[] getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public String getExcludePattern(int index) {
        return this.excludePatterns[index];
    }

    public void setExcludePattern(String excludePattern, int index) {
        this.excludePatterns[index] = excludePattern;
    }

    public String[] getSortBy() {
        if (this.sortBy != null) {
            return this.sortBy;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void setSortBy(String[] sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String resultLimit) {
        this.limit = resultLimit;
    }

    public String toString() {
        return "FileSpec{aql=" + this.aql + ", pattern='" + this.pattern + '\'' + ", target='" + this.target + '\'' + ", props='" + this.props + '\'' + ", recursive='" + this.recursive + '\'' + ", flat='" + this.flat + '\'' + ", regexp='" + this.regexp + '\'' + ", build='" + this.build + '\'' + ", explode='" + this.explode + '\'' + ", excludePatterns='" + Arrays.toString(this.excludePatterns) + '\'' + ", sortBy='" + Arrays.toString(this.sortBy) + '\'' + ", sortOrder='" + this.sortOrder + '\'' + ", offset='" + this.offset + '\'' + ", limit='" + this.limit + '\'' + '}';
    }

    public SpecType getSpecType() throws IOException {
        if (StringUtils.isNotEmpty(this.build) && StringUtils.isEmpty(this.getAql()) && (StringUtils.isEmpty(this.pattern) || this.pattern.equals("*"))) {
            return SpecType.BUILD;
        }
        if (StringUtils.isNotEmpty(this.pattern)) {
            return SpecType.PATTERN;
        }
        if (StringUtils.isNotEmpty(this.getAql())) {
            return SpecType.AQL;
        }
        return null;
    }

    public static enum SpecType {
        BUILD,
        PATTERN,
        AQL;

    }
}

