package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AadConnectivityState enumerates the values for aad connectivity state.
type AadConnectivityState string

const (
	// Connected ...
	Connected AadConnectivityState = "Connected"
	// Discovered ...
	Discovered AadConnectivityState = "Discovered"
	// NotLicensed ...
	NotLicensed AadConnectivityState = "NotLicensed"
)

// PossibleAadConnectivityStateValues returns an array of possible values for the AadConnectivityState const type.
func PossibleAadConnectivityStateValues() []AadConnectivityState {
	return []AadConnectivityState{Connected, Discovered, NotLicensed}
}

// Action enumerates the values for action.
type Action string

const (
	// Add ...
	Add Action = "Add"
	// Recommended ...
	Recommended Action = "Recommended"
	// Remove ...
	Remove Action = "Remove"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Add, Recommended, Remove}
}

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeAutomationAction ...
	ActionTypeAutomationAction ActionType = "AutomationAction"
	// ActionTypeEventHub ...
	ActionTypeEventHub ActionType = "EventHub"
	// ActionTypeLogicApp ...
	ActionTypeLogicApp ActionType = "LogicApp"
	// ActionTypeWorkspace ...
	ActionTypeWorkspace ActionType = "Workspace"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeAutomationAction, ActionTypeEventHub, ActionTypeLogicApp, ActionTypeWorkspace}
}

// AdditionalWorkspaceDataType enumerates the values for additional workspace data type.
type AdditionalWorkspaceDataType string

const (
	// Alerts ...
	Alerts AdditionalWorkspaceDataType = "Alerts"
	// RawEvents ...
	RawEvents AdditionalWorkspaceDataType = "RawEvents"
)

// PossibleAdditionalWorkspaceDataTypeValues returns an array of possible values for the AdditionalWorkspaceDataType const type.
func PossibleAdditionalWorkspaceDataTypeValues() []AdditionalWorkspaceDataType {
	return []AdditionalWorkspaceDataType{Alerts, RawEvents}
}

// AdditionalWorkspaceType enumerates the values for additional workspace type.
type AdditionalWorkspaceType string

const (
	// Sentinel ...
	Sentinel AdditionalWorkspaceType = "Sentinel"
)

// PossibleAdditionalWorkspaceTypeValues returns an array of possible values for the AdditionalWorkspaceType const type.
func PossibleAdditionalWorkspaceTypeValues() []AdditionalWorkspaceType {
	return []AdditionalWorkspaceType{Sentinel}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// High High
	High AlertSeverity = "High"
	// Informational Informational
	Informational AlertSeverity = "Informational"
	// Low Low
	Low AlertSeverity = "Low"
	// Medium Medium
	Medium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{High, Informational, Low, Medium}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// Active An alert which doesn't specify a value is assigned the status 'Active'
	Active AlertStatus = "Active"
	// Dismissed Alert dismissed as false positive
	Dismissed AlertStatus = "Dismissed"
	// InProgress An alert which is in handling state
	InProgress AlertStatus = "InProgress"
	// Resolved Alert closed after handling
	Resolved AlertStatus = "Resolved"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{Active, Dismissed, InProgress, Resolved}
}

// ApplicationConditionOperator enumerates the values for application condition operator.
type ApplicationConditionOperator string

const (
	// Equals Checks that the string value of the data defined in Property equals any of the given values
	// (exact fit)
	Equals ApplicationConditionOperator = "Equals"
	// In Checks that the string value of the data defined in Property contains the given value
	In ApplicationConditionOperator = "In"
)

// PossibleApplicationConditionOperatorValues returns an array of possible values for the ApplicationConditionOperator const type.
func PossibleApplicationConditionOperatorValues() []ApplicationConditionOperator {
	return []ApplicationConditionOperator{Equals, In}
}

// AssessedResourceType enumerates the values for assessed resource type.
type AssessedResourceType string

const (
	// AssessedResourceTypeAdditionalData ...
	AssessedResourceTypeAdditionalData AssessedResourceType = "AdditionalData"
	// AssessedResourceTypeContainerRegistryVulnerability ...
	AssessedResourceTypeContainerRegistryVulnerability AssessedResourceType = "ContainerRegistryVulnerability"
	// AssessedResourceTypeServerVulnerabilityAssessment ...
	AssessedResourceTypeServerVulnerabilityAssessment AssessedResourceType = "ServerVulnerabilityAssessment"
	// AssessedResourceTypeSQLServerVulnerability ...
	AssessedResourceTypeSQLServerVulnerability AssessedResourceType = "SqlServerVulnerability"
)

// PossibleAssessedResourceTypeValues returns an array of possible values for the AssessedResourceType const type.
func PossibleAssessedResourceTypeValues() []AssessedResourceType {
	return []AssessedResourceType{AssessedResourceTypeAdditionalData, AssessedResourceTypeContainerRegistryVulnerability, AssessedResourceTypeServerVulnerabilityAssessment, AssessedResourceTypeSQLServerVulnerability}
}

// AssessmentStatusCode enumerates the values for assessment status code.
type AssessmentStatusCode string

const (
	// Healthy The resource is healthy
	Healthy AssessmentStatusCode = "Healthy"
	// NotApplicable Assessment for this resource did not happen
	NotApplicable AssessmentStatusCode = "NotApplicable"
	// Unhealthy The resource has a security issue that needs to be addressed
	Unhealthy AssessmentStatusCode = "Unhealthy"
)

// PossibleAssessmentStatusCodeValues returns an array of possible values for the AssessmentStatusCode const type.
func PossibleAssessmentStatusCodeValues() []AssessmentStatusCode {
	return []AssessmentStatusCode{Healthy, NotApplicable, Unhealthy}
}

// AssessmentType enumerates the values for assessment type.
type AssessmentType string

const (
	// BuiltIn Microsoft Defender for Cloud managed assessments
	BuiltIn AssessmentType = "BuiltIn"
	// CustomerManaged User assessments pushed directly by the user or other third party to Microsoft Defender
	// for Cloud
	CustomerManaged AssessmentType = "CustomerManaged"
	// CustomPolicy User defined policies that are automatically ingested from Azure Policy to Microsoft
	// Defender for Cloud
	CustomPolicy AssessmentType = "CustomPolicy"
	// VerifiedPartner An assessment that was created by a verified 3rd party if the user connected it to ASC
	VerifiedPartner AssessmentType = "VerifiedPartner"
)

// PossibleAssessmentTypeValues returns an array of possible values for the AssessmentType const type.
func PossibleAssessmentTypeValues() []AssessmentType {
	return []AssessmentType{BuiltIn, CustomerManaged, CustomPolicy, VerifiedPartner}
}

// AuthenticationProvisioningState enumerates the values for authentication provisioning state.
type AuthenticationProvisioningState string

const (
	// Expired the connection has expired
	Expired AuthenticationProvisioningState = "Expired"
	// IncorrectPolicy Incorrect policy of the connector
	IncorrectPolicy AuthenticationProvisioningState = "IncorrectPolicy"
	// Invalid Invalid connector
	Invalid AuthenticationProvisioningState = "Invalid"
	// Valid Valid connector
	Valid AuthenticationProvisioningState = "Valid"
)

// PossibleAuthenticationProvisioningStateValues returns an array of possible values for the AuthenticationProvisioningState const type.
func PossibleAuthenticationProvisioningStateValues() []AuthenticationProvisioningState {
	return []AuthenticationProvisioningState{Expired, IncorrectPolicy, Invalid, Valid}
}

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeAuthenticationDetailsProperties ...
	AuthenticationTypeAuthenticationDetailsProperties AuthenticationType = "AuthenticationDetailsProperties"
	// AuthenticationTypeAwsAssumeRole ...
	AuthenticationTypeAwsAssumeRole AuthenticationType = "awsAssumeRole"
	// AuthenticationTypeAwsCreds ...
	AuthenticationTypeAwsCreds AuthenticationType = "awsCreds"
	// AuthenticationTypeGcpCredentials ...
	AuthenticationTypeGcpCredentials AuthenticationType = "gcpCredentials"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AuthenticationTypeAuthenticationDetailsProperties, AuthenticationTypeAwsAssumeRole, AuthenticationTypeAwsCreds, AuthenticationTypeGcpCredentials}
}

// AutoProvision enumerates the values for auto provision.
type AutoProvision string

const (
	// Off Do not install security agent on the VMs automatically
	Off AutoProvision = "Off"
	// On Install missing security agent on VMs automatically
	On AutoProvision = "On"
)

// PossibleAutoProvisionValues returns an array of possible values for the AutoProvision const type.
func PossibleAutoProvisionValues() []AutoProvision {
	return []AutoProvision{Off, On}
}

// BundleType enumerates the values for bundle type.
type BundleType string

const (
	// AppServices ...
	AppServices BundleType = "AppServices"
	// CosmosDbs ...
	CosmosDbs BundleType = "CosmosDbs"
	// DNS ...
	DNS BundleType = "DNS"
	// KeyVaults ...
	KeyVaults BundleType = "KeyVaults"
	// KubernetesService ...
	KubernetesService BundleType = "KubernetesService"
	// ResourceManager ...
	ResourceManager BundleType = "ResourceManager"
	// SQLServers ...
	SQLServers BundleType = "SqlServers"
	// StorageAccounts ...
	StorageAccounts BundleType = "StorageAccounts"
	// VirtualMachines ...
	VirtualMachines BundleType = "VirtualMachines"
)

// PossibleBundleTypeValues returns an array of possible values for the BundleType const type.
func PossibleBundleTypeValues() []BundleType {
	return []BundleType{AppServices, CosmosDbs, DNS, KeyVaults, KubernetesService, ResourceManager, SQLServers, StorageAccounts, VirtualMachines}
}

// Categories enumerates the values for categories.
type Categories string

const (
	// Compute ...
	Compute Categories = "Compute"
	// Data ...
	Data Categories = "Data"
	// IdentityAndAccess ...
	IdentityAndAccess Categories = "IdentityAndAccess"
	// IoT ...
	IoT Categories = "IoT"
	// Networking ...
	Networking Categories = "Networking"
)

// PossibleCategoriesValues returns an array of possible values for the Categories const type.
func PossibleCategoriesValues() []Categories {
	return []Categories{Compute, Data, IdentityAndAccess, IoT, Networking}
}

// CloudName enumerates the values for cloud name.
type CloudName string

const (
	// AWS ...
	AWS CloudName = "AWS"
	// Azure ...
	Azure CloudName = "Azure"
	// AzureDevOps ...
	AzureDevOps CloudName = "AzureDevOps"
	// GCP ...
	GCP CloudName = "GCP"
	// Github ...
	Github CloudName = "Github"
)

// PossibleCloudNameValues returns an array of possible values for the CloudName const type.
func PossibleCloudNameValues() []CloudName {
	return []CloudName{AWS, Azure, AzureDevOps, GCP, Github}
}

// ConfigurationStatus enumerates the values for configuration status.
type ConfigurationStatus string

const (
	// ConfigurationStatusConfigured ...
	ConfigurationStatusConfigured ConfigurationStatus = "Configured"
	// ConfigurationStatusFailed ...
	ConfigurationStatusFailed ConfigurationStatus = "Failed"
	// ConfigurationStatusInProgress ...
	ConfigurationStatusInProgress ConfigurationStatus = "InProgress"
	// ConfigurationStatusNoStatus ...
	ConfigurationStatusNoStatus ConfigurationStatus = "NoStatus"
	// ConfigurationStatusNotConfigured ...
	ConfigurationStatusNotConfigured ConfigurationStatus = "NotConfigured"
)

// PossibleConfigurationStatusValues returns an array of possible values for the ConfigurationStatus const type.
func PossibleConfigurationStatusValues() []ConfigurationStatus {
	return []ConfigurationStatus{ConfigurationStatusConfigured, ConfigurationStatusFailed, ConfigurationStatusInProgress, ConfigurationStatusNoStatus, ConfigurationStatusNotConfigured}
}

// ConfigurationStatus1 enumerates the values for configuration status 1.
type ConfigurationStatus1 string

const (
	// ConfigurationStatus1Configured ...
	ConfigurationStatus1Configured ConfigurationStatus1 = "Configured"
	// ConfigurationStatus1Failed ...
	ConfigurationStatus1Failed ConfigurationStatus1 = "Failed"
	// ConfigurationStatus1InProgress ...
	ConfigurationStatus1InProgress ConfigurationStatus1 = "InProgress"
	// ConfigurationStatus1NoStatus ...
	ConfigurationStatus1NoStatus ConfigurationStatus1 = "NoStatus"
	// ConfigurationStatus1NotConfigured ...
	ConfigurationStatus1NotConfigured ConfigurationStatus1 = "NotConfigured"
)

// PossibleConfigurationStatus1Values returns an array of possible values for the ConfigurationStatus1 const type.
func PossibleConfigurationStatus1Values() []ConfigurationStatus1 {
	return []ConfigurationStatus1{ConfigurationStatus1Configured, ConfigurationStatus1Failed, ConfigurationStatus1InProgress, ConfigurationStatus1NoStatus, ConfigurationStatus1NotConfigured}
}

// ConfigurationStatus2 enumerates the values for configuration status 2.
type ConfigurationStatus2 string

const (
	// ConfigurationStatus2Configured ...
	ConfigurationStatus2Configured ConfigurationStatus2 = "Configured"
	// ConfigurationStatus2Failed ...
	ConfigurationStatus2Failed ConfigurationStatus2 = "Failed"
	// ConfigurationStatus2InProgress ...
	ConfigurationStatus2InProgress ConfigurationStatus2 = "InProgress"
	// ConfigurationStatus2NoStatus ...
	ConfigurationStatus2NoStatus ConfigurationStatus2 = "NoStatus"
	// ConfigurationStatus2NotConfigured ...
	ConfigurationStatus2NotConfigured ConfigurationStatus2 = "NotConfigured"
)

// PossibleConfigurationStatus2Values returns an array of possible values for the ConfigurationStatus2 const type.
func PossibleConfigurationStatus2Values() []ConfigurationStatus2 {
	return []ConfigurationStatus2{ConfigurationStatus2Configured, ConfigurationStatus2Failed, ConfigurationStatus2InProgress, ConfigurationStatus2NoStatus, ConfigurationStatus2NotConfigured}
}

// ConnectionType enumerates the values for connection type.
type ConnectionType string

const (
	// External ...
	External ConnectionType = "External"
	// Internal ...
	Internal ConnectionType = "Internal"
)

// PossibleConnectionTypeValues returns an array of possible values for the ConnectionType const type.
func PossibleConnectionTypeValues() []ConnectionType {
	return []ConnectionType{External, Internal}
}

// ControlType enumerates the values for control type.
type ControlType string

const (
	// ControlTypeBuiltIn Microsoft Defender for Cloud managed assessments
	ControlTypeBuiltIn ControlType = "BuiltIn"
	// ControlTypeCustom Non Microsoft Defender for Cloud managed assessments
	ControlTypeCustom ControlType = "Custom"
)

// PossibleControlTypeValues returns an array of possible values for the ControlType const type.
func PossibleControlTypeValues() []ControlType {
	return []ControlType{ControlTypeBuiltIn, ControlTypeCustom}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DataSource enumerates the values for data source.
type DataSource string

const (
	// TwinData Devices twin data
	TwinData DataSource = "TwinData"
)

// PossibleDataSourceValues returns an array of possible values for the DataSource const type.
func PossibleDataSourceValues() []DataSource {
	return []DataSource{TwinData}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// Inbound ...
	Inbound Direction = "Inbound"
	// Outbound ...
	Outbound Direction = "Outbound"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{Inbound, Outbound}
}

// EndOfSupportStatus enumerates the values for end of support status.
type EndOfSupportStatus string

const (
	// NoLongerSupported ...
	NoLongerSupported EndOfSupportStatus = "noLongerSupported"
	// None ...
	None EndOfSupportStatus = "None"
	// UpcomingNoLongerSupported ...
	UpcomingNoLongerSupported EndOfSupportStatus = "upcomingNoLongerSupported"
	// UpcomingVersionNoLongerSupported ...
	UpcomingVersionNoLongerSupported EndOfSupportStatus = "upcomingVersionNoLongerSupported"
	// VersionNoLongerSupported ...
	VersionNoLongerSupported EndOfSupportStatus = "versionNoLongerSupported"
)

// PossibleEndOfSupportStatusValues returns an array of possible values for the EndOfSupportStatus const type.
func PossibleEndOfSupportStatusValues() []EndOfSupportStatus {
	return []EndOfSupportStatus{NoLongerSupported, None, UpcomingNoLongerSupported, UpcomingVersionNoLongerSupported, VersionNoLongerSupported}
}

// EnforcementMode enumerates the values for enforcement mode.
type EnforcementMode string

const (
	// EnforcementModeAudit ...
	EnforcementModeAudit EnforcementMode = "Audit"
	// EnforcementModeEnforce ...
	EnforcementModeEnforce EnforcementMode = "Enforce"
	// EnforcementModeNone ...
	EnforcementModeNone EnforcementMode = "None"
)

// PossibleEnforcementModeValues returns an array of possible values for the EnforcementMode const type.
func PossibleEnforcementModeValues() []EnforcementMode {
	return []EnforcementMode{EnforcementModeAudit, EnforcementModeEnforce, EnforcementModeNone}
}

// EnforcementSupport enumerates the values for enforcement support.
type EnforcementSupport string

const (
	// NotSupported ...
	NotSupported EnforcementSupport = "NotSupported"
	// Supported ...
	Supported EnforcementSupport = "Supported"
	// Unknown ...
	Unknown EnforcementSupport = "Unknown"
)

// PossibleEnforcementSupportValues returns an array of possible values for the EnforcementSupport const type.
func PossibleEnforcementSupportValues() []EnforcementSupport {
	return []EnforcementSupport{NotSupported, Supported, Unknown}
}

// EnvironmentType enumerates the values for environment type.
type EnvironmentType string

const (
	// EnvironmentTypeAwsAccount ...
	EnvironmentTypeAwsAccount EnvironmentType = "AwsAccount"
	// EnvironmentTypeAzureDevOpsScope ...
	EnvironmentTypeAzureDevOpsScope EnvironmentType = "AzureDevOpsScope"
	// EnvironmentTypeEnvironmentData ...
	EnvironmentTypeEnvironmentData EnvironmentType = "EnvironmentData"
	// EnvironmentTypeGcpProject ...
	EnvironmentTypeGcpProject EnvironmentType = "GcpProject"
	// EnvironmentTypeGithubScope ...
	EnvironmentTypeGithubScope EnvironmentType = "GithubScope"
)

// PossibleEnvironmentTypeValues returns an array of possible values for the EnvironmentType const type.
func PossibleEnvironmentTypeValues() []EnvironmentType {
	return []EnvironmentType{EnvironmentTypeAwsAccount, EnvironmentTypeAzureDevOpsScope, EnvironmentTypeEnvironmentData, EnvironmentTypeGcpProject, EnvironmentTypeGithubScope}
}

// EventSource enumerates the values for event source.
type EventSource string

const (
	// EventSourceAlerts ...
	EventSourceAlerts EventSource = "Alerts"
	// EventSourceAssessments ...
	EventSourceAssessments EventSource = "Assessments"
	// EventSourceAssessmentsSnapshot ...
	EventSourceAssessmentsSnapshot EventSource = "AssessmentsSnapshot"
	// EventSourceRegulatoryComplianceAssessment ...
	EventSourceRegulatoryComplianceAssessment EventSource = "RegulatoryComplianceAssessment"
	// EventSourceRegulatoryComplianceAssessmentSnapshot ...
	EventSourceRegulatoryComplianceAssessmentSnapshot EventSource = "RegulatoryComplianceAssessmentSnapshot"
	// EventSourceSecureScoreControls ...
	EventSourceSecureScoreControls EventSource = "SecureScoreControls"
	// EventSourceSecureScoreControlsSnapshot ...
	EventSourceSecureScoreControlsSnapshot EventSource = "SecureScoreControlsSnapshot"
	// EventSourceSecureScores ...
	EventSourceSecureScores EventSource = "SecureScores"
	// EventSourceSecureScoresSnapshot ...
	EventSourceSecureScoresSnapshot EventSource = "SecureScoresSnapshot"
	// EventSourceSubAssessments ...
	EventSourceSubAssessments EventSource = "SubAssessments"
	// EventSourceSubAssessmentsSnapshot ...
	EventSourceSubAssessmentsSnapshot EventSource = "SubAssessmentsSnapshot"
)

// PossibleEventSourceValues returns an array of possible values for the EventSource const type.
func PossibleEventSourceValues() []EventSource {
	return []EventSource{EventSourceAlerts, EventSourceAssessments, EventSourceAssessmentsSnapshot, EventSourceRegulatoryComplianceAssessment, EventSourceRegulatoryComplianceAssessmentSnapshot, EventSourceSecureScoreControls, EventSourceSecureScoreControlsSnapshot, EventSourceSecureScores, EventSourceSecureScoresSnapshot, EventSourceSubAssessments, EventSourceSubAssessmentsSnapshot}
}

// Exe enumerates the values for exe.
type Exe string

const (
	// ExeAudit ...
	ExeAudit Exe = "Audit"
	// ExeEnforce ...
	ExeEnforce Exe = "Enforce"
	// ExeNone ...
	ExeNone Exe = "None"
)

// PossibleExeValues returns an array of possible values for the Exe const type.
func PossibleExeValues() []Exe {
	return []Exe{ExeAudit, ExeEnforce, ExeNone}
}

// Executable enumerates the values for executable.
type Executable string

const (
	// ExecutableAudit ...
	ExecutableAudit Executable = "Audit"
	// ExecutableEnforce ...
	ExecutableEnforce Executable = "Enforce"
	// ExecutableNone ...
	ExecutableNone Executable = "None"
)

// PossibleExecutableValues returns an array of possible values for the Executable const type.
func PossibleExecutableValues() []Executable {
	return []Executable{ExecutableAudit, ExecutableEnforce, ExecutableNone}
}

// ExpandControlsEnum enumerates the values for expand controls enum.
type ExpandControlsEnum string

const (
	// Definition Add definition object for each control
	Definition ExpandControlsEnum = "definition"
)

// PossibleExpandControlsEnumValues returns an array of possible values for the ExpandControlsEnum const type.
func PossibleExpandControlsEnumValues() []ExpandControlsEnum {
	return []ExpandControlsEnum{Definition}
}

// ExpandEnum enumerates the values for expand enum.
type ExpandEnum string

const (
	// Links All links associated with an assessment
	Links ExpandEnum = "links"
	// Metadata Assessment metadata
	Metadata ExpandEnum = "metadata"
)

// PossibleExpandEnumValues returns an array of possible values for the ExpandEnum const type.
func PossibleExpandEnumValues() []ExpandEnum {
	return []ExpandEnum{Links, Metadata}
}

// ExportData enumerates the values for export data.
type ExportData string

const (
	// ExportDataRawEvents Agent raw events
	ExportDataRawEvents ExportData = "RawEvents"
)

// PossibleExportDataValues returns an array of possible values for the ExportData const type.
func PossibleExportDataValues() []ExportData {
	return []ExportData{ExportDataRawEvents}
}

// ExternalSecuritySolutionKind enumerates the values for external security solution kind.
type ExternalSecuritySolutionKind string

const (
	// AAD ...
	AAD ExternalSecuritySolutionKind = "AAD"
	// ATA ...
	ATA ExternalSecuritySolutionKind = "ATA"
	// CEF ...
	CEF ExternalSecuritySolutionKind = "CEF"
)

// PossibleExternalSecuritySolutionKindValues returns an array of possible values for the ExternalSecuritySolutionKind const type.
func PossibleExternalSecuritySolutionKindValues() []ExternalSecuritySolutionKind {
	return []ExternalSecuritySolutionKind{AAD, ATA, CEF}
}

// Family enumerates the values for family.
type Family string

const (
	// Ngfw ...
	Ngfw Family = "Ngfw"
	// SaasWaf ...
	SaasWaf Family = "SaasWaf"
	// Va ...
	Va Family = "Va"
	// Waf ...
	Waf Family = "Waf"
)

// PossibleFamilyValues returns an array of possible values for the Family const type.
func PossibleFamilyValues() []Family {
	return []Family{Ngfw, SaasWaf, Va, Waf}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// FileTypeDll ...
	FileTypeDll FileType = "Dll"
	// FileTypeExe ...
	FileTypeExe FileType = "Exe"
	// FileTypeExecutable ...
	FileTypeExecutable FileType = "Executable"
	// FileTypeMsi ...
	FileTypeMsi FileType = "Msi"
	// FileTypeScript ...
	FileTypeScript FileType = "Script"
	// FileTypeUnknown ...
	FileTypeUnknown FileType = "Unknown"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{FileTypeDll, FileTypeExe, FileTypeExecutable, FileTypeMsi, FileTypeScript, FileTypeUnknown}
}

// GovernanceRuleConditionOperator enumerates the values for governance rule condition operator.
type GovernanceRuleConditionOperator string

const (
	// GovernanceRuleConditionOperatorEquals Checks that the string value of the data defined in Property
	// equals the given value - exact fit
	GovernanceRuleConditionOperatorEquals GovernanceRuleConditionOperator = "Equals"
	// GovernanceRuleConditionOperatorIn Checks that the string value of the data defined in Property equals
	// any of the given values (exact fit)
	GovernanceRuleConditionOperatorIn GovernanceRuleConditionOperator = "In"
)

// PossibleGovernanceRuleConditionOperatorValues returns an array of possible values for the GovernanceRuleConditionOperator const type.
func PossibleGovernanceRuleConditionOperatorValues() []GovernanceRuleConditionOperator {
	return []GovernanceRuleConditionOperator{GovernanceRuleConditionOperatorEquals, GovernanceRuleConditionOperatorIn}
}

// GovernanceRuleOwnerSourceType enumerates the values for governance rule owner source type.
type GovernanceRuleOwnerSourceType string

const (
	// ByTag The rule source type defined using resource tag
	ByTag GovernanceRuleOwnerSourceType = "ByTag"
	// Manually The rule source type defined manually
	Manually GovernanceRuleOwnerSourceType = "Manually"
)

// PossibleGovernanceRuleOwnerSourceTypeValues returns an array of possible values for the GovernanceRuleOwnerSourceType const type.
func PossibleGovernanceRuleOwnerSourceTypeValues() []GovernanceRuleOwnerSourceType {
	return []GovernanceRuleOwnerSourceType{ByTag, Manually}
}

// GovernanceRuleType enumerates the values for governance rule type.
type GovernanceRuleType string

const (
	// Integrated The source of the rule type definition is integrated
	Integrated GovernanceRuleType = "Integrated"
	// ServiceNow The source of the rule type definition is ServiceNow
	ServiceNow GovernanceRuleType = "ServiceNow"
)

// PossibleGovernanceRuleTypeValues returns an array of possible values for the GovernanceRuleType const type.
func PossibleGovernanceRuleTypeValues() []GovernanceRuleType {
	return []GovernanceRuleType{Integrated, ServiceNow}
}

// HybridComputeProvisioningState enumerates the values for hybrid compute provisioning state.
type HybridComputeProvisioningState string

const (
	// HybridComputeProvisioningStateExpired the service principal details are expired
	HybridComputeProvisioningStateExpired HybridComputeProvisioningState = "Expired"
	// HybridComputeProvisioningStateInvalid Invalid service principal details.
	HybridComputeProvisioningStateInvalid HybridComputeProvisioningState = "Invalid"
	// HybridComputeProvisioningStateValid Valid service principal details.
	HybridComputeProvisioningStateValid HybridComputeProvisioningState = "Valid"
)

// PossibleHybridComputeProvisioningStateValues returns an array of possible values for the HybridComputeProvisioningState const type.
func PossibleHybridComputeProvisioningStateValues() []HybridComputeProvisioningState {
	return []HybridComputeProvisioningState{HybridComputeProvisioningStateExpired, HybridComputeProvisioningStateInvalid, HybridComputeProvisioningStateValid}
}

// ImplementationEffort enumerates the values for implementation effort.
type ImplementationEffort string

const (
	// ImplementationEffortHigh ...
	ImplementationEffortHigh ImplementationEffort = "High"
	// ImplementationEffortLow ...
	ImplementationEffortLow ImplementationEffort = "Low"
	// ImplementationEffortModerate ...
	ImplementationEffortModerate ImplementationEffort = "Moderate"
)

// PossibleImplementationEffortValues returns an array of possible values for the ImplementationEffort const type.
func PossibleImplementationEffortValues() []ImplementationEffort {
	return []ImplementationEffort{ImplementationEffortHigh, ImplementationEffortLow, ImplementationEffortModerate}
}

// InformationProtectionPolicyName enumerates the values for information protection policy name.
type InformationProtectionPolicyName string

const (
	// Custom ...
	Custom InformationProtectionPolicyName = "custom"
	// Effective ...
	Effective InformationProtectionPolicyName = "effective"
)

// PossibleInformationProtectionPolicyNameValues returns an array of possible values for the InformationProtectionPolicyName const type.
func PossibleInformationProtectionPolicyNameValues() []InformationProtectionPolicyName {
	return []InformationProtectionPolicyName{Custom, Effective}
}

// Intent enumerates the values for intent.
type Intent string

const (
	// IntentCollection Collection consists of techniques used to identify and gather information, such as
	// sensitive files, from a target network prior to exfiltration.
	IntentCollection Intent = "Collection"
	// IntentCommandAndControl The command and control tactic represents how adversaries communicate with
	// systems under their control within a target network.
	IntentCommandAndControl Intent = "CommandAndControl"
	// IntentCredentialAccess Credential access represents techniques resulting in access to or control over
	// system, domain, or service credentials that are used within an enterprise environment.
	IntentCredentialAccess Intent = "CredentialAccess"
	// IntentDefenseEvasion Defense evasion consists of techniques an adversary may use to evade detection or
	// avoid other defenses.
	IntentDefenseEvasion Intent = "DefenseEvasion"
	// IntentDiscovery Discovery consists of techniques that allow the adversary to gain knowledge about the
	// system and internal network.
	IntentDiscovery Intent = "Discovery"
	// IntentExecution The execution tactic represents techniques that result in execution of
	// adversary-controlled code on a local or remote system.
	IntentExecution Intent = "Execution"
	// IntentExfiltration Exfiltration refers to techniques and attributes that result or aid in the adversary
	// removing files and information from a target network.
	IntentExfiltration Intent = "Exfiltration"
	// IntentExploitation Exploitation is the stage where an attacker manages to get a foothold on the attacked
	// resource. This stage is relevant for compute hosts and resources such as user accounts, certificates
	// etc.
	IntentExploitation Intent = "Exploitation"
	// IntentImpact Impact events primarily try to directly reduce the availability or integrity of a system,
	// service, or network; including manipulation of data to impact a business or operational process.
	IntentImpact Intent = "Impact"
	// IntentInitialAccess InitialAccess is the stage where an attacker manages to get foothold on the attacked
	// resource.
	IntentInitialAccess Intent = "InitialAccess"
	// IntentLateralMovement Lateral movement consists of techniques that enable an adversary to access and
	// control remote systems on a network and could, but does not necessarily, include execution of tools on
	// remote systems.
	IntentLateralMovement Intent = "LateralMovement"
	// IntentPersistence Persistence is any access, action, or configuration change to a system that gives a
	// threat actor a persistent presence on that system.
	IntentPersistence Intent = "Persistence"
	// IntentPreAttack PreAttack could be either an attempt to access a certain resource regardless of a
	// malicious intent, or a failed attempt to gain access to a target system to gather information prior to
	// exploitation. This step is usually detected as an attempt, originating from outside the network, to scan
	// the target system and find a way in.  Further details on the PreAttack stage can be read in [MITRE
	// Pre-Att&ck matrix](https://attack.mitre.org/matrices/pre/).
	IntentPreAttack Intent = "PreAttack"
	// IntentPrivilegeEscalation Privilege escalation is the result of actions that allow an adversary to
	// obtain a higher level of permissions on a system or network.
	IntentPrivilegeEscalation Intent = "PrivilegeEscalation"
	// IntentProbing Probing could be either an attempt to access a certain resource regardless of a malicious
	// intent, or a failed attempt to gain access to a target system to gather information prior to
	// exploitation.
	IntentProbing Intent = "Probing"
	// IntentUnknown Unknown
	IntentUnknown Intent = "Unknown"
)

// PossibleIntentValues returns an array of possible values for the Intent const type.
func PossibleIntentValues() []Intent {
	return []Intent{IntentCollection, IntentCommandAndControl, IntentCredentialAccess, IntentDefenseEvasion, IntentDiscovery, IntentExecution, IntentExfiltration, IntentExploitation, IntentImpact, IntentInitialAccess, IntentLateralMovement, IntentPersistence, IntentPreAttack, IntentPrivilegeEscalation, IntentProbing, IntentUnknown}
}

// Issue enumerates the values for issue.
type Issue string

const (
	// ExecutableViolationsAudited ...
	ExecutableViolationsAudited Issue = "ExecutableViolationsAudited"
	// MsiAndScriptViolationsAudited ...
	MsiAndScriptViolationsAudited Issue = "MsiAndScriptViolationsAudited"
	// MsiAndScriptViolationsBlocked ...
	MsiAndScriptViolationsBlocked Issue = "MsiAndScriptViolationsBlocked"
	// RulesViolatedManually ...
	RulesViolatedManually Issue = "RulesViolatedManually"
	// ViolationsAudited ...
	ViolationsAudited Issue = "ViolationsAudited"
	// ViolationsBlocked ...
	ViolationsBlocked Issue = "ViolationsBlocked"
)

// PossibleIssueValues returns an array of possible values for the Issue const type.
func PossibleIssueValues() []Issue {
	return []Issue{ExecutableViolationsAudited, MsiAndScriptViolationsAudited, MsiAndScriptViolationsBlocked, RulesViolatedManually, ViolationsAudited, ViolationsBlocked}
}

// KindEnum enumerates the values for kind enum.
type KindEnum string

const (
	// KindAAD ...
	KindAAD KindEnum = "AAD"
	// KindATA ...
	KindATA KindEnum = "ATA"
	// KindCEF ...
	KindCEF KindEnum = "CEF"
	// KindExternalSecuritySolution ...
	KindExternalSecuritySolution KindEnum = "ExternalSecuritySolution"
)

// PossibleKindEnumValues returns an array of possible values for the KindEnum const type.
func PossibleKindEnumValues() []KindEnum {
	return []KindEnum{KindAAD, KindATA, KindCEF, KindExternalSecuritySolution}
}

// KindEnum1 enumerates the values for kind enum 1.
type KindEnum1 string

const (
	// KindAlertSimulatorRequestProperties ...
	KindAlertSimulatorRequestProperties KindEnum1 = "AlertSimulatorRequestProperties"
	// KindBundles ...
	KindBundles KindEnum1 = "Bundles"
)

// PossibleKindEnum1Values returns an array of possible values for the KindEnum1 const type.
func PossibleKindEnum1Values() []KindEnum1 {
	return []KindEnum1{KindAlertSimulatorRequestProperties, KindBundles}
}

// KindEnum2 enumerates the values for kind enum 2.
type KindEnum2 string

const (
	// KindAlertSyncSettings ...
	KindAlertSyncSettings KindEnum2 = "AlertSyncSettings"
	// KindDataExportSettings ...
	KindDataExportSettings KindEnum2 = "DataExportSettings"
	// KindSetting ...
	KindSetting KindEnum2 = "Setting"
)

// PossibleKindEnum2Values returns an array of possible values for the KindEnum2 const type.
func PossibleKindEnum2Values() []KindEnum2 {
	return []KindEnum2{KindAlertSyncSettings, KindDataExportSettings, KindSetting}
}

// MinimalSeverity enumerates the values for minimal severity.
type MinimalSeverity string

const (
	// MinimalSeverityHigh Get notifications on new alerts with High severity
	MinimalSeverityHigh MinimalSeverity = "High"
	// MinimalSeverityLow Don't get notifications on new alerts with low, medium or high severity
	MinimalSeverityLow MinimalSeverity = "Low"
	// MinimalSeverityMedium Get notifications on new alerts with medium or high severity
	MinimalSeverityMedium MinimalSeverity = "Medium"
)

// PossibleMinimalSeverityValues returns an array of possible values for the MinimalSeverity const type.
func PossibleMinimalSeverityValues() []MinimalSeverity {
	return []MinimalSeverity{MinimalSeverityHigh, MinimalSeverityLow, MinimalSeverityMedium}
}

// Msi enumerates the values for msi.
type Msi string

const (
	// MsiAudit ...
	MsiAudit Msi = "Audit"
	// MsiEnforce ...
	MsiEnforce Msi = "Enforce"
	// MsiNone ...
	MsiNone Msi = "None"
)

// PossibleMsiValues returns an array of possible values for the Msi const type.
func PossibleMsiValues() []Msi {
	return []Msi{MsiAudit, MsiEnforce, MsiNone}
}

// OfferingType enumerates the values for offering type.
type OfferingType string

const (
	// OfferingTypeCloudOffering ...
	OfferingTypeCloudOffering OfferingType = "cloudOffering"
	// OfferingTypeCspmMonitorAws ...
	OfferingTypeCspmMonitorAws OfferingType = "CspmMonitorAws"
	// OfferingTypeCspmMonitorAzureDevOps ...
	OfferingTypeCspmMonitorAzureDevOps OfferingType = "CspmMonitorAzureDevOps"
	// OfferingTypeCspmMonitorGcp ...
	OfferingTypeCspmMonitorGcp OfferingType = "CspmMonitorGcp"
	// OfferingTypeCspmMonitorGithub ...
	OfferingTypeCspmMonitorGithub OfferingType = "CspmMonitorGithub"
	// OfferingTypeDefenderCspmAws ...
	OfferingTypeDefenderCspmAws OfferingType = "DefenderCspmAws"
	// OfferingTypeDefenderCspmGcp ...
	OfferingTypeDefenderCspmGcp OfferingType = "DefenderCspmGcp"
	// OfferingTypeDefenderForContainersAws ...
	OfferingTypeDefenderForContainersAws OfferingType = "DefenderForContainersAws"
	// OfferingTypeDefenderForContainersGcp ...
	OfferingTypeDefenderForContainersGcp OfferingType = "DefenderForContainersGcp"
	// OfferingTypeDefenderForDatabasesAws ...
	OfferingTypeDefenderForDatabasesAws OfferingType = "DefenderForDatabasesAws"
	// OfferingTypeDefenderForDatabasesGcp ...
	OfferingTypeDefenderForDatabasesGcp OfferingType = "DefenderForDatabasesGcp"
	// OfferingTypeDefenderForDevOpsAzureDevOps ...
	OfferingTypeDefenderForDevOpsAzureDevOps OfferingType = "DefenderForDevOpsAzureDevOps"
	// OfferingTypeDefenderForDevOpsGithub ...
	OfferingTypeDefenderForDevOpsGithub OfferingType = "DefenderForDevOpsGithub"
	// OfferingTypeDefenderForServersAws ...
	OfferingTypeDefenderForServersAws OfferingType = "DefenderForServersAws"
	// OfferingTypeDefenderForServersGcp ...
	OfferingTypeDefenderForServersGcp OfferingType = "DefenderForServersGcp"
	// OfferingTypeInformationProtectionAws ...
	OfferingTypeInformationProtectionAws OfferingType = "InformationProtectionAws"
)

// PossibleOfferingTypeValues returns an array of possible values for the OfferingType const type.
func PossibleOfferingTypeValues() []OfferingType {
	return []OfferingType{OfferingTypeCloudOffering, OfferingTypeCspmMonitorAws, OfferingTypeCspmMonitorAzureDevOps, OfferingTypeCspmMonitorGcp, OfferingTypeCspmMonitorGithub, OfferingTypeDefenderCspmAws, OfferingTypeDefenderCspmGcp, OfferingTypeDefenderForContainersAws, OfferingTypeDefenderForContainersGcp, OfferingTypeDefenderForDatabasesAws, OfferingTypeDefenderForDatabasesGcp, OfferingTypeDefenderForDevOpsAzureDevOps, OfferingTypeDefenderForDevOpsGithub, OfferingTypeDefenderForServersAws, OfferingTypeDefenderForServersGcp, OfferingTypeInformationProtectionAws}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// OperatorContains Applies only for non-decimal operands
	OperatorContains Operator = "Contains"
	// OperatorEndsWith Applies only for non-decimal operands
	OperatorEndsWith Operator = "EndsWith"
	// OperatorEquals Applies for decimal and non-decimal operands
	OperatorEquals Operator = "Equals"
	// OperatorGreaterThan Applies only for decimal operands
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqualTo Applies only for decimal operands
	OperatorGreaterThanOrEqualTo Operator = "GreaterThanOrEqualTo"
	// OperatorLesserThan Applies only for decimal operands
	OperatorLesserThan Operator = "LesserThan"
	// OperatorLesserThanOrEqualTo Applies only for decimal operands
	OperatorLesserThanOrEqualTo Operator = "LesserThanOrEqualTo"
	// OperatorNotEquals Applies  for decimal and non-decimal operands
	OperatorNotEquals Operator = "NotEquals"
	// OperatorStartsWith Applies only for non-decimal operands
	OperatorStartsWith Operator = "StartsWith"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{OperatorContains, OperatorEndsWith, OperatorEquals, OperatorGreaterThan, OperatorGreaterThanOrEqualTo, OperatorLesserThan, OperatorLesserThanOrEqualTo, OperatorNotEquals, OperatorStartsWith}
}

// OrganizationMembershipType enumerates the values for organization membership type.
type OrganizationMembershipType string

const (
	// OrganizationMembershipTypeAwsOrganizationalData ...
	OrganizationMembershipTypeAwsOrganizationalData OrganizationMembershipType = "AwsOrganizationalData"
	// OrganizationMembershipTypeMember ...
	OrganizationMembershipTypeMember OrganizationMembershipType = "Member"
	// OrganizationMembershipTypeOrganization ...
	OrganizationMembershipTypeOrganization OrganizationMembershipType = "Organization"
)

// PossibleOrganizationMembershipTypeValues returns an array of possible values for the OrganizationMembershipType const type.
func PossibleOrganizationMembershipTypeValues() []OrganizationMembershipType {
	return []OrganizationMembershipType{OrganizationMembershipTypeAwsOrganizationalData, OrganizationMembershipTypeMember, OrganizationMembershipTypeOrganization}
}

// OrganizationMembershipTypeBasicGcpOrganizationalData enumerates the values for organization membership type
// basic gcp organizational data.
type OrganizationMembershipTypeBasicGcpOrganizationalData string

const (
	// OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData ...
	OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData OrganizationMembershipTypeBasicGcpOrganizationalData = "GcpOrganizationalData"
	// OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember ...
	OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember OrganizationMembershipTypeBasicGcpOrganizationalData = "Member"
	// OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization ...
	OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization OrganizationMembershipTypeBasicGcpOrganizationalData = "Organization"
)

// PossibleOrganizationMembershipTypeBasicGcpOrganizationalDataValues returns an array of possible values for the OrganizationMembershipTypeBasicGcpOrganizationalData const type.
func PossibleOrganizationMembershipTypeBasicGcpOrganizationalDataValues() []OrganizationMembershipTypeBasicGcpOrganizationalData {
	return []OrganizationMembershipTypeBasicGcpOrganizationalData{OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData, OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember, OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization}
}

// PermissionProperty enumerates the values for permission property.
type PermissionProperty string

const (
	// AWSAmazonSSMAutomationRole The permission provides for EC2 Automation service to execute activities
	// defined within Automation documents.
	AWSAmazonSSMAutomationRole PermissionProperty = "AWS::AmazonSSMAutomationRole"
	// AWSAWSSecurityHubReadOnlyAccess This permission provides read only access to AWS Security Hub resources.
	AWSAWSSecurityHubReadOnlyAccess PermissionProperty = "AWS::AWSSecurityHubReadOnlyAccess"
	// AWSSecurityAudit This permission grants access to read security configuration metadata.
	AWSSecurityAudit PermissionProperty = "AWS::SecurityAudit"
	// GCPSecurityCenterAdminViewer This permission provides read only access to GCP Security Command Center.
	GCPSecurityCenterAdminViewer PermissionProperty = "GCP::Security Center Admin Viewer"
)

// PossiblePermissionPropertyValues returns an array of possible values for the PermissionProperty const type.
func PossiblePermissionPropertyValues() []PermissionProperty {
	return []PermissionProperty{AWSAmazonSSMAutomationRole, AWSAWSSecurityHubReadOnlyAccess, AWSSecurityAudit, GCPSecurityCenterAdminViewer}
}

// PricingTier enumerates the values for pricing tier.
type PricingTier string

const (
	// Free Get free Microsoft Defender for Cloud experience with basic security features
	Free PricingTier = "Free"
	// Standard Get the standard Microsoft Defender for Cloud experience with advanced security features
	Standard PricingTier = "Standard"
)

// PossiblePricingTierValues returns an array of possible values for the PricingTier const type.
func PossiblePricingTierValues() []PricingTier {
	return []PricingTier{Free, Standard}
}

// PropertyType enumerates the values for property type.
type PropertyType string

const (
	// Boolean ...
	Boolean PropertyType = "Boolean"
	// Integer ...
	Integer PropertyType = "Integer"
	// Number ...
	Number PropertyType = "Number"
	// String ...
	String PropertyType = "String"
)

// PossiblePropertyTypeValues returns an array of possible values for the PropertyType const type.
func PossiblePropertyTypeValues() []PropertyType {
	return []PropertyType{Boolean, Integer, Number, String}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// All ...
	All Protocol = "*"
	// TCP ...
	TCP Protocol = "TCP"
	// UDP ...
	UDP Protocol = "UDP"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{All, TCP, UDP}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Failed, Succeeded, Updating}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Canceled ...
	ProvisioningState1Canceled ProvisioningState1 = "Canceled"
	// ProvisioningState1Deprovisioning ...
	ProvisioningState1Deprovisioning ProvisioningState1 = "Deprovisioning"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Provisioning ...
	ProvisioningState1Provisioning ProvisioningState1 = "Provisioning"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Canceled, ProvisioningState1Deprovisioning, ProvisioningState1Failed, ProvisioningState1Provisioning, ProvisioningState1Succeeded}
}

// Rank enumerates the values for rank.
type Rank string

const (
	// RankCritical ...
	RankCritical Rank = "Critical"
	// RankHigh ...
	RankHigh Rank = "High"
	// RankLow ...
	RankLow Rank = "Low"
	// RankMedium ...
	RankMedium Rank = "Medium"
	// RankNone ...
	RankNone Rank = "None"
)

// PossibleRankValues returns an array of possible values for the Rank const type.
func PossibleRankValues() []Rank {
	return []Rank{RankCritical, RankHigh, RankLow, RankMedium, RankNone}
}

// RecommendationAction enumerates the values for recommendation action.
type RecommendationAction string

const (
	// RecommendationActionAdd ...
	RecommendationActionAdd RecommendationAction = "Add"
	// RecommendationActionRecommended ...
	RecommendationActionRecommended RecommendationAction = "Recommended"
	// RecommendationActionRemove ...
	RecommendationActionRemove RecommendationAction = "Remove"
)

// PossibleRecommendationActionValues returns an array of possible values for the RecommendationAction const type.
func PossibleRecommendationActionValues() []RecommendationAction {
	return []RecommendationAction{RecommendationActionAdd, RecommendationActionRecommended, RecommendationActionRemove}
}

// RecommendationAction1 enumerates the values for recommendation action 1.
type RecommendationAction1 string

const (
	// RecommendationAction1Add ...
	RecommendationAction1Add RecommendationAction1 = "Add"
	// RecommendationAction1Recommended ...
	RecommendationAction1Recommended RecommendationAction1 = "Recommended"
	// RecommendationAction1Remove ...
	RecommendationAction1Remove RecommendationAction1 = "Remove"
)

// PossibleRecommendationAction1Values returns an array of possible values for the RecommendationAction1 const type.
func PossibleRecommendationAction1Values() []RecommendationAction1 {
	return []RecommendationAction1{RecommendationAction1Add, RecommendationAction1Recommended, RecommendationAction1Remove}
}

// RecommendationConfigStatus enumerates the values for recommendation config status.
type RecommendationConfigStatus string

const (
	// Disabled ...
	Disabled RecommendationConfigStatus = "Disabled"
	// Enabled ...
	Enabled RecommendationConfigStatus = "Enabled"
)

// PossibleRecommendationConfigStatusValues returns an array of possible values for the RecommendationConfigStatus const type.
func PossibleRecommendationConfigStatusValues() []RecommendationConfigStatus {
	return []RecommendationConfigStatus{Disabled, Enabled}
}

// RecommendationStatus enumerates the values for recommendation status.
type RecommendationStatus string

const (
	// RecommendationStatusNoStatus ...
	RecommendationStatusNoStatus RecommendationStatus = "NoStatus"
	// RecommendationStatusNotAvailable ...
	RecommendationStatusNotAvailable RecommendationStatus = "NotAvailable"
	// RecommendationStatusNotRecommended ...
	RecommendationStatusNotRecommended RecommendationStatus = "NotRecommended"
	// RecommendationStatusRecommended ...
	RecommendationStatusRecommended RecommendationStatus = "Recommended"
)

// PossibleRecommendationStatusValues returns an array of possible values for the RecommendationStatus const type.
func PossibleRecommendationStatusValues() []RecommendationStatus {
	return []RecommendationStatus{RecommendationStatusNoStatus, RecommendationStatusNotAvailable, RecommendationStatusNotRecommended, RecommendationStatusRecommended}
}

// RecommendationType enumerates the values for recommendation type.
type RecommendationType string

const (
	// IoTACRAuthentication Authentication schema used for pull an edge module from an ACR repository does not
	// use Service Principal Authentication.
	IoTACRAuthentication RecommendationType = "IoT_ACRAuthentication"
	// IoTAgentSendsUnutilizedMessages IoT agent message size capacity is currently underutilized, causing an
	// increase in the number of sent messages. Adjust message intervals for better utilization.
	IoTAgentSendsUnutilizedMessages RecommendationType = "IoT_AgentSendsUnutilizedMessages"
	// IoTBaseline Identified security related system configuration issues.
	IoTBaseline RecommendationType = "IoT_Baseline"
	// IoTEdgeHubMemOptimize You can optimize Edge Hub memory usage by turning off protocol heads for any
	// protocols not used by Edge modules in your solution.
	IoTEdgeHubMemOptimize RecommendationType = "IoT_EdgeHubMemOptimize"
	// IoTEdgeLoggingOptions Logging is disabled for this edge module.
	IoTEdgeLoggingOptions RecommendationType = "IoT_EdgeLoggingOptions"
	// IoTInconsistentModuleSettings A minority within a device security group has inconsistent Edge Module
	// settings with the rest of their group.
	IoTInconsistentModuleSettings RecommendationType = "IoT_InconsistentModuleSettings"
	// IoTInstallAgent Install the Azure Security of Things Agent.
	IoTInstallAgent RecommendationType = "IoT_InstallAgent"
	// IoTIPFilterDenyAll IP Filter Configuration should have rules defined for allowed traffic and should deny
	// all other traffic by default.
	IoTIPFilterDenyAll RecommendationType = "IoT_IPFilter_DenyAll"
	// IoTIPFilterPermissiveRule An Allow IP Filter rules source IP range is too large. Overly permissive rules
	// might expose your IoT hub to malicious intenders.
	IoTIPFilterPermissiveRule RecommendationType = "IoT_IPFilter_PermissiveRule"
	// IoTOpenPorts A listening endpoint was found on the device.
	IoTOpenPorts RecommendationType = "IoT_OpenPorts"
	// IoTPermissiveFirewallPolicy An Allowed firewall policy was found (INPUT/OUTPUT). The policy should Deny
	// all traffic by default and define rules to allow necessary communication to/from the device.
	IoTPermissiveFirewallPolicy RecommendationType = "IoT_PermissiveFirewallPolicy"
	// IoTPermissiveInputFirewallRules A rule in the firewall has been found that contains a permissive pattern
	// for a wide range of IP addresses or Ports.
	IoTPermissiveInputFirewallRules RecommendationType = "IoT_PermissiveInputFirewallRules"
	// IoTPermissiveOutputFirewallRules A rule in the firewall has been found that contains a permissive
	// pattern for a wide range of IP addresses or Ports.
	IoTPermissiveOutputFirewallRules RecommendationType = "IoT_PermissiveOutputFirewallRules"
	// IoTPrivilegedDockerOptions Edge module is configured to run in privileged mode, with extensive Linux
	// capabilities or with host-level network access (send/receive data to host machine).
	IoTPrivilegedDockerOptions RecommendationType = "IoT_PrivilegedDockerOptions"
	// IoTSharedCredentials Same authentication credentials to the IoT Hub used by multiple devices. This could
	// indicate an illegitimate device impersonating a legitimate device. It also exposes the risk of device
	// impersonation by an attacker.
	IoTSharedCredentials RecommendationType = "IoT_SharedCredentials"
	// IoTVulnerableTLSCipherSuite Insecure TLS configurations detected. Immediate upgrade recommended.
	IoTVulnerableTLSCipherSuite RecommendationType = "IoT_VulnerableTLSCipherSuite"
)

// PossibleRecommendationTypeValues returns an array of possible values for the RecommendationType const type.
func PossibleRecommendationTypeValues() []RecommendationType {
	return []RecommendationType{IoTACRAuthentication, IoTAgentSendsUnutilizedMessages, IoTBaseline, IoTEdgeHubMemOptimize, IoTEdgeLoggingOptions, IoTInconsistentModuleSettings, IoTInstallAgent, IoTIPFilterDenyAll, IoTIPFilterPermissiveRule, IoTOpenPorts, IoTPermissiveFirewallPolicy, IoTPermissiveInputFirewallRules, IoTPermissiveOutputFirewallRules, IoTPrivilegedDockerOptions, IoTSharedCredentials, IoTVulnerableTLSCipherSuite}
}

// ReportedSeverity enumerates the values for reported severity.
type ReportedSeverity string

const (
	// ReportedSeverityHigh ...
	ReportedSeverityHigh ReportedSeverity = "High"
	// ReportedSeverityInformational ...
	ReportedSeverityInformational ReportedSeverity = "Informational"
	// ReportedSeverityLow ...
	ReportedSeverityLow ReportedSeverity = "Low"
	// ReportedSeverityMedium ...
	ReportedSeverityMedium ReportedSeverity = "Medium"
)

// PossibleReportedSeverityValues returns an array of possible values for the ReportedSeverity const type.
func PossibleReportedSeverityValues() []ReportedSeverity {
	return []ReportedSeverity{ReportedSeverityHigh, ReportedSeverityInformational, ReportedSeverityLow, ReportedSeverityMedium}
}

// ResourceStatus enumerates the values for resource status.
type ResourceStatus string

const (
	// ResourceStatusHealthy This assessment on the resource is healthy
	ResourceStatusHealthy ResourceStatus = "Healthy"
	// ResourceStatusNotApplicable This assessment is not applicable to this resource
	ResourceStatusNotApplicable ResourceStatus = "NotApplicable"
	// ResourceStatusNotHealthy This assessment on the resource is not healthy
	ResourceStatusNotHealthy ResourceStatus = "NotHealthy"
	// ResourceStatusOffByPolicy This assessment is turned off by policy on this subscription
	ResourceStatusOffByPolicy ResourceStatus = "OffByPolicy"
)

// PossibleResourceStatusValues returns an array of possible values for the ResourceStatus const type.
func PossibleResourceStatusValues() []ResourceStatus {
	return []ResourceStatus{ResourceStatusHealthy, ResourceStatusNotApplicable, ResourceStatusNotHealthy, ResourceStatusOffByPolicy}
}

// Roles enumerates the values for roles.
type Roles string

const (
	// AccountAdmin If enabled, send notification on new alerts to the account admins
	AccountAdmin Roles = "AccountAdmin"
	// Contributor If enabled, send notification on new alerts to the subscription contributors
	Contributor Roles = "Contributor"
	// Owner If enabled, send notification on new alerts to the subscription owners
	Owner Roles = "Owner"
	// ServiceAdmin If enabled, send notification on new alerts to the service admins
	ServiceAdmin Roles = "ServiceAdmin"
)

// PossibleRolesValues returns an array of possible values for the Roles const type.
func PossibleRolesValues() []Roles {
	return []Roles{AccountAdmin, Contributor, Owner, ServiceAdmin}
}

// RuleSeverity enumerates the values for rule severity.
type RuleSeverity string

const (
	// RuleSeverityHigh High
	RuleSeverityHigh RuleSeverity = "High"
	// RuleSeverityInformational Informational
	RuleSeverityInformational RuleSeverity = "Informational"
	// RuleSeverityLow Low
	RuleSeverityLow RuleSeverity = "Low"
	// RuleSeverityMedium Medium
	RuleSeverityMedium RuleSeverity = "Medium"
	// RuleSeverityObsolete Obsolete
	RuleSeverityObsolete RuleSeverity = "Obsolete"
)

// PossibleRuleSeverityValues returns an array of possible values for the RuleSeverity const type.
func PossibleRuleSeverityValues() []RuleSeverity {
	return []RuleSeverity{RuleSeverityHigh, RuleSeverityInformational, RuleSeverityLow, RuleSeverityMedium, RuleSeverityObsolete}
}

// RuleState enumerates the values for rule state.
type RuleState string

const (
	// RuleStateDisabled ...
	RuleStateDisabled RuleState = "Disabled"
	// RuleStateEnabled ...
	RuleStateEnabled RuleState = "Enabled"
	// RuleStateExpired ...
	RuleStateExpired RuleState = "Expired"
)

// PossibleRuleStateValues returns an array of possible values for the RuleState const type.
func PossibleRuleStateValues() []RuleState {
	return []RuleState{RuleStateDisabled, RuleStateEnabled, RuleStateExpired}
}

// RuleStatus enumerates the values for rule status.
type RuleStatus string

const (
	// Finding Finding
	Finding RuleStatus = "Finding"
	// InternalError InternalError
	InternalError RuleStatus = "InternalError"
	// NonFinding NonFinding
	NonFinding RuleStatus = "NonFinding"
)

// PossibleRuleStatusValues returns an array of possible values for the RuleStatus const type.
func PossibleRuleStatusValues() []RuleStatus {
	return []RuleStatus{Finding, InternalError, NonFinding}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// BaselineExpected BaselineExpected
	BaselineExpected RuleType = "BaselineExpected"
	// Binary Binary
	Binary RuleType = "Binary"
	// NegativeList NegativeList
	NegativeList RuleType = "NegativeList"
	// PositiveList PositiveList
	PositiveList RuleType = "PositiveList"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{BaselineExpected, Binary, NegativeList, PositiveList}
}

// RuleTypeBasicCustomAlertRule enumerates the values for rule type basic custom alert rule.
type RuleTypeBasicCustomAlertRule string

const (
	// RuleTypeActiveConnectionsNotInAllowedRange ...
	RuleTypeActiveConnectionsNotInAllowedRange RuleTypeBasicCustomAlertRule = "ActiveConnectionsNotInAllowedRange"
	// RuleTypeAllowlistCustomAlertRule ...
	RuleTypeAllowlistCustomAlertRule RuleTypeBasicCustomAlertRule = "AllowlistCustomAlertRule"
	// RuleTypeAmqpC2DMessagesNotInAllowedRange ...
	RuleTypeAmqpC2DMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "AmqpC2DMessagesNotInAllowedRange"
	// RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "AmqpC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeAmqpD2CMessagesNotInAllowedRange ...
	RuleTypeAmqpD2CMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "AmqpD2CMessagesNotInAllowedRange"
	// RuleTypeConnectionFromIPNotAllowed ...
	RuleTypeConnectionFromIPNotAllowed RuleTypeBasicCustomAlertRule = "ConnectionFromIpNotAllowed"
	// RuleTypeConnectionToIPNotAllowed ...
	RuleTypeConnectionToIPNotAllowed RuleTypeBasicCustomAlertRule = "ConnectionToIpNotAllowed"
	// RuleTypeCustomAlertRule ...
	RuleTypeCustomAlertRule RuleTypeBasicCustomAlertRule = "CustomAlertRule"
	// RuleTypeDenylistCustomAlertRule ...
	RuleTypeDenylistCustomAlertRule RuleTypeBasicCustomAlertRule = "DenylistCustomAlertRule"
	// RuleTypeDirectMethodInvokesNotInAllowedRange ...
	RuleTypeDirectMethodInvokesNotInAllowedRange RuleTypeBasicCustomAlertRule = "DirectMethodInvokesNotInAllowedRange"
	// RuleTypeFailedLocalLoginsNotInAllowedRange ...
	RuleTypeFailedLocalLoginsNotInAllowedRange RuleTypeBasicCustomAlertRule = "FailedLocalLoginsNotInAllowedRange"
	// RuleTypeFileUploadsNotInAllowedRange ...
	RuleTypeFileUploadsNotInAllowedRange RuleTypeBasicCustomAlertRule = "FileUploadsNotInAllowedRange"
	// RuleTypeHTTPC2DMessagesNotInAllowedRange ...
	RuleTypeHTTPC2DMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "HttpC2DMessagesNotInAllowedRange"
	// RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "HttpC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeHTTPD2CMessagesNotInAllowedRange ...
	RuleTypeHTTPD2CMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "HttpD2CMessagesNotInAllowedRange"
	// RuleTypeListCustomAlertRule ...
	RuleTypeListCustomAlertRule RuleTypeBasicCustomAlertRule = "ListCustomAlertRule"
	// RuleTypeLocalUserNotAllowed ...
	RuleTypeLocalUserNotAllowed RuleTypeBasicCustomAlertRule = "LocalUserNotAllowed"
	// RuleTypeMqttC2DMessagesNotInAllowedRange ...
	RuleTypeMqttC2DMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "MqttC2DMessagesNotInAllowedRange"
	// RuleTypeMqttC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeMqttC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "MqttC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeMqttD2CMessagesNotInAllowedRange ...
	RuleTypeMqttD2CMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "MqttD2CMessagesNotInAllowedRange"
	// RuleTypeProcessNotAllowed ...
	RuleTypeProcessNotAllowed RuleTypeBasicCustomAlertRule = "ProcessNotAllowed"
	// RuleTypeQueuePurgesNotInAllowedRange ...
	RuleTypeQueuePurgesNotInAllowedRange RuleTypeBasicCustomAlertRule = "QueuePurgesNotInAllowedRange"
	// RuleTypeThresholdCustomAlertRule ...
	RuleTypeThresholdCustomAlertRule RuleTypeBasicCustomAlertRule = "ThresholdCustomAlertRule"
	// RuleTypeTimeWindowCustomAlertRule ...
	RuleTypeTimeWindowCustomAlertRule RuleTypeBasicCustomAlertRule = "TimeWindowCustomAlertRule"
	// RuleTypeTwinUpdatesNotInAllowedRange ...
	RuleTypeTwinUpdatesNotInAllowedRange RuleTypeBasicCustomAlertRule = "TwinUpdatesNotInAllowedRange"
	// RuleTypeUnauthorizedOperationsNotInAllowedRange ...
	RuleTypeUnauthorizedOperationsNotInAllowedRange RuleTypeBasicCustomAlertRule = "UnauthorizedOperationsNotInAllowedRange"
)

// PossibleRuleTypeBasicCustomAlertRuleValues returns an array of possible values for the RuleTypeBasicCustomAlertRule const type.
func PossibleRuleTypeBasicCustomAlertRuleValues() []RuleTypeBasicCustomAlertRule {
	return []RuleTypeBasicCustomAlertRule{RuleTypeActiveConnectionsNotInAllowedRange, RuleTypeAllowlistCustomAlertRule, RuleTypeAmqpC2DMessagesNotInAllowedRange, RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange, RuleTypeAmqpD2CMessagesNotInAllowedRange, RuleTypeConnectionFromIPNotAllowed, RuleTypeConnectionToIPNotAllowed, RuleTypeCustomAlertRule, RuleTypeDenylistCustomAlertRule, RuleTypeDirectMethodInvokesNotInAllowedRange, RuleTypeFailedLocalLoginsNotInAllowedRange, RuleTypeFileUploadsNotInAllowedRange, RuleTypeHTTPC2DMessagesNotInAllowedRange, RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange, RuleTypeHTTPD2CMessagesNotInAllowedRange, RuleTypeListCustomAlertRule, RuleTypeLocalUserNotAllowed, RuleTypeMqttC2DMessagesNotInAllowedRange, RuleTypeMqttC2DRejectedMessagesNotInAllowedRange, RuleTypeMqttD2CMessagesNotInAllowedRange, RuleTypeProcessNotAllowed, RuleTypeQueuePurgesNotInAllowedRange, RuleTypeThresholdCustomAlertRule, RuleTypeTimeWindowCustomAlertRule, RuleTypeTwinUpdatesNotInAllowedRange, RuleTypeUnauthorizedOperationsNotInAllowedRange}
}

// ScanningMode enumerates the values for scanning mode.
type ScanningMode string

const (
	// Default ...
	Default ScanningMode = "Default"
)

// PossibleScanningModeValues returns an array of possible values for the ScanningMode const type.
func PossibleScanningModeValues() []ScanningMode {
	return []ScanningMode{Default}
}

// ScanState enumerates the values for scan state.
type ScanState string

const (
	// ScanStateFailed Failed
	ScanStateFailed ScanState = "Failed"
	// ScanStateFailedToRun FailedToRun
	ScanStateFailedToRun ScanState = "FailedToRun"
	// ScanStateInProgress InProgress
	ScanStateInProgress ScanState = "InProgress"
	// ScanStatePassed Passed
	ScanStatePassed ScanState = "Passed"
)

// PossibleScanStateValues returns an array of possible values for the ScanState const type.
func PossibleScanStateValues() []ScanState {
	return []ScanState{ScanStateFailed, ScanStateFailedToRun, ScanStateInProgress, ScanStatePassed}
}

// ScanTriggerType enumerates the values for scan trigger type.
type ScanTriggerType string

const (
	// OnDemand OnDemand
	OnDemand ScanTriggerType = "OnDemand"
	// Recurring Recurring
	Recurring ScanTriggerType = "Recurring"
)

// PossibleScanTriggerTypeValues returns an array of possible values for the ScanTriggerType const type.
func PossibleScanTriggerTypeValues() []ScanTriggerType {
	return []ScanTriggerType{OnDemand, Recurring}
}

// Script enumerates the values for script.
type Script string

const (
	// ScriptAudit ...
	ScriptAudit Script = "Audit"
	// ScriptEnforce ...
	ScriptEnforce Script = "Enforce"
	// ScriptNone ...
	ScriptNone Script = "None"
)

// PossibleScriptValues returns an array of possible values for the Script const type.
func PossibleScriptValues() []Script {
	return []Script{ScriptAudit, ScriptEnforce, ScriptNone}
}

// SettingName2 enumerates the values for setting name 2.
type SettingName2 string

const (
	// SettingName2MCAS ...
	SettingName2MCAS SettingName2 = "MCAS"
	// SettingName2Sentinel ...
	SettingName2Sentinel SettingName2 = "Sentinel"
	// SettingName2WDATP ...
	SettingName2WDATP SettingName2 = "WDATP"
	// SettingName2WDATPEXCLUDELINUXPUBLICPREVIEW ...
	SettingName2WDATPEXCLUDELINUXPUBLICPREVIEW SettingName2 = "WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW"
	// SettingName2WDATPUNIFIEDSOLUTION ...
	SettingName2WDATPUNIFIEDSOLUTION SettingName2 = "WDATP_UNIFIED_SOLUTION"
)

// PossibleSettingName2Values returns an array of possible values for the SettingName2 const type.
func PossibleSettingName2Values() []SettingName2 {
	return []SettingName2{SettingName2MCAS, SettingName2Sentinel, SettingName2WDATP, SettingName2WDATPEXCLUDELINUXPUBLICPREVIEW, SettingName2WDATPUNIFIEDSOLUTION}
}

// SettingName4 enumerates the values for setting name 4.
type SettingName4 string

const (
	// SettingName4MCAS ...
	SettingName4MCAS SettingName4 = "MCAS"
	// SettingName4Sentinel ...
	SettingName4Sentinel SettingName4 = "Sentinel"
	// SettingName4WDATP ...
	SettingName4WDATP SettingName4 = "WDATP"
	// SettingName4WDATPEXCLUDELINUXPUBLICPREVIEW ...
	SettingName4WDATPEXCLUDELINUXPUBLICPREVIEW SettingName4 = "WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW"
	// SettingName4WDATPUNIFIEDSOLUTION ...
	SettingName4WDATPUNIFIEDSOLUTION SettingName4 = "WDATP_UNIFIED_SOLUTION"
)

// PossibleSettingName4Values returns an array of possible values for the SettingName4 const type.
func PossibleSettingName4Values() []SettingName4 {
	return []SettingName4{SettingName4MCAS, SettingName4Sentinel, SettingName4WDATP, SettingName4WDATPEXCLUDELINUXPUBLICPREVIEW, SettingName4WDATPUNIFIEDSOLUTION}
}

// SettingName5 enumerates the values for setting name 5.
type SettingName5 string

const (
	// SettingName5MCAS ...
	SettingName5MCAS SettingName5 = "MCAS"
	// SettingName5Sentinel ...
	SettingName5Sentinel SettingName5 = "Sentinel"
	// SettingName5WDATP ...
	SettingName5WDATP SettingName5 = "WDATP"
	// SettingName5WDATPEXCLUDELINUXPUBLICPREVIEW ...
	SettingName5WDATPEXCLUDELINUXPUBLICPREVIEW SettingName5 = "WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW"
	// SettingName5WDATPUNIFIEDSOLUTION ...
	SettingName5WDATPUNIFIEDSOLUTION SettingName5 = "WDATP_UNIFIED_SOLUTION"
)

// PossibleSettingName5Values returns an array of possible values for the SettingName5 const type.
func PossibleSettingName5Values() []SettingName5 {
	return []SettingName5{SettingName5MCAS, SettingName5Sentinel, SettingName5WDATP, SettingName5WDATPEXCLUDELINUXPUBLICPREVIEW, SettingName5WDATPUNIFIEDSOLUTION}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityHigh ...
	SeverityHigh Severity = "High"
	// SeverityLow ...
	SeverityLow Severity = "Low"
	// SeverityMedium ...
	SeverityMedium Severity = "Medium"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityHigh, SeverityLow, SeverityMedium}
}

// SeverityEnum enumerates the values for severity enum.
type SeverityEnum string

const (
	// SeverityEnumHigh ...
	SeverityEnumHigh SeverityEnum = "High"
	// SeverityEnumLow ...
	SeverityEnumLow SeverityEnum = "Low"
	// SeverityEnumMedium ...
	SeverityEnumMedium SeverityEnum = "Medium"
)

// PossibleSeverityEnumValues returns an array of possible values for the SeverityEnum const type.
func PossibleSeverityEnumValues() []SeverityEnum {
	return []SeverityEnum{SeverityEnumHigh, SeverityEnumLow, SeverityEnumMedium}
}

// SolutionStatus enumerates the values for solution status.
type SolutionStatus string

const (
	// SolutionStatusDisabled ...
	SolutionStatusDisabled SolutionStatus = "Disabled"
	// SolutionStatusEnabled ...
	SolutionStatusEnabled SolutionStatus = "Enabled"
)

// PossibleSolutionStatusValues returns an array of possible values for the SolutionStatus const type.
func PossibleSolutionStatusValues() []SolutionStatus {
	return []SolutionStatus{SolutionStatusDisabled, SolutionStatusEnabled}
}

// Source enumerates the values for source.
type Source string

const (
	// SourceAzure ...
	SourceAzure Source = "Azure"
	// SourceOnPremise ...
	SourceOnPremise Source = "OnPremise"
	// SourceOnPremiseSQL ...
	SourceOnPremiseSQL Source = "OnPremiseSql"
	// SourceResourceDetails ...
	SourceResourceDetails Source = "ResourceDetails"
)

// PossibleSourceValues returns an array of possible values for the Source const type.
func PossibleSourceValues() []Source {
	return []Source{SourceAzure, SourceOnPremise, SourceOnPremiseSQL, SourceResourceDetails}
}

// SourceSystem enumerates the values for source system.
type SourceSystem string

const (
	// SourceSystemAzureAppLocker ...
	SourceSystemAzureAppLocker SourceSystem = "Azure_AppLocker"
	// SourceSystemAzureAuditD ...
	SourceSystemAzureAuditD SourceSystem = "Azure_AuditD"
	// SourceSystemNonAzureAppLocker ...
	SourceSystemNonAzureAppLocker SourceSystem = "NonAzure_AppLocker"
	// SourceSystemNonAzureAuditD ...
	SourceSystemNonAzureAuditD SourceSystem = "NonAzure_AuditD"
	// SourceSystemNone ...
	SourceSystemNone SourceSystem = "None"
)

// PossibleSourceSystemValues returns an array of possible values for the SourceSystem const type.
func PossibleSourceSystemValues() []SourceSystem {
	return []SourceSystem{SourceSystemAzureAppLocker, SourceSystemAzureAuditD, SourceSystemNonAzureAppLocker, SourceSystemNonAzureAuditD, SourceSystemNone}
}

// State enumerates the values for state.
type State string

const (
	// StateFailed At least one supported regulatory compliance control in the given standard has a state of
	// failed
	StateFailed State = "Failed"
	// StatePassed All supported regulatory compliance controls in the given standard have a passed state
	StatePassed State = "Passed"
	// StateSkipped All supported regulatory compliance controls in the given standard have a state of skipped
	StateSkipped State = "Skipped"
	// StateUnsupported No supported regulatory compliance data for the given standard
	StateUnsupported State = "Unsupported"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateFailed, StatePassed, StateSkipped, StateUnsupported}
}

// StateForAlertNotifications enumerates the values for state for alert notifications.
type StateForAlertNotifications string

const (
	// StateForAlertNotificationsOff Don't get notifications on new alerts
	StateForAlertNotificationsOff StateForAlertNotifications = "Off"
	// StateForAlertNotificationsOn Get notifications on new alerts
	StateForAlertNotificationsOn StateForAlertNotifications = "On"
)

// PossibleStateForAlertNotificationsValues returns an array of possible values for the StateForAlertNotifications const type.
func PossibleStateForAlertNotificationsValues() []StateForAlertNotifications {
	return []StateForAlertNotifications{StateForAlertNotificationsOff, StateForAlertNotificationsOn}
}

// StateForNotificationsByRole enumerates the values for state for notifications by role.
type StateForNotificationsByRole string

const (
	// StateForNotificationsByRoleOff Don't send notification on new alerts to the subscription's admins
	StateForNotificationsByRoleOff StateForNotificationsByRole = "Off"
	// StateForNotificationsByRoleOn Send notification on new alerts to the subscription's admins
	StateForNotificationsByRoleOn StateForNotificationsByRole = "On"
)

// PossibleStateForNotificationsByRoleValues returns an array of possible values for the StateForNotificationsByRole const type.
func PossibleStateForNotificationsByRoleValues() []StateForNotificationsByRole {
	return []StateForNotificationsByRole{StateForNotificationsByRoleOff, StateForNotificationsByRoleOn}
}

// Status enumerates the values for status.
type Status string

const (
	// Initiated ...
	Initiated Status = "Initiated"
	// Revoked ...
	Revoked Status = "Revoked"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Initiated, Revoked}
}

// StatusReason enumerates the values for status reason.
type StatusReason string

const (
	// StatusReasonExpired ...
	StatusReasonExpired StatusReason = "Expired"
	// StatusReasonNewerRequestInitiated ...
	StatusReasonNewerRequestInitiated StatusReason = "NewerRequestInitiated"
	// StatusReasonUserRequested ...
	StatusReasonUserRequested StatusReason = "UserRequested"
)

// PossibleStatusReasonValues returns an array of possible values for the StatusReason const type.
func PossibleStatusReasonValues() []StatusReason {
	return []StatusReason{StatusReasonExpired, StatusReasonNewerRequestInitiated, StatusReasonUserRequested}
}

// SubAssessmentStatusCode enumerates the values for sub assessment status code.
type SubAssessmentStatusCode string

const (
	// SubAssessmentStatusCodeHealthy The resource is healthy
	SubAssessmentStatusCodeHealthy SubAssessmentStatusCode = "Healthy"
	// SubAssessmentStatusCodeNotApplicable Assessment for this resource did not happen
	SubAssessmentStatusCodeNotApplicable SubAssessmentStatusCode = "NotApplicable"
	// SubAssessmentStatusCodeUnhealthy The resource has a security issue that needs to be addressed
	SubAssessmentStatusCodeUnhealthy SubAssessmentStatusCode = "Unhealthy"
)

// PossibleSubAssessmentStatusCodeValues returns an array of possible values for the SubAssessmentStatusCode const type.
func PossibleSubAssessmentStatusCodeValues() []SubAssessmentStatusCode {
	return []SubAssessmentStatusCode{SubAssessmentStatusCodeHealthy, SubAssessmentStatusCodeNotApplicable, SubAssessmentStatusCodeUnhealthy}
}

// SubPlan enumerates the values for sub plan.
type SubPlan string

const (
	// P1 ...
	P1 SubPlan = "P1"
	// P2 ...
	P2 SubPlan = "P2"
)

// PossibleSubPlanValues returns an array of possible values for the SubPlan const type.
func PossibleSubPlanValues() []SubPlan {
	return []SubPlan{P1, P2}
}

// SupportedCloudEnum enumerates the values for supported cloud enum.
type SupportedCloudEnum string

const (
	// SupportedCloudEnumAWS ...
	SupportedCloudEnumAWS SupportedCloudEnum = "AWS"
	// SupportedCloudEnumGCP ...
	SupportedCloudEnumGCP SupportedCloudEnum = "GCP"
)

// PossibleSupportedCloudEnumValues returns an array of possible values for the SupportedCloudEnum const type.
func PossibleSupportedCloudEnumValues() []SupportedCloudEnum {
	return []SupportedCloudEnum{SupportedCloudEnumAWS, SupportedCloudEnumGCP}
}

// Tactics enumerates the values for tactics.
type Tactics string

const (
	// Collection ...
	Collection Tactics = "Collection"
	// CommandandControl ...
	CommandandControl Tactics = "Command and Control"
	// CredentialAccess ...
	CredentialAccess Tactics = "Credential Access"
	// DefenseEvasion ...
	DefenseEvasion Tactics = "Defense Evasion"
	// Discovery ...
	Discovery Tactics = "Discovery"
	// Execution ...
	Execution Tactics = "Execution"
	// Exfiltration ...
	Exfiltration Tactics = "Exfiltration"
	// Impact ...
	Impact Tactics = "Impact"
	// InitialAccess ...
	InitialAccess Tactics = "Initial Access"
	// LateralMovement ...
	LateralMovement Tactics = "Lateral Movement"
	// Persistence ...
	Persistence Tactics = "Persistence"
	// PrivilegeEscalation ...
	PrivilegeEscalation Tactics = "Privilege Escalation"
	// Reconnaissance ...
	Reconnaissance Tactics = "Reconnaissance"
	// ResourceDevelopment ...
	ResourceDevelopment Tactics = "Resource Development"
)

// PossibleTacticsValues returns an array of possible values for the Tactics const type.
func PossibleTacticsValues() []Tactics {
	return []Tactics{Collection, CommandandControl, CredentialAccess, DefenseEvasion, Discovery, Execution, Exfiltration, Impact, InitialAccess, LateralMovement, Persistence, PrivilegeEscalation, Reconnaissance, ResourceDevelopment}
}

// TaskUpdateActionType enumerates the values for task update action type.
type TaskUpdateActionType string

const (
	// Activate ...
	Activate TaskUpdateActionType = "Activate"
	// Close ...
	Close TaskUpdateActionType = "Close"
	// Dismiss ...
	Dismiss TaskUpdateActionType = "Dismiss"
	// Resolve ...
	Resolve TaskUpdateActionType = "Resolve"
	// Start ...
	Start TaskUpdateActionType = "Start"
)

// PossibleTaskUpdateActionTypeValues returns an array of possible values for the TaskUpdateActionType const type.
func PossibleTaskUpdateActionTypeValues() []TaskUpdateActionType {
	return []TaskUpdateActionType{Activate, Close, Dismiss, Resolve, Start}
}

// Techniques enumerates the values for techniques.
type Techniques string

const (
	// AbuseElevationControlMechanism ...
	AbuseElevationControlMechanism Techniques = "Abuse Elevation Control Mechanism"
	// AccessTokenManipulation ...
	AccessTokenManipulation Techniques = "Access Token Manipulation"
	// AccountDiscovery ...
	AccountDiscovery Techniques = "Account Discovery"
	// AccountManipulation ...
	AccountManipulation Techniques = "Account Manipulation"
	// ActiveScanning ...
	ActiveScanning Techniques = "Active Scanning"
	// ApplicationLayerProtocol ...
	ApplicationLayerProtocol Techniques = "Application Layer Protocol"
	// AudioCapture ...
	AudioCapture Techniques = "Audio Capture"
	// BootorLogonAutostartExecution ...
	BootorLogonAutostartExecution Techniques = "Boot or Logon Autostart Execution"
	// BootorLogonInitializationScripts ...
	BootorLogonInitializationScripts Techniques = "Boot or Logon Initialization Scripts"
	// BruteForce ...
	BruteForce Techniques = "Brute Force"
	// CloudInfrastructureDiscovery ...
	CloudInfrastructureDiscovery Techniques = "Cloud Infrastructure Discovery"
	// CloudServiceDashboard ...
	CloudServiceDashboard Techniques = "Cloud Service Dashboard"
	// CloudServiceDiscovery ...
	CloudServiceDiscovery Techniques = "Cloud Service Discovery"
	// CommandandScriptingInterpreter ...
	CommandandScriptingInterpreter Techniques = "Command and Scripting Interpreter"
	// CompromiseClientSoftwareBinary ...
	CompromiseClientSoftwareBinary Techniques = "Compromise Client Software Binary"
	// CompromiseInfrastructure ...
	CompromiseInfrastructure Techniques = "Compromise Infrastructure"
	// ContainerandResourceDiscovery ...
	ContainerandResourceDiscovery Techniques = "Container and Resource Discovery"
	// CreateAccount ...
	CreateAccount Techniques = "Create Account"
	// CreateorModifySystemProcess ...
	CreateorModifySystemProcess Techniques = "Create or Modify System Process"
	// CredentialsfromPasswordStores ...
	CredentialsfromPasswordStores Techniques = "Credentials from Password Stores"
	// DataDestruction ...
	DataDestruction Techniques = "Data Destruction"
	// DataEncryptedforImpact ...
	DataEncryptedforImpact Techniques = "Data Encrypted for Impact"
	// DatafromCloudStorageObject ...
	DatafromCloudStorageObject Techniques = "Data from Cloud Storage Object"
	// DatafromConfigurationRepository ...
	DatafromConfigurationRepository Techniques = "Data from Configuration Repository"
	// DatafromInformationRepositories ...
	DatafromInformationRepositories Techniques = "Data from Information Repositories"
	// DatafromLocalSystem ...
	DatafromLocalSystem Techniques = "Data from Local System"
	// DataManipulation ...
	DataManipulation Techniques = "Data Manipulation"
	// DataStaged ...
	DataStaged Techniques = "Data Staged"
	// Defacement ...
	Defacement Techniques = "Defacement"
	// DeobfuscateDecodeFilesorInformation ...
	DeobfuscateDecodeFilesorInformation Techniques = "Deobfuscate/Decode Files or Information"
	// DiskWipe ...
	DiskWipe Techniques = "Disk Wipe"
	// DomainTrustDiscovery ...
	DomainTrustDiscovery Techniques = "Domain Trust Discovery"
	// DriveByCompromise ...
	DriveByCompromise Techniques = "Drive-by Compromise"
	// DynamicResolution ...
	DynamicResolution Techniques = "Dynamic Resolution"
	// EndpointDenialofService ...
	EndpointDenialofService Techniques = "Endpoint Denial of Service"
	// EventTriggeredExecution ...
	EventTriggeredExecution Techniques = "Event Triggered Execution"
	// ExfiltrationOverAlternativeProtocol ...
	ExfiltrationOverAlternativeProtocol Techniques = "Exfiltration Over Alternative Protocol"
	// ExploitationforClientExecution ...
	ExploitationforClientExecution Techniques = "Exploitation for Client Execution"
	// ExploitationforCredentialAccess ...
	ExploitationforCredentialAccess Techniques = "Exploitation for Credential Access"
	// ExploitationforDefenseEvasion ...
	ExploitationforDefenseEvasion Techniques = "Exploitation for Defense Evasion"
	// ExploitationforPrivilegeEscalation ...
	ExploitationforPrivilegeEscalation Techniques = "Exploitation for Privilege Escalation"
	// ExploitationofRemoteServices ...
	ExploitationofRemoteServices Techniques = "Exploitation of Remote Services"
	// ExploitPublicFacingApplication ...
	ExploitPublicFacingApplication Techniques = "Exploit Public-Facing Application"
	// ExternalRemoteServices ...
	ExternalRemoteServices Techniques = "External Remote Services"
	// FallbackChannels ...
	FallbackChannels Techniques = "Fallback Channels"
	// FileandDirectoryDiscovery ...
	FileandDirectoryDiscovery Techniques = "File and Directory Discovery"
	// FileandDirectoryPermissionsModification ...
	FileandDirectoryPermissionsModification Techniques = "File and Directory Permissions Modification"
	// GatherVictimNetworkInformation ...
	GatherVictimNetworkInformation Techniques = "Gather Victim Network Information"
	// HideArtifacts ...
	HideArtifacts Techniques = "Hide Artifacts"
	// HijackExecutionFlow ...
	HijackExecutionFlow Techniques = "Hijack Execution Flow"
	// ImpairDefenses ...
	ImpairDefenses Techniques = "Impair Defenses"
	// ImplantContainerImage ...
	ImplantContainerImage Techniques = "Implant Container Image"
	// IndicatorRemovalonHost ...
	IndicatorRemovalonHost Techniques = "Indicator Removal on Host"
	// IndirectCommandExecution ...
	IndirectCommandExecution Techniques = "Indirect Command Execution"
	// IngressToolTransfer ...
	IngressToolTransfer Techniques = "Ingress Tool Transfer"
	// InputCapture ...
	InputCapture Techniques = "Input Capture"
	// InterProcessCommunication ...
	InterProcessCommunication Techniques = "Inter-Process Communication"
	// LateralToolTransfer ...
	LateralToolTransfer Techniques = "Lateral Tool Transfer"
	// ManInTheMiddle ...
	ManInTheMiddle Techniques = "Man-in-the-Middle"
	// Masquerading ...
	Masquerading Techniques = "Masquerading"
	// ModifyAuthenticationProcess ...
	ModifyAuthenticationProcess Techniques = "Modify Authentication Process"
	// ModifyRegistry ...
	ModifyRegistry Techniques = "Modify Registry"
	// NetworkDenialofService ...
	NetworkDenialofService Techniques = "Network Denial of Service"
	// NetworkServiceScanning ...
	NetworkServiceScanning Techniques = "Network Service Scanning"
	// NetworkSniffing ...
	NetworkSniffing Techniques = "Network Sniffing"
	// NonApplicationLayerProtocol ...
	NonApplicationLayerProtocol Techniques = "Non-Application Layer Protocol"
	// NonStandardPort ...
	NonStandardPort Techniques = "Non-Standard Port"
	// ObfuscatedFilesorInformation ...
	ObfuscatedFilesorInformation Techniques = "Obfuscated Files or Information"
	// ObtainCapabilities ...
	ObtainCapabilities Techniques = "Obtain Capabilities"
	// OfficeApplicationStartup ...
	OfficeApplicationStartup Techniques = "Office Application Startup"
	// OSCredentialDumping ...
	OSCredentialDumping Techniques = "OS Credential Dumping"
	// PermissionGroupsDiscovery ...
	PermissionGroupsDiscovery Techniques = "Permission Groups Discovery"
	// Phishing ...
	Phishing Techniques = "Phishing"
	// PreOSBoot ...
	PreOSBoot Techniques = "Pre-OS Boot"
	// ProcessDiscovery ...
	ProcessDiscovery Techniques = "Process Discovery"
	// ProcessInjection ...
	ProcessInjection Techniques = "Process Injection"
	// ProtocolTunneling ...
	ProtocolTunneling Techniques = "Protocol Tunneling"
	// Proxy ...
	Proxy Techniques = "Proxy"
	// QueryRegistry ...
	QueryRegistry Techniques = "Query Registry"
	// RemoteAccessSoftware ...
	RemoteAccessSoftware Techniques = "Remote Access Software"
	// RemoteServices ...
	RemoteServices Techniques = "Remote Services"
	// RemoteServiceSessionHijacking ...
	RemoteServiceSessionHijacking Techniques = "Remote Service Session Hijacking"
	// RemoteSystemDiscovery ...
	RemoteSystemDiscovery Techniques = "Remote System Discovery"
	// ResourceHijacking ...
	ResourceHijacking Techniques = "Resource Hijacking"
	// ScheduledTaskJob ...
	ScheduledTaskJob Techniques = "Scheduled Task/Job"
	// ScreenCapture ...
	ScreenCapture Techniques = "Screen Capture"
	// SearchVictimOwnedWebsites ...
	SearchVictimOwnedWebsites Techniques = "Search Victim-Owned Websites"
	// ServerSoftwareComponent ...
	ServerSoftwareComponent Techniques = "Server Software Component"
	// ServiceStop ...
	ServiceStop Techniques = "Service Stop"
	// SignedBinaryProxyExecution ...
	SignedBinaryProxyExecution Techniques = "Signed Binary Proxy Execution"
	// SoftwareDeploymentTools ...
	SoftwareDeploymentTools Techniques = "Software Deployment Tools"
	// SQLStoredProcedures ...
	SQLStoredProcedures Techniques = "SQL Stored Procedures"
	// StealorForgeKerberosTickets ...
	StealorForgeKerberosTickets Techniques = "Steal or Forge Kerberos Tickets"
	// SubvertTrustControls ...
	SubvertTrustControls Techniques = "Subvert Trust Controls"
	// SupplyChainCompromise ...
	SupplyChainCompromise Techniques = "Supply Chain Compromise"
	// SystemInformationDiscovery ...
	SystemInformationDiscovery Techniques = "System Information Discovery"
	// TaintSharedContent ...
	TaintSharedContent Techniques = "Taint Shared Content"
	// TrafficSignaling ...
	TrafficSignaling Techniques = "Traffic Signaling"
	// TransferDatatoCloudAccount ...
	TransferDatatoCloudAccount Techniques = "Transfer Data to Cloud Account"
	// TrustedRelationship ...
	TrustedRelationship Techniques = "Trusted Relationship"
	// UnsecuredCredentials ...
	UnsecuredCredentials Techniques = "Unsecured Credentials"
	// UserExecution ...
	UserExecution Techniques = "User Execution"
	// ValidAccounts ...
	ValidAccounts Techniques = "Valid Accounts"
	// WindowsManagementInstrumentation ...
	WindowsManagementInstrumentation Techniques = "Windows Management Instrumentation"
)

// PossibleTechniquesValues returns an array of possible values for the Techniques const type.
func PossibleTechniquesValues() []Techniques {
	return []Techniques{AbuseElevationControlMechanism, AccessTokenManipulation, AccountDiscovery, AccountManipulation, ActiveScanning, ApplicationLayerProtocol, AudioCapture, BootorLogonAutostartExecution, BootorLogonInitializationScripts, BruteForce, CloudInfrastructureDiscovery, CloudServiceDashboard, CloudServiceDiscovery, CommandandScriptingInterpreter, CompromiseClientSoftwareBinary, CompromiseInfrastructure, ContainerandResourceDiscovery, CreateAccount, CreateorModifySystemProcess, CredentialsfromPasswordStores, DataDestruction, DataEncryptedforImpact, DatafromCloudStorageObject, DatafromConfigurationRepository, DatafromInformationRepositories, DatafromLocalSystem, DataManipulation, DataStaged, Defacement, DeobfuscateDecodeFilesorInformation, DiskWipe, DomainTrustDiscovery, DriveByCompromise, DynamicResolution, EndpointDenialofService, EventTriggeredExecution, ExfiltrationOverAlternativeProtocol, ExploitationforClientExecution, ExploitationforCredentialAccess, ExploitationforDefenseEvasion, ExploitationforPrivilegeEscalation, ExploitationofRemoteServices, ExploitPublicFacingApplication, ExternalRemoteServices, FallbackChannels, FileandDirectoryDiscovery, FileandDirectoryPermissionsModification, GatherVictimNetworkInformation, HideArtifacts, HijackExecutionFlow, ImpairDefenses, ImplantContainerImage, IndicatorRemovalonHost, IndirectCommandExecution, IngressToolTransfer, InputCapture, InterProcessCommunication, LateralToolTransfer, ManInTheMiddle, Masquerading, ModifyAuthenticationProcess, ModifyRegistry, NetworkDenialofService, NetworkServiceScanning, NetworkSniffing, NonApplicationLayerProtocol, NonStandardPort, ObfuscatedFilesorInformation, ObtainCapabilities, OfficeApplicationStartup, OSCredentialDumping, PermissionGroupsDiscovery, Phishing, PreOSBoot, ProcessDiscovery, ProcessInjection, ProtocolTunneling, Proxy, QueryRegistry, RemoteAccessSoftware, RemoteServices, RemoteServiceSessionHijacking, RemoteSystemDiscovery, ResourceHijacking, ScheduledTaskJob, ScreenCapture, SearchVictimOwnedWebsites, ServerSoftwareComponent, ServiceStop, SignedBinaryProxyExecution, SoftwareDeploymentTools, SQLStoredProcedures, StealorForgeKerberosTickets, SubvertTrustControls, SupplyChainCompromise, SystemInformationDiscovery, TaintSharedContent, TrafficSignaling, TransferDatatoCloudAccount, TrustedRelationship, UnsecuredCredentials, UserExecution, ValidAccounts, WindowsManagementInstrumentation}
}

// Threats enumerates the values for threats.
type Threats string

const (
	// AccountBreach ...
	AccountBreach Threats = "accountBreach"
	// DataExfiltration ...
	DataExfiltration Threats = "dataExfiltration"
	// DataSpillage ...
	DataSpillage Threats = "dataSpillage"
	// DenialOfService ...
	DenialOfService Threats = "denialOfService"
	// ElevationOfPrivilege ...
	ElevationOfPrivilege Threats = "elevationOfPrivilege"
	// MaliciousInsider ...
	MaliciousInsider Threats = "maliciousInsider"
	// MissingCoverage ...
	MissingCoverage Threats = "missingCoverage"
	// ThreatResistance ...
	ThreatResistance Threats = "threatResistance"
)

// PossibleThreatsValues returns an array of possible values for the Threats const type.
func PossibleThreatsValues() []Threats {
	return []Threats{AccountBreach, DataExfiltration, DataSpillage, DenialOfService, ElevationOfPrivilege, MaliciousInsider, MissingCoverage, ThreatResistance}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "TCP"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "UDP"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolTCP, TransportProtocolUDP}
}

// Type enumerates the values for type.
type Type string

const (
	// Qualys ...
	Qualys Type = "Qualys"
	// TVM ...
	TVM Type = "TVM"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{Qualys, TVM}
}

// Type1 enumerates the values for type 1.
type Type1 string

const (
	// BinarySignature ...
	BinarySignature Type1 = "BinarySignature"
	// File ...
	File Type1 = "File"
	// FileHash ...
	FileHash Type1 = "FileHash"
	// ProductSignature ...
	ProductSignature Type1 = "ProductSignature"
	// PublisherSignature ...
	PublisherSignature Type1 = "PublisherSignature"
	// VersionAndAboveSignature ...
	VersionAndAboveSignature Type1 = "VersionAndAboveSignature"
)

// PossibleType1Values returns an array of possible values for the Type1 const type.
func PossibleType1Values() []Type1 {
	return []Type1{BinarySignature, File, FileHash, ProductSignature, PublisherSignature, VersionAndAboveSignature}
}

// TypeBasicResourceIdentifier enumerates the values for type basic resource identifier.
type TypeBasicResourceIdentifier string

const (
	// TypeAzureResource ...
	TypeAzureResource TypeBasicResourceIdentifier = "AzureResource"
	// TypeLogAnalytics ...
	TypeLogAnalytics TypeBasicResourceIdentifier = "LogAnalytics"
	// TypeResourceIdentifier ...
	TypeResourceIdentifier TypeBasicResourceIdentifier = "ResourceIdentifier"
)

// PossibleTypeBasicResourceIdentifierValues returns an array of possible values for the TypeBasicResourceIdentifier const type.
func PossibleTypeBasicResourceIdentifierValues() []TypeBasicResourceIdentifier {
	return []TypeBasicResourceIdentifier{TypeAzureResource, TypeLogAnalytics, TypeResourceIdentifier}
}

// UnmaskedIPLoggingStatus enumerates the values for unmasked ip logging status.
type UnmaskedIPLoggingStatus string

const (
	// UnmaskedIPLoggingStatusDisabled Unmasked IP logging is disabled
	UnmaskedIPLoggingStatusDisabled UnmaskedIPLoggingStatus = "Disabled"
	// UnmaskedIPLoggingStatusEnabled Unmasked IP logging is enabled
	UnmaskedIPLoggingStatusEnabled UnmaskedIPLoggingStatus = "Enabled"
)

// PossibleUnmaskedIPLoggingStatusValues returns an array of possible values for the UnmaskedIPLoggingStatus const type.
func PossibleUnmaskedIPLoggingStatusValues() []UnmaskedIPLoggingStatus {
	return []UnmaskedIPLoggingStatus{UnmaskedIPLoggingStatusDisabled, UnmaskedIPLoggingStatusEnabled}
}

// UserImpact enumerates the values for user impact.
type UserImpact string

const (
	// UserImpactHigh ...
	UserImpactHigh UserImpact = "High"
	// UserImpactLow ...
	UserImpactLow UserImpact = "Low"
	// UserImpactModerate ...
	UserImpactModerate UserImpact = "Moderate"
)

// PossibleUserImpactValues returns an array of possible values for the UserImpact const type.
func PossibleUserImpactValues() []UserImpact {
	return []UserImpact{UserImpactHigh, UserImpactLow, UserImpactModerate}
}

// ValueType enumerates the values for value type.
type ValueType string

const (
	// ValueTypeIPCidr An IP range in CIDR format (e.g. '192.168.0.1/8').
	ValueTypeIPCidr ValueType = "IpCidr"
	// ValueTypeString Any string value.
	ValueTypeString ValueType = "String"
)

// PossibleValueTypeValues returns an array of possible values for the ValueType const type.
func PossibleValueTypeValues() []ValueType {
	return []ValueType{ValueTypeIPCidr, ValueTypeString}
}
