/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */

// If we refactor the database/connection model we can move this const to a util and use it in a form component.
// The ideal (future) scenario is the API provides this and we don't have to manually write the schema :)
export const EXPECTED_FIELDS = {
  'elasticsearch-database-plugin': {
    default: [
      'url',
      'username',
      'password',
      'ca_cert',
      'ca_path',
      'client_cert',
      'client_key',
      'tls_server_name',
      'insecure',
      'username_template',
    ],
    showAttrs: [
      'plugin_name',
      'name',
      'password_policy',
      'url',
      'ca_cert',
      'ca_path',
      'client_cert',
      'client_key',
      'tls_server_name',
      'insecure',
      'username_template',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'verify_connection', 'password_policy'],
    pluginFieldGroups: undefined,
    statementFields: [],
  },
  'mongodb-database-plugin': {
    default: ['username', 'password', 'write_concern', 'username_template'],
    showAttrs: [
      'plugin_name',
      'name',
      'connection_url',
      'password_policy',
      'write_concern',
      'username_template',
      'tls',
      'tls_ca',
      'root_rotation_statements',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'connection_url', 'verify_connection', 'password_policy'],
    pluginFieldGroups: ['username', 'password', 'write_concern', 'username_template'],
    statementFields: [
      {
        name: 'root_rotation_statements',
        options: {
          defaultShown: 'Default',
          editType: 'stringArray',
          subText:
            "The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",
        },
        type: undefined,
      },
    ],
    'TLS options': ['tls', 'tls_ca'],
  },
  'mssql-database-plugin': {
    default: [
      'username',
      'password',
      'username_template',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
    ],
    showAttrs: [
      'plugin_name',
      'name',
      'connection_url',
      'password_policy',
      'username_template',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'root_rotation_statements',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'connection_url', 'verify_connection', 'password_policy'],
    statementFields: [
      {
        name: 'root_rotation_statements',
        options: {
          defaultShown: 'Default',
          editType: 'stringArray',
          subText:
            "The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",
        },
        type: undefined,
      },
    ],
  },
  'mysql-aurora-database-plugin': {
    default: [
      'connection_url',
      'username',
      'password',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
    ],
    showAttrs: [
      'plugin_name',
      'name',
      'password_policy',
      'connection_url',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
      'tls',
      'tls_ca',
      'root_rotation_statements',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'verify_connection', 'password_policy'],
    statementFields: [
      {
        name: 'root_rotation_statements',
        options: {
          defaultShown: 'Default',
          editType: 'stringArray',
          subText:
            "The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",
        },
        type: undefined,
      },
    ],
    'TLS options': ['tls', 'tls_ca'],
  },
  'mysql-legacy-database-plugin': {
    default: [
      'connection_url',
      'username',
      'password',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
    ],
    showAttrs: [
      'plugin_name',
      'name',
      'password_policy',
      'connection_url',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
      'tls',
      'tls_ca',
      'root_rotation_statements',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'verify_connection', 'password_policy'],
    statementFields: [
      {
        name: 'root_rotation_statements',
        options: {
          defaultShown: 'Default',
          editType: 'stringArray',
          subText:
            "The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",
        },
        type: undefined,
      },
    ],
    'TLS options': ['tls', 'tls_ca'],
  },
  'mysql-database-plugin': {
    default: [
      'connection_url',
      'username',
      'password',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
    ],
    showAttrs: [
      'plugin_name',
      'name',
      'password_policy',
      'connection_url',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
      'tls',
      'tls_ca',
      'root_rotation_statements',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'verify_connection', 'password_policy'],
    statementFields: [
      {
        name: 'root_rotation_statements',
        options: {
          defaultShown: 'Default',
          editType: 'stringArray',
          subText:
            "The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",
        },
        type: undefined,
      },
    ],
    'TLS options': ['tls', 'tls_ca'],
  },
  'mysql-rds-database-plugin': {
    default: [
      'connection_url',
      'username',
      'password',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
    ],
    showAttrs: [
      'plugin_name',
      'name',
      'password_policy',
      'connection_url',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
      'tls',
      'tls_ca',
      'root_rotation_statements',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'verify_connection', 'password_policy'],
    statementFields: [
      {
        name: 'root_rotation_statements',
        options: {
          defaultShown: 'Default',
          editType: 'stringArray',
          subText:
            "The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",
        },
        type: undefined,
      },
    ],
    'TLS options': ['tls', 'tls_ca'],
  },
  'vault-plugin-database-oracle': {
    default: [
      'connection_url',
      'username',
      'password',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
    ],
    showAttrs: [
      'plugin_name',
      'name',
      'password_policy',
      'connection_url',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'username_template',
      'root_rotation_statements',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'verify_connection', 'password_policy'],
    statementFields: [
      {
        name: 'root_rotation_statements',
        options: {
          defaultShown: 'Default',
          editType: 'stringArray',
          subText:
            "The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",
        },
        type: undefined,
      },
    ],
  },
  'postgresql-database-plugin': {
    default: [
      'connection_url',
      'username',
      'password',
      'password_authentication',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'auth_type',
      'service_account_json',
      'use_private_ip',
      'username_template',
      'disable_escaping',
    ],
    showAttrs: [
      'plugin_name',
      'name',
      'password_policy',
      'connection_url',
      'password_authentication',
      'max_open_connections',
      'max_idle_connections',
      'max_connection_lifetime',
      'auth_type',
      'service_account_json',
      'use_private_ip',
      'username_template',
      'disable_escaping',
      'root_rotation_statements',
      'private_key',
      'tls_ca',
      'tls_certificate',
      'allowed_roles',
    ],
    fieldAttrs: ['plugin_name', 'name', 'verify_connection', 'password_policy'],
    statementFields: [
      {
        name: 'root_rotation_statements',
        options: {
          defaultShown: 'Default',
          editType: 'stringArray',
          subText:
            "The database statements to be executed to rotate the root user's credentials. If nothing is entered, Vault will use a reasonable default.",
        },
        type: undefined,
      },
    ],
    enterpriseOnly: 'self_managed',
  },
};
