/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import jlibs.core.graph.Convertor;
import jlibs.core.graph.Filter;
import jlibs.core.util.regex.TemplateMatcher;

public class StringUtil {
    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == s2 || s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isWhitespace(CharSequence str) {
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String[] getTokens(String str, String delim, boolean trim) {
        StringTokenizer stok = new StringTokenizer(str, delim);
        String[] tokens = new String[stok.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = stok.nextToken();
            if (!trim) continue;
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    public static String suggest(Filter<String> filter, String pattern, boolean tryEmptyVar) {
        int i;
        String value;
        if (!pattern.contains("${i}")) {
            throw new IllegalArgumentException("pattern must have ${i}");
        }
        TemplateMatcher matcher = new TemplateMatcher("${", "}");
        if (tryEmptyVar && filter.select(value = matcher.replace(pattern, Collections.singletonMap("i", "")))) {
            return value;
        }
        int n = i = tryEmptyVar ? 2 : 1;
        String value2;
        while (!filter.select(value2 = matcher.replace(pattern, Collections.singletonMap("i", String.valueOf(i))))) {
            ++i;
        }
        return value2;
    }

    public static String capitalize(String str) {
        if (str == null) {
            return null;
        }
        switch (str.length()) {
            case 0: {
                return str;
            }
            case 1: {
                return str.toUpperCase();
            }
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String underscore(String camelCaseWord) {
        if (camelCaseWord == null) {
            return null;
        }
        if ((camelCaseWord = camelCaseWord.trim()).length() == 0) {
            return "";
        }
        camelCaseWord = camelCaseWord.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2");
        camelCaseWord = camelCaseWord.replaceAll("([a-z\\d])([A-Z])", "$1_$2");
        return camelCaseWord.toLowerCase();
    }

    public static String ordinalize(int number) {
        int modulo = number % 100;
        if (modulo >= 11 && modulo <= 13) {
            return number + "th";
        }
        switch (number % 10) {
            case 1: {
                return number + "st";
            }
            case 2: {
                return number + "nd";
            }
            case 3: {
                return number + "rd";
            }
        }
        return number + "th";
    }

    public static int[] toCodePoints(String str) {
        int count = str.codePointCount(0, str.length());
        int[] codePoints = new int[count];
        int charIndex = 0;
        for (int cpIndex = 0; cpIndex < count; ++cpIndex) {
            int cp;
            codePoints[cpIndex] = cp = str.codePointAt(charIndex);
            charIndex += Character.charCount(cp);
        }
        return codePoints;
    }

    public static <T> String join(T[] array) {
        return StringUtil.join(array, ", ", null);
    }

    public static <T> String join(T[] array, String separator) {
        return StringUtil.join(array, separator, null);
    }

    public static <T> String join(T[] array, String separator, Convertor<T, String> convertor) {
        StringBuilder buff = new StringBuilder();
        boolean addSeparator = false;
        for (T item : array) {
            if (addSeparator) {
                buff.append(separator);
            } else {
                addSeparator = true;
            }
            if (item == null) {
                buff.append("null");
                continue;
            }
            buff.append(convertor == null ? item.toString() : convertor.convert(item));
        }
        return buff.toString();
    }

    public static <T> String join(Iterator<T> iter) {
        return StringUtil.join(iter, ", ", null);
    }

    public static <T> String join(Iterator<T> iter, String separator) {
        return StringUtil.join(iter, separator, null);
    }

    public static <T> String join(Iterator<T> iter, String separator, Convertor<T, String> convertor) {
        StringBuilder buff = new StringBuilder();
        boolean addSeparator = false;
        while (iter.hasNext()) {
            T item = iter.next();
            if (addSeparator) {
                buff.append(separator);
            } else {
                addSeparator = true;
            }
            if (item == null) {
                buff.append("null");
                continue;
            }
            buff.append(convertor == null ? item.toString() : convertor.convert(item));
        }
        return buff.toString();
    }

    public static String toLiteral(char ch, boolean useRaw) {
        if (ch == '\'') {
            return "\\'";
        }
        if (ch == '\"') {
            return "\"";
        }
        return StringUtil.toLiteral(String.valueOf(ch), useRaw);
    }

    public static String toLiteral(CharSequence str, boolean useRaw) {
        StringBuilder buf = new StringBuilder(str.length() + 25);
        int len = str.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        buf.append(c);
                        continue block9;
                    }
                    buf.append("\\u");
                    String hex = Integer.toHexString(c);
                    for (int j = 4 - hex.length(); j > 0; --j) {
                        buf.append('0');
                    }
                    buf.append(hex);
                }
            }
        }
        return buf.toString();
    }

    public static String fromLiteral(String str) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        block14: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == str.length() - 1) {
                        buf.append('\\');
                        continue block14;
                    }
                    c = str.charAt(++i);
                    switch (c) {
                        case 'n': {
                            buf.append('\n');
                            continue block14;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block14;
                        }
                        case 'r': {
                            buf.append('\r');
                            continue block14;
                        }
                        case 'u': {
                            int value = 0;
                            block15: for (int j = 0; j < 4; ++j) {
                                c = str.charAt(++i);
                                switch (c) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        value = (value << 4) + c - 48;
                                        continue block15;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        value = (value << 4) + 10 + c - 97;
                                        continue block15;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        value = (value << 4) + 10 + c - 65;
                                        continue block15;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                            }
                            buf.append((char)value);
                            continue block14;
                        }
                    }
                    buf.append(c);
                    continue block14;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

