/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * support.h
 * Copyright (C) Carles Sentis 2010 <realtimesunlightwallpaper.gtk@gmail.com>
 * 
 * gtk-sunlight is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * gtk-sunlight is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
#ifndef __SUPPORT_H__
#define __SUPPORT_H__

#include "errno.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdlib.h>
#include <glib/gprintf.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <glib-object.h>
//#include <libgnomeui/libgnomeui.h>

#define UI_FILE "/usr/share/sunlight/sunlight.glade"

#define DIR_PROJECT "/.gnome2/RealtimeSunlightWallpaper"
#define DIR_WALLPAPERS DIR_PROJECT"/gtk-sunlight"

//~ #define GCONF_SET_WALLPAPER "gconftool-2 --type string --set /desktop/gnome/background/picture_filename"
//~ #define GCONF_SET_PICTURE_OPTIONS "gconftool-2 --type string --set /desktop/gnome/background/picture_options "
//~ #define GCONF_SET_COLOR_PRIMARY_OPTIONS "gconftool-2 --type string --set /desktop/gnome/background/primary_color "
//~ #define GCONF_SET_COLOR_SECONDARY_OPTIONS "gconftool-2 --type string --set /desktop/gnome/background/secondary_color "
//~ #define GCONF_SET_GRADIENT_OPTIONS "gconftool-2 --type string --set /desktop/gnome/background/color_shading_type "

#define GCONF_SET_WALLPAPER "gsettings set org.gnome.desktop.background picture-uri file://"
#define GCONF_SET_PICTURE_OPTIONS "gsettings set org.gnome.desktop.background picture-options "
#define GCONF_SET_COLOR_PRIMARY_OPTIONS "gsettings set org.gnome.desktop.background primary-color "
#define GCONF_SET_COLOR_SECONDARY_OPTIONS "gsettings set org.gnome.desktop.background secondary-color "
#define GCONF_SET_GRADIENT_OPTIONS "gsettings set org.gnome.desktop.background color-shading-type "

/* Convenience macros for obtaining objects from UI file */
#define CH_GET_OBJECT( builder, name, type, data ) \
	data->name = type( gtk_builder_get_object( builder, #name ) )
#define CH_GET_WIDGET( builder, name, data ) \
	CH_GET_OBJECT( builder, name, GTK_WIDGET, data )
	
/* Debugging macros*/
// #define DEBUG
#ifdef DEBUG
	#define DBG(x) g_print x
#else
	#define DBG(x) /* nothing */
#endif

/* Main data structure definition */
/* store the widgets which may need to be accessed in a typedef struct */

typedef struct _ChData ChData;
struct _ChData
{
	GtkWidget *main_window;
	GtkImage *main_image;
	GtkToggleButton *chk_start_up;

	struct _RadioButtons
	{
		GtkToggleButton *rd_worldmap;
		GtkToggleButton *rd_mercator;
		GtkToggleButton *rd_peters;
		GtkToggleButton *rd_mollweide;
		GtkToggleButton *rd_equirectangular;
		GtkToggleButton *rd_realistic;
		GtkToggleButton	*rd_moon;
	}rad;
	
	struct _AdvancedOptions
	{
		GtkToggleButton *chk_move_map;
		GtkAdjustment *hscale_adj;
		GtkWidget *box_advanced;
		GtkExpander *exp_advanced;
	}adv;
	
	struct _SystemSettings
	{
		GtkComboBox *cmb_style;
		GtkComboBox *cmb_colors;
		GtkColorButton *color_picker_one;
		GtkColorButton *color_picker_two;
		GtkWidget *hbox;
	}sys;
	
	struct _MessageDialog
	{
		GtkWidget *message_dialog;
	}mes;
	
	struct _OfflineMode
	{
		GtkToggleButton *chk_offline;
		GtkWidget *box_offline;
		GtkWidget *file_offline;
		GtkFileFilter *filter_offline;
		gshort cmb_style;
		gshort cmb_color;
		gint color_one;
		gint color_two;
	}offline;
	
	struct _Variables
	{
		gshort gi_rd1;
		gshort gi_rd2;
		gshort gi_start_up;
		gshort gi_map_height;
		gfloat gd_map_scale;
		gboolean gb_move_map;
		gboolean gb_apply_clicked;
		gboolean gb_offline;
		glong gl_file_time;
		time_t tm_current;
		time_t tm_saved;
	}var;
};

#endif /* __SUPPORT_H__ */

