/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * sunlight.c
 * Copyright (C) Carles Sentis 2010 <realtimesunlightwallpaper.gtk@gmail.com>
 * 
 * gtk-sunlight is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * gtk-sunlight is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "support.h"

void initialize_variables (ChData *data){
	data->var.gi_rd1 = 1;
	data->var.gi_rd2 = 1;
	data->var.gd_map_scale = 0;
	data->var.gb_move_map = FALSE;
	data->var.gb_offline = FALSE;
	time(&data->var.tm_saved);
	data->var.gb_apply_clicked = FALSE;
	
	if(data->var.gi_rd2 == 1) data->var.gi_map_height = 887;
	else if (data->var.gi_rd2 == 2) data->var.gi_map_height = 710;
	else if (data->var.gi_rd2 == 4) data->var.gi_map_height = 660;
	else data->var.gi_map_height = 0;
}

gboolean make_dir(gchar *trail){
	gboolean success = FALSE;
	gchar *dir = g_strconcat(g_get_home_dir(), trail, NULL);

	if (!g_file_test(dir, G_FILE_TEST_IS_DIR)) {
		if (g_mkdir(dir, 0750) == 0) success = TRUE;
	} else { // exists
		success = TRUE;
	}

	g_free(dir);
	return success;
}

/* Pulling variables from a string */
void get_options (char *string, gint length, ChData *data){
	gshort cnt = 0;

	while (1){
	
		gchar *tail;
		gint64 tmp_int;
		
		while (isspace (*string)) string++;
		
		if (*string == 0)
			break;

		errno = 0;
		tmp_int = strtol (string, &tail, 0);

		if (errno)
			DBG (("Overflow\n"));
		else{
			switch(cnt){
				case 0:	data->var.gi_rd1 = (gshort)tmp_int;
						break;
				case 1: data->var.gi_rd2 = (gshort)tmp_int;
						break;
				case 2: data->var.gd_map_scale = (float)tmp_int;
						break;
				case 3: if(tmp_int == 0){
							DBG (("move map TRUE\n"));
							data->var.gb_move_map = TRUE;
						}else{
							DBG (("move map FALSE\n"));
							data->var.gb_move_map = FALSE;
						}
						break;
				case 4:	if(tmp_int == 0){
							DBG (("offline mode TRUE"));
							data->var.gb_offline = TRUE;
						}else{
							DBG (("offline mode FALSE"));
							data->var.gb_offline = FALSE;
						}
						break;
				case 5: data->var.tm_saved = tmp_int;
						break;
			}cnt++;
		}
		string = tail;
	}
}

int main( int argc, char **argv ){
	DBG (("DBG - gtk-sunlight Started\n"));
	
	ChData     	*data;
	GtkBuilder 	*builder;
	GError     	*error = NULL;
	gchar 		*option_file = g_strconcat(g_get_home_dir(), DIR_PROJECT, "/sunlight_options", NULL);
	gchar 		*contents;
	gsize 		length;
	guint32		time_out;
	
	GOptionContext 	*context;
	gboolean 	nodisplay = FALSE;

	GOptionEntry entries[] =
	{
		{ "nodisplay", 0, 0, G_OPTION_ARG_NONE, &nodisplay, "Do not show main window", NULL },
		{ NULL }
	};

	/* Init threads */
	if( !g_thread_supported() ){
		g_thread_init(NULL);
		gdk_threads_init();
	}else{ DBG (("g_thread NOT supported\n"));}

	context = g_option_context_new ("- Real-time Sunlight Wallpaper");
  	g_option_context_add_main_entries (context, entries, NULL);
  	g_option_context_add_group (context, gtk_get_option_group (TRUE));
	
  	if (!g_option_context_parse (context, &argc, &argv, &error)) {
		DBG (("Failed to initialize: %s\n", error->message));
    	g_error_free (error);
    	return 1;
	}
	g_option_context_free (context);
	
	/* Init GTK+ */
	gtk_init( &argc, &argv );

	/* Allocate data structure */
	data = g_slice_new( ChData );
	
	/* create project directories if necessary */
	if (!make_dir(DIR_PROJECT)) return 1;
	if (!make_dir(DIR_WALLPAPERS)) return 1;

	/* Check for sunlight_options file and getting gi_rd1 and gi_rd2*/
	initialize_variables(data);
	
	if (g_file_test(option_file, G_FILE_TEST_EXISTS))
	{
		if (g_file_get_contents (option_file, &contents, &length, &error))
		{
			/* We are reading a string from file, and we need two integers */
			get_options(contents, length, data);		
		}else{
			initialize_variables(data);
		}
		g_free(contents);
	}else{
		initialize_variables(data);
	}
	g_free(option_file);
	
	/* Create new GtkBuilder object */
	builder = gtk_builder_new();
	
	if( ! gtk_builder_add_from_file( builder, UI_FILE, &error ) )
	{
		g_warning( "%s", error->message );
		g_free( error );
		return( 1 );
	}

	/* Get objects from UI */
#define GW( name ) CH_GET_WIDGET( builder, name, data )
	GW( main_window );
#undef GW

	/* get the widgets which will be referenced in callbacks */
	data->main_window	= GTK_WIDGET 		(gtk_builder_get_object (builder, "main_window"));
	data->main_image	= GTK_IMAGE 		(gtk_builder_get_object (builder, "sunlight_image"));
	data->chk_start_up	= GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "chk_startup"));
	
	data->rad.rd_worldmap			= GTK_TOGGLE_BUTTON	(gtk_builder_get_object (builder, "rd1_worldmap"));
	data->rad.rd_mercator			= GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "rd2_mercator"));
	data->rad.rd_peters				= GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "rd2_peters"));
	data->rad.rd_mollweide			= GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "rd2_mollweide"));
	data->rad.rd_equirectangular	= GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "rd2_equirectangular"));
	data->rad.rd_realistic			= GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "rd1_realistic"));
	data->rad.rd_moon				= GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "rd1_moon"));
	
	data->adv.chk_move_map	= GTK_TOGGLE_BUTTON	(gtk_builder_get_object (builder, "chk_move_map"));
	data->adv.hscale_adj	= GTK_ADJUSTMENT 	(gtk_builder_get_object (builder, "hscale_adj"));
	data->adv.box_advanced	= GTK_WIDGET		(gtk_builder_get_object (builder, "box_extra_options"));
	data->adv.exp_advanced	= GTK_EXPANDER		(gtk_builder_get_object (builder, "exp_advanced"));

	data->sys.cmb_style			= GTK_COMBO_BOX 	(gtk_builder_get_object (builder, "cmb_style"));
	data->sys.cmb_colors		= GTK_COMBO_BOX 	(gtk_builder_get_object (builder, "cmb_colors"));
	data->sys.color_picker_one	= GTK_COLOR_BUTTON 	(gtk_builder_get_object (builder, "colorbutton1"));
	data->sys.color_picker_two	= GTK_COLOR_BUTTON 	(gtk_builder_get_object (builder, "colorbutton2"));
	data->sys.hbox 				= GTK_WIDGET 		(gtk_builder_get_object (builder, "hbox4"));
	
	data->mes.message_dialog = GTK_WIDGET (gtk_builder_get_object (builder, "message_dialog"));
	
	data->offline.chk_offline	= GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "chk_offline"));
	data->offline.box_offline	= GTK_WIDGET		(gtk_builder_get_object (builder, "box_offline"));
	data->offline.file_offline	= GTK_WIDGET		(gtk_builder_get_object (builder, "filechooser_offline"));
	data->offline.filter_offline= GTK_FILE_FILTER	(gtk_builder_get_object (builder, "file_filter_offline"));

	/* Connect signals */
	gtk_builder_connect_signals( builder, data );

	/* Destroy builder, since we don't need it anymore */
	g_object_unref( G_OBJECT( builder ) );
	
	gchar *kill_sunlight = "killall gtk-sunlight -q -o 5s";
	system (kill_sunlight);
	
	if (!nodisplay) 
		gtk_widget_show( data->main_window );
	else{
		change_wallpaper (data);
		if(data->var.gi_rd1 != 3) {
			time_out = g_timeout_add(1800000, (GSourceFunc) change_wallpaper, data);
		}
		else {
			time_out = g_timeout_add(86400000, (GSourceFunc) change_wallpaper, data);
		}
	}
	
	/* Start main loop */
	gtk_main();
	
	/* Free any allocated data */
	g_slice_free( ChData, data );
	
	return( 0 );
}
