#    Copyright 2003,2008 Regis Damongeot

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 
proc refresh_total_file_size {} {
	global file_list total_file_size_f space_left_f command_line t_session excluded_file_list dvd_size 
	#set local var total_file_size_type cause if total_file_size < 1024 octets, total_file_size isnt set
	set total_file_size_type "KB"
	#set local var total_file_size cause if llength $file_list > 1 then $total_file_size is not set for the fisrt iteration of "for"
	set total_file_size 0
	#attention: $total_file_size is in KB to prevent overflow if $total_file_size > 2go
	if {[llength $file_list] == 0} {
		set total_file_size 0
	} elseif { [llength $file_list] == 1 } {
		if {[file isdirectory [lindex $file_list 0]]} {
			set total_file_size [expr [lindex [exec du -ks -- [lindex $file_list 0]] 0] - [file size [lindex $file_list 0]]/1024]
		} else { set total_file_size [expr [file size [lindex $file_list 0]]/1024.] }
	} else {
		for { set i 0 } {$i < [llength $file_list]} {incr i} {
			if {[file isdirectory [lindex $file_list $i]]} {
				set total_file_size [expr $total_file_size + [expr [lindex [exec du -ks -- [lindex $file_list $i]] 0] - [file size [lindex $file_list 0]]/1024]]
			} else { set total_file_size [expr ($total_file_size + [expr ([file size [lindex $file_list $i]])/1024.])] }
		}
	}
	
	
	foreach i $excluded_file_list {
		if { [file isdirectory $i] } {
			set total_file_size [expr $total_file_size - [exec du -ks $i | cut -f1 ] ]
		} elseif { [file isfile $i] } {
			set total_file_size [expr $total_file_size - ([ file size $i ] / 1024.) ]
		}
	}
	
	
	# save total_file_size in order to reuse it to calculate space_left more easily
	set space_left $total_file_size
	if { $total_file_size > 1048576 } {
		set total_file_size [expr (($total_file_size)/1024.)/1024.]
		set total_file_size_type "GB"
	} elseif { $total_file_size > 1024 } {
		set total_file_size [expr ($total_file_size)/1024.]
		set total_file_size_type "MB"
	} else {
		set total_file_size $total_file_size
		set total_file_size_type "KB"
	}
	set total_file_size_f "$total_file_size $total_file_size_type"
	switch $total_file_size_type  {
		GB {
			set space_left [expr ($dvd_size - $space_left)/1024.]
			set space_left_type "MB"
		}
		MB {
			#if we burn CD we don't want space left to be in GB
			if { $dvd_size == "665600" || $dvd_size == "716800"} {
				set space_left [expr ($dvd_size - $space_left)/1024.]
				set space_left_type "MB"
			} else {
				set space_left [expr (($dvd_size - $space_left)/1024.)/1024.]
				set space_left_type "GB"
			}
		}
		KB {
			#if we burn CD we don't want space left to be in GB
			if { $dvd_size == "665600" || $dvd_size == "716800"} {
				set space_left [expr ($dvd_size - $space_left)/1024.]
				set space_left_type "MB"
			} else {
				set space_left [expr (($dvd_size - $space_left)/1024.)/1024.]
				set space_left_type "GB"
			}
		}
	}
	#if {$t_session == "-use-the-force-luke=tty -Z"} {set space_left_f "$space_left $space_left_type"
	#} else {set space_left_f "N/A"}
	set space_left_f "$space_left $space_left_type"
}