/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.DropdownListComponent;
import com.install4j.runtime.beans.formcomponents.TextComponentUtil;
import com.install4j.runtime.installer.helper.InstallerUtil;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ComboboxComponent
extends DropdownListComponent
implements TextComponentUtil.InputVerifierParameterProvider {
    private ScriptProperty inputVerifier;

    public ScriptProperty getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(ScriptProperty scriptProperty) {
        this.inputVerifier = scriptProperty;
    }

    protected void applyComboBoxProperties(JComboBox jComboBox) {
        super.applyComboBoxProperties(jComboBox);
        jComboBox.setEditable(true);
        Object object = this.getContext().getVariable(this.getVariableName());
        if (object != null && object instanceof String) {
            jComboBox.setSelectedItem(object);
        }
        TextComponentUtil.addInputVerifier(this, this.inputVerifier, (JComponent)jComboBox.getEditor().getEditorComponent(), this);
    }

    public boolean checkCompleted() {
        final JComboBox jComboBox = this.getComboBox();
        InputVerifier inputVerifier = ((JComponent)jComboBox.getEditor().getEditorComponent()).getInputVerifier();
        if (inputVerifier != null && !inputVerifier.verify(jComboBox)) {
            if (!InstallerUtil.isUnattended() && !InstallerUtil.isConsole()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ComboboxComponent.this.getFormEnvironment().makeParentGroupVisible(ComboboxComponent.this);
                        jComboBox.requestFocus();
                    }
                });
            }
            return false;
        }
        this.getContext().setVariable(this.getVariableName(), this.getComboBox().getSelectedItem().toString());
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    protected boolean getInitialFillHorizontal() {
        return true;
    }

    public Object[] createInputVerifierParameters() {
        return new Object[]{this.getFormEnvironment(), this.getComboBox().getEditor().getItem()};
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        JComboBox jComboBox = this.getComboBox();
        InputVerifier inputVerifier = ((JComponent)jComboBox.getEditor().getEditorComponent()).getInputVerifier();
        Object object = jComboBox.getSelectedItem();
        do {
            jComboBox.setSelectedItem(object);
            String string = console.askString(this.getConsoleLabelText(false), object == null ? null : object.toString());
            jComboBox.setSelectedItem(string);
        } while (inputVerifier != null && !inputVerifier.verify(jComboBox));
        return true;
    }
}

