/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.update;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ShutdownCallingLauncherAction
extends SystemInstallOrUninstallAction {
    private boolean wait = true;
    private int timeout = 60;

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean bl) {
        this.wait = bl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (InstallerUtil.isInProcess()) {
            InstallerUtil.setShutdownOnInProcessExit(true);
            return true;
        }
        String string = System.getProperty("install4j.shutdownFile");
        if (string == null) {
            Logger.getInstance().error(this, "no shutdown file property");
            return false;
        }
        ProgressInterface progressInterface = context.getProgressInterface();
        progressInterface.setStatusMessage(context.getMessage("WaitLabel"));
        progressInterface.setIndeterminateProgress(true);
        try {
            File file = new File(string);
            if (file.exists()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(83);
                fileOutputStream.close();
                if (this.isWait()) {
                    for (int i = 0; this.getTimeout() == 0 || i < this.getTimeout(); ++i) {
                        if (!file.exists()) {
                            this.sleepOneSecond();
                            return true;
                        }
                        this.sleepOneSecond();
                    }
                    Logger.getInstance().error(this, "timeout");
                    return false;
                }
            } else {
                Logger.getInstance().error(this, "calling launcher already terminated");
            }
            return true;
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
            return false;
        }
    }

    private void sleepOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public boolean isRollbackSupported() {
        return false;
    }
}

