/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.registry.PreferenceDeleteType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public abstract class PreferencesDeleteAction
extends PreferencesAction {
    private PreferenceDeleteType preferenceDeleteType = PreferenceDeleteType.USER;

    public PreferenceDeleteType getPreferenceDeleteType() {
        return this.preferenceDeleteType;
    }

    public void setPreferenceDeleteType(PreferenceDeleteType preferenceDeleteType) {
        this.preferenceDeleteType = preferenceDeleteType;
    }

    protected boolean executePreferencesDeleter(PreferencesDeleter preferencesDeleter, Context context) {
        boolean bl = false;
        if (this.preferenceDeleteType == PreferenceDeleteType.SYSTEM || this.preferenceDeleteType == PreferenceDeleteType.SYSTEM_AND_USER) {
            bl |= this.handleRollbackActions(PreferencesDeleteAction.executePreferenceDeleter(preferencesDeleter, this.getPackageName(), false, context));
        }
        if (this.preferenceDeleteType == PreferenceDeleteType.USER || this.preferenceDeleteType == PreferenceDeleteType.SYSTEM_AND_USER) {
            bl |= this.handleRollbackActions(PreferencesDeleteAction.executePreferenceDeleter(preferencesDeleter, this.getPackageName(), true, context));
        }
        return bl;
    }

    private static List executePreferenceDeleter(PreferencesDeleter preferencesDeleter, String string, boolean bl, Context context) {
        if (HelperCommunication.getInstance().isElevatedHelper() && bl) {
            return PreferencesDeleteAction.executePreferenceDeleterUnelevated(preferencesDeleter, string, bl);
        }
        try {
            PreferencesAction.PackageNodeProvider packageNodeProvider = new PreferencesAction.PackageNodeProvider(string, bl, false);
            Preferences preferences = packageNodeProvider.getPackageNodeUnguarded();
            if (preferences != null) {
                ArrayList arrayList = new ArrayList();
                boolean bl2 = preferencesDeleter.deleteFromPreferences(packageNodeProvider, context, arrayList);
                preferences.flush();
                return bl2 ? arrayList : null;
            }
            Logger.getInstance().log(null, "Package " + string + " does not exist", false);
        }
        catch (Exception exception) {
            Logger.getInstance().log(exception);
        }
        return null;
    }

    private static List executePreferenceDeleterUnelevated(final PreferencesDeleter preferencesDeleter, final String string, final boolean bl) {
        return (List)HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws Exception {
                return PreferencesDeleteAction.executePreferenceDeleter(preferencesDeleter, string, bl, context);
            }
        });
    }

    protected static void deleteNode(PreferencesAction.PackageNodeProvider packageNodeProvider, List list) throws BackingStoreException {
        PerformedAction performedAction = new PerformedAction(packageNodeProvider);
        packageNodeProvider.getPackageNode().removeNode();
        list.add(performedAction);
    }

    protected static boolean deleteKey(PreferencesAction.PackageNodeProvider packageNodeProvider, String string, List list) throws BackingStoreException {
        Preferences preferences = packageNodeProvider.getPackageNode();
        String[] stringArray = preferences.keys();
        if (stringArray == null || !Arrays.asList(stringArray).contains(string)) {
            Logger.getInstance().log(null, "Key " + string + " does not exist", false);
            return false;
        }
        PerformedAction performedAction = new PerformedAction(packageNodeProvider, string);
        preferences.remove(string);
        list.add(performedAction);
        return true;
    }

    private static class PerformedAction
    extends PreferencesAction.PreferencesRollbackAction {
        private PreferencesAction.PackageNodeProvider packageNodeProvider;
        private String key;
        private String oldValue;
        private byte[] exportedTree;

        public PerformedAction(PreferencesAction.PackageNodeProvider packageNodeProvider, String string) {
            this.packageNodeProvider = packageNodeProvider;
            this.key = string;
            this.oldValue = packageNodeProvider.getPackageNode().get(string, null);
        }

        public PerformedAction(PreferencesAction.PackageNodeProvider packageNodeProvider) throws BackingStoreException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                packageNodeProvider.getPackageNode().exportSubtree(byteArrayOutputStream);
                this.exportedTree = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        protected void rollbackDirectly(Context context) {
            Preferences preferences = this.packageNodeProvider.getPackageNode();
            if (preferences != null && this.oldValue != null) {
                Preferences preferences2 = PreferencesUtil.getPackageNode(preferences.absolutePath(), preferences.isUserNode());
                preferences2.put(this.key, this.oldValue);
                try {
                    preferences2.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    Logger.getInstance().log(backingStoreException);
                }
            }
            if (this.exportedTree != null) {
                try {
                    Preferences.importPreferences(new ByteArrayInputStream(this.exportedTree));
                }
                catch (IOException iOException) {
                    Logger.getInstance().log(iOException);
                }
                catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
                    Logger.getInstance().log(invalidPreferencesFormatException);
                }
            }
        }
    }

    protected static interface PreferencesDeleter
    extends Serializable {
        public boolean deleteFromPreferences(PreferencesAction.PackageNodeProvider var1, Context var2, List var3) throws BackingStoreException;
    }
}

