/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.analysis.common.UniqueTokenFilter;
import org.elasticsearch.analysis.common.XUniqueTokenFilter;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class UniqueTokenFilterFactory
extends AbstractTokenFilterFactory {
    static final String ONLY_ON_SAME_POSITION = "only_on_same_position";
    private final boolean onlyOnSamePosition;
    private final boolean correctPositionIncrement;

    UniqueTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name, settings);
        this.onlyOnSamePosition = settings.getAsBoolean(ONLY_ON_SAME_POSITION, Boolean.valueOf(false));
        this.correctPositionIncrement = indexSettings.getIndexVersionCreated().onOrAfter((VersionId)IndexVersions.UNIQUE_TOKEN_FILTER_POS_FIX);
    }

    public TokenStream create(TokenStream tokenStream) {
        if (!this.correctPositionIncrement) {
            return new XUniqueTokenFilter(tokenStream, this.onlyOnSamePosition);
        }
        return new UniqueTokenFilter(tokenStream, this.onlyOnSamePosition);
    }
}

