/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;

public final class MvMinBytesRefEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvMinBytesRefEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMin";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        BytesRefBlock v = (BytesRefBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef firstScratch = new BytesRef();
            BytesRef nextScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                BytesRef value = v.getBytesRef(first, firstScratch);
                for (int i = first + 1; i < end; ++i) {
                    BytesRef next = v.getBytesRef(i, nextScratch);
                    MvMin.process(value, next);
                }
                BytesRef result = value;
                builder.appendBytesRef(result);
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        BytesRefBlock v = (BytesRefBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BytesRefVector.Builder builder = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef firstScratch = new BytesRef();
            BytesRef nextScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                BytesRef value = v.getBytesRef(first, firstScratch);
                for (int i = first + 1; i < end; ++i) {
                    BytesRef next = v.getBytesRef(i, nextScratch);
                    MvMin.process(value, next);
                }
                BytesRef result = value;
                builder.appendBytesRef(result);
            }
            BytesRefBlock bytesRefBlock = builder.build().asBlock();
            return bytesRefBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        BytesRefBlock v = (BytesRefBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef firstScratch = new BytesRef();
            BytesRef nextScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int idx = MvMin.ascendingIndex(valueCount);
                BytesRef result = v.getBytesRef(first + idx, firstScratch);
                builder.appendBytesRef(result);
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        BytesRefBlock v = (BytesRefBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BytesRefVector.Builder builder = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef firstScratch = new BytesRef();
            BytesRef nextScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int idx = MvMin.ascendingIndex(valueCount);
                BytesRef result = v.getBytesRef(first + idx, firstScratch);
                builder.appendBytesRef(result);
            }
            BytesRefBlock bytesRefBlock = builder.build().asBlock();
            return bytesRefBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMinBytesRefEvaluator get(DriverContext context) {
            return new MvMinBytesRefEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMin[field=" + String.valueOf(this.field) + "]";
        }
    }
}

