/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteClusterAwareRequest;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

final class RemoteClusterAwareClient
implements RemoteClusterClient {
    private final TransportService service;
    private final String clusterAlias;
    private final RemoteClusterService remoteClusterService;
    private final Executor responseExecutor;
    private final boolean ensureConnected;

    RemoteClusterAwareClient(TransportService service, String clusterAlias, Executor responseExecutor, boolean ensureConnected) {
        this.service = service;
        this.clusterAlias = clusterAlias;
        this.remoteClusterService = service.getRemoteClusterService();
        this.responseExecutor = responseExecutor;
        this.ensureConnected = ensureConnected;
    }

    @Override
    public <Request extends ActionRequest, Response extends TransportResponse> void execute(Transport.Connection connection, RemoteClusterActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.service.sendRequest(connection, action.name(), request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<Response>(listener, action.getResponseReader(), this.responseExecutor));
    }

    @Override
    public <Request extends ActionRequest> void getConnection(@Nullable Request request, ActionListener<Transport.Connection> listener) {
        SubscribableListener.newForked(ensureConnectedListener -> {
            if (this.ensureConnected) {
                this.remoteClusterService.ensureConnected(this.clusterAlias, (ActionListener<Void>)ensureConnectedListener);
            } else {
                ensureConnectedListener.onResponse(null);
            }
        }).andThenApply(ignored -> {
            try {
                if (request instanceof RemoteClusterAwareRequest) {
                    RemoteClusterAwareRequest remoteClusterAwareRequest = (RemoteClusterAwareRequest)((Object)request);
                    return this.remoteClusterService.getConnection(remoteClusterAwareRequest.getPreferredTargetNode(), this.clusterAlias);
                }
                return this.remoteClusterService.getConnection(this.clusterAlias);
            }
            catch (ConnectTransportException e) {
                if (!this.ensureConnected) {
                    this.remoteClusterService.ensureConnected(this.clusterAlias, ActionListener.noop());
                }
                throw e;
            }
        }).addListener(listener);
    }
}

