/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.Constants;

public class ESVectorUtil {
    static final boolean XOR_BIT_COUNT_STRIDE_AS_INT = Constants.OS_ARCH.equals("aarch64");

    public static int xorBitCount(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        if (XOR_BIT_COUNT_STRIDE_AS_INT) {
            return ESVectorUtil.xorBitCountInt(a, b);
        }
        return ESVectorUtil.xorBitCountLong(a, b);
    }

    static int xorBitCountInt(byte[] a, byte[] b) {
        int i;
        int distance = 0;
        int upperBound = a.length & 0xFFFFFFFC;
        for (i = 0; i < upperBound; i += 4) {
            distance += Integer.bitCount(BitUtil.VH_NATIVE_INT.get(a, i) ^ BitUtil.VH_NATIVE_INT.get(b, i));
        }
        while (i < a.length) {
            distance += Integer.bitCount((a[i] ^ b[i]) & 0xFF);
            ++i;
        }
        return distance;
    }

    static int xorBitCountLong(byte[] a, byte[] b) {
        int i;
        int distance = 0;
        int upperBound = a.length & 0xFFFFFFF8;
        for (i = 0; i < upperBound; i += 8) {
            distance += Long.bitCount(BitUtil.VH_NATIVE_LONG.get(a, i) ^ BitUtil.VH_NATIVE_LONG.get(b, i));
        }
        while (i < a.length) {
            distance += Integer.bitCount((a[i] ^ b[i]) & 0xFF);
            ++i;
        }
        return distance;
    }

    private ESVectorUtil() {
    }
}

