/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.features;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.FeatureSpecification;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class FeatureData {
    private static final Logger Log = LogManager.getLogger(FeatureData.class);
    private static final boolean INCLUDE_TEST_FEATURES = System.getProperty("tests.testfeatures.enabled", "").equals("true");
    private final NavigableMap<Version, Set<String>> historicalFeatures;
    private final Map<String, NodeFeature> nodeFeatures;

    private FeatureData(NavigableMap<Version, Set<String>> historicalFeatures, Map<String, NodeFeature> nodeFeatures) {
        this.historicalFeatures = historicalFeatures;
        this.nodeFeatures = nodeFeatures;
    }

    public static FeatureData createFromSpecifications(List<? extends FeatureSpecification> specs) {
        HashMap<String, FeatureSpecification> allFeatures = new HashMap<String, FeatureSpecification>();
        TreeMap<Version, Set<String>> historicalFeatures = new TreeMap<Version, Set<String>>(Map.of(Version.V_EMPTY, Set.of()));
        HashMap<String, NodeFeature> nodeFeatures = new HashMap<String, NodeFeature>();
        for (FeatureSpecification featureSpecification : specs) {
            FeatureSpecification existing;
            Set<NodeFeature> specFeatures = featureSpecification.getFeatures();
            if (INCLUDE_TEST_FEATURES) {
                specFeatures = new HashSet<NodeFeature>(specFeatures);
                specFeatures.addAll(featureSpecification.getTestFeatures());
            }
            for (Map.Entry<NodeFeature, Version> hfe : featureSpecification.getHistoricalFeatures().entrySet()) {
                existing = allFeatures.putIfAbsent(hfe.getKey().id(), featureSpecification);
                if (existing != null && existing.getClass() != featureSpecification.getClass()) {
                    throw new IllegalArgumentException(Strings.format("Duplicate feature - [%s] is declared by both [%s] and [%s]", hfe.getKey().id(), existing, featureSpecification));
                }
                if (hfe.getValue().after(FeatureService.CLUSTER_FEATURES_ADDED_VERSION)) {
                    throw new IllegalArgumentException(Strings.format("Historical feature [%s] declared by [%s] for version [%s] is not a historical version", hfe.getKey().id(), featureSpecification, hfe.getValue()));
                }
                if (specFeatures.contains(hfe.getKey())) {
                    throw new IllegalArgumentException(Strings.format("Feature [%s] cannot be declared as both a regular and historical feature by [%s]", hfe.getKey().id(), featureSpecification));
                }
                historicalFeatures.computeIfAbsent(hfe.getValue(), k -> new HashSet()).add(hfe.getKey().id());
            }
            for (NodeFeature f : specFeatures) {
                existing = allFeatures.putIfAbsent(f.id(), featureSpecification);
                if (existing != null && existing.getClass() != featureSpecification.getClass()) {
                    throw new IllegalArgumentException(Strings.format("Duplicate feature - [%s] is declared by both [%s] and [%s]", f.id(), existing, featureSpecification));
                }
                nodeFeatures.put(f.id(), f);
            }
        }
        return new FeatureData(FeatureData.consolidateHistoricalFeatures(historicalFeatures), Map.copyOf(nodeFeatures));
    }

    private static NavigableMap<Version, Set<String>> consolidateHistoricalFeatures(NavigableMap<Version, Set<String>> declaredHistoricalFeatures) {
        HashSet featureAggregator = new HashSet();
        for (Map.Entry entry : declaredHistoricalFeatures.entrySet()) {
            featureAggregator.addAll((Collection)entry.getValue());
            entry.setValue(Set.copyOf(featureAggregator));
        }
        return Collections.unmodifiableNavigableMap(declaredHistoricalFeatures);
    }

    public NavigableMap<Version, Set<String>> getHistoricalFeatures() {
        return this.historicalFeatures;
    }

    public Map<String, NodeFeature> getNodeFeatures() {
        return this.nodeFeatures;
    }

    static {
        if (INCLUDE_TEST_FEATURES) {
            Log.warn("WARNING: Test features are enabled. This should ONLY be used in automated tests.");
        }
    }
}

