/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.security.AccessController;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionHandler;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.common.util.concurrent.TaskExecutionTimeTrackingEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.TimedRunnable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.node.Node;

public class EsExecutors {
    private static final int MAX_NUM_PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static final Setting<Processors> NODE_PROCESSORS_SETTING = new Setting<Processors>("node.processors", Double.toString(MAX_NUM_PROCESSORS), textValue -> {
        double numberOfProcessors = Double.parseDouble(textValue);
        if (Double.isNaN(numberOfProcessors) || Double.isInfinite(numberOfProcessors)) {
            String err = "Failed to parse value [" + textValue + "] for setting [node.processors]";
            throw new IllegalArgumentException(err);
        }
        if (numberOfProcessors <= 0.0) {
            String err = "Failed to parse value [" + textValue + "] for setting [node.processors] must be > 0";
            throw new IllegalArgumentException(err);
        }
        if (numberOfProcessors > (double)MAX_NUM_PROCESSORS) {
            String err = "Failed to parse value [" + textValue + "] for setting [node.processors] must be <= " + MAX_NUM_PROCESSORS;
            throw new IllegalArgumentException(err);
        }
        return Processors.of(numberOfProcessors);
    }, Setting.Property.NodeScope);
    public static final ExecutorService DIRECT_EXECUTOR_SERVICE = new DirectExecutorService();

    public static int allocatedProcessors(Settings settings) {
        return NODE_PROCESSORS_SETTING.get(settings).roundUp();
    }

    public static Processors nodeProcessors(Settings settings) {
        return NODE_PROCESSORS_SETTING.get(settings);
    }

    public static PrioritizedEsThreadPoolExecutor newSinglePrioritizing(String name, ThreadFactory threadFactory, ThreadContext contextHolder, ScheduledExecutorService timer) {
        return new PrioritizedEsThreadPoolExecutor(name, 1, 1, 0L, TimeUnit.MILLISECONDS, threadFactory, contextHolder, timer);
    }

    public static EsThreadPoolExecutor newScaling(String name, int min, int max, long keepAliveTime, TimeUnit unit, boolean rejectAfterShutdown, ThreadFactory threadFactory, ThreadContext contextHolder, TaskTrackingConfig config) {
        boolean probeWorkerPool;
        LinkedTransferQueue<Runnable> queue = EsExecutors.newUnboundedScalingLTQueue(min, max);
        boolean bl = probeWorkerPool = min == 0 && queue instanceof ExecutorScalingQueue;
        if (config.trackExecutionTime()) {
            return new TaskExecutionTimeTrackingEsThreadPoolExecutor(name, min, max, keepAliveTime, unit, queue, TimedRunnable::new, threadFactory, new ForceQueuePolicy(rejectAfterShutdown, probeWorkerPool), contextHolder, config);
        }
        return new EsThreadPoolExecutor(name, min, max, keepAliveTime, unit, queue, threadFactory, new ForceQueuePolicy(rejectAfterShutdown, probeWorkerPool), contextHolder);
    }

    public static EsThreadPoolExecutor newScaling(String name, int min, int max, long keepAliveTime, TimeUnit unit, boolean rejectAfterShutdown, ThreadFactory threadFactory, ThreadContext contextHolder) {
        return EsExecutors.newScaling(name, min, max, keepAliveTime, unit, rejectAfterShutdown, threadFactory, contextHolder, TaskTrackingConfig.DO_NOT_TRACK);
    }

    public static EsThreadPoolExecutor newFixed(String name, int size, int queueCapacity, ThreadFactory threadFactory, ThreadContext contextHolder, TaskTrackingConfig config) {
        EsRejectedExecutionHandler rejectedExecutionHandler;
        BlockingQueue<Runnable> queue;
        if (queueCapacity < 0) {
            queue = ConcurrentCollections.newBlockingQueue();
            rejectedExecutionHandler = new RejectOnShutdownOnlyPolicy();
        } else {
            queue = new SizeBlockingQueue(ConcurrentCollections.newBlockingQueue(), queueCapacity);
            rejectedExecutionHandler = new EsAbortPolicy();
        }
        if (config.trackExecutionTime()) {
            return new TaskExecutionTimeTrackingEsThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, queue, TimedRunnable::new, threadFactory, rejectedExecutionHandler, contextHolder, config);
        }
        return new EsThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, queue, threadFactory, rejectedExecutionHandler, contextHolder);
    }

    public static Throwable rethrowErrors(Runnable runnable) {
        block7: {
            if (runnable instanceof RunnableFuture) {
                RunnableFuture runnableFuture = (RunnableFuture)runnable;
                assert (runnableFuture.isDone());
                try {
                    runnableFuture.get();
                }
                catch (Exception e) {
                    assert (e instanceof CancellationException || e instanceof InterruptedException || e instanceof ExecutionException) : e;
                    Optional<Error> maybeError = ExceptionsHelper.maybeError(e);
                    if (maybeError.isPresent()) {
                        throw maybeError.get();
                    }
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(e instanceof ExecutionException)) break block7;
                    return e.getCause();
                }
            }
        }
        return null;
    }

    public static String threadName(Settings settings, String namePrefix) {
        if (Node.NODE_NAME_SETTING.exists(settings)) {
            return EsExecutors.threadName(Node.NODE_NAME_SETTING.get(settings), namePrefix);
        }
        return EsExecutors.threadName("", namePrefix);
    }

    public static String threadName(String nodeName, String namePrefix) {
        return "elasticsearch" + (nodeName.isEmpty() ? "" : "[") + nodeName + (nodeName.isEmpty() ? "" : "]") + "[" + namePrefix + "]";
    }

    public static String executorName(String threadName) {
        int executorNameEnd = threadName.lastIndexOf(93, threadName.length() - 2);
        int executorNameStart = threadName.lastIndexOf(91, executorNameEnd);
        if (executorNameStart == -1 || executorNameEnd - executorNameStart <= 1 || threadName.startsWith("TEST-") || threadName.startsWith("LuceneTestCase")) {
            return null;
        }
        return threadName.substring(executorNameStart + 1, executorNameEnd);
    }

    public static String executorName(Thread thread) {
        return EsExecutors.executorName(thread.getName());
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String namePrefix) {
        return EsExecutors.createDaemonThreadFactory(EsExecutors.threadName(settings, namePrefix), false);
    }

    public static ThreadFactory daemonThreadFactory(String nodeName, String namePrefix) {
        return EsExecutors.daemonThreadFactory(nodeName, namePrefix, false);
    }

    public static ThreadFactory daemonThreadFactory(String nodeName, String namePrefix, boolean isSystemThread) {
        assert (nodeName != null && !nodeName.isEmpty());
        return EsExecutors.createDaemonThreadFactory(EsExecutors.threadName(nodeName, namePrefix), isSystemThread);
    }

    public static ThreadFactory daemonThreadFactory(String name) {
        assert (name != null && !name.isEmpty());
        return EsExecutors.createDaemonThreadFactory(name, false);
    }

    private static ThreadFactory createDaemonThreadFactory(String namePrefix, boolean isSystemThread) {
        return new EsThreadFactory(namePrefix, isSystemThread);
    }

    private EsExecutors() {
    }

    private static <E> LinkedTransferQueue<E> newUnboundedScalingLTQueue(int corePoolSize, int maxPoolSize) {
        if (maxPoolSize == 1 || maxPoolSize == corePoolSize) {
            return new LinkedTransferQueue();
        }
        return new ExecutorScalingQueue();
    }

    static class ExecutorScalingQueue<E>
    extends LinkedTransferQueue<E> {
        ExecutorScalingQueue() {
        }

        @Override
        public boolean offer(E e) {
            if (e == EsThreadPoolExecutor.WORKER_PROBE) {
                return super.offer(e);
            }
            return this.tryTransfer(e);
        }

        @Override
        public void put(E e) {
            super.offer(e);
        }

        @Override
        public boolean add(E e) {
            return super.offer(e);
        }

        @Override
        public boolean offer(E e, long timeout, TimeUnit unit) {
            return super.offer(e);
        }
    }

    public static class TaskTrackingConfig {
        public static double DEFAULT_EWMA_ALPHA = 0.3;
        private final boolean trackExecutionTime;
        private final boolean trackOngoingTasks;
        private final double ewmaAlpha;
        public static TaskTrackingConfig DO_NOT_TRACK = new TaskTrackingConfig(false, false, DEFAULT_EWMA_ALPHA);
        public static TaskTrackingConfig DEFAULT = new TaskTrackingConfig(true, false, DEFAULT_EWMA_ALPHA);

        public TaskTrackingConfig(boolean trackOngoingTasks, double ewmaAlpha) {
            this(true, trackOngoingTasks, ewmaAlpha);
        }

        private TaskTrackingConfig(boolean trackExecutionTime, boolean trackOngoingTasks, double EWMAAlpha) {
            this.trackExecutionTime = trackExecutionTime;
            this.trackOngoingTasks = trackOngoingTasks;
            this.ewmaAlpha = EWMAAlpha;
        }

        public boolean trackExecutionTime() {
            return this.trackExecutionTime;
        }

        public boolean trackOngoingTasks() {
            return this.trackOngoingTasks;
        }

        public double getEwmaAlpha() {
            return this.ewmaAlpha;
        }
    }

    static class ForceQueuePolicy
    extends EsRejectedExecutionHandler {
        private final boolean rejectAfterShutdown;
        private final boolean probeWorkerPool;

        ForceQueuePolicy(boolean rejectAfterShutdown, boolean probeWorkerPool) {
            this.rejectAfterShutdown = rejectAfterShutdown;
            this.probeWorkerPool = probeWorkerPool;
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            if (task == EsThreadPoolExecutor.WORKER_PROBE) {
                return;
            }
            if (this.rejectAfterShutdown) {
                if (executor.isShutdown()) {
                    this.reject(executor, task);
                } else {
                    this.put(executor, task);
                    if (executor.isShutdown() && executor.remove(task)) {
                        this.reject(executor, task);
                    }
                }
            } else {
                this.put(executor, task);
            }
        }

        private void put(ThreadPoolExecutor executor, Runnable task) {
            BlockingQueue<Runnable> queue = executor.getQueue();
            assert (queue instanceof LinkedTransferQueue);
            try {
                queue.put(task);
                if (this.probeWorkerPool && task == queue.peek()) {
                    executor.execute(EsThreadPoolExecutor.WORKER_PROBE);
                }
            }
            catch (InterruptedException e) {
                assert (false) : "a scaling queue never blocks so a put to it can never be interrupted";
                throw new AssertionError((Object)e);
            }
        }

        private void reject(ThreadPoolExecutor executor, Runnable task) {
            this.incrementRejections();
            throw ForceQueuePolicy.newRejectedException(task, executor, true);
        }
    }

    static class RejectOnShutdownOnlyPolicy
    extends EsRejectedExecutionHandler {
        RejectOnShutdownOnlyPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            assert (executor.isShutdown()) : executor;
            this.incrementRejections();
            throw RejectOnShutdownOnlyPolicy.newRejectedException(task, executor, true);
        }
    }

    static class EsThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final boolean isSystem;

        EsThreadFactory(String namePrefix, boolean isSystem) {
            this.namePrefix = namePrefix;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.isSystem = isSystem;
        }

        @Override
        public Thread newThread(Runnable r) {
            return AccessController.doPrivileged(() -> {
                EsThread t = new EsThread(this.group, r, this.namePrefix + "[T#" + this.threadNumber.getAndIncrement() + "]", 0L, this.isSystem);
                t.setDaemon(true);
                return t;
            });
        }
    }

    private static final class DirectExecutorService
    extends AbstractExecutorService {
        @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
        DirectExecutorService() {
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            command.run();
            EsExecutors.rethrowErrors(command);
        }
    }

    public static class EsThread
    extends Thread {
        private final boolean isSystem;

        EsThread(ThreadGroup group, Runnable target, String name, long stackSize, boolean isSystem) {
            super(group, target, name, stackSize);
            this.isSystem = isSystem;
        }

        public boolean isSystem() {
            return this.isSystem;
        }
    }
}

