/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.IndexMetadataUpdater;
import org.elasticsearch.cluster.routing.allocation.MoveDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.StaleShard;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.ESLogMessage;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotsInfoService;

public class AllocationService {
    private static final Logger logger = LogManager.getLogger(AllocationService.class);
    private final AllocationDeciders allocationDeciders;
    private Map<String, ExistingShardsAllocator> existingShardsAllocators;
    private final ShardsAllocator shardsAllocator;
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final ShardRoutingRoleStrategy shardRoutingRoleStrategy;

    public AllocationService(AllocationDeciders allocationDeciders, GatewayAllocator gatewayAllocator, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
        this(allocationDeciders, shardsAllocator, clusterInfoService, snapshotsInfoService, shardRoutingRoleStrategy);
        this.setExistingShardsAllocators(Collections.singletonMap("gateway_allocator", gatewayAllocator));
    }

    public AllocationService(AllocationDeciders allocationDeciders, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
        this.allocationDeciders = allocationDeciders;
        this.shardsAllocator = shardsAllocator;
        this.clusterInfoService = clusterInfoService;
        this.snapshotsInfoService = snapshotsInfoService;
        this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
    }

    public void setExistingShardsAllocators(Map<String, ExistingShardsAllocator> existingShardsAllocators) {
        assert (this.existingShardsAllocators == null) : "cannot set allocators " + String.valueOf(existingShardsAllocators) + " twice";
        assert (!existingShardsAllocators.isEmpty()) : "must add at least one ExistingShardsAllocator";
        this.existingShardsAllocators = Collections.unmodifiableMap(existingShardsAllocators);
    }

    public AllocationDeciders getAllocationDeciders() {
        return this.allocationDeciders;
    }

    public ShardRoutingRoleStrategy getShardRoutingRoleStrategy() {
        return this.shardRoutingRoleStrategy;
    }

    public ClusterState applyStartedShards(ClusterState clusterState, List<ShardRouting> startedShards) {
        assert (this.assertInitialized());
        if (startedShards.isEmpty()) {
            return clusterState;
        }
        RoutingAllocation allocation = this.createRoutingAllocation(clusterState, this.currentNanoTime());
        startedShards = new ArrayList<ShardRouting>(startedShards);
        startedShards.sort(Comparator.comparing(ShardRouting::primary));
        AllocationService.applyStartedShards(allocation, startedShards);
        for (ExistingShardsAllocator allocator : this.existingShardsAllocators.values()) {
            allocator.applyStartedShards(startedShards, allocation);
        }
        assert (RoutingNodes.assertShardStats(allocation.routingNodes()));
        String startedShardsAsString = AllocationService.firstListElementsToCommaDelimitedString(startedShards, s -> s.shardId().toString(), logger.isDebugEnabled());
        return AllocationService.buildResultAndLogHealthChange(clusterState, allocation, "shards started [" + startedShardsAsString + "]");
    }

    private static ClusterState buildResultAndLogHealthChange(ClusterState oldState, RoutingAllocation allocation, String reason) {
        RoutingTable oldRoutingTable = oldState.routingTable();
        RoutingNodes newRoutingNodes = allocation.routingNodes();
        RoutingTable newRoutingTable = RoutingTable.of(newRoutingNodes);
        Metadata newMetadata = allocation.updateMetadataWithRoutingChanges(newRoutingTable);
        assert (newRoutingTable.validate(newMetadata));
        ClusterState.Builder newStateBuilder = ClusterState.builder(oldState).routingTable(newRoutingTable).metadata(newMetadata);
        RestoreInProgress restoreInProgress = RestoreInProgress.get(allocation.getClusterState());
        RestoreInProgress updatedRestoreInProgress = allocation.updateRestoreInfoWithRoutingChanges(restoreInProgress);
        if (updatedRestoreInProgress != restoreInProgress) {
            ImmutableOpenMap.Builder<String, ClusterState.Custom> customsBuilder = ImmutableOpenMap.builder(allocation.getClusterState().getCustoms());
            customsBuilder.put("restore", updatedRestoreInProgress);
            newStateBuilder.customs(customsBuilder.build());
        }
        ClusterState newState = newStateBuilder.build();
        AllocationService.logClusterHealthStateChange(oldState, newState, reason);
        return newState;
    }

    public ClusterState applyFailedShards(ClusterState clusterState, List<FailedShard> failedShards, List<StaleShard> staleShards) {
        assert (this.assertInitialized());
        if (staleShards.isEmpty() && failedShards.isEmpty()) {
            return clusterState;
        }
        ClusterState tmpState = IndexMetadataUpdater.removeStaleIdsWithoutRoutings(clusterState, staleShards, logger);
        long currentNanoTime = this.currentNanoTime();
        RoutingAllocation allocation = this.createRoutingAllocation(tmpState, currentNanoTime);
        for (FailedShard failedShardEntry : failedShards) {
            ShardRouting shardToFail = failedShardEntry.routingEntry();
            assert (allocation.metadata().hasIndex(shardToFail.shardId().getIndex()));
            allocation.addIgnoreShardForNode(shardToFail.shardId(), shardToFail.currentNodeId());
            ShardRouting failedShard = allocation.routingNodes().getByAllocationId(shardToFail.shardId(), shardToFail.allocationId().getId());
            if (failedShard != null) {
                Set<String> failedNodeIds;
                int failedAllocations;
                if (failedShard != shardToFail) {
                    logger.trace("{} shard routing modified in an earlier iteration (previous: {}, current: {})", (Object)shardToFail.shardId(), (Object)shardToFail, (Object)failedShard);
                }
                int n = failedAllocations = failedShard.unassignedInfo() != null ? failedShard.unassignedInfo().failedAllocations() : 0;
                if (failedShard.unassignedInfo() != null) {
                    failedNodeIds = Sets.newHashSetWithExpectedSize(failedShard.unassignedInfo().failedNodeIds().size() + 1);
                    failedNodeIds.addAll(failedShard.unassignedInfo().failedNodeIds());
                    failedNodeIds.add(failedShard.currentNodeId());
                } else {
                    failedNodeIds = Collections.emptySet();
                }
                String message = "failed shard on node [" + shardToFail.currentNodeId() + "]: " + failedShardEntry.message();
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.ALLOCATION_FAILED, message, failedShardEntry.failure(), failedAllocations + 1, currentNanoTime, System.currentTimeMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT, failedNodeIds, shardToFail.currentNodeId());
                if (failedShardEntry.markAsStale()) {
                    allocation.removeAllocationId(failedShard);
                }
                logger.warn(() -> "failing shard [" + String.valueOf(failedShardEntry) + "]", (Throwable)failedShardEntry.failure());
                allocation.routingNodes().failShard(failedShard, unassignedInfo, allocation.changes());
                continue;
            }
            logger.trace("{} shard routing failed in an earlier iteration (routing: {})", (Object)shardToFail.shardId(), (Object)shardToFail);
        }
        for (ExistingShardsAllocator allocator : this.existingShardsAllocators.values()) {
            allocator.applyFailedShards(failedShards, allocation);
        }
        this.reroute(allocation, routingAllocation -> this.shardsAllocator.allocate(routingAllocation, AllocationActionListener.rerouteCompletionIsNotRequired()));
        String failedShardsAsString = AllocationService.firstListElementsToCommaDelimitedString(failedShards, s -> s.routingEntry().shardId().toString(), logger.isDebugEnabled());
        return AllocationService.buildResultAndLogHealthChange(clusterState, allocation, "shards failed [" + failedShardsAsString + "]");
    }

    public ClusterState disassociateDeadNodes(ClusterState clusterState, boolean reroute, String reason) {
        RoutingAllocation allocation = this.createRoutingAllocation(clusterState, this.currentNanoTime());
        AllocationService.disassociateDeadNodes(allocation);
        if (allocation.routingNodesChanged()) {
            clusterState = AllocationService.buildResultAndLogHealthChange(clusterState, allocation, reason);
        }
        if (reroute) {
            return this.reroute(clusterState, reason, AllocationActionListener.rerouteCompletionIsNotRequired());
        }
        return clusterState;
    }

    public ClusterState adaptAutoExpandReplicas(ClusterState clusterState) {
        Supplier<RoutingAllocation> allocationSupplier = () -> new RoutingAllocation(this.allocationDeciders, clusterState, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), this.currentNanoTime());
        Map<Integer, List<String>> autoExpandReplicaChanges = AutoExpandReplicas.getAutoExpandReplicaChanges(clusterState.metadata(), allocationSupplier);
        if (autoExpandReplicaChanges.isEmpty()) {
            return clusterState;
        }
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(this.shardRoutingRoleStrategy, clusterState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(clusterState.metadata());
        for (Map.Entry<Integer, List<String>> entry : autoExpandReplicaChanges.entrySet()) {
            int numberOfReplicas = entry.getKey();
            String[] indices = entry.getValue().toArray(Strings.EMPTY_ARRAY);
            routingTableBuilder.updateNumberOfReplicas(numberOfReplicas, indices);
            metadataBuilder.updateNumberOfReplicas(numberOfReplicas, indices);
            for (String index : indices) {
                IndexMetadata indexMetadata = metadataBuilder.get(index);
                IndexMetadata.Builder indexMetadataBuilder = new IndexMetadata.Builder(indexMetadata).settingsVersion(1L + indexMetadata.getSettingsVersion());
                metadataBuilder.put(indexMetadataBuilder);
            }
            logger.info("updating number_of_replicas to [{}] for indices {}", (Object)numberOfReplicas, (Object)indices);
        }
        ClusterState fixedState = ClusterState.builder(clusterState).routingTable(routingTableBuilder.build()).metadata(metadataBuilder).build();
        assert (AutoExpandReplicas.getAutoExpandReplicaChanges(fixedState.metadata(), allocationSupplier).isEmpty());
        return fixedState;
    }

    public static <T> String firstListElementsToCommaDelimitedString(List<T> elements, Function<T, String> formatter, boolean isDebugEnabled) {
        int maxNumberOfElements = 10;
        if (isDebugEnabled || elements.size() <= 10) {
            return elements.stream().map(formatter).collect(Collectors.joining(", "));
        }
        return elements.stream().limit(10L).map(formatter).collect(Collectors.joining(", ")) + ", ... [" + elements.size() + " items in total]";
    }

    public CommandsResult reroute(ClusterState clusterState, AllocationCommands commands, boolean explain, boolean retryFailed, boolean dryRun, ActionListener<Void> reroute) {
        RoutingAllocation allocation = this.createRoutingAllocation(clusterState, this.currentNanoTime());
        RoutingExplanations explanations = this.shardsAllocator.execute(allocation, commands, explain, retryFailed);
        if (!dryRun) {
            this.reroute(allocation, routingAllocation -> this.shardsAllocator.allocate(routingAllocation, reroute));
        } else {
            reroute.onResponse(null);
        }
        return new CommandsResult(explanations, AllocationService.buildResultAndLogHealthChange(clusterState, allocation, "reroute commands"));
    }

    public ClusterState reroute(ClusterState clusterState, String reason, ActionListener<Void> listener) {
        return this.executeWithRoutingAllocation(clusterState, reason, routingAllocation -> this.shardsAllocator.allocate(routingAllocation, listener));
    }

    public ClusterState executeWithRoutingAllocation(ClusterState clusterState, String reason, RerouteStrategy rerouteStrategy) {
        ClusterState fixedClusterState = this.adaptAutoExpandReplicas(clusterState);
        RoutingAllocation allocation = this.createRoutingAllocation(fixedClusterState, this.currentNanoTime());
        this.reroute(allocation, rerouteStrategy);
        if (fixedClusterState == clusterState && !allocation.routingNodesChanged()) {
            return clusterState;
        }
        return AllocationService.buildResultAndLogHealthChange(clusterState, allocation, reason);
    }

    private static void logClusterHealthStateChange(ClusterState previousState, ClusterState newState, String reason) {
        ClusterHealthStatus currentHealth;
        ClusterHealthStatus previousHealth = AllocationService.getHealthStatus(previousState);
        if (!previousHealth.equals(currentHealth = AllocationService.getHealthStatus(newState))) {
            logger.info((Message)new ESLogMessage("Cluster health status changed from [{}] to [{}] (reason: [{}]).", new Object[0]).argAndField("previous.health", previousHealth).argAndField("current.health", currentHealth).argAndField("reason", reason));
        }
    }

    public static ClusterHealthStatus getHealthStatus(ClusterState clusterState) {
        if (clusterState.blocks().hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE)) {
            return ClusterHealthStatus.RED;
        }
        ClusterHealthStatus computeStatus = ClusterHealthStatus.GREEN;
        for (String index : clusterState.metadata().getConcreteAllIndices()) {
            IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(index);
            if (indexRoutingTable == null || indexRoutingTable.allShardsActive()) continue;
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(i);
                ShardRouting primary = indexShardRoutingTable.primaryShard();
                if (primary.active()) {
                    computeStatus = ClusterHealthStatus.YELLOW;
                    continue;
                }
                computeStatus = ClusterShardHealth.getInactivePrimaryHealth(primary);
                if (computeStatus != ClusterHealthStatus.RED) continue;
                logger.debug("One of inactive primary shard {} causes cluster state RED.", (Object)primary.shardId());
                return ClusterHealthStatus.RED;
            }
        }
        return computeStatus;
    }

    private static boolean hasDeadNodes(RoutingAllocation allocation) {
        for (RoutingNode routingNode : allocation.routingNodes()) {
            if (allocation.nodes().getDataNodes().containsKey(routingNode.nodeId())) continue;
            return true;
        }
        return false;
    }

    private void reroute(RoutingAllocation allocation, RerouteStrategy rerouteStrategy) {
        assert (!AllocationService.hasDeadNodes(allocation)) : "dead nodes should be explicitly cleaned up. See disassociateDeadNodes";
        assert (AutoExpandReplicas.getAutoExpandReplicaChanges(allocation.metadata(), () -> allocation).isEmpty()) : "auto-expand replicas out of sync with number of nodes in the cluster";
        assert (this.assertInitialized());
        rerouteStrategy.removeDelayMarkers(allocation);
        this.allocateExistingUnassignedShards(allocation);
        rerouteStrategy.execute(allocation);
        assert (RoutingNodes.assertShardStats(allocation.routingNodes()));
    }

    private void allocateExistingUnassignedShards(RoutingAllocation allocation) {
        allocation.routingNodes().unassigned().sort(PriorityComparator.getAllocationComparator(allocation));
        for (ExistingShardsAllocator existingShardsAllocator : this.existingShardsAllocators.values()) {
            existingShardsAllocator.beforeAllocation(allocation);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator primaryIterator = allocation.routingNodes().unassigned().iterator();
        while (primaryIterator.hasNext()) {
            ShardRouting shardRouting2 = primaryIterator.next();
            if (!shardRouting2.primary()) continue;
            this.getAllocatorForShard(shardRouting2, allocation).allocateUnassigned(shardRouting2, allocation, primaryIterator);
        }
        for (ExistingShardsAllocator existingShardsAllocator : this.existingShardsAllocators.values()) {
            existingShardsAllocator.afterPrimariesBeforeReplicas(allocation, shardRouting -> this.getAllocatorForShard((ShardRouting)shardRouting, allocation) == existingShardsAllocator);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator replicaIterator = allocation.routingNodes().unassigned().iterator();
        while (replicaIterator.hasNext()) {
            ShardRouting shardRouting3 = replicaIterator.next();
            if (shardRouting3.primary()) continue;
            this.getAllocatorForShard(shardRouting3, allocation).allocateUnassigned(shardRouting3, allocation, replicaIterator);
        }
    }

    public void addAllocFailuresResetListenerTo(ClusterService clusterService) {
        MasterServiceTaskQueue taskQueue = clusterService.createTaskQueue("reset-allocation-failures", Priority.NORMAL, batchCtx -> {
            batchCtx.taskContexts().forEach(taskCtx -> taskCtx.success(() -> {}));
            return this.reroute(batchCtx.initialState(), new AllocationCommands(new AllocationCommand[0]), false, true, false, ActionListener.noop()).clusterState();
        });
        clusterService.addListener(changeEvent -> {
            if (changeEvent.nodesAdded() && changeEvent.state().getRoutingNodes().hasAllocationFailures()) {
                taskQueue.submitTask("reset-allocation-failures", e -> {
                    assert (MasterService.isPublishFailureException(e));
                }, null);
            }
        });
    }

    private static void disassociateDeadNodes(RoutingAllocation allocation) {
        Iterator<RoutingNode> it = allocation.routingNodes().mutableIterator();
        while (it.hasNext()) {
            RoutingNode node = it.next();
            if (allocation.nodes().getDataNodes().containsKey(node.nodeId())) continue;
            SingleNodeShutdownMetadata nodeShutdownMetadata = allocation.metadata().nodeShutdowns().get(node.nodeId(), SingleNodeShutdownMetadata.Type.RESTART);
            UnassignedInfo.Reason unassignedReason = nodeShutdownMetadata != null ? UnassignedInfo.Reason.NODE_RESTARTING : UnassignedInfo.Reason.NODE_LEFT;
            boolean delayedDueToKnownRestart = nodeShutdownMetadata != null && nodeShutdownMetadata.getAllocationDelay().nanos() > 0L;
            for (ShardRouting shardRouting : node.copyShards()) {
                IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
                boolean delayed = delayedDueToKnownRestart || UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(indexMetadata.getSettings()).nanos() > 0L;
                UnassignedInfo unassignedInfo = new UnassignedInfo(unassignedReason, "node_left [" + node.nodeId() + "]", null, 0, allocation.getCurrentNanoTime(), System.currentTimeMillis(), delayed, UnassignedInfo.AllocationStatus.NO_ATTEMPT, Collections.emptySet(), shardRouting.currentNodeId());
                allocation.routingNodes().failShard(shardRouting, unassignedInfo, allocation.changes());
            }
            it.remove();
        }
    }

    private static void applyStartedShards(RoutingAllocation routingAllocation, List<ShardRouting> startedShardEntries) {
        assert (!startedShardEntries.isEmpty()) : "non-empty list of started shard entries expected";
        RoutingNodes routingNodes = routingAllocation.routingNodes();
        for (ShardRouting startedShard : startedShardEntries) {
            assert (startedShard.initializing()) : "only initializing shards can be started";
            assert (routingAllocation.metadata().index(startedShard.shardId().getIndex()) != null) : "shard started for unknown index (shard entry: " + String.valueOf(startedShard) + ")";
            assert (startedShard == routingNodes.getByAllocationId(startedShard.shardId(), startedShard.allocationId().getId())) : "shard routing to start does not exist in routing table, expected: " + String.valueOf(startedShard) + " but was: " + String.valueOf(routingNodes.getByAllocationId(startedShard.shardId(), startedShard.allocationId().getId()));
            long expectedShardSize = routingAllocation.metadata().getIndexSafe(startedShard.index()).isSearchableSnapshot() ? startedShard.getExpectedShardSize() : -1L;
            routingNodes.startShard(startedShard, routingAllocation.changes(), expectedShardSize);
        }
    }

    private RoutingAllocation createRoutingAllocation(ClusterState clusterState, long currentNanoTime) {
        return new RoutingAllocation(this.allocationDeciders, clusterState.mutableRoutingNodes(), clusterState, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), currentNanoTime);
    }

    protected long currentNanoTime() {
        return System.nanoTime();
    }

    public void cleanCaches() {
        assert (this.assertInitialized());
        this.existingShardsAllocators.values().forEach(ExistingShardsAllocator::cleanCaches);
    }

    public int getNumberOfInFlightFetches() {
        assert (this.assertInitialized());
        return this.existingShardsAllocators.values().stream().mapToInt(ExistingShardsAllocator::getNumberOfInFlightFetches).sum();
    }

    public ShardAllocationDecision explainShardAllocation(ShardRouting shardRouting, RoutingAllocation allocation) {
        AllocateUnassignedDecision allocateDecision;
        assert (allocation.debugDecision());
        AllocateUnassignedDecision allocateUnassignedDecision = allocateDecision = shardRouting.unassigned() ? this.explainUnassignedShardAllocation(shardRouting, allocation) : AllocateUnassignedDecision.NOT_TAKEN;
        if (allocateDecision.isDecisionTaken()) {
            return new ShardAllocationDecision(allocateDecision, MoveDecision.NOT_TAKEN);
        }
        return this.shardsAllocator.decideShardAllocation(shardRouting, allocation);
    }

    private AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting shardRouting, RoutingAllocation routingAllocation) {
        assert (shardRouting.unassigned());
        assert (routingAllocation.debugDecision());
        assert (this.assertInitialized());
        ExistingShardsAllocator existingShardsAllocator = this.getAllocatorForShard(shardRouting, routingAllocation);
        AllocateUnassignedDecision decision = existingShardsAllocator.explainUnassignedShardAllocation(shardRouting, routingAllocation);
        if (decision.isDecisionTaken()) {
            return decision;
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    private ExistingShardsAllocator getAllocatorForShard(ShardRouting shardRouting, RoutingAllocation routingAllocation) {
        assert (this.assertInitialized());
        String allocatorName = ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.get(routingAllocation.metadata().getIndexSafe(shardRouting.index()).getSettings());
        ExistingShardsAllocator existingShardsAllocator = this.existingShardsAllocators.get(allocatorName);
        return existingShardsAllocator != null ? existingShardsAllocator : new NotFoundAllocator(allocatorName);
    }

    private boolean assertInitialized() {
        assert (this.existingShardsAllocators != null) : "must have set allocators first";
        return true;
    }

    boolean isBalancedShardsAllocator() {
        return this.shardsAllocator instanceof BalancedShardsAllocator;
    }

    @FunctionalInterface
    public static interface RerouteStrategy {
        default public void removeDelayMarkers(RoutingAllocation allocation) {
            RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = allocation.routingNodes().unassigned().iterator();
            Metadata metadata = allocation.metadata();
            while (unassignedIterator.hasNext()) {
                long newComputedLeftDelayNanos;
                ShardRouting shardRouting = unassignedIterator.next();
                UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
                if (!unassignedInfo.delayed() || (newComputedLeftDelayNanos = unassignedInfo.remainingDelay(allocation.getCurrentNanoTime(), metadata.getIndexSafe(shardRouting.index()).getSettings(), metadata.nodeShutdowns())) != 0L) continue;
                unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.reason(), unassignedInfo.message(), unassignedInfo.failure(), unassignedInfo.failedAllocations(), unassignedInfo.unassignedTimeNanos(), unassignedInfo.unassignedTimeMillis(), false, unassignedInfo.lastAllocationStatus(), unassignedInfo.failedNodeIds(), unassignedInfo.lastAllocatedNodeId()), shardRouting.recoverySource(), allocation.changes());
            }
        }

        public void execute(RoutingAllocation var1);
    }

    public record CommandsResult(RoutingExplanations explanations, ClusterState clusterState) {
    }

    private static class NotFoundAllocator
    implements ExistingShardsAllocator {
        private final String allocatorName;

        private NotFoundAllocator(String allocatorName) {
            this.allocatorName = allocatorName;
        }

        @Override
        public void beforeAllocation(RoutingAllocation allocation) {
        }

        @Override
        public void afterPrimariesBeforeReplicas(RoutingAllocation allocation, Predicate<ShardRouting> isRelevantShardPredicate) {
        }

        @Override
        public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
            unassignedAllocationHandler.removeAndIgnore(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, allocation.changes());
        }

        @Override
        public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting unassignedShard, RoutingAllocation allocation) {
            assert (unassignedShard.unassigned());
            assert (allocation.debugDecision());
            ArrayList<NodeAllocationResult> nodeAllocationResults = new ArrayList<NodeAllocationResult>(allocation.nodes().getSize());
            for (DiscoveryNode discoveryNode : allocation.nodes()) {
                nodeAllocationResults.add(new NodeAllocationResult(discoveryNode, null, allocation.decision(Decision.NO, "allocator_plugin", "finding the previous copies of this shard requires an allocator called [%s] but that allocator was not found; perhaps the corresponding plugin is not installed", this.allocatorName)));
            }
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, nodeAllocationResults);
        }

        @Override
        public void cleanCaches() {
        }

        @Override
        public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        }

        @Override
        public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        }

        @Override
        public int getNumberOfInFlightFetches() {
            return 0;
        }
    }
}

