/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.broadcast.unpromotable.BroadcastUnpromotableRequest;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UnpromotableShardRefreshRequest
extends BroadcastUnpromotableRequest {
    private final long primaryTerm;
    private final long segmentGeneration;

    public UnpromotableShardRefreshRequest(IndexShardRoutingTable indexShardRoutingTable, long primaryTerm, long segmentGeneration, boolean failShardOnError) {
        super(indexShardRoutingTable, failShardOnError);
        this.primaryTerm = primaryTerm;
        this.segmentGeneration = segmentGeneration;
    }

    public UnpromotableShardRefreshRequest(StreamInput in) throws IOException {
        super(in);
        this.segmentGeneration = in.readVLong();
        this.primaryTerm = in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readVLong() : -1L;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.segmentGeneration == -1L) {
            validationException = ValidateActions.addValidationError("segment generation is unknown", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.segmentGeneration);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeVLong(this.primaryTerm);
        }
    }

    public long getSegmentGeneration() {
        return this.segmentGeneration;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @Override
    public String toString() {
        return Strings.format("UnpromotableShardRefreshRequest{shardId=%s, primaryTerm=%d, segmentGeneration=%d}", this.shardId(), this.primaryTerm, this.segmentGeneration);
    }
}

