/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.DoubleAsyncCounter;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;

public class DoubleAsyncCounterAdapter
extends AbstractInstrument<ObservableDoubleCounter>
implements DoubleAsyncCounter {
    public DoubleAsyncCounterAdapter(Meter meter, String name, String description, String unit, Supplier<Collection<DoubleWithAttributes>> observer) {
        super(meter, new Builder(name, description, unit, observer));
    }

    public void close() throws Exception {
        ((ObservableDoubleCounter)this.getInstrument()).close();
    }

    private static class Builder
    extends AbstractInstrument.Builder<ObservableDoubleCounter> {
        private final Supplier<Collection<DoubleWithAttributes>> observer;

        private Builder(String name, String description, String unit, Supplier<Collection<DoubleWithAttributes>> observer) {
            super(name, description, unit);
            this.observer = Objects.requireNonNull(observer);
        }

        @Override
        public ObservableDoubleCounter build(Meter meter) {
            return Objects.requireNonNull(meter).counterBuilder(this.name).setDescription(this.description).setUnit(this.unit).ofDoubles().buildWithCallback(OtelHelper.doubleMeasurementCallback(this.observer));
        }
    }
}

