/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;

public class RestWatcherStatsAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestWatcherStatsAction.class);
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("emit_stacktraces");

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_watcher/stats").replaces(RestRequest.Method.GET, "/_xpack/watcher/stats", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_watcher/stats/{metric}").replaces(RestRequest.Method.GET, "/_xpack/watcher/stats/{metric}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "watcher_stats";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        Set metrics = Strings.tokenizeByCommaToSet((String)restRequest.param("metric", ""));
        WatcherStatsRequest request = new WatcherStatsRequest();
        if (metrics.contains("_all")) {
            request.includeCurrentWatches(true);
            request.includeQueuedWatches(true);
        } else {
            request.includeCurrentWatches(metrics.contains("current_watches"));
            request.includeQueuedWatches(metrics.contains("queued_watches") || metrics.contains("pending_watches"));
        }
        if (metrics.contains("pending_watches")) {
            deprecationLogger.warn(DeprecationCategory.API, "pending_watches", "The pending_watches parameter is deprecated, use queued_watches instead", new Object[0]);
        }
        return channel -> client.execute((ActionType)WatcherStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

