/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.policy.RequestRetryOptions;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.azure.AzureBlobServiceClient;
import org.elasticsearch.repositories.azure.AzureStorageSettings;
import org.elasticsearch.repositories.azure.LocationMode;
import org.elasticsearch.repositories.azure.SocketAccess;
import org.elasticsearch.repositories.azure.executors.PrivilegedExecutor;
import org.elasticsearch.repositories.azure.executors.ReactorScheduledExecutorService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.NettyAllocator;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

class AzureClientProvider
extends AbstractLifecycleComponent {
    private static final TimeValue DEFAULT_CONNECTION_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    private static final TimeValue DEFAULT_MAX_CONNECTION_IDLE_TIME = TimeValue.timeValueSeconds((long)60L);
    private static final int DEFAULT_MAX_CONNECTIONS = 50;
    private static final int DEFAULT_EVENT_LOOP_THREAD_COUNT = 1;
    private static final int PENDING_CONNECTION_QUEUE_SIZE = -1;
    private static final boolean DISABLE_INSTANCE_DISCOVERY = System.getProperty("tests.azure.credentials.disable_instance_discovery", "false").equals("true");
    static final Setting<Integer> EVENT_LOOP_THREAD_COUNT = Setting.intSetting((String)"repository.azure.http_client.event_loop_executor_thread_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Integer> MAX_OPEN_CONNECTIONS = Setting.intSetting((String)"repository.azure.http_client.max_open_connections", (int)50, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> OPEN_CONNECTION_TIMEOUT = Setting.timeSetting((String)"repository.azure.http_client.connection_timeout", (TimeValue)DEFAULT_CONNECTION_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> MAX_IDLE_TIME = Setting.timeSetting((String)"repository.azure.http_client.connection_max_idle_time", (TimeValue)DEFAULT_MAX_CONNECTION_IDLE_TIME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final ThreadPool threadPool;
    private final String reactorExecutorName;
    private final EventLoopGroup eventLoopGroup;
    private final ConnectionProvider connectionProvider;
    private final ByteBufAllocator byteBufAllocator;
    private final LoopResources nioLoopResources;
    private volatile boolean closed = false;

    AzureClientProvider(ThreadPool threadPool, String reactorExecutorName, EventLoopGroup eventLoopGroup, ConnectionProvider connectionProvider, ByteBufAllocator byteBufAllocator) {
        this.threadPool = threadPool;
        this.reactorExecutorName = reactorExecutorName;
        this.eventLoopGroup = eventLoopGroup;
        this.connectionProvider = connectionProvider;
        this.byteBufAllocator = byteBufAllocator;
        this.nioLoopResources = useNative -> eventLoopGroup;
    }

    static int eventLoopThreadsFromSettings(Settings settings) {
        return (Integer)EVENT_LOOP_THREAD_COUNT.get(settings);
    }

    static AzureClientProvider create(ThreadPool threadPool, Settings settings) {
        ExecutorService eventLoopExecutor = threadPool.executor("azure_event_loop");
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(AzureClientProvider.eventLoopThreadsFromSettings(settings), (Executor)new PrivilegedExecutor(eventLoopExecutor));
        TimeValue openConnectionTimeout = (TimeValue)OPEN_CONNECTION_TIMEOUT.get(settings);
        TimeValue maxIdleTime = (TimeValue)MAX_IDLE_TIME.get(settings);
        ConnectionProvider provider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"azure-sdk-connection-pool").maxConnections(((Integer)MAX_OPEN_CONNECTIONS.get(settings)).intValue())).pendingAcquireMaxCount(-1)).pendingAcquireTimeout(Duration.ofMillis(openConnectionTimeout.millis()))).maxIdleTime(Duration.ofMillis(maxIdleTime.millis()))).build();
        threadPool.executor("repository_azure");
        return new AzureClientProvider(threadPool, "repository_azure", (EventLoopGroup)eventLoopGroup, provider, NettyAllocator.getAllocator());
    }

    AzureBlobServiceClient createClient(AzureStorageSettings settings, LocationMode locationMode, RequestRetryOptions retryOptions, ProxyOptions proxyOptions, BiConsumer<String, URL> successfulRequestConsumer) {
        if (this.closed) {
            throw new IllegalStateException("AzureClientProvider is already closed");
        }
        HttpClient nettyHttpClient = HttpClient.create((ConnectionProvider)this.connectionProvider);
        nettyHttpClient = (HttpClient)((HttpClient)((HttpClient)nettyHttpClient.port(80).wiretap(false).resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE)).runOn(this.nioLoopResources)).option(ChannelOption.ALLOCATOR, (Object)this.byteBufAllocator);
        com.azure.core.http.HttpClient httpClient = new NettyAsyncHttpClientBuilder(nettyHttpClient).disableBufferCopy(true).proxy(proxyOptions).build();
        String connectionString = settings.getConnectString();
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder().connectionString(connectionString).httpClient(httpClient).retryOptions(retryOptions);
        if (!settings.hasCredentials()) {
            DefaultAzureCredentialBuilder credentialBuilder = new DefaultAzureCredentialBuilder().executorService((ExecutorService)this.eventLoopGroup);
            if (DISABLE_INSTANCE_DISCOVERY) {
                credentialBuilder.disableInstanceDiscovery();
            }
            builder.credential((TokenCredential)credentialBuilder.build());
        }
        if (successfulRequestConsumer != null) {
            builder.addPolicy((HttpPipelinePolicy)new SuccessfulRequestTracker(successfulRequestConsumer));
        }
        if (locationMode.isSecondary()) {
            String secondaryUri = settings.getStorageEndpoint().secondaryURI();
            if (secondaryUri == null) {
                throw new IllegalArgumentException("Unable to configure an AzureClient using a secondary location without a secondary endpoint");
            }
            builder.endpoint(secondaryUri);
        }
        BlobServiceClient blobServiceClient = SocketAccess.doPrivilegedException(() -> ((BlobServiceClientBuilder)builder).buildClient());
        BlobServiceAsyncClient asyncClient = SocketAccess.doPrivilegedException(() -> ((BlobServiceClientBuilder)builder).buildAsyncClient());
        return new AzureBlobServiceClient(blobServiceClient, asyncClient, settings.getMaxRetries(), this.byteBufAllocator);
    }

    protected void doStart() {
        final ReactorScheduledExecutorService executorService = new ReactorScheduledExecutorService(this.threadPool, this.reactorExecutorName){

            @Override
            protected Runnable decorateRunnable(Runnable command) {
                return () -> SocketAccess.doPrivilegedVoidException(command::run);
            }

            @Override
            protected <V> Callable<V> decorateCallable(Callable<V> callable) {
                return () -> SocketAccess.doPrivilegedException(callable::call);
            }
        };
        Schedulers.setFactory((Schedulers.Factory)new Schedulers.Factory(){

            public Scheduler newParallel(int parallelism, ThreadFactory threadFactory) {
                return Schedulers.fromExecutor((Executor)executorService);
            }

            public Scheduler newElastic(int ttlSeconds, ThreadFactory threadFactory) {
                return Schedulers.fromExecutor((Executor)executorService);
            }

            public Scheduler newBoundedElastic(int threadCap, int queuedTaskCap, ThreadFactory threadFactory, int ttlSeconds) {
                return Schedulers.fromExecutor((Executor)executorService);
            }

            public Scheduler newSingle(ThreadFactory threadFactory) {
                return Schedulers.fromExecutor((Executor)executorService);
            }
        });
    }

    protected void doStop() {
        this.closed = true;
        this.connectionProvider.dispose();
        this.eventLoopGroup.shutdownGracefully();
        Schedulers.resetFactory();
    }

    protected void doClose() throws IOException {
    }

    private static final class SuccessfulRequestTracker
    implements HttpPipelinePolicy {
        private static final Logger logger = LogManager.getLogger(SuccessfulRequestTracker.class);
        private final BiConsumer<String, URL> onSuccessfulRequest;

        private SuccessfulRequestTracker(BiConsumer<String, URL> onSuccessfulRequest) {
            this.onSuccessfulRequest = onSuccessfulRequest;
        }

        public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
            return next.process().doOnSuccess(httpResponse -> this.trackSuccessfulRequest(context.getHttpRequest(), (HttpResponse)httpResponse));
        }

        private void trackSuccessfulRequest(HttpRequest httpRequest, HttpResponse httpResponse) {
            HttpMethod method = httpRequest.getHttpMethod();
            if (httpResponse != null && method != null && httpResponse.getStatusCode() > 199 && httpResponse.getStatusCode() <= 299) {
                try {
                    this.onSuccessfulRequest.accept(method.name(), httpRequest.getUrl());
                }
                catch (Exception e) {
                    logger.warn("Unable to notify a successful request", (Throwable)e);
                }
            }
        }
    }
}

