/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.metric;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.metric.SecurityMetricGroup;
import org.elasticsearch.xpack.security.metric.SecurityMetrics;

public class InstrumentedSecurityActionListener {
    public static <R, C> ActionListener<AuthenticationResult<R>> wrapForAuthc(SecurityMetrics<C> metrics, C context, ActionListener<AuthenticationResult<R>> listener) {
        assert (metrics.type().group() == SecurityMetricGroup.AUTHC);
        long startTimeNano = metrics.relativeTimeInNanos();
        return ActionListener.runBefore((ActionListener)ActionListener.wrap(result -> {
            if (result.isAuthenticated()) {
                metrics.recordSuccess(context);
            } else {
                metrics.recordFailure(context, result.getMessage());
            }
            listener.onResponse(result);
        }, e -> {
            metrics.recordFailure(context, e.getMessage());
            listener.onFailure(e);
        }), () -> metrics.recordTime(context, startTimeNano));
    }
}

