/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSlice;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.PartialLeafReaderContext;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class TimeSeriesSortedSourceOperatorFactory
extends LuceneOperator.Factory {
    private final int maxPageSize;

    private TimeSeriesSortedSourceOperatorFactory(List<? extends ShardContext> contexts, Function<ShardContext, Query> queryFunction, int taskConcurrency, int maxPageSize, int limit) {
        super(contexts, queryFunction, DataPartitioning.SHARD, taskConcurrency, limit, ScoreMode.COMPLETE_NO_SCORES);
        this.maxPageSize = maxPageSize;
    }

    @Override
    public SourceOperator get(DriverContext driverContext) {
        return new Impl(driverContext.blockFactory(), this.sliceQueue, this.maxPageSize, this.limit);
    }

    @Override
    public String describe() {
        return "TimeSeriesSortedSourceOperator[maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + "]";
    }

    public static TimeSeriesSortedSourceOperatorFactory create(int limit, int maxPageSize, int taskConcurrency, List<? extends ShardContext> searchContexts, Function<ShardContext, Query> queryFunction) {
        return new TimeSeriesSortedSourceOperatorFactory(searchContexts, queryFunction, taskConcurrency, maxPageSize, limit);
    }

    static final class Impl
    extends SourceOperator {
        private final int maxPageSize;
        private final BlockFactory blockFactory;
        private final LuceneSliceQueue sliceQueue;
        private int currentPagePos = 0;
        private int remainingDocs;
        private boolean doneCollecting;
        private IntVector.Builder docsBuilder;
        private IntVector.Builder segmentsBuilder;
        private LongVector.Builder timestampsBuilder;
        private BytesRefVector.Builder tsHashesBuilder;
        private TimeSeriesIterator iterator;

        Impl(BlockFactory blockFactory, LuceneSliceQueue sliceQueue, int maxPageSize, int limit) {
            this.maxPageSize = maxPageSize;
            this.blockFactory = blockFactory;
            this.remainingDocs = limit;
            this.docsBuilder = blockFactory.newIntVectorBuilder(Math.min(limit, maxPageSize));
            this.segmentsBuilder = null;
            this.timestampsBuilder = blockFactory.newLongVectorBuilder(Math.min(limit, maxPageSize));
            this.tsHashesBuilder = blockFactory.newBytesRefVectorBuilder(Math.min(limit, maxPageSize));
            this.sliceQueue = sliceQueue;
        }

        @Override
        public void finish() {
            this.doneCollecting = true;
        }

        @Override
        public boolean isFinished() {
            return this.doneCollecting;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Page getOutput() {
            block13: {
                block14: {
                    if (this.isFinished()) {
                        return null;
                    }
                    if (this.remainingDocs <= 0) {
                        this.doneCollecting = true;
                        return null;
                    }
                    page = null;
                    shard = null;
                    leaf = null;
                    docs = null;
                    timestamps = null;
                    tsids = null;
                    if (this.iterator != null) ** GOTO lbl27
                    slice = this.sliceQueue.nextSlice();
                    if (slice != null) break block13;
                    this.doneCollecting = true;
                    var8_10 = null;
                    if (page != null) break block14;
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs, timestamps, tsids});
                }
                return var8_10;
            }
            try {
                if (this.segmentsBuilder == null && slice.numLeaves() > 1) {
                    this.segmentsBuilder = this.blockFactory.newIntVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                }
                this.iterator = new TimeSeriesIterator(slice);
lbl27:
                // 2 sources

                this.iterator.consume();
                shard = this.blockFactory.newConstantIntBlockWith(this.iterator.slice.shardContext().index(), this.currentPagePos);
                if (this.iterator.slice.numLeaves() == 1) {
                    segmentOrd = this.iterator.slice.getLeaf((int)0).leafReaderContext().ord;
                    leaf = this.blockFactory.newConstantIntBlockWith(segmentOrd, this.currentPagePos).asVector();
                } else {
                    leaf = this.segmentsBuilder.build();
                    this.segmentsBuilder = this.blockFactory.newIntVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                }
                docs = this.docsBuilder.build();
                this.docsBuilder = this.blockFactory.newIntVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                timestamps = this.timestampsBuilder.build();
                this.timestampsBuilder = this.blockFactory.newLongVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                tsids = this.tsHashesBuilder.build();
                this.tsHashesBuilder = this.blockFactory.newBytesRefVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                page = new Page(this.currentPagePos, new Block[]{new DocVector(shard.asVector(), leaf, docs, leaf.isConstant()).asBlock(), tsids.asBlock(), timestamps.asBlock()});
                this.currentPagePos = 0;
                if (this.iterator.completed()) {
                    this.iterator = null;
                }
                ** if (page != null) goto lbl-1000
            }
            catch (IOException e) {
                try {
                    throw new UncheckedIOException(e);
                }
                catch (Throwable var9_11) {
                    if (page == null) {
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs, timestamps, tsids});
                    }
                    throw var9_11;
                }
            }
lbl-1000:
            // 1 sources

            {
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs, timestamps, tsids});
            }
lbl-1000:
            // 2 sources

            {
            }
            return page;
        }

        @Override
        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.docsBuilder, this.segmentsBuilder, this.timestampsBuilder, this.tsHashesBuilder});
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[maxPageSize=" + this.maxPageSize + ", remainingDocs=" + this.remainingDocs + "]";
        }

        class TimeSeriesIterator {
            final LuceneSlice slice;
            final Leaf leaf;
            final PriorityQueue<Leaf> queue;
            int globalTsidOrd;
            BytesRef currentTsid = new BytesRef();

            TimeSeriesIterator(LuceneSlice slice) throws IOException {
                this.slice = slice;
                Weight weight = slice.weight();
                if (slice.numLeaves() == 1) {
                    this.queue = null;
                    this.leaf = new Leaf(weight, slice.getLeaf(0).leafReaderContext());
                } else {
                    this.queue = new PriorityQueue<Leaf>(slice.numLeaves()){

                        protected boolean lessThan(Leaf a, Leaf b) {
                            int cmp = a.timeSeriesHash.compareTo(b.timeSeriesHash);
                            if (cmp == 0) {
                                cmp = -Long.compare(a.timestamp, b.timestamp);
                            }
                            return cmp < 0;
                        }
                    };
                    this.leaf = null;
                    for (PartialLeafReaderContext leafReaderContext : slice.leaves()) {
                        Leaf leaf = new Leaf(weight, leafReaderContext.leafReaderContext());
                        if (!leaf.nextDoc()) continue;
                        this.queue.add((Object)leaf);
                    }
                }
            }

            void consume() throws IOException {
                if (this.queue != null) {
                    if (this.queue.size() > 0) {
                        this.currentTsid = BytesRef.deepCopyOf((BytesRef)((Leaf)this.queue.top()).timeSeriesHash);
                        ((Leaf)this.queue.top()).reinitializeIfNeeded(Thread.currentThread());
                    }
                    while (this.queue.size() > 0 && Impl.this.remainingDocs > 0 && Impl.this.currentPagePos < Impl.this.maxPageSize) {
                        Leaf newTop;
                        ++Impl.this.currentPagePos;
                        --Impl.this.remainingDocs;
                        Leaf leaf = (Leaf)this.queue.top();
                        Impl.this.segmentsBuilder.appendInt(leaf.segmentOrd);
                        Impl.this.docsBuilder.appendInt(leaf.iterator.docID());
                        Impl.this.timestampsBuilder.appendLong(leaf.timestamp);
                        Impl.this.tsHashesBuilder.appendBytesRef(this.currentTsid);
                        if (leaf.nextDoc()) {
                            newTop = (Leaf)this.queue.updateTop();
                        } else {
                            this.queue.pop();
                            Leaf leaf2 = newTop = this.queue.size() > 0 ? (Leaf)this.queue.top() : null;
                        }
                        if (newTop == null) continue;
                        if (newTop != leaf) {
                            newTop.reinitializeIfNeeded(Thread.currentThread());
                        }
                        if (newTop.timeSeriesHash.equals((Object)this.currentTsid)) continue;
                        ++this.globalTsidOrd;
                        this.currentTsid = BytesRef.deepCopyOf((BytesRef)newTop.timeSeriesHash);
                    }
                } else {
                    this.leaf.reinitializeIfNeeded(Thread.currentThread());
                    while (this.leaf.nextDoc()) {
                        Impl.this.tsHashesBuilder.appendBytesRef(this.leaf.timeSeriesHash);
                        Impl.this.timestampsBuilder.appendLong(this.leaf.timestamp);
                        Impl.this.docsBuilder.appendInt(this.leaf.iterator.docID());
                        ++Impl.this.currentPagePos;
                        --Impl.this.remainingDocs;
                        if (Impl.this.remainingDocs > 0 && Impl.this.currentPagePos < Impl.this.maxPageSize) continue;
                        break;
                    }
                }
            }

            boolean completed() {
                if (this.queue != null) {
                    return Impl.this.iterator.queue.size() == 0;
                }
                return this.leaf.iterator.docID() == Integer.MAX_VALUE;
            }

            static class Leaf {
                private final int segmentOrd;
                private final Weight weight;
                private final LeafReaderContext leaf;
                private SortedDocValues tsids;
                private SortedNumericDocValues timestamps;
                private DocIdSetIterator iterator;
                private Thread createdThread;
                private long timestamp;
                private int timeSeriesHashOrd;
                private BytesRef timeSeriesHash;
                private int docID = -1;

                Leaf(Weight weight, LeafReaderContext leaf) throws IOException {
                    this.segmentOrd = leaf.ord;
                    this.weight = weight;
                    this.leaf = leaf;
                    this.createdThread = Thread.currentThread();
                    this.tsids = leaf.reader().getSortedDocValues("_tsid");
                    this.timestamps = leaf.reader().getSortedNumericDocValues("@timestamp");
                    Scorer scorer = weight.scorer(leaf);
                    this.iterator = scorer != null ? scorer.iterator() : DocIdSetIterator.empty();
                }

                boolean nextDoc() throws IOException {
                    this.docID = this.iterator.nextDoc();
                    if (this.docID == Integer.MAX_VALUE) {
                        return false;
                    }
                    boolean advanced = this.tsids.advanceExact(this.docID);
                    assert (advanced);
                    this.timeSeriesHashOrd = this.tsids.ordValue();
                    this.timeSeriesHash = this.tsids.lookupOrd(this.timeSeriesHashOrd);
                    advanced = this.timestamps.advanceExact(this.docID);
                    assert (advanced);
                    this.timestamp = this.timestamps.nextValue();
                    return true;
                }

                void reinitializeIfNeeded(Thread executingThread) throws IOException {
                    if (executingThread != this.createdThread) {
                        this.tsids = this.leaf.reader().getSortedDocValues("_tsid");
                        this.timestamps = this.leaf.reader().getSortedNumericDocValues("@timestamp");
                        Scorer scorer = this.weight.scorer(this.leaf);
                        DocIdSetIterator docIdSetIterator = this.iterator = scorer != null ? scorer.iterator() : DocIdSetIterator.empty();
                        if (this.docID != -1) {
                            this.iterator.advance(this.docID);
                        }
                        this.createdThread = executingThread;
                    }
                }
            }
        }
    }
}

