/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class LuceneQueryExpressionEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final BlockFactory blockFactory;
    private final ShardConfig[] shards;
    private ShardState[] perShardState = EMPTY_SHARD_STATES;
    private static final ShardState[] EMPTY_SHARD_STATES = new ShardState[0];
    private static final SegmentState[] EMPTY_SEGMENT_STATES = new SegmentState[0];

    public LuceneQueryExpressionEvaluator(BlockFactory blockFactory, ShardConfig[] shards) {
        this.blockFactory = blockFactory;
        this.shards = shards;
    }

    @Override
    public Block eval(Page page) {
        Object block = page.getBlock(0);
        assert (block instanceof DocBlock) : "LuceneQueryExpressionEvaluator expects DocBlock as input";
        DocVector docs = (DocVector)block.asVector();
        try {
            if (docs.singleSegmentNonDecreasing()) {
                return this.evalSingleSegmentNonDecreasing(docs).asBlock();
            }
            return this.evalSlow(docs).asBlock();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private BooleanVector evalSingleSegmentNonDecreasing(DocVector docs) throws IOException {
        ShardState shardState = this.shardState(docs.shards().getInt(0));
        SegmentState segmentState = shardState.segmentState(docs.segments().getInt(0));
        int min = docs.docs().getInt(0);
        int max = docs.docs().getInt(docs.getPositionCount() - 1);
        int length = max - min + 1;
        if (length == docs.getPositionCount() && length > 1) {
            return segmentState.scoreDense(min, max);
        }
        return segmentState.scoreSparse(docs.docs());
    }

    private BooleanVector evalSlow(DocVector docs) throws IOException {
        int[] map = docs.shardSegmentDocMapForwards();
        int prevShard = -1;
        int prevSegment = -1;
        SegmentState segmentState = null;
        try (BooleanVector.FixedBuilder builder = this.blockFactory.newBooleanVectorFixedBuilder(docs.getPositionCount());){
            BooleanVector booleanVector;
            block15: {
                for (int i = 0; i < docs.getPositionCount(); ++i) {
                    int shard = docs.shards().getInt(docs.shards().getInt(map[i]));
                    int segment = docs.segments().getInt(map[i]);
                    if (segmentState == null || prevShard != shard || prevSegment != segment) {
                        segmentState = this.shardState(shard).segmentState(segment);
                        segmentState.initScorer(docs.docs().getInt(map[i]));
                        prevShard = shard;
                        prevSegment = segment;
                    }
                    if (segmentState.noMatch) {
                        builder.appendBoolean(false);
                        continue;
                    }
                    segmentState.scoreSingleDocWithScorer(builder, docs.docs().getInt(map[i]));
                }
                BooleanVector outOfOrder = builder.build();
                try {
                    booleanVector = outOfOrder.filter(docs.shardSegmentDocMapBackwards());
                    if (outOfOrder == null) break block15;
                }
                catch (Throwable throwable) {
                    if (outOfOrder != null) {
                        try {
                            outOfOrder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outOfOrder.close();
            }
            return booleanVector;
        }
    }

    public void close() {
    }

    private ShardState shardState(int shard) throws IOException {
        if (shard >= this.perShardState.length) {
            this.perShardState = (ShardState[])ArrayUtil.grow((Object[])this.perShardState, (int)(shard + 1));
        } else if (this.perShardState[shard] != null) {
            return this.perShardState[shard];
        }
        this.perShardState[shard] = new ShardState(this.shards[shard]);
        return this.perShardState[shard];
    }

    private class ShardState {
        private final Weight weight;
        private final IndexSearcher searcher;
        private SegmentState[] perSegmentState = EMPTY_SEGMENT_STATES;

        ShardState(ShardConfig config) throws IOException {
            this.weight = config.searcher.createWeight(config.query, ScoreMode.COMPLETE_NO_SCORES, 0.0f);
            this.searcher = config.searcher;
        }

        SegmentState segmentState(int segment) throws IOException {
            if (segment >= this.perSegmentState.length) {
                this.perSegmentState = (SegmentState[])ArrayUtil.grow((Object[])this.perSegmentState, (int)(segment + 1));
            } else if (this.perSegmentState[segment] != null) {
                return this.perSegmentState[segment];
            }
            this.perSegmentState[segment] = new SegmentState(this.weight, (LeafReaderContext)this.searcher.getLeafContexts().get(segment));
            return this.perSegmentState[segment];
        }
    }

    public record ShardConfig(Query query, IndexSearcher searcher) {
    }

    private class SegmentState {
        private final Weight weight;
        private final LeafReaderContext ctx;
        private Scorer scorer;
        private Thread scorerThread;
        private BulkScorer bulkScorer;
        private Thread bulkScorerThread;
        private boolean noMatch;

        private SegmentState(Weight weight, LeafReaderContext ctx) {
            this.weight = weight;
            this.ctx = ctx;
        }

        BooleanVector scoreDense(int min, int max) throws IOException {
            int length = max - min + 1;
            if (this.noMatch) {
                return LuceneQueryExpressionEvaluator.this.blockFactory.newConstantBooleanVector(false, length);
            }
            if (this.bulkScorer == null || Thread.currentThread() != this.bulkScorerThread) {
                this.bulkScorerThread = Thread.currentThread();
                this.bulkScorer = this.weight.bulkScorer(this.ctx);
                if (this.bulkScorer == null) {
                    this.noMatch = true;
                    return LuceneQueryExpressionEvaluator.this.blockFactory.newConstantBooleanVector(false, length);
                }
            }
            try (DenseCollector collector = new DenseCollector(LuceneQueryExpressionEvaluator.this.blockFactory, min, max);){
                this.bulkScorer.score((LeafCollector)collector, this.ctx.reader().getLiveDocs(), min, max + 1);
                BooleanVector booleanVector = collector.build();
                return booleanVector;
            }
        }

        BooleanVector scoreSparse(IntVector docs) throws IOException {
            this.initScorer(docs.getInt(0));
            if (this.noMatch) {
                return LuceneQueryExpressionEvaluator.this.blockFactory.newConstantBooleanVector(false, docs.getPositionCount());
            }
            try (BooleanVector.FixedBuilder builder = LuceneQueryExpressionEvaluator.this.blockFactory.newBooleanVectorFixedBuilder(docs.getPositionCount());){
                for (int i = 0; i < docs.getPositionCount(); ++i) {
                    this.scoreSingleDocWithScorer(builder, docs.getInt(i));
                }
                BooleanVector booleanVector = builder.build();
                return booleanVector;
            }
        }

        private void initScorer(int minDocId) throws IOException {
            if (this.noMatch) {
                return;
            }
            if (this.scorer == null || this.scorerThread != Thread.currentThread() || this.scorer.iterator().docID() > minDocId) {
                this.scorerThread = Thread.currentThread();
                this.scorer = this.weight.scorer(this.ctx);
                if (this.scorer == null) {
                    this.noMatch = true;
                }
            }
        }

        private void scoreSingleDocWithScorer(BooleanVector.Builder builder, int doc) throws IOException {
            if (this.scorer.iterator().docID() == doc) {
                builder.appendBoolean(true);
            } else if (this.scorer.iterator().docID() > doc) {
                builder.appendBoolean(false);
            } else {
                builder.appendBoolean(this.scorer.iterator().advance(doc) == doc);
            }
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final ShardConfig[] shardConfigs;

        public Factory(ShardConfig[] shardConfigs) {
            this.shardConfigs = shardConfigs;
        }

        @Override
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new LuceneQueryExpressionEvaluator(context.blockFactory(), this.shardConfigs);
        }
    }

    static class DenseCollector
    implements LeafCollector,
    Releasable {
        private final BooleanVector.FixedBuilder builder;
        private final int max;
        int next;

        DenseCollector(BlockFactory blockFactory, int min, int max) {
            this.builder = blockFactory.newBooleanVectorFixedBuilder(max - min + 1);
            this.max = max;
            this.next = min;
        }

        public void setScorer(Scorable scorable) {
        }

        public void collect(int doc) {
            while (this.next++ < doc) {
                this.builder.appendBoolean(false);
            }
            this.builder.appendBoolean(true);
        }

        public BooleanVector build() {
            return this.builder.build();
        }

        public void finish() {
            while (this.next++ <= this.max) {
                this.builder.appendBoolean(false);
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.builder);
        }
    }
}

