/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import org.ojalgo.type.ComparableNumber;

public interface PrimitiveNumber
extends ComparableNumber<PrimitiveNumber> {
    public static PrimitiveNumber of(byte value) {
        return new BoxedByte(value);
    }

    public static PrimitiveNumber of(double value) {
        return new BoxedDouble(value);
    }

    public static PrimitiveNumber of(float value) {
        return new BoxedFloat(value);
    }

    public static PrimitiveNumber of(int value) {
        return new BoxedInt(value);
    }

    public static PrimitiveNumber of(long value) {
        return new BoxedLong(value);
    }

    public static PrimitiveNumber of(short value) {
        return new BoxedShort(value);
    }

    public static PrimitiveNumber valueOf(byte value) {
        return PrimitiveNumber.of(value);
    }

    public static PrimitiveNumber valueOf(double value) {
        return PrimitiveNumber.of(value);
    }

    public static PrimitiveNumber valueOf(float value) {
        return PrimitiveNumber.of(value);
    }

    public static PrimitiveNumber valueOf(int value) {
        return PrimitiveNumber.of(value);
    }

    public static PrimitiveNumber valueOf(long value) {
        return PrimitiveNumber.of(value);
    }

    public static PrimitiveNumber valueOf(short value) {
        return PrimitiveNumber.of(value);
    }

    public static class BoxedShort
    implements PrimitiveNumber {
        public final short value;

        BoxedShort(short value) {
            this.value = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Short.compare(this.value, other.shortValue());
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public short shortValue() {
            return this.value;
        }
    }

    public static class BoxedLong
    implements PrimitiveNumber {
        public final long value;

        BoxedLong(long value) {
            this.value = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Long.compare(this.value, other.longValue());
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }

    public static class BoxedInt
    implements PrimitiveNumber {
        public final int value;

        BoxedInt(int value) {
            this.value = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Integer.compare(this.value, other.intValue());
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }

    public static class BoxedFloat
    implements PrimitiveNumber {
        public final float value;

        BoxedFloat(float value) {
            this.value = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Float.compare(this.value, other.floatValue());
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }
    }

    public static class BoxedDouble
    implements PrimitiveNumber {
        public final double value;

        BoxedDouble(double value) {
            this.value = value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Double.compare(this.value, other.doubleValue());
        }

        @Override
        public double doubleValue() {
            return this.value;
        }
    }

    public static class BoxedByte
    implements PrimitiveNumber {
        public final byte value;

        BoxedByte(byte value) {
            this.value = value;
        }

        @Override
        public byte byteValue() {
            return this.value;
        }

        @Override
        public int compareTo(PrimitiveNumber other) {
            return Byte.compare(this.value, other.byteValue());
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public short shortValue() {
            return this.value;
        }
    }
}

