/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.operation.MultiplyBoth;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.structure.Access1D;

abstract class Subregion2D<N extends Comparable<N>>
implements TransformableRegion<N> {
    private final TransformableRegion.FillByMultiplying<N> myMultiplier;

    private Subregion2D() {
        this(null, 0L, 0L);
    }

    Subregion2D(TransformableRegion.FillByMultiplying<N> multiplier, long rows, long columns) {
        this.myMultiplier = multiplier instanceof MultiplyBoth.Primitive ? MultiplyBoth.newPrimitive64(Math.toIntExact(rows), Math.toIntExact(columns)) : (multiplier instanceof MultiplyBoth.Generic ? MultiplyBoth.newGeneric(Math.toIntExact(rows), Math.toIntExact(columns)) : multiplier);
    }

    @Override
    public final void fillByMultiplying(Access1D<N> left, Access1D<N> right) {
        int complexity = Math.toIntExact(left.count() / this.countRows());
        if (complexity != Math.toIntExact(right.count() / this.countColumns())) {
            ProgrammingError.throwForMultiplicationNotPossible();
        }
        this.myMultiplier.invoke((TransformableRegion<N>)this, left, (int)(left.count() / this.countRows()), right);
    }

    @Override
    public final TransformableRegion<N> regionByColumns(int ... columns) {
        return new ColumnsRegion<N>(this, this.myMultiplier, columns);
    }

    @Override
    public final TransformableRegion<N> regionByLimits(int rowLimit, int columnLimit) {
        return new LimitRegion<N>(this, this.myMultiplier, rowLimit, columnLimit);
    }

    @Override
    public final TransformableRegion<N> regionByOffsets(int rowOffset, int columnOffset) {
        return new OffsetRegion<N>(this, this.myMultiplier, rowOffset, columnOffset);
    }

    @Override
    public final TransformableRegion<N> regionByRows(int ... rows) {
        return new RowsRegion<N>(this, this.myMultiplier, rows);
    }

    @Override
    public TransformableRegion<N> regionByTransposing() {
        return new TransposedRegion<N>(this, this.myMultiplier);
    }

    public String toString() {
        return Access1D.toString(this);
    }

    static final class TransposedRegion<N extends Comparable<N>>
    extends Subregion2D<N> {
        private final TransformableRegion<N> myBase;

        TransposedRegion(TransformableRegion<N> base, TransformableRegion.FillByMultiplying<N> multiplier) {
            super(multiplier, base.countColumns(), base.countRows());
            this.myBase = base;
        }

        @Override
        public void add(long row, long col, Comparable<?> addend) {
            this.myBase.add(col, row, addend);
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add(col, row, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countRows();
        }

        @Override
        public long countRows() {
            return this.myBase.countColumns();
        }

        @Override
        public double doubleValue(long row, long col) {
            return this.myBase.doubleValue(col, row);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TransposedRegion)) {
                return false;
            }
            TransposedRegion other = (TransposedRegion)obj;
            return !(this.myBase == null ? other.myBase != null : !this.myBase.equals(other.myBase));
        }

        @Override
        public void fillColumn(long row, long col, N value) {
            this.myBase.fillRow(col, row, value);
        }

        @Override
        public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillRow(col, row, supplier);
        }

        @Override
        public void fillDiagonal(long row, long col, N value) {
            this.myBase.fillDiagonal(col, row, value);
        }

        @Override
        public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillRow(col, row, supplier);
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne(col, row, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne(col, row, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillOne(col, row, supplier);
        }

        @Override
        public void fillRow(long row, long col, N value) {
            this.myBase.fillDiagonal(col, row, value);
        }

        @Override
        public void fillRow(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillDiagonal(col, row, supplier);
        }

        @Override
        public N get(long row, long col) {
            return this.myBase.get(col, row);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myBase == null ? 0 : this.myBase.hashCode());
            return result;
        }

        @Override
        public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyRow(col, row, modifier);
        }

        @Override
        public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyDiagonal(col, row, modifier);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne(col, row, modifier);
        }

        @Override
        public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyColumn(col, row, modifier);
        }

        @Override
        public TransformableRegion<N> regionByTransposing() {
            return this.myBase;
        }

        @Override
        public void set(long row, long col, Comparable<?> value) {
            this.myBase.set(col, row, value);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set(col, row, value);
        }
    }

    static final class RowsRegion<N extends Comparable<N>>
    extends Subregion2D<N> {
        private final TransformableRegion<N> myBase;
        private final int[] myRows;

        RowsRegion(TransformableRegion<N> base, TransformableRegion.FillByMultiplying<N> multiplier, int ... rows) {
            super(multiplier, rows.length, base.countColumns());
            this.myBase = base;
            this.myRows = rows;
        }

        @Override
        public void add(long row, long col, Comparable<?> addend) {
            this.myBase.add((long)this.myRows[(int)row], col, addend);
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add((long)this.myRows[(int)row], col, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countColumns();
        }

        @Override
        public long countRows() {
            return this.myRows.length;
        }

        @Override
        public double doubleValue(long row, long col) {
            return this.myBase.doubleValue(this.myRows[(int)row], col);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RowsRegion)) {
                return false;
            }
            RowsRegion other = (RowsRegion)obj;
            if (this.myBase == null ? other.myBase != null : !this.myBase.equals(other.myBase)) {
                return false;
            }
            return Arrays.equals(this.myRows, other.myRows);
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne(this.myRows[(int)row], col, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne((long)this.myRows[(int)row], col, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillOne((long)this.myRows[(int)row], col, supplier);
        }

        @Override
        public void fillRow(long row, long col, Access1D<N> values) {
            this.myBase.fillRow((long)this.myRows[(int)row], col, values);
        }

        @Override
        public void fillRow(long row, long col, N value) {
            this.myBase.fillRow((long)this.myRows[(int)row], col, value);
        }

        @Override
        public void fillRow(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillRow((long)this.myRows[(int)row], col, supplier);
        }

        @Override
        public N get(long row, long col) {
            return this.myBase.get(this.myRows[(int)row], col);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myBase == null ? 0 : this.myBase.hashCode());
            result = 31 * result + Arrays.hashCode(this.myRows);
            return result;
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne(this.myRows[(int)row], col, modifier);
        }

        @Override
        public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyRow(this.myRows[(int)row], col, modifier);
        }

        @Override
        public void set(long row, long col, Comparable<?> value) {
            this.myBase.set((long)this.myRows[(int)row], col, value);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set((long)this.myRows[(int)row], col, value);
        }
    }

    static final class OffsetRegion<N extends Comparable<N>>
    extends Subregion2D<N> {
        private final TransformableRegion<N> myBase;
        private final int myRowOffset;
        private final int myColumnOffset;

        OffsetRegion(TransformableRegion<N> base, TransformableRegion.FillByMultiplying<N> multiplier, int rowOffset, int columnOffset) {
            super(multiplier, base.countRows() - (long)rowOffset, base.countColumns() - (long)columnOffset);
            this.myBase = base;
            this.myRowOffset = rowOffset;
            this.myColumnOffset = columnOffset;
        }

        @Override
        public void add(long row, long col, Comparable<?> addend) {
            this.myBase.add((long)this.myRowOffset + row, (long)this.myColumnOffset + col, addend);
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add((long)this.myRowOffset + row, (long)this.myColumnOffset + col, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countColumns() - (long)this.myColumnOffset;
        }

        @Override
        public long countRows() {
            return this.myBase.countRows() - (long)this.myRowOffset;
        }

        @Override
        public double doubleValue(long row, long col) {
            return this.myBase.doubleValue((long)this.myRowOffset + row, (long)this.myColumnOffset + col);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OffsetRegion)) {
                return false;
            }
            OffsetRegion other = (OffsetRegion)obj;
            if (this.myBase == null ? other.myBase != null : !this.myBase.equals(other.myBase)) {
                return false;
            }
            return this.myColumnOffset == other.myColumnOffset && this.myRowOffset == other.myRowOffset;
        }

        @Override
        public void fillAll(N value) {
            long tmpCountColumns = this.myBase.countColumns();
            for (long j = (long)this.myColumnOffset; j < tmpCountColumns; ++j) {
                this.myBase.fillColumn((long)this.myRowOffset, j, value);
            }
        }

        @Override
        public void fillAll(NullaryFunction<?> supplier) {
            long tmpCountColumns = this.myBase.countColumns();
            for (long j = (long)this.myColumnOffset; j < tmpCountColumns; ++j) {
                this.myBase.fillColumn((long)this.myRowOffset, j, supplier);
            }
        }

        @Override
        public void fillColumn(long row, long col, N value) {
            this.myBase.fillColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + col, supplier);
        }

        @Override
        public void fillDiagonal(long row, long col, N value) {
            this.myBase.fillDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + col, supplier);
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne((long)this.myRowOffset + row, (long)this.myColumnOffset + col, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillOne((long)this.myRowOffset + row, (long)this.myColumnOffset + col, supplier);
        }

        @Override
        public void fillRow(long row, long col, N value) {
            this.myBase.fillRow((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void fillRow(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillRow((long)this.myRowOffset + row, (long)this.myColumnOffset + col, supplier);
        }

        @Override
        public N get(long row, long col) {
            return this.myBase.get((long)this.myRowOffset + row, (long)this.myColumnOffset + col);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myBase == null ? 0 : this.myBase.hashCode());
            result = 31 * result + this.myColumnOffset;
            result = 31 * result + this.myRowOffset;
            return result;
        }

        @Override
        public void modifyAll(UnaryFunction<N> modifier) {
            for (long j = (long)this.myColumnOffset; j < this.myBase.countColumns(); ++j) {
                this.myBase.modifyColumn(this.myRowOffset, j, modifier);
            }
        }

        @Override
        public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + col, modifier);
        }

        @Override
        public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + col, modifier);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne((long)this.myRowOffset + row, (long)this.myColumnOffset + col, modifier);
        }

        @Override
        public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyRow((long)this.myRowOffset + row, (long)this.myColumnOffset + col, modifier);
        }

        @Override
        public void set(long row, long col, Comparable<?> value) {
            this.myBase.set((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set((long)this.myRowOffset + row, (long)this.myColumnOffset + col, value);
        }
    }

    static final class LimitRegion<N extends Comparable<N>>
    extends Subregion2D<N> {
        private final TransformableRegion<N> myBase;
        private final int myRowLimit;
        private final int myColumnLimit;

        LimitRegion(TransformableRegion<N> base, TransformableRegion.FillByMultiplying<N> multiplier, int rowLimit, int columnLimit) {
            super(multiplier, rowLimit, columnLimit);
            this.myBase = base;
            this.myRowLimit = rowLimit;
            this.myColumnLimit = columnLimit;
        }

        @Override
        public void add(long row, long col, Comparable<?> addend) {
            this.myBase.add(row, col, addend);
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add(row, col, addend);
        }

        @Override
        public long countColumns() {
            return this.myColumnLimit;
        }

        @Override
        public long countRows() {
            return this.myRowLimit;
        }

        @Override
        public double doubleValue(long row, long col) {
            return this.myBase.doubleValue(row, col);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LimitRegion)) {
                return false;
            }
            LimitRegion other = (LimitRegion)obj;
            if (this.myBase == null ? other.myBase != null : !this.myBase.equals(other.myBase)) {
                return false;
            }
            return this.myColumnLimit == other.myColumnLimit && this.myRowLimit == other.myRowLimit;
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne(row, col, values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne(row, col, value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillOne(row, col, supplier);
        }

        @Override
        public N get(long row, long col) {
            return this.myBase.get(row, col);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myBase == null ? 0 : this.myBase.hashCode());
            result = 31 * result + this.myColumnLimit;
            result = 31 * result + this.myRowLimit;
            return result;
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne(row, col, modifier);
        }

        @Override
        public void set(long row, long col, Comparable<?> value) {
            this.myBase.set(row, col, value);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set(row, col, value);
        }
    }

    static final class ColumnsRegion<N extends Comparable<N>>
    extends Subregion2D<N> {
        private final TransformableRegion<N> myBase;
        private final int[] myColumns;

        ColumnsRegion(TransformableRegion<N> base, TransformableRegion.FillByMultiplying<N> multiplier, int ... columns) {
            super(multiplier, base.countRows(), columns.length);
            this.myBase = base;
            this.myColumns = columns;
        }

        @Override
        public void add(long row, long col, Comparable<?> addend) {
            this.myBase.add(row, (long)this.myColumns[(int)col], addend);
        }

        @Override
        public void add(long row, long col, double addend) {
            this.myBase.add(row, (long)this.myColumns[(int)col], addend);
        }

        @Override
        public long countColumns() {
            return this.myColumns.length;
        }

        @Override
        public long countRows() {
            return this.myBase.countRows();
        }

        @Override
        public double doubleValue(long row, long col) {
            return this.myBase.doubleValue(row, this.myColumns[(int)col]);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ColumnsRegion)) {
                return false;
            }
            ColumnsRegion other = (ColumnsRegion)obj;
            if (this.myBase == null ? other.myBase != null : !this.myBase.equals(other.myBase)) {
                return false;
            }
            return Arrays.equals(this.myColumns, other.myColumns);
        }

        @Override
        public void fillColumn(long row, long col, Access1D<N> values) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)col], values);
        }

        @Override
        public void fillColumn(long row, long col, N value) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)col], value);
        }

        @Override
        public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)col], supplier);
        }

        @Override
        public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.myBase.fillOne(row, this.myColumns[(int)col], values, valueIndex);
        }

        @Override
        public void fillOne(long row, long col, N value) {
            this.myBase.fillOne(row, (long)this.myColumns[(int)col], value);
        }

        @Override
        public void fillOne(long row, long col, NullaryFunction<?> supplier) {
            this.myBase.fillOne(row, (long)this.myColumns[(int)col], supplier);
        }

        @Override
        public N get(long row, long col) {
            return this.myBase.get(row, this.myColumns[(int)col]);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myBase == null ? 0 : this.myBase.hashCode());
            result = 31 * result + Arrays.hashCode(this.myColumns);
            return result;
        }

        @Override
        public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyColumn(row, this.myColumns[(int)col], modifier);
        }

        @Override
        public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
            this.myBase.modifyOne(row, this.myColumns[(int)col], modifier);
        }

        @Override
        public void set(long row, long col, Comparable<?> value) {
            this.myBase.set(row, (long)this.myColumns[(int)col], value);
        }

        @Override
        public void set(long row, long col, double value) {
            this.myBase.set(row, (long)this.myColumns[(int)col], value);
        }
    }
}

