/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.LogicalStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;

abstract class ShadingStore<N extends Comparable<N>>
extends LogicalStore<N> {
    protected ShadingStore(MatrixStore<N> base) {
        super(base, base.getRowDim(), base.getColDim());
    }

    @Override
    public void supplyTo(TransformableRegion<N> consumer) {
        consumer.reset();
        int numberOfColumns = this.getColDim();
        if (this.isPrimitive()) {
            for (int j = 0; j < numberOfColumns; ++j) {
                int first = this.firstInColumn(j);
                int limit = this.limitOfColumn(j);
                for (int i = first; i < limit; ++i) {
                    consumer.set((long)i, (long)j, this.doubleValue(i, j));
                }
            }
        } else {
            for (int j = 0; j < numberOfColumns; ++j) {
                int first = this.firstInColumn(j);
                int limit = this.limitOfColumn(j);
                for (int i = first; i < limit; ++i) {
                    consumer.fillOne((long)i, (long)j, this.get(i, j));
                }
            }
        }
    }
}

